unit scrn;
interface
uses crt;
Procedure SaveScreen(Page:byte);
Procedure RestoreScreen(Page:byte);
Procedure DisposeScreen(Page:byte);
Const
    Max_Screens = 10;
    ScreenCounter : byte = 0;
Type
    ScreenImage = record
                       CursorX : byte;
                       CursorY : byte;
                       ScanTop : byte;
                       ScanBot : byte;
                       SavedLines:byte;
                       ScreenPtr: pointer;
                  end;
    ScreenPtr = ^ScreenImage;
Var
    Screen : array[1..Max_Screens] of ScreenPtr;
    DisplayLines : byte;
   BaseOfScreen: pointer;       {Base address of video memory}
  ActiveScreenPtr: pointer;    {address of virtual screen}
implementation

Procedure DisposeScreen(Page:byte);
{Free memory and set pointer to nil}
begin
    If Screen[Page] = nil then
    begin
       write('nothing to dispose');
       exit;
    end
    else
      { W_error := 0;}
    FreeMem(Screen[Page]^.ScreenPtr,Screen[Page]^.SavedLines*160);
    Freemem(Screen[Page],SizeOf(Screen[Page]^));
    Screen[page] := nil;
   { If ActiveVscreen = Page then
       Activate_Visible_Screen;}
   { dec(ScreenCounter);}
end;

Procedure SaveScreen(Page:byte);
{Save screen display and cursor details}
begin
    If (Page > Max_Screens) then
    begin
      Write('error max screens reached');
      exit;
    end;
    If ((Screen[Page] <> nil) and (DisplayLines <> Screen[Page]^.SavedLines)) then
        DisposeScreen(Page);
    If Screen[Page] = nil then            {need to allocate memory}
    begin
        If MaxAvail < SizeOf(Screen[Page]^) then
        begin
            Write('not enough memory to save screen');
            exit;
        end;
        GetMem(Screen[Page],SizeOf(Screen[Page]^));
        If MaxAvail < DisplayLines*160 then     {do check in two parts 'cos Maxavail is not same as MemAvail}
        begin
            Write('not enough memory to save screen');
            Freemem(Screen[Page],SizeOf(Screen[Page]^));
            Screen[Page] := nil;
            exit;
        end;
        GetMem(Screen[Page]^.ScreenPtr,DisplayLines*160);
        Inc(ScreenCounter);
    end;
    With Screen[Page]^ do
    begin
      { FindCursor(CursorX,CursorY,ScanTop,ScanBot);     {Save Cursor posn. and shape}
       SavedLines := DisplayLines;
       Move(BaseOfScreen^,Screen[Page]^.ScreenPtr^,DisplayLines*80);
    end;
end;

Procedure RestoreScreen(Page:byte);
{Display a screen that was previously saved}
begin
    If Screen[Page] = nil then
    begin
       Write('screen has not been created cannot restore');
       exit;
    end
    else
    With Screen[Page]^ do
    begin
        Move(ScreenPtr^,BaseOfScreen^, 80*SavedLines);
    end;
end;  {Proc RestoreScreen}

end.