unit Inp;

interface
uses
  Crt;

const
  BkgChar = '';

const
  InsMode: Boolean = True;


Function InputLn(S: string; Max: Byte) : String;


implementation
procedure NormalCursor; assembler;
asm
  mov ah, 01h
  mov cx, 7 + 6 shl 8
  int 10h
end;

procedure BlockCursor; assembler;
asm
  mov ah, 01h
  mov cx, 7
  int 10h
end;

Function InputLn(S: string; Max: Byte) : String;
var
  i: Byte;
  Ch: Char;
begin
  if Length(S) > Max then S[0] := Chr(Max);
  Write(S);
  i := Succ(Length(S));
  while i <= Max do
  begin
    Write(BkgChar);
    Inc(i);
  end;
  GotoXY(WhereX - (Max - Length(S)), WhereY);
  i := Succ(Length(S));
  repeat
    Ch := ReadKey;
    case Ch of
      #32..#255: { Normal character }
        if (Length(S) < Max) or (not InsMode and (i <= Max)) then
        begin
          if InsMode then
          begin
            Insert(Ch, S, i);
            Write(Copy(S, i, Succ(Length(S) - i)));
            GotoXY(WhereX - (Length(S) - i), WhereY);
          end
          else
          begin
            Write(Ch);
            if i > Length(S) then Inc(S[0]);
            S[i] := Ch;
          end;
          Inc(i);
        end;
      #8: { Backspace }
        if i > 1 then
        begin
          GotoXY(Pred(WhereX), WhereY);
          Dec(i);
          Delete(S, i, 1);
          Write(Copy(S, i, Succ(Length(S) - i)), BkgChar);
          GotoXY(WhereX - (Length(S) - i + 2), WhereY);
        end;
      #0: { Extended key }
        case ReadKey of
          #75: { Left }
            if i > 1 then
            begin
              GotoXY(Pred(WhereX), WhereY);
              Dec(i);
            end;
          #77: { Right }
            if i <= Length(S) then
            begin
              GotoXY(Succ(WhereX), WhereY);
              Inc(i);
            end;
          #71: { Home }
            if i > 1 then
            begin
              GotoXY(WhereX - Pred(i), WhereY);
              i := 1;
            end;
          #79: { End }
            if i <= Length(S) then
            begin
              GotoXY(WhereX + (Succ(Length(S)) - i), WhereY);
              i := Succ(Length(S));
            end;
          #82: { Insert }
            begin
              if InsMode then BlockCursor else NormalCursor;
              InsMode := not InsMode;
            end;
          #83: { Delete }
            if i <= Length(S) then
            begin
              Delete(S, i, 1);
              Write(Copy(S, i, Succ(Length(S) - i)), BkgChar);
              GotoXY(WhereX - (Length(S) - i + 2), WhereY);
            end;
        end;

    end;
  until (Ch = #13) or (Ch=#27);

  InputLn := S;

  if not InsMode then NormalCursor;
end;
end.
