// types.h : header file

// Define other types
#ifdef WIN32
	#include <windows.h>
#else
	typedef char BOOL;
	typedef char* PSTR;					// Pointer to a string
	typedef const char* PCSTR;			// Pointer to a const string
	typedef char near* NPSTR;			// Near pointer to a string
	typedef const char near* NPCSTR;	// Near pointer to a const string
	typedef char far* LPSTR;			// Long pointer to a string
	typedef const char far* LPCSTR;		// Long pointer to a const string
#endif

typedef char CHAR;
typedef int INT;						// Integer
typedef signed char      INT8;			// 8-bit integer
typedef signed short int INT16;			// 16-bit integer
typedef signed long  int INT32;			// 32-bit integer
typedef long LONG;
typedef unsigned char BYTE;
typedef unsigned int UINT;
typedef unsigned short int WORD;
typedef unsigned long  int DWORD;
typedef unsigned long  int ULONG;

// Define FALSE
#ifndef FALSE
  #define FALSE 0
#endif

// Define TRUE
#ifndef TRUE
  #define TRUE 1
#endif

// Define TRUE (Properley)
// #ifndef TRUE
//  #define TRUE (!FALSE)
// #endif

