// file7.h : header file
//
// Class:		InterBbsNodeFile
//
// Created:		20/05/98
//
// Author:		S.D.Holme
//
// Version:		1.00
//
// Modifications:
//
//	1.00	20/05/98	S.D.Holme	Created.
//			27/05/98	S.D.Holme	Add m_bModified to InterBbsNodeFile class.
//									Added the following functions to
//									InterBbsNodeFile class:
//										AddNode();
//										RemoveNode();
//										IsModified();
//									Converted InterBbsNode from a structure
//									into a class.
//			09/06/98	S.D.Holme	Made g_szLocationSeperator a public
//									member of InterBbsNodeFile as m_sz...
//									Added GetNode() const function.
//			19/06/98	S.D.Holme	Added IsModified() function to the
//									InterBbsNode class.
//				 					Public release.
//
// File Library. Copyright (c) 1995-98 Fonty Technologies, Inc.
//
#ifndef _FILE7_H
#define _FILE7_H

#define F7_MAX_NODES			256
#define F7_MAX_NODE_NAME		40
#define F7_MAX_NODE_ADDRESS		23
#define F7_MAX_LOCATION			40
#define F7_MAX_STATE			2
#define F7_MAX_COUNTRY			2

class InterBbsNode
{
// Construction
public:
	InterBbsNode();
	InterBbsNode(const InterBbsNode& rSource);
	InterBbsNode(const char* lpszName, const char* lpszAddress,
				 const char* lpszLocation, INT16 iRouteTo = -1,
				 BOOL bCrash = FALSE, BOOL bHold = FALSE);
	virtual ~InterBbsNode();

// Operations
public:
	// Services
	virtual BOOL Empty(void);
	virtual BOOL IsEmpty(void) const;

	// Set Accessors
	BOOL SetName(const char* lpszName);
	BOOL SetAddress(const char* lpszAddress);
	BOOL SetLocation(const char* lpszLocation);
	BOOL SetRouteTo(INT16 iRouteTo);
	BOOL SetCrash(BOOL bCrash);
	BOOL SetHold(BOOL bHold);

	// Get Accessors
	const char* GetName(void) const;
	const char* GetAddress(void) const;
	const char* GetLocation(void) const;
	INT16 GetRouteTo(void) const;
	BOOL GetCrash(void) const;
	BOOL GetHold(void) const;
	BOOL IsModified(void) const;

	void Copy(const InterBbsNode& rSource);

	// Operators
	InterBbsNode& operator=(const InterBbsNode& rSource);

// Attributes
protected:
	char m_szName[F7_MAX_NODE_NAME + 1];
	char m_szAddress[F7_MAX_NODE_ADDRESS + 1];
	char m_szLocation[F7_MAX_LOCATION + 1];
	INT16 m_iRouteTo;
	BOOL m_bCrash;
	BOOL m_bHold;
	BOOL m_bModified;
};

// InterBbsNodeFile

class InterBbsNodeFile : public TextFile
{
// Construction
public:
	InterBbsNodeFile(const char* pszFilename = "", int nAccess = 0);
	virtual ~InterBbsNodeFile();

// Operations
public:
	// Initialisation
	BOOL Initialise(const char* lpszHostNodeName, const char* lpszHostNodeAddress);

#ifdef __BORLANDC__
#pragma warn -hid
#endif
	// Input
	virtual BOOL Read(void);

	// Ouput
	virtual BOOL Write(void);
#ifdef __BORLANDC__
#pragma warn +hid
#endif

	// Services
	virtual INT16 Find(const char* lpszName, const char* lpszAddress) const;
	virtual INT16 GetRouteTo(const char* lpszName, const char* lpszAddress) const;
	virtual INT16 GetRouteTo(WORD nNode) const;

	// Set Accessors
	INT16 AddNode(const InterBbsNode& rNode);
	BOOL RemoveNode(WORD wNode);

	// Get Accessors
	InterBbsNode* GetNode(WORD wNode);
	const InterBbsNode& GetNode(WORD wNode) const;
	virtual WORD GetTotalSystems(void) const;
	virtual BOOL IsModified(void) const;

// Attributes
protected:
	char m_szHostNodeName[F7_MAX_NODE_NAME + 1];
	char m_szHostNodeAddress[F7_MAX_NODE_ADDRESS + 1];
	WORD m_wTotalSystems;
	BOOL m_bModified;

	// Array pointer
	InterBbsNode* m_pNode;

public:
	static char m_szLocationSeperator[3];
};

#endif