// file6.h : header file
//
// Class:		InterBbsSystemFile
//
// Created:		20/05/98
//
// Author:		S.D.Holme
//
// Version:		1.00
//
// Modifications:
//
//	1.00	20/05/98	S.D.Holme	Created.
//			19/06/98	S.D.Holme	Public release.
//
// File Library. Copyright (c) 1995-98 Fonty Technologies, Inc.
//
#ifndef _FILE6_H
#define _FILE6_H

#define F6_MAX_SYSOP_NAME	40
#define F6_MAX_NODE_NAME	40
#define F6_MAX_NODE_ADDRESS	23

// InterBbsSystemFile

typedef enum
{
	MAILER_NONE,
	MAILER_MSG,
	MAILER_FRONTDOOR
} InterBbsMailer;

class InterBbsSystemFile : public TextFile
{
// Construction
public:
	InterBbsSystemFile(const char* pszFilename = "", int nAccess = 0);
	virtual ~InterBbsSystemFile();

// Operations
public:
	// Initialisation
	BOOL Initialise(void);

#ifdef __BORLANDC__
#pragma warn -hid
#endif
	// Input
	virtual BOOL Read();

	// Output
	virtual BOOL Write();
#ifdef __BORLANDC__
#pragma warn +hid
#endif

	// Accessors
	BOOL SetSysopName(const char* lpszSysopName);
	BOOL SetNodeName(const char* lpszNodeName);
	BOOL SetNodeAddress(const char* lpszNodeAddress);
	BOOL SetInboundDir(const char* lpszInboundDir);
	BOOL SetNetmailDir(const char* lpszNetmailDir);
	BOOL SetLeague(WORD wLeague);
	BOOL SetMailer(InterBbsMailer eMailer);

	const char* GetSysopName(void);
	const char* GetNodeName(void);
	const char* GetNodeAddress(void);
	const char* GetInboundDir(void);
	const char* GetNetmailDir(void);
	WORD GetLeague(void);
	InterBbsMailer GetMailer(void);
	char* GetMailerString(void);
	BOOL IsModified(void);

// Attributes
protected:
	char m_szSysopName[F6_MAX_SYSOP_NAME + 1];
	char m_szNodeName[F6_MAX_NODE_NAME + 1];
	char m_szNodeAddress[F6_MAX_NODE_ADDRESS + 1];
	char m_szInboundDir[_MAX_PATH];
	char m_szNetmailDir[_MAX_PATH];
	WORD m_wLeague;
	InterBbsMailer m_eMailer;
	BOOL m_bModified;
};

#endif