// file6.cpp : implementation file
//
// Class:		InterBbsSystemFile
//
// Created:		20/05/98
//
// Author:		S.D.Holme
//
// Version:		1.00
//
// Modifications:
//
//	1.00	20/05/98	S.D.Holme	Created.
//			29/05/98	S.D.Holme	Added m_bModified to InterBbsSystemFile
//									Added IsModified() to InterBbsSystemFile
//			19/06/98	S.D.Holme	Public release.
//
// File Library. Copyright (c) 1995-98 Fonty Technologies, Inc.
//
#include <mem.h>
#include <stdlib.h>
#include <string.h>

#include "file.h"

char g_szMailer[][10] = { "NONE", "MSG", "FRONTDOOR" };

/////////////////////////////////////////////////////////////////////////////
// InterBbsSystemFile Class

// Constructor
InterBbsSystemFile::InterBbsSystemFile(const char* pszFilename, int nMode)
	: TextFile(pszFilename, nMode)
{
	// Initialise member attributes
	m_bModified = FALSE;
}

// Destructor
InterBbsSystemFile::~InterBbsSystemFile()
{
}

// Initialiser
BOOL InterBbsSystemFile::Initialise(void)
{
	if(! TextFile::Initialise())
	{
		// Return failure
		return FALSE;
	}

	// Initialise member attributes

	// Return success
	return TRUE;
}

// Functions

BOOL InterBbsSystemFile::Read(void)
{
	WORD wLeague;
	char szLine[256 + 1];
	char szSysopName[F6_MAX_SYSOP_NAME + 1];
	char szNodeName[F6_MAX_NODE_NAME + 1];
	char szNodeAddress[F6_MAX_NODE_ADDRESS + 1];
	char szInboundDir[_MAX_PATH];
	char szNetmailDir[_MAX_PATH];
	InterBbsMailer eMailer;

	// Check file is open
	if(! IsOpen())
	{
		// Return failure
		return FALSE;
	}

	// Read the first line (sysop name) of the configuration file
	if(! ReadNot(szLine))
	{
		// Return failure
		return FALSE;
	}

	// Copy line to a temporary storage area
	memset(szSysopName, '\0', sizeof(szSysopName));
	strncpy(szSysopName, szLine, sizeof(szSysopName) - 1);

	// Read the second line (node name) of the configuration file
	if(! ReadNot(szLine))
	{
		// Return failure
		return FALSE;
	}

	// Copy line to a temporary storage area
	memset(szNodeName, '\0', sizeof(szNodeName));
	strncpy(szNodeName, szLine, sizeof(szNodeName) - 1);

	// Read the third line (node address) of the configuration file
	if(! ReadNot(szLine))
	{
		// Return failure
		return FALSE;
	}

	// Copy line to a temporary storage area
	memset(szNodeAddress, '\0', sizeof(szNodeAddress));
	strncpy(szNodeAddress, szLine, sizeof(szNodeAddress) - 1);

	// Read the forth line (inbound dir) of the configuration file
	if(! ReadNot(szLine))
	{
		// Return failure
		return FALSE;
	}

	// Copy line to a temporary storage area
	memset(szInboundDir, '\0', sizeof(szInboundDir));
	strncpy(szInboundDir, szLine, sizeof(szInboundDir) - 1);

	// Read the fifth line (outbound dir) of the configuration file
	if(! ReadNot(szLine))
	{
		// Return failure
		return FALSE;
	}

	// Copy line to a temporary storage area
	memset(szNetmailDir, '\0', sizeof(szNetmailDir));
	strncpy(szNetmailDir, szLine, sizeof(szNetmailDir) - 1);

	// Read the sixth line (league) of the configuration file
	if(! ReadNot(szLine))
	{
		// Return failure
		return FALSE;
	}

	// Copy line to a temporary storage area
	wLeague = atoi(szLine);

	// Read the seventh line (mailer) of the configuration file
	if(! ReadNot(szLine))
	{
		// Return failure
		return FALSE;
	}

	// Check mailer is valid
	if(stricmp(szLine, g_szMailer[MAILER_MSG]) == 0)
	{
		eMailer = MAILER_MSG;
	}
	else if(stricmp(szLine, g_szMailer[MAILER_FRONTDOOR]) == 0)
	{
		eMailer = MAILER_FRONTDOOR;
	}
	else
	{
		eMailer = MAILER_NONE;
	}

	// The file was read okay - So copy all relevant information
	strcpy(m_szSysopName, szSysopName);
	strcpy(m_szNodeName, szNodeName);
	strcpy(m_szNodeAddress, szNodeAddress);
	strcpy(m_szInboundDir, szInboundDir);
	strcpy(m_szNetmailDir, szNetmailDir);
	m_wLeague = wLeague;
	m_eMailer = eMailer;

	// Reset the modified member attribute
	m_bModified = FALSE;

	// Return success
	return TRUE;
}

BOOL InterBbsSystemFile::Write(void)
{
	// Check file is open
	if(! IsOpen())
	{
		// Return failure
		return FALSE;
	}

	// Write the sysop name out
	if(! Writeln(m_szSysopName))
	{
		// Return failure
		return FALSE;
	}

	// Write the node name out
	if(! Writeln(m_szNodeName))
	{
		// Return failure
		return FALSE;
	}

	// Write the node address out
	if(! Writeln(m_szNodeAddress))
	{
		// Return failure
		return FALSE;
	}

	// Write the inbound dir out
	if(! Writeln(m_szInboundDir))
	{
		// Return failure
		return FALSE;
	}

	// Write the outbound dir out
	if(! Writeln(m_szNetmailDir))
	{
		// Return failure
		return FALSE;
	}

	// Write the league out
	if(! Writef("%u", m_wLeague) || ! Writeln())
	{
		// Return failure
		return FALSE;
	}

	// Write the mailer out
	if(! Writeln(g_szMailer[m_eMailer]))
	{
		// Return failure
		return FALSE;
	}

	// Reset the modified member attribute
	m_bModified = FALSE;

	// Return success
	return TRUE;
}

BOOL InterBbsSystemFile::SetSysopName(const char* lpszSysopName)
{
	// Check for a valid sysop name
	if(lpszSysopName == NULL || strlen(lpszSysopName) >= sizeof(m_szSysopName))
	{
		// Return failure
		return FALSE;
	}

	// Set the modified member attribute
	m_bModified = TRUE;

	// Set the sysop name member attribute
	strcpy(m_szSysopName, lpszSysopName);

	// Return success
	return TRUE;
}

BOOL InterBbsSystemFile::SetNodeName(const char* lpszNodeName)
{
	// Check for a valid node name
	if(lpszNodeName == NULL || strlen(lpszNodeName) >= sizeof(m_szNodeName))
	{
		// Return failure
		return FALSE;
	}

	// Set the modified member attribute
	m_bModified = TRUE;

	// Set the node name member attribute
	strcpy(m_szNodeName, lpszNodeName);

	// Return success
	return TRUE;
}

BOOL InterBbsSystemFile::SetNodeAddress(const char* lpszNodeAddress)
{
	// Check for a valid node address
	if(lpszNodeAddress == NULL || strlen(lpszNodeAddress) >= sizeof(m_szNodeAddress))
	{
		// Return failure
		return FALSE;
	}

	// Set the modified member attribute
	m_bModified = TRUE;

	// Set the node address member attribute
	strcpy(m_szNodeAddress, lpszNodeAddress);

	// Return success
	return TRUE;
}

BOOL InterBbsSystemFile::SetInboundDir(const char* lpszInboundDir)
{
	// Check for a valid inbound dir
	if(lpszInboundDir == NULL || strlen(lpszInboundDir) >= sizeof(m_szInboundDir))
	{
		// Return failure
		return FALSE;
	}

	// Set the inbound dir member attribute
	strcpy(m_szInboundDir, lpszInboundDir);

	// Set the modified member attribute
	m_bModified = TRUE;

	// Return success
	return TRUE;
}

BOOL InterBbsSystemFile::SetNetmailDir(const char* lpszNetmailDir)
{
	// Check for a valid outbound dir
	if(lpszNetmailDir == NULL || strlen(lpszNetmailDir) >= sizeof(m_szNetmailDir))
	{
		// Return failure
		return FALSE;
	}

	// Set the outbound dir member attribute
	strcpy(m_szNetmailDir, lpszNetmailDir);

	// Set the modified member attribute
	m_bModified = TRUE;

	// Return success
	return TRUE;
}

BOOL InterBbsSystemFile::SetLeague(WORD wLeague)
{
	// Set the league member attribute
	m_wLeague = wLeague;

	// Set the modified member attribute
	m_bModified = TRUE;

	// Return success
	return TRUE;
}

BOOL InterBbsSystemFile::SetMailer(InterBbsMailer eMailer)
{
	// Check for a valid mailer
	switch(eMailer)
	{
	case MAILER_NONE:
	case MAILER_MSG:
	case MAILER_FRONTDOOR:
		break;
	default:
		return FALSE;
	}

	// Set the mailer member attribute
	m_eMailer = eMailer;

	// Set the modified member attribute
	m_bModified = TRUE;

	// Return success
	return TRUE;
}

const char* InterBbsSystemFile::GetSysopName(void)
{
	// Return the sysop name member attribute
   return m_szSysopName;
}

const char* InterBbsSystemFile::GetNodeName(void)
{
	// Return the node name member attribute
	return m_szNodeName;
}

const char* InterBbsSystemFile::GetNodeAddress(void)
{
	// Return the node address member attribute
	return m_szNodeAddress;
}

const char* InterBbsSystemFile::GetInboundDir(void)
{
	// Return the inbound dir member attribute
	return m_szInboundDir;
}

const char* InterBbsSystemFile::GetNetmailDir(void)
{
	// Return the outbound dir member attribute
	return m_szNetmailDir;
}

WORD InterBbsSystemFile::GetLeague(void)
{
	// Return the league member attribute
	return m_wLeague;
}

InterBbsMailer InterBbsSystemFile::GetMailer(void)
{
	// Return the mailer member attribute
	return m_eMailer;
}

char* InterBbsSystemFile::GetMailerString(void)
{
	return g_szMailer[m_eMailer];
}

BOOL InterBbsSystemFile::IsModified(void)
{
	// Return the modified member attribute
	return m_bModified;
}
