// file5.cpp : implementation file
//
// Class:		AvatarFile
//
// Created:		19/09/95
//
// Author:		S.D.Holme
//
// Version:		1.00
//
// Modifications:
//
//	1.00	19/09/95	S.D.Holme	Created.
//			12/07/97	S.D.Holme	Public release.
//
//	1.01	20/05/98	S.D.Holme	Tidied up the class declaration.
//
// File Library. Copyright (c) 1995-98 Fonty Technologies, Inc.
//
#include <string.h>

#include "file.h"

/////////////////////////////////////////////////////////////////////////////
// AvatarFile Class

// Constructor
AvatarFile::AvatarFile(const char* pszFilename, int nAccess)
	: BinaryFile(pszFilename, nAccess)
{
	// Initialise member attributes
	m_nAttribute = 3;
	m_nLastAttribute = 3;
}

//  Destructor
AvatarFile::~AvatarFile()
{
}

// Initialiser
BOOL AvatarFile::Initialise(void)
{
	if(! BinaryFile::Initialise())
	{
		// Return failure
		return FALSE;
	}

	// Initialise member attributes

	return TRUE;
}

// Functions
BOOL AvatarFile::Close(void)
{
	WriteColour(7);

	return BinaryFile::Close();
}

BOOL AvatarFile::Write(const char* pszText)
{
	if(! WriteColour())
	{
		// Return failure
		return FALSE;
	}

	return BinaryFile::Write((void*)pszText, strlen(pszText));
}

BOOL AvatarFile::Repeat(char chCharacter, int nTimes)
{
	BOOL bReturn;

	if(! WriteColour())
	{
		// Return failure
		return FALSE;
	}

	bReturn = Writef("%c%c", chCharacter, (char) nTimes);

	return bReturn;
}

void AvatarFile::ClrScr(void)
{
	Write("");
}

void AvatarFile::GotoXY(int nColumn, int nRow)
{
	Writef("%c%c", (char) nRow, (char) nColumn);
}

BOOL AvatarFile::WriteColour(void)
{
	return WriteColour(m_nAttribute);
}

BOOL AvatarFile::WriteColour(int nAttribute)
{
	if(nAttribute == m_nLastAttribute)
	{
		// Return success
		return TRUE;
	}

	// Let last equal current
	m_nLastAttribute = nAttribute;

	// Write the Avatar code for changing the colour
	if(! BinaryFile::Writef("%c", (char) nAttribute))
	{
		// Return failure
		return FALSE;
	}

	// Write the avatar code for flashing
	if(nAttribute & 128)
	{
		if(! BinaryFile::Write(""))
		{
			// Return failure
			return FALSE;
		}
	}

	// Return success
	return TRUE;
}

void AvatarFile::SetColour(int nForeground, int nBackground)
{
	SetAttr( nForeground | (nBackground << 4) );
}

void AvatarFile::SetAttr(int nAttribute)
{
	m_nAttribute = nAttribute;
}
