// file4.h : header file
//
// Class:		ANSiTextFile
//
// Created:		19/09/95
//
// Author:		S.D.Holme
//
// Version:		1.01
//
// Modifications:
//
//	1.00	19/09/95	S.D.Holme	Created.
//			12/07/97	S.D.Holme	Public release.
//
//	1.01	20/05/98	S.D.Holme	Tidied up the class declaration.
//
// File Library. Copyright (c) 1995-98 Fonty Technologies, Inc.
//
#ifndef _FILE4_H
#define _FILE4_H

// ANSiTextFile

class ANSiTextFile : public TextFile
{
// Construction
public:
	ANSiTextFile(const char* pszFilename = "", int nAccess = 0);
	virtual ~ANSiTextFile();

// Operations
public:
	// Initialisation
	BOOL Initialise(void);

	// Services
	virtual BOOL Close(void);

	// Output
	virtual BOOL Write(const char* pszText);
	// No need to overide Writef as TextFile::Writef will call ANSiTextFile::Write
	virtual BOOL Repeat(char chCharacter, int nTimes);
	virtual BOOL WriteColour(void);
	virtual BOOL WriteColour(int nAttribute);

	virtual void ClrScr(void);
	virtual void GotoXY(int nColumn, int nRow);

	// Accessors
	virtual void SetColour(int nForeground, int nBackground);
	virtual void SetAttr(int nAttribute);

protected:
	int ANSiColourCode(int nPcColourCode);

// Attributes
protected:
	int m_nAttribute;
	int m_nLastAttribute;
};

#endif