// file4.cpp : implementation file
//
// Class:		ANSiTextFile
//
// Created:		19/09/95
//
// Author:		S.D.Holme
//
// Version:		1.00
//
// Modifications:
//
//	1.00	19/09/95	S.D.Holme	Created.
//			21/07/97	S.D.Holme	Bug Fix: WriteColour() would not output a
//									correct colour sequence if the colour
//									being outputted was the dark version of
//									the previous colour.
//			12/07/97	S.D.Holme	Public release.
//
//	1.01	20/05/98	S.D.Holme	Tidied up class implementation.
//
// File Library. Copyright (c) 1995-98 Fonty Technologies, Inc.
//
#include <string.h>

#include "file.h"

/////////////////////////////////////////////////////////////////////////////
// ANSiTextFile Class

// Constructor
ANSiTextFile::ANSiTextFile(const char* pszFilename, int nAccess)
	: TextFile(pszFilename, nAccess)
{
	// Initialise member attributes
	m_nAttribute = 7;
	m_nLastAttribute = 7;
}

// Destructor
ANSiTextFile::~ANSiTextFile()
{
}

// Initialiser
BOOL ANSiTextFile::Initialise(void)
{
	if(! TextFile::Initialise())
	{
		// Return failure
		return FALSE;
	}

	// Initialise attributes

	// Return failure
	return TRUE;
}

// Functions
BOOL ANSiTextFile::Close(void)
{
	Write("[0m[255D");

	return TextFile::Close();
}

BOOL ANSiTextFile::Write(const char* pszText)
{
	if(! WriteColour())
	{
		// Return failure
		return FALSE;
	}

	// Call File::Write() so line feed isn't appended
	return File::Write((void*)pszText, strlen(pszText));
}

BOOL ANSiTextFile::Repeat(char chCharacter, int nTimes)
{
	BOOL bReturn;

	if(! WriteColour())
	{
		// Return failure
		return FALSE;
	}

	if(chCharacter == ' ')
	{
		bReturn = TextFile::Writef("[%dC", nTimes);
	}
	else
	{
		bReturn = TextFile::Repeat(chCharacter, nTimes);
	}

	return bReturn;
}

void ANSiTextFile::ClrScr(void)
{
	Write("[2J");
}

void ANSiTextFile::GotoXY(int nColumn, int nRow)
{
	Writef("[%d;%dH", nRow, nColumn);
}

BOOL ANSiTextFile::WriteColour(void)
{
	return WriteColour(m_nAttribute);
}

BOOL ANSiTextFile::WriteColour(int nAttribute)
{
	BOOL bOneWrittenBefore = FALSE;
	BOOL bLight;
	BOOL bLastLight;
	BOOL bFlash;
	BOOL bLastFlash;
	int nForeground;
	int nLastForeground;
	int nBackground;
	int nLastBackground;

	if(nAttribute == m_nLastAttribute)
	{
		// Return success
		return TRUE;
	}

	// Establish all CURRENT attribute variables
	nForeground = nAttribute & 0x0F;
	nBackground = nAttribute >> 4;
	bLight = (nForeground > 7)?TRUE:FALSE;
	bFlash = (nBackground > 15)?TRUE:FALSE;
	nForeground = ANSiColourCode(nForeground - (8 * bLight));
	nBackground = ANSiColourCode(nBackground - (8 * bFlash)) + 10;

	// Establish all LAST attribute variables
	nLastForeground = m_nLastAttribute & 0x0F;
	nLastBackground = m_nLastAttribute >> 4;
	bLastLight = (nLastForeground > 7)?TRUE:FALSE;
	bLastFlash = (nLastBackground > 15)?TRUE:FALSE;
	nLastForeground = ANSiColourCode(nLastForeground - (8 * bLastLight));
	nLastBackground = ANSiColourCode(nLastBackground - (8 * bLastFlash)) + 10;

	// Let last equal current
	m_nLastAttribute = nAttribute;

	// Write the ANSI header code
	if(! TextFile::Write("["))
	{
		// Return failure
		return FALSE;
	}

	if(bLight != bLastLight)
	{
		if(! TextFile::Writef("%d", bLight))
		{
			// Return failure
			return FALSE;
		}

		bOneWrittenBefore = TRUE;
	}

	if(bFlash != bLastFlash)
	{
		if(bOneWrittenBefore)
		{
			TextFile::Putch(';');
		}

		if(! TextFile::Writef("%d", bFlash * 5))
		{
			// Return failure
			return FALSE;
		}

		bOneWrittenBefore = TRUE;
	}

	if(nForeground != nLastForeground || bOneWrittenBefore)
	{
		if(bOneWrittenBefore)
		{
			TextFile::Putch(';');
		}

		if(! TextFile::Writef("%d", nForeground))
		{
			// Return failure
			return FALSE;
		}

		bOneWrittenBefore = TRUE;
	}

	if(nBackground != nLastBackground)
	{
		if(bOneWrittenBefore)
		{
			// Return failure
			TextFile::Putch(';');
		}

		if(! TextFile::Writef("%d", nBackground))
		{
			// Return failure
			return FALSE;
		}

		bOneWrittenBefore = TRUE;
	}

	// Write the ANSI code for changing the colour
	if(! TextFile::Write("m"))
	{
		// Return failure
		return FALSE;
	}

	// Return success
	return TRUE;
}

void ANSiTextFile::SetColour(int nForeground, int nBackground)
{
	SetAttr( nForeground | (nBackground << 4) );
}

void ANSiTextFile::SetAttr(int nAttribute)
{
	m_nAttribute = nAttribute;
}

// Protected Functions
int ANSiTextFile::ANSiColourCode(int nPcColourCode)
{
	int nANSiColourCode;

	switch(nPcColourCode)
	{
	case 0 :
		nANSiColourCode = 30;
		break;

	case 1 :
		nANSiColourCode = 34;
		break;

	case 2 :
		nANSiColourCode = 32;
		break;

	case 3 :
		nANSiColourCode = 36;
		break;

	case 4 :
		nANSiColourCode = 31;
		break;

	case 5 :
		nANSiColourCode = 35;
		break;

	case 6 :
		nANSiColourCode = 33;
		break;

	case 7 :
		nANSiColourCode = 37;
		break;
	}

	return nANSiColourCode;
}
