// file2.cpp : implementation file
//
// Class:		TextFile
//
// Created:		19/09/95
//
// Author:		S.D.Holme
//
// Version:		1.00
//
// Modifications:
//
//	1.00	19/09/95	S.D.Holme	Created.
//			31/10/96	S.D.Holme	Renamed the use of eof() to Eof().
//			12/07/97	S.D.Holme	Public release.
//
//	1.01	20/05/98	S.D.Holme	Tidied up the class implementation.
//
// File Library. Copyright (c) 1995-98 Fonty Technologies, Inc.
//
#include <string.h>

#include "file.h"

/////////////////////////////////////////////////////////////////////////////
// TextFile Class

// Constructor
TextFile::TextFile(const char* pszFilename, int nAccess)
	: File(pszFilename, nAccess)
{
	// Set the mode (must be called here, as virtual functions are not known)
	SetMode(nAccess);

	// Initialise member attributes
}

// Destructor
TextFile::~TextFile()
{
}

// Initialisation
BOOL TextFile::Initialise()
{
	if(! File::Initialise())
	{
		// Return failure
		return FALSE;
	}

	// Initialise member attributes

	// Return success
	return TRUE;
}

// Functions
BOOL TextFile::SetMode(int nAccess)
{
	// Not allowed to change the access mode whilst a file is open
	if(IsOpen())
	{
		// Return failure
		return FALSE;
	}

	// Make sure that the mode is not binary
	if(nAccess & O_BINARY)
	{
		nAccess ^= O_BINARY;
	}

	// Make sure that the mode is text
	if(! (nAccess & O_TEXT))
	{
		nAccess |= O_TEXT;
	}

	// Call the base function
	return File::SetMode(nAccess);
}

BOOL TextFile::Writeln(const char* pszText)
{
	if(strlen(pszText) > 0)
	{
		if(! Write(pszText))
		{
			// Return failure
			return FALSE;
		}
	}

	return Write("\n");
}

BOOL TextFile::Readln(char* pszText, char chDelimiter, int nMax)
{
	// Check file is open
	if(! IsOpen())
	{
		// Return failure
		return FALSE;
	}

	// Check file mode is INput
	if(! (GetMode() & O_RDONLY || GetMode() & O_RDWR))
	{
		// Return failure
		return FALSE;
	}

	// Read a line
	for(int i = 0; i < nMax; i++)
	{
		if(! Read(pszText + i, 1))
			break;

		if(pszText[i] == chDelimiter)
			break;
	}

	// Null terminate the string.
	// If the read fails on a char, a null will be written in its place. If
	// the delimiter is reached, a null will be written in its place. Else
	// the maximum chars is read and a null placed at the end if them!
	pszText[i] = NULL;

	// Return success
	return TRUE;
}

BOOL TextFile::ReadNot(char* pszText, char* pszNotText, char chDelimiter, int nMax)
{
	char* pszLine;
	BOOL bDone = FALSE;
	BOOL bFound = FALSE;

	// Allocate temporary buffer
	pszLine = new char[nMax + 1];
	if(pszLine == NULL)
	{
		// Return failure
		return FALSE;
	}

	while(! bDone && !bFound)
	{
		// Read a line of text in
		Readln(pszLine, chDelimiter, nMax);

		// If the line equals the pszNotText variable then continue
		if(strcmp(pszLine, pszNotText) != 0)
		{
			strcpy(pszText, pszLine);
			bFound = TRUE;
		}

		// Check for end of file
		if(Eof())
		{
			bDone = TRUE;
		}
	}

	// Delete the allocated memory
	delete pszLine;

	return bFound;
}