// file1.cpp : implementation file
//
// Class:		BinaryFile
//
// Created:		19/09/95
//
// Author:		S.D.Holme
//
// Version:		1.01
//
// Modifications:
//
//	1.00	19/09/95	S.D.Holme	Created.
//			12/07/97	S.D.Holme	Public release.
//
//	1.01	20/05/98	S.D.Holme	Tidied up the class implementation.
//
// File Library. Copyright (c) 1995-98 Fonty Technologies, Inc.
//
#include "file.h"

/////////////////////////////////////////////////////////////////////////////
// BinaryFile Class

// Constructor
BinaryFile::BinaryFile(const char* pszFilename, int nMode)
	: File(pszFilename, nMode)
{
	// Set the mode (must be called from here, as virtual functions not known)
	SetMode(nMode);

	// Initialise variables
}

// Destructor
BinaryFile::~BinaryFile()
{
}

// Initialisation
BOOL BinaryFile::Initialise(void)
{
	if(! File::Initialise())
	{
		// Return failure
		return FALSE;
	}

	// Initialise variables

	// Return success
	return TRUE;
}

// Functinons
BOOL BinaryFile::SetMode(int nAccess)
{
	// Not allowed to change the access mode whilst a file is open
	if(IsOpen())
	{
		// Return failure
		return FALSE;
	}

	// Make sure that the mode is not text
	if(nAccess & O_TEXT)
	{
		nAccess ^= O_TEXT;
	}

	// Make sure that the mode is binary
	if(! (nAccess & O_BINARY))
	{
		nAccess |= O_BINARY;
	}

	// Call the base function
	return File::SetMode(nAccess);
}

