// file0.h : header file
//
// Class:		File
//
// Created:		19/09/95
//
// Author:		S.D.Holme
//
// Version:		1.01
//
// Modifications:
//
//	1.00	19/09/95	S.D.Holme	Created.
//			20/03/96	S.D.Holme	Added Seek() function.
//			02/04/96	S.D.Holme   Changed Seek() to acccept a long
//									rather than an int.
//			31/10/96	S.D.Holme	Added the following functions:
//										Exists()
//										Remove()
//										Rename()
//										GetLength()
//										Trunc()
//										SetFTime()
//										GetFTime()
//									Renamed eof() to Eof().
//									Class no longer uses fstream as the base
//									class.
//			21/06/97	S.D.Holme	Changed retry timeout to be time
//									dependent.
//			12/07/97	S.D.Holme	Public release.
//
//	1.01	20/05/98	S.D.Holme	Tidied up the class declaration.
//									Added DirExists() function.
//									Changed SetFilename() return type.
//									Changed GetFilename() return type.
//									Renamed file to file0.h
//			21/05/98	S.D.Holme	Added m_bInitialised member attribute.
//
// File Library. Copyright (c) 1995-98 Fonty Technologies, Inc.
//
#ifndef _FILE0_H
#define _FILE0_H

// File

class File
{
// Construction
public:
	File(const char* pszFilename = "", int nMode = 0);
	virtual ~File();

// Operations
public:
	// Initialisation
	BOOL Initialise(void);

	// Services
	virtual BOOL Open(int nAccess = -1);
	virtual BOOL Close(void);

	// Accessors
	virtual BOOL SetMode(int nAccess);
	virtual int GetMode(void);
	virtual BOOL SetFilename(const char* lpstrFilename);
	virtual BOOL GetFilename(char* lpstrFilename);
	virtual BOOL IsOpen(void);

	// Output
	virtual BOOL Write(void* pBuffer, unsigned nBytesToWrite);
	virtual BOOL Write(const char* pszText);
	virtual BOOL Writeln(const char* pszText = "");
	virtual BOOL Writef(const char* pszText, ...);
	virtual BOOL Putch(char chCharacter);
	virtual BOOL Repeat(char chCharacter, int nTimes);

	// Input
	virtual BOOL Read(void* pBuffer, unsigned nBytesToRead);

	// Misc
	virtual BOOL Seek(long lPosition, int nFromWhere = SEEK_SET);
	virtual BOOL Exists(void);
	virtual BOOL Remove(void);
	virtual BOOL Rename(const char* pszNewName);
	virtual BOOL Eof(void);
	virtual long GetLength(void);
	virtual BOOL Trunc(long nNewSize);
#ifndef WIN32
	virtual BOOL SetFTime(struct ftime* pFileTime);
	virtual BOOL GetFTime(struct ftime* pFileTime);
#endif

	// Static functions
	static BOOL DirExists(const char* lpszDirName);

// Attributes
protected:
	int m_nAccess;
	int m_nHandle;
	char m_szFilename[_MAX_PATH];
	BOOL m_bInitialised;
	DWORD m_dwRetry;
};

#endif