
{$R-}    {Range checking off}
{$S+}    {Stack checking on}
{$F+}    {Far calls       n}
{$I+}    {I/O checking on}
{$N+}    {Numeric coprocessor}
{$M 65520,0,655360}
(****************************************************************)
(*            DDPLUS IGM KIT -DDIGMCFG 1.00                     *)
(*            BY STEVEN R. LORENZ  (C)                          *)
(*            Copyright 1995                                    *)
(*            Online Game Config                                *)
(****************************************************************)
{ Sample Igm config program                                      }
{ Installs XXXXIGM                                               }

program DDIGMCFG;
uses
  dos,
  crt;

Var
  ExitCall          : pointer;
  numlines,spin:byte;
  option :shortint;
  progname:string[60];
  gamefilepath,lordfilepath,temppath:DirStr;

Procedure Getfilepath;
var
  P : PathStr;
  D : Dirstr;
  N : NameStr;
  E : ExtStr;
  i,len : byte;
begin
  p := ParamStr(0);
  Fsplit(p,d,n,e);
  gamefilepath := '';
  lordfilepath := d;
end;

Procedure Propeller(v:byte);
const
  CX :array [1..6] of char =(chr(250),'','/','-','\','?');
var
  b : byte;
begin
  b:=6;
  case v of
   1,15      : b:=1;
   2,6,10,14 : b:=2;
   3,7,11    : b:=3;
   4,8,12    : b:=4;
   5,9,13    : b:=5;
  end;
  if v < 17 then
    begin
      write(cx[b]);
      write(#8);
    end;
end;

Procedure ReadCh(var a:char);
var
  b:byte;
begin
  if not keypressed then exit;
  a :=readkey;
  if (a=#0) and (keypressed) then
   begin
     a:=readkey;
     case a of
       #72 : a:=#223;
       #80 : a:=#222;
     end;
   end;
end;

function supcase(s: string): string;
var
 a: integer;
begin;
 for a:=1 to length(s) do s[a]:=upcase(s[a]);
 supcase:=s;
end;

Procedure FrameEntry(maxlen,x,y,b : byte;var s: string;var ExitOK,EndOK:boolean);

type
  chr80 = array[1..80] of char;
var
  TextX : Chr80;
  i,j   : byte;
  CROK  : boolean;
  o:string;
  ch : char;
begin
  EndOK  := false;
  ExitOK := false;
  TextBackGround(b);
  FillChar(Textx,80,' ');
  FillChar(o,maxlen+1,' ');
  o[0]:=char(maxlen);
  Gotoxy(x+1,y);
  write(o);
  CROK := false;
  s:='';
  i:=0;
  repeat
   If i = maxlen then
     GotoXY((x+i),y)
   else
     GotoXY((x+i+1),y);

   ch:=#0;
   repeat
    Readch(ch);
   until ch<>#0;
   If EndOk then Exit;
   case byte(ch) of
    32..126 : if i < maxlen then
               begin
                 inc(i);
                 Textx[i] := ch;
                 GotoXY((x+i),y);
                 write(ch);
              end;
     8     :  if i > 0 then
               begin
                 Textx[i] := chr(32);
                 GotoXY((x+i),y);
                 write(' ');
                 dec(i);
                 GotoXY((x+i),y);
              end;
     13    : CROK := true;
     27    : begin
               ExitOK := true;
               CrOk   := true;
             end;
  end;


   If (i=maxlen) then
     begin
       CROK:=true;
     end;

  until CROK;
  s:='';
  for j := 1 to i do
     s:=s+Textx[j];
  TextBackGround(0);
  Gotoxy(x+1,y);
  write(o);

end;

Procedure ReadLoop(var cx:char);
var
  t1,d1:longint;
  t : integer;
  ch : char;
  rotate : byte;
begin
   t := 0;
   cx:=#0;
   ch:=#0;
   repeat
     inc(t);
     if t > 2000 then
       begin
          t := 0;
          inc(spin);
          if spin > 22 then spin := 0;
          If spin < 17 then Propeller(spin);
       end;
     ReadCh(ch);
     If ch <>#0 then  cx := ch;

   until (cx <> #0);
   cx:=Upcase(cx);
   if byte(cx) in [30..126] then write(cx+#8);
end;

Procedure MoveCheck(ch:char;newoption:byte);
var
 y:byte;
begin
  y:=4;
  case option of
   1:y:=4;
   2:y:=5;
   3:y:=6;
   4:y:=7;
   5:y:=8;
  end;
  TextColor(7);
  Gotoxy(18,y);
  write(' ');

  case ch of
   #222 : inc(option);
   #223 : dec(option);
   #224 : option:=newoption;
  end;

  If option < 1 then option:=5;
  If option > 5 then option:=1;
  case option of
   1 :y:=4;
   2 :y:=5;
   3 :y:=6;
   4 :y:=7;
   5 :y:=8;
  end;
  TextColor(10);
  Gotoxy(18,y);
  write(chr(251));
  gotoxy(1,15);
  TextBackground(0);
  clreol;

end;

Procedure T3Party(flag:byte);
var
 f,g: text;
 s:string;
 a:integer;
 ofm: word;
 i,c:byte;
 fn,gn:dirstr;
begin
 MoveCheck(#224,flag);

 fn:=lordfilepath+'3RDPARTY.DAT';
 ofm:=filemode;
 filemode:=66;
 assign(f,fn);
 {$i-}
 reset(f);
 {$i+}
 if ioresult<>0 then
 begin
    gotoxy(11,15);
    TextColor(7);
    write('File path: '+fn+' not found.');
    exit;
 end;
 gotoxy(1,20);

 gn:='TEMP.XXX';
 assign(g,gn);
 {$i-}
 rewrite(g);
 while not eof(f) do
  begin
    readln(f,s);
    s:=supcase(s);
    If Pos('XXXXIGM',s) >0 then
      readln(f,s)
    else
      writeln(g,s);
  end;

  if flag=1 then
   begin
     s:=gamefilepath+'XXXXIGM.EXE /N* /E';
     if (gamefilepath>'') and (gamefilepath<>lordfilepath) then
       s:=s+' /P'+lordfilepath;
     writeln(g,s);
     writeln(g,'`#L`5ord `#I`5GM');
  end;

  close(f);
  close(g);
  erase(f);
  rename(g,fn);
 {$i+}
  filemode:=ofm;

  gotoxy(1,15);
  c:=3;
  if flag=2 then c:=4;
  TextBackground(c);
  clreol;
  TextColor(c+8);
  if flag=1 then
    s:='XXXXIGM Installed'
  else
    s:='XXXXIGM Uninstalled';
  gotoxy(40-(length(s) div 2),15);
  write(s);
  TextBackground(0);
end;

procedure Title;
var
 s:string;
begin
  TextBackGround(0);
  TextColor(10);
  s:='-=-=-=-=-='+chr(21)+' XXXXIGM Install Program '+chr(21)+'=-=-=-=-=-';
  gotoxy(40-(length(s) div 2),2);
  write(s);
  Gotoxy(20,4);
  TextColor(2);
  write('(');
  TextColor(5);
  write('I');
  TextColor(2);
  write(')  Install XXXXIGM');
  Gotoxy(20,5);
  TextColor(2);
  write('(');
  TextColor(5);
  write('U');
  TextColor(2);
  write(')  Uninstall XXXXIGM');
  Gotoxy(20,6);
  TextColor(2);
  write('(');
  TextColor(5);
  write('L');
  TextColor(2);
  write(')  Define path to Lord directory');
  Gotoxy(20,7);
  TextColor(2);
  write('(');
  TextColor(5);
  write('P');
  TextColor(2);
  write(')  Define path to IGM directory');
  Gotoxy(20,8);
  TextColor(2);
  write('(');
  TextColor(15);
  write('Q');
  TextColor(2);
  write(')  Quit to DOS');
  option:=1;
  MoveCheck(#224,1);
end;

procedure ShowFilepath;
begin
  Gotoxy(20,10);
  TextColor(5);
  write('Lord File Path:');
  TextColor(7);
  TextBackGround(1);
  write(lordfilepath);
  TextBackGround(0);
  Gotoxy(20,11);
  TextColor(5);
  write('IGM File Path: ');
  TextColor(7);
  TextBackGround(1);
  write(gamefilepath);
  TextBackGround(0);
end;

procedure EnterLordPath;
var
  s:string;
  ch:char;
  ExitOK,EndOK:boolean;
  filenm:dirstr;
  DirInfo: SearchRec;
begin
  MoveCheck(#224,3);
  gotoxy(16,10);
  TextColor(14);
  write('Enter Path of Lord Directory>'+#8);
  TextBackGround(1);
  FrameEntry(30,wherex,10,1,s,exitok,endok);
  TextBackGround(0);
  gotoxy(16,10);
  write('                               ');
  if s[length(s)]<>'\' then s:=s+'\';
  temppath:=supcase(s);
  filenm:=temppath+'LORD.EXE';
  {$i-}
   FindFirst((filenm),AnyFile,DirInfo);
     if DosError=0 then
       Lordfilepath:=temppath;
 {$i+}
  gotoxy(1,15);
  TextBackground(0);
  clreol;

end;

procedure EnterIGMPath;
var
  s:string;
  ch:char;
  ExitOK,EndOK:boolean;
  filenm:dirstr;
  DirInfo: SearchRec;
begin
  MoveCheck(#224,4);
  gotoxy(16,11);
  TextColor(14);
  write('Enter Path of IGM Directory>'+#8);
  TextBackGround(1);
  FrameEntry(30,wherex,11,1,s,exitok,endok);
  TextBackGround(0);
  gotoxy(16,11);
  write('                               ');
  if s[length(s)]<>'\' then s:=s+'\';
  temppath:=supcase(s);
  filenm:=temppath+'XXXXIGM.EXE';
  {$i-}
   FindFirst((filenm),AnyFile,DirInfo);
     if DosError=0 then
       gamefilepath:=temppath;
 {$i+}
  gotoxy(1,15);
  TextBackground(0);
  clreol;

end;

procedure Prompt(var ch:char);
begin
  ch:=#3;
  repeat
   Showfilepath;
   TextColor(5);
   Gotoxy(28,23);
   write('Enter Option [ ]');
   TextColor(8);
   write(#8+#8);
   ReadLoop(ch);
   case  ch of
    #222,#223 : MoveCheck(ch,0);
    'I' : t3Party(1);
    'U' : t3Party(2);
    'L' : EnterLordPath;
    'P' : EnterIGMPath;
    #13 : case option of
           1: t3Party(1);
           2: t3Party(2);
           3: EnterLordPath;
           4: EnterIGMPath;
           5: ch:='Q';
          end;
   end;

  until ch in [#27,'X','E','Q'];
end;

procedure StatusLine;
begin
  progname:='DDIGMCHG XXXXIGM Install/Uninstall 1.0';
  window(1,1,80,numlines);
  TextColor(7);
  TextBackGround(0);
  clrscr;
  Gotoxy(1,numlines);
  textcolor(10);
  textbackground(2);
  clreol;
  gotoxy(40-(length(progname) div 2),numlines);
  write(progname);
end;

{Main routine}
var
  b:byte;
  ch:char;

BEGIN
  Getfilepath;
  FileMode := 66;
  numlines:=25;
  spin:=0;
  StatusLine;
  Title;
  Prompt(ch);
End.