Program Sample;

{$IFDEF MSDOS}
  {$M 40000,0,100000}
{$ENDIF}

Uses
  CRT,
  Door32;

Function Int2Str (N: LongInt): String;
Var
  T : String;
Begin
  Str(N, T);
  Int2Str := T;
End;

Function Str2Int (Str: String): LongInt;
Var
  I   : {$IFNDEF VIRTUALPASCAL} Word; {$ELSE} LongInt; {$ENDIF}
  Temp: LongInt;
Begin
  Val(Str, Temp, i);
  Str2Int := Temp;
End;

Procedure PlayGame;
Var
  Winner : Boolean;
  Number : Word;
  Guess  : Word;
  A      : Word;
  Ch     : Char;
Begin
  Randomize;

  Repeat
    Winner := False;
    Number := Random(999) + 1;

    SendCLS;
    SendLn ('|14Guess a number between 1 and 1000 - you have 10 guesses!');

    For Guess := 1 to 10 Do Begin
      Send ('|CR|09Guess #' + Int2Str(Guess) + ': ');

      A := Str2Int(Input(0, 4, inNumber, ''));

      SendLn ('');

      If Number > A Then
        SendLn ('|10The number is greater than |15' + Int2Str(A))
      Else
      If Number < A Then
        SendLn ('|10The number is less than |15' + Int2Str(A))
      Else Begin
        Winner := True;
        Break;
      End;
    End;

    If Winner Then
      SendLn ('|12You won!  And it only took you ' + Int2Str(Guess) + ' guesses!')
    Else
      SendLn ('|09You lost.  The number was ' + Int2Str(Number));

    Send ('|11Play again? (Y/N): ');
    If OneKey('YN', True) = 'N' Then Break;
  Until False;
End;

Var
  Res : Byte;
  Str : String;
Begin
  WriteLn;

  If ParamCount <> 1 Then Begin
    WriteLn ('SAMPLE.EXE : A simple sample door program');
    WriteLn;
    WriteLn ('Syntax  : SAMPLE <Path and filename of drop file>');
    {$IFNDEF MSDOS}
      WriteLn ('Example : SAMPLE C:\BBS\DOOR32.SYS');
    {$ELSE}
      WriteLn ('Example : SAMPLE C:\BBS\DORINFO1.DEF');
      WriteLn ('          SAMPLE C:\BBS\DOOR.SYS');
      WriteLn ('          SAMPLE C:\BBS\CHAIN.TXT');
    {$ENDIF}
    Halt;
  End;

  Res := OpenDOOR(ParamStr(1));

  Case Res of
    1 : WriteLn ('ERROR: Drop file not found.');
    2 : WriteLn ('ERROR: Error reading drop file');
    3 : WriteLn ('ERROR: Unknown drop file type');
    4 : WriteLn ('ERROR: Unable to open communications port');
  End;

  If Res <> 0 Then Halt;

  PlayGame;

  CloseDOOR;
End.
