Unit ScrnSave;

{ SCRNSAVE.PAS : Cross platform text mode screen saving object for DOS,    }
{ Win32, and OS/2.  Written By James Coyle - Updated March 21st, 1999      }

{ Note: This unit assumes that the program is running on a color system in }
{       80 x 25 line text mode.                                            }

Interface

Type
  ScrnSavePTR = ^ScrnSaveOBJ;
  ScrnSaveOBJ = Object
  Public
    OutputHandle : Longint;

                Constructor Init;
                Destructor  Done;
    Procedure   Save;
    Procedure   Restore;

    procedure   WriteXY(const X, Y: Byte; Attr: Byte; CH: Byte);
    procedure   GetXY(const X, Y: Byte; var Attr: Byte; var CH: Byte);
  Private
    SavedX : Byte;
    SavedY : Byte;
                SavedA : Byte;
    Buffer : Array[0..3999] of Byte;
  End;

Implementation

Uses CRT
  {$IFDEF WIN32}
    ,Windows
  {$ENDIF}

  {$IFDEF OS2}
    ,Os2Base
  {$ENDIF};

Constructor ScrnSaveOBJ.Init;
Begin
  OutputHandle := -1;

  {$IFDEF VirtualPascal}
    {$IFDEF WIN32}
      OutputHandle := SysFileStdOut;
    {$ENDIF}

    {$IFDEF OS2}
      OutputHandle := TvVioHandle;
    {$ENDIF}
  {$ENDIF}

  {$IFDEF FPC}
    OutputHandle := OutHandle;
  {$ENDIF}
End;

Destructor ScrnSaveOBJ.Done;
Begin
End;

Procedure ScrnSaveOBJ.Save;
{$IFNDEF MSDOS}
Var
  P : Word;
  X : Byte;
  Y : Byte;
{$ENDIF}
Begin
  SavedX := WhereX;
  SavedY := WhereY;
        SavedA := TextAttr;

  {$IFDEF MSDOS}
    Move (Mem[$B800:$0000], Buffer, 4000);
  {$ELSE}
    P := 0;
    For Y := 0 to 24 Do
      For X := 0 to 79 Do Begin
        begin
          GetXY(X, Y, Buffer[P], Buffer[P + 1]);
          Inc (P, 2);
        end; { if }
      End;
  {$ENDIF}
End;

Procedure ScrnSaveOBJ.Restore;
{$IFNDEF MSDOS}
Var
  X, Y    : Longint;
  P       : Longint;
{$ENDIF}
Begin
  {$IFDEF MSDOS}
    Move (Buffer, Mem[$B800:$0000], 4000);
  {$ELSE}
    P := 0;
    For Y := 0 to 24 Do
      For X := 0 to 79 Do
        begin
           WriteXY(X, Y, Buffer[P], Buffer[P + 1]);
           Inc (P, 2);
        end; { for }
  {$ENDIF}

  GotoXY (SavedX, SavedY);
  TextAttr := SavedA;
End;

procedure ScrnSaveObj.WriteXY(const X, Y: Byte; Attr: Byte; CH: Byte);
{$IFDEF WIN32}
var Cell    : TCharInfo;
    BufSize : TCoord;                   { Column-row size of source buffer }
    WritePos: TCoord;                      { Upper-left cell to write from }
    DestRect: TSmallRect;
{$ENDIF}

{$IFDEF MSDOS}
var OldX, OldY, OldA: Byte;
{$ENDIF}

{$IFDEF OS2}
var TempStr: String;
{$ENDIF}
begin
  {$IFDEF WIN32}
    BufSize.X := 01;
    BufSize.Y := 01;

    WritePos.X := 0;
    WritePos.Y := 0;

    Cell.Attributes := Attr;
    Cell.UniCodeChar := Ord(CH);

    DestRect.Left := X;
    DestRect.Top := Y;
    DestRect.Right := X;
    DestRect.Bottom := Y;

    WriteConsoleOutput(OutputHandle, @Cell, BufSize, WritePos, DestRect);
  {$ENDIF}

  {$IFDEF OS2}
    VioWrtCharStrAtt(@CH, 1, Y, X, Attr, OutputHandle);
  {$ENDIF}


  {$IFDEF MSDOS}
    OldX := WhereX;
    OldY := WhereY;
    OldA := TextAttr;

    GotoXY(X, Y);
    TextAttr := Attr;
    Write(CH);

    GotoXY(OldX, OldY);
    TextAttr := OldA;
  {$ENDIF}
end; { proc. WriteXY }


procedure ScrnSaveObj.GetXY(const X, Y: Byte; var Attr: Byte; var CH: byte);
{$IFDEF WIN32}
var Reads: DWORD;
    Coord: TCoord;

    Temp: SmallWord;
{$ENDIF}

{$IFDEF OS2}
var ScrnWord,
    ReadSize : SmallWord;
{$ENDIF}
begin
  {$IFDEF WIN32}
    FillChar(Coord, SizeOf(Coord), 0);
    Coord.X := X;
    Coord.Y := Y;

    ReadConsoleOutputCharacter(OutputHandle, @Temp, 1, Coord, Reads);
    Ch := Byte(Temp);

    ReadConsoleOutputAttribute(OutputHandle, @Temp, 1, Coord, Reads);
    Attr := Byte(Temp);
  {$ENDIF}

  {$IFDEF OS2}
    ReadSize := SizeOf(ScrnWord);
    VioReadCellStr(ScrnWord, ReadSize, Y, X, OutputHandle);

    Attr := Hi(ScrnWord) and $7f;
    CH := Lo(ScrnWord);
  {$ENDIF}

  {$IFDEF MSDOS}
    { dummy }
  {$ENDIF}
end; { proc. GetXY }

End.
