{****************************************************************************}
{**                                                                        **}
{**         Datentypen und Strukturen im Pascal-Include-Format             **}
{**                                                                        **}
{**                  Copyright by Michael von Tessin                       **}
{**                                                                        **}
{****************************************************************************}

{****************************************************************************}
{**        Binaer-Datei (*.VFL), Listen-Struktur-Versionsnummer: 1         **}
{****************************************************************************}

{ Die Typen sind in der Reihenfolge aufgefuehrt, wie sie in der Datei auch   }
{ wirklich vorkommen. Offsets und Areanummern beginnen immer bei 0.          }

{ Type SmallWord = System.Word }

Const  HEADER_ID:      Array[1..24] Of Char = 'VF-List binary filelist ';
       STRUCT_VERSION: Byte = 1;

Type   PHeaderRec = ^THeaderRec;
       THeaderRec = Record
         ID_String:  Array[1..24] Of Char;     {Immer HEADER_ID              }
         VersNr:     Byte;                     {Immer STRUCT_VERSION         }
         Erst_Prog:  String[50];               {Name des Programms, das die  }
                                               {Liste erstellt hat           }
         BBSName,                              {Mailboxname                  }
         SysopName:  String[30];               {Sysopname                    }
         TotalSize:  LongInt;                  {Total Filebase-Groesse in KB!}
         TotAnzFile: LongInt;                  {Totale Anzahl Files in der FB}
         Day,                                  {Erstellungs-Datum:           }
         Month,                                {  Tag, Monat, Jahr           }
         Year:       SmallWord;                {  (Jahr 4-stellig)           }
       End;

Type   POffsetRec = ^TOffsetRec;
       TOffsetRec = Record     {Offsets: In Byte relativ zum Dateianfang     }
         Infoblatt,            {Wo der Infotext startet                      }
         Areas,                {Wo die Area-Records starten                  }
         Directories,          {Wo die Directory-Records starten             }
         Dir_Tabelle,          {Wo die Directory-Tabelle ist                 }
         File_Recs,            {Wo die TFileRec-Records starten              }
         File_Descs:  LongInt; {Wo die File-Descriptions starten             }
       End;

Type   PMagicRec = ^TMagicRec;
       TMagicRec = Record
         MagicName: String[12];  {Magic-Name                                 }
         RealFName: String[12];  {Wirklicher Name des Files                  }
         Password:  Byte;        {Bit 0: Request benoetigt Passwort          }
         Desc:      String[50];  {Beschreibung des Magics                    }
       End;

{ An dieser Stelle kommt das "Infoblatt". Dies wird im normalen Textformat   }
{ abgespeichert. Fuer einen Zeilenvorsprungen wird jedoch kein CR+LF sondern }
{ ein ASCII 0 benutzt.                                                       }

Type   PAreaRec = ^TAreaRec;
       TAreaRec = Record
         AreaName:  String[60];  {Name der Area                              }
         Orig_Num:  SmallWord;   {Original-Area-Nummer (in Concord)          }
         ID_Ofs:    SmallWord;   {Ab dem wievielten TFileRec-Record sind die }
                                 {Files dieser Area aufgelistet              }
         ID_Anz:    SmallWord;   {Wieviele TFileRecs beinhaltet die Area?    }
         Size:      LongInt;     {Groesse aller Files in der Area in Byte    }
         AnzFile:   SmallWord;   {Wieviele Dateien (ohne Kommentar-Linien)   }
       End;                      {beinhaltet diese Area?                     }

Type   PDirectoryRec = ^TDirectoryRec;
       TDirectoryRec = Record
         DirectoryName: String[60]; {Name des Unterverzeichnisses            }
         SD_Ptr:        SmallWord;  {An der vievielten Stelle (Anz. Words in }
                                    {der Directory-Tabelle) die Liste der    }
                                    {Subdirectories unter diesem Directory   }
                                    {beginnen.                               }
         SD_Anz:        SmallWord;  {Wieviele Subdirectories hat dieses Dir.?}
         AR_Ptr:        SmallWord;  {Ab dem wievielten TAreaRec die Areas    }
                                    {von diesem Directory beginnen           }
         AR_Anz:        SmallWord;  {Wieviele Areas hat dieses Dir.?         }
       End;

{ Der erste Directory-Record ist sozusagen das "Stammverzeichnis". D.h. er   }
{ beinhaltet die Information, welche Areas und SubDirs sind in der untersten }
{ "Ebene" befinden. Als Name traegt er die Listenbezeichnung.                }

{ Hier folgt nun die Directory-Tabelle. Diese Tabelle ist eine Ansammlung von}
{ SmallWords. Jedes Directory beansprucht einen Teil dieser Tabelle als Liste}
{ fuer sich. Es kann also in die Liste abspeichern, welche Directories zu ihm}
{ gehoeren.                                                                  }

Type   PFileRec = ^TFileRec;
       TFileRec = Record
         FileName: String[12];           {Name des Files                     }
                                         {Wenn FileName = '': Dieser Record  }
                                         {bezeichnet kein File, sondern einen}
                                         {Kommentar, dessen Text gleich wie  }
                                         {bei einem File eingelesen wird, je-}
                                         {doch max. 1 Linie beinhalten darf. }
                                         {"DateTime", "DL_Count", "Size" und }
                                         {"Options" werden ignoriert.        }
         DateTime: LongInt;              {Datum/Zeit des Files gepackt (DOS) }
                                         {Wenn DateTime = 0: File ist Offline}
         DL_Count: SmallWord;            {Anzahl Downloads                   }
         Size:     LongInt;              {Filegroesse in Byte                }
         Desc_Ptr: LongInt;              {Zeiger auf File-Desc., in Byte rel.}
                                         {zum Anfang des Desc-Abschnitts.    }
         Desc_Len: SmallWord;            {Laenge der Desc in Byte (max. 8192)}
       End;

{ Hier sind dann die Datei-Descriptions. Diese werden in normalem Textformat }
{ geschrieben (wie das "Infoblatt"). Auch hier werden CR+LF durch ein ASCII 0}
{ ersetzt.                                                                   }

{ EOF }
