{****************************************************************************}
{**                                                                        **}
{**         Datentypen und Strukturen im Pascal-Include-Format             **}
{**                                                                        **}
{**                  Copyright by Michael von Tessin                       **}
{**                                                                        **}
{****************************************************************************}

{****************************************************************************}
{**        Textfile-Diff-Datei (*.TXD) / Struktur-Versionsnummer: 1        **}
{****************************************************************************}

{ Type SmallWord = System.Word }

Const DIFF_HEADER_ID:      Array[1..21] Of Char = 'TXD-Format Diff-File ';
      DIFF_STRUCT_VERSION: Byte                 = 1;

Type DiffHeadRec = Record
       Header_ID: Array[1..21] Of Char; {ist immer DIFF_HEADER_ID            }
       VersNr:    Byte;                 {ist immer DIFF_STRUCT_VERSION       }
       OldCRC:    LongInt;              {CRC-32 des alten Files              }
     End;

Type DiffPointRec = Record
       OldFilePos:  LongInt;            {Offset im alten File                }
       OldFileAnz:  SmallWord;          {Anzahl der zu lesenden Bytes        }
       ToNextPoint: SmallWord;          {Anzahl Bytes bis zum naechsten      }
     End;                               {DiffPointRec                        }

{ == Anwendungs-Beschreibung: ==

 Fuer die Berechnung des CRC32 im DiffHeadRec werden alle Zeilen inkl. allen
 Zeilenvorschueben miteinbezogen. Ein allfaelliger #26 (ASCII 26) am Schluss
 des Files wird jedoch NICHT miteinbezogen!
 Nach dem DiffHeadRec steht als erstes ein DiffPointRec. Dieser wird eingele-
 sen und folgendermassen ausgewertet:
 Ab der Position OldFilePos werden OldFileAnz Bytes eingelesen und ins New-
 file geschrieben.
 Dann muessen ToNextPoint Bytes vom Diff-File gelesen und ins Newfile kopiert
 werden.
 An der jetzigen Diff-File-Position steht nun wieder der nchste DiffPiontRec.
 Dies geht so weiter, bis das Ende des Diff-Files erreicht ist. }

{ EOF }
