(* RA2XX (c) Copyright 1996 by Pasi Talliniemi *)

Uses Crt, Dos, Strings, { standard units }
     MyFunc,            { own function library }
     ConcStruct,        { STRUCT.INC }
     RAStruct;          { STRUCT.250 }

var RApath: DirStr;
    ConcordPath: DirStr;
    IORes: Integer;

Procedure HandleIORes (Fname: PathStr);
begin
  WriteLn ('Error ', IORes, ' with ', Fname);
end;

Procedure ConvertSecurity (SecLvl: Word; Flags, NotFlags: FlagType;
                           Age: Byte; BpsRate: Byte;
                           var ConcordSecurity: Security);
var A: Integer;
begin
  FillChar (ConcordSecurity, SizeOf (ConcordSecurity), #0);
  ConcordSecurity.BpsRate := BpsRate;
  ConcordSecurity.Age     := Age;
  ConcordSecurity.SecLvl  := SecLvl;
  for A := 1 to 4 do begin
    ConcordSecurity.Flags    [A] := Flags    [A];
    ConcordSecurity.NotFlags [A] := NotFlags [A];
  end;
end;

Procedure ConvertGroup (Group1: Word; Group2: GroupStr);
const CharSet: String [35] = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
begin
  Group2 := CharSet [Group1 shr 10 and $1F] +
            CharSet [Group1 shr 5 and $1F] +
            CharSet [Group1 and $1F];
end;

Procedure ConvertMessageAreas;
var F1: File of MESSAGErecord;
    R1: MESSAGErecord;
    F2: File of MAreaRec;
    R2: MAreaRec;
    A, Num: Integer;
begin
  Num := 0;
  WriteLn ('Converting message area list...');
  Assign (F1, RApath + 'MESSAGES.RA');
  {$I-} Reset (F1); {$I+} IORes := IOResult;
  if IORes = 0 then begin
    Assign (F2, ConcordPath + 'MAREAS.DAT');
    {$I-} Reset (F2); {$I+} IORes := IOResult;
    if IORes = 2 then begin
      {$I-} Rewrite (F2); {$I+} IORes := IOResult;
    end;
    if IORes = 0 then begin
      Seek (F2, FileSize (F2));
      while not Eof (F1) do begin
        Read (F1, R1);
        FillChar (R2, SizeOf (R2), #0);
        R2.Id := ID_CFG_MAREA;
        R2.Name := R1.Name;
        R2.ShortName := Copy (R2.Name, 1, 15);
        if R2.Name <> '' then begin
          R2.Attrib := MAREA_ACTIVE;
        end;
        if R1.Attribute and (1 shl 1) <> 0 then begin
          R2.Attrib := R2.Attrib or MAREA_SELECT;
        end;
        if R1.Attribute and (1 shl 2) <> 0 then begin
          R2.Attrib := R2.Attrib or MAREA_FATTACH;
        end;
        if R1.Attribute and (1 shl 6) <> 0 then begin
          R2.Attrib := R2.Attrib or MAREA_DELETE;
        end;
        if R1.Attribute and (1 shl 7) <> 0 then begin
          R2.Format   := MAREAFMT_JAM;
          R2.Pathname := R1.JAMbase;
          R2.OwnBoard := 0;
        end else begin
          R2.Format   := MAREAFMT_HMB;
          R2.Pathname := ConcordPath + 'HUDSON\';
          if (R1.AreaNum = 0) then begin
            Inc (Num);
            R2.OwnBoard := Num;
          end else begin
            R2.OwnBoard := R1.AreaNum;
          end;
        end;
        ConvertGroup (R1.Group, R2.Group);
        R2.PassWord := '';
        case R1.Typ of
          LocalMail: R2.Typ := MAREATYPE_LOCAL;
          NetMail:   R2.Typ := MAREATYPE_NET;
          EchoMail:  R2.Typ := MAREATYPE_ECHO;
          Internet:  R2.Typ := MAREATYPE_ECHO; { not supported }
          Newsgroup: R2.Typ := MAREATYPE_ECHO; { not supported }
        end;
        R2.ReplyStatus := MAREAREPLY_BOTH;
        case R1.MsgKinds of
          Both:    R2.Kinds := MAREAKIND_BOTH;
          Private: R2.Kinds := MAREAKIND_PRIV;
          Public:  R2.Kinds := MAREAKIND_PUB;
          ROnly:   R2.Kinds := MAREAKIND_RO;
          NoReply: begin
                     R2.Kinds := MAREAKIND_BOTH;
                     R2.ReplyStatus := MAREAREPLY_NONE;
                   end;
        end;
        if R1.Attribute and (1 shl 3) <> 0 then begin
          if R1.Attribute and (1 shl 5) <> 0 then begin
            R2.UseAlias := MAREAALIAS_YES;
          end else begin
            R2.UseAlias := MAREAALIAS_BOTH;
          end;
        end else begin
          R2.UseAlias := MAREAALIAS_NO;
        end;
        ConvertSecurity (R1.ReadSecurity,  R1.ReadFlags,  R1.ReadNotFlags,  R1.Age, 0, R2.ReadRights);
        ConvertSecurity (R1.WriteSecurity, R1.WriteFlags, R1.WriteNotFlags, R1.Age, 0, R2.WriteRights);
        ConvertSecurity (R1.SysopSecurity, R1.SysopFlags, R1.SysopNotFlags, R1.Age, 0, R2.SysopRights);
        R2.DaysKill     := R1.DaysKill;
        R2.ReceiveKill  := R1.RecvKill;
        R2.CountKill    := R1.CountKill;
        R2.SubDirNum    := 0;
        R2.UseAka       := R1.AkaAddress;
        R2.CharTable    := 0;
        R2.OriginLine   := R1.OriginLine;
        R2.OpenFrom     := 0;
        R2.OpenTo       := 1439;
        R2.JumpDirNum   := 0;
        R2.ReplyArea    := 0; { R1.NetMailArea }
        { not supported :
          AltGroup   : Array[1..3] of Word;
          Attribute2 : Byte; -- Bit 0 : Include in all groups
          Attribute  : Bit 0 : Enable EchoInfo
                       Bit 4 : Use SoftCRs as characters
        }
        Write (F2, R2);
      end;
      WriteLn ('Conversion finished.');
      WriteLn ('Move Hudson message base to path ', ConcordPath, 'HUDSON\');
    end else begin
      HandleIORes (ConcordPath + 'MAREAS.DAT');
    end;
    Close (F1);
  end else begin
    HandleIORes (RApath + 'MESSAGES.RA');
  end;
end;

Procedure ConvertFileAreas;
var F1: File of FILESrecord;
    R1: FILESrecord;
    F2: File of FAreaRec;
    R2: FAreaRec;
    A, Num: Integer;
begin
  Num:=0;
  WriteLn ('Converting file area list...');
  Assign (F1, RApath + 'FILES.RA');
  {$I-} Reset (F1); {$I+} IORes := IOResult;
  if IORes = 0 then begin
    Assign (F2, ConcordPath + 'FAREAS.DAT');
    {$I-} Reset (F2); {$I+} IORes := IOResult;
    if IORes = 2 then begin
      {$I-} Rewrite (F2); {$I+} IORes := IOResult;
    end;
    if IORes = 0 then begin
      Seek (F2, FileSize (F2));
      while not Eof (F1) do begin
        Read (F1, R1);
        FillChar (R2, SizeOf (R2), #0);
        R2.Id           := ID_CFG_FAREA;
        R2.Name         := R1.Name;
        if R2.Name <> '' then begin
          R2.Attrib     := FAREA_ACTIVE;
        end;
        R2.DownloadPath := AddSlash (R1.FilePath);
        R2.Password     := R1.Password;
        R2.UploadArea   := R1.UploadArea;
        R2.ArchiveFmt   := R1.ConvertExt;
        R2.KillDaysDL   := R1.KillDaysDL;
        R2.KillDaysFD   := R1.KillDaysFD;
        R2.FilePoints   := R1.DefCost;
        R2.Basename     := ZeroStart (R1.AreaNum, 5);
        If (R1.Areanum=0) Then Begin
        Inc(Num);
        R2.Basename := ZeroStart (Num, 5);
        End;
        R2.OpenFrom     := 0;
        R2.OpenTo       := 1439;
        if R1.Attrib and (1 shl 0) <> 0 then begin
          R2.Attrib := R2.Attrib or FAREA_NEWFILES;
        end;
        if R1.Attrib and (1 shl 1) <> 0 then begin
          R2.Attrib := R2.Attrib or FAREA_DUPECHK;
        end;
        if R1.Attrib and (1 shl 3) <> 0 then begin
          R2.Attrib := R2.Attrib or FAREA_CDROM;
        end;
        if R1.Attrib and (1 shl 4) <> 0 then begin
          R2.Attrib := R2.Attrib or FAREA_FREE;
        end;
        if R1.Attrib and (1 shl 5) <> 0 then begin
          R2.Attrib := R2.Attrib or FAREA_NOLISTREQ;
        end;
        if R1.Attrib and (1 shl 7) <> 0 then begin
          R2.Attrib := R2.Attrib or FAREA_VIRUSCHK;
        end;
        ConvertGroup (R1.Group, R2.Group);
        ConvertSecurity (R1.UploadSecurity, R1.UploadFlags, R1.UploadNotFlags, R1.Age, 0, R2.UploadSec);
        ConvertSecurity (R1.Security,       R1.Flags,       R1.NotFlags,       R1.Age, 0, R2.DownloadSec);
        ConvertSecurity (R1.ListSecurity,   R1.ListFlags,   R1.ListNotFlags,   R1.Age, 0, R2.FileListSec);
        { not supported :
          AltGroup   : Array[1..3] of Word;
          Attrib     : Byte; -- Bit 2 : Permit long descriptions
                                Bit 6 : Allow users to password uploads
          Attrib2    : Byte; -- Bit 0 : Include in all groups
          Device     : Byte;
        }
        Write (F2, R2);
      end;
      WriteLn ('Conversion finished.');
    end else begin
      HandleIORes (ConcordPath + 'FAREAS.DAT');
    end;
    Close (F1);
  end else begin
    HandleIORes (RApath + 'FILES.RA');
  end;
end;

Procedure ConvertFileList;
const BLOCK_SIZE = 80;
var F1: File of FILESrecord;
    R1: FILESrecord;
    F2: File of FILESHDRrecord;
    R2: FILESHDRrecord;
    F3: File of FileListRec;
    R3: FileListRec;
    F4: File;
    R4: Array [0..2048] of Char;
    F5: File;
    A, Num: Integer;
    P: Byte;
    RaConfigPath, RAFileBasePath : String;
    SysRec : CONFIGrecord;
    SysFile : File of CONFIGrecord;
    Holder: Char;
    NumRead: Word;
begin
  Num:=0;
  WriteLn ('Converting file lists...');
  Assign (F1, RApath + 'FILES.RA');
  {$I-} Reset (F1); {$I+} IORes := IOResult;
  if IORes = 0 then begin
    RAConfigPath:=RAPath+'CONFIG.RA';
    Assign(SysFile, RAConfigPath);
    {$I-}
    Reset(SysFile);
    {$I+}
    If IOResult <> 0 Then Begin
       WriteLn('Error reading ',RAConfigPath);
       Delay(2000);
       Halt(1);
       End;
    Read(SysFile, SysRec);
    Close(SysFile);
    RAFileBasePath:=AddSlash(SysRec.FileBasePath);
    while not Eof (F1) do begin
      Inc(Num);
      Read (F1, R1);
      if R1.Name <> '' then begin
        Assign (F2, RAFileBasePath + 'HDR\FDB' + ToStr(Num) + '.HDR');
        {$I-} Reset (F2); {$I+} IORes := IOresult;
        if IORes = 0 then begin
          Assign (F5, RAFileBasePath + 'TXT\FDB' + ToStr(Num) + '.TXT');
          {$I-} Reset (F5, 1); {$I+} IORes := IOresult;
          if IORes = 0 then begin
            If (R1.AreaNum=0) Then Assign (F3, ConcordPath + 'FILEBASE\' + ZeroStart (Num, 5) + '.HDR')
            Else Assign (F3, ConcordPath + 'FILEBASE\' + ZeroStart (R1.AreaNum, 5) + '.HDR');
            {$I-} Rewrite (F3); {$I+} IORes := IOresult;
            if IORes = 0 then begin
              If (R1.AreaNum=0) Then Assign (F4, ConcordPath + 'FILEBASE\' + ZeroStart (Num, 5) + '.TXT')
              Else Assign (F4, ConcordPath + 'FILEBASE\' + ZeroStart (R1.AreaNum, 5) + '.TXT');
              {$I-} Rewrite (F4, 1); {$I+} IORes := IOresult;
              if IORes = 0 then begin
                while not Eof (F2) do begin
                  Read (F2, R2);
                  Seek (F5, R2.LongDescPtr);
                  FillChar (R3, SizeOf (R3), #0);
                  FillChar (R3.Name, SizeOf (R3.Name), #32);
                  P := Pos ('.', R2.Name);
                  if P = 0 then begin
                    Move (R2.Name [1], R3.Name [1], Length (R2.Name));
                  end else begin
                    Move (R2.Name [1],     R3.Name [1], P - 1);
                    Move (R2.Name [P + 1], R3.Name [9], Length (R2.Name) - P);
                  end;
                  R3.Size       := R2.Size;
                  R3.UploadDate := R2.UploadDate;
                  R3.Downloads  := R2.TimesDL;
                  R3.DescPtr    := FilePos (F4);
                  R3.DescRecLen := 0;
                  R3.UpLdrLen   := 1+Length (R2.Uploader);
                  if R2.Attrib and (1 shl 0) <> 0 then begin
                    R3.Attribute := R3.Attribute or (1 shl 0);
                  end;
                  if R2.Attrib and (1 shl 1) <> 0 then begin
                    R3.Attribute := R3.Attribute or (1 shl 3);
                  end;
                  if R2.Attrib and (1 shl 3) <> 0 then begin
                    R3.Attribute := R3.Attribute or (1 shl 1);
                  end;
                  if R2.Attrib and (1 shl 5) <> 0 then begin
                    R3.Attribute := R3.Attribute or (1 shl 2);
                  end;
                  { not supported :
                    CRC32    : longint;
                    filedate : longint;
                    lastdate : longint;
                    password : string [15];
                    keyword  : array [1..5] of string [15];
                    cost     : word;
                    Attrib - 2 : Free (don't adjust ratio) - Does NOT affect "Cost"
                             4 : Locked (no kill)
                             6 : No time restrictions - always allow DL
                  }
                  Repeat
                    BlockRead (F5, R4 [R3.DescRecLen], BLOCK_SIZE, NumRead);
                    for A := 1 to NumRead do begin
                      if R4 [R3.DescRecLen] = #0 then begin
                        Inc (R3.DescRecLen);
                        NumRead := 0;
                        Break;
                      end;
                      Inc (R3.DescRecLen);
                    end;
                  Until (NumRead = 0) or (R3.DescRecLen > 1024);
                  if R3.DescRecLen > 1024 then begin
                    R3.DescRecLen := 1023;
                  end;
                  if (R3.DescRecLen = 0) or (R4 [R3.DescRecLen] <> #0) then begin
                    R4 [R3.DescRecLen] := #0;
                    Inc (R3.DescRecLen);
                  end;
                  BlockWrite (F4, R4, R3.DescRecLen);
                  Write(F3, R3);
                  Move (R2.Uploader [1], R4 [0], Length (R2.Uploader));
                  R4 [Length (R2.Uploader)] := #0;
                  BlockWrite (F4, R4, R3.UpldrLen);
                end;
                Close (F4);
              end else begin
                HandleIORes (ConcordPath + 'FILEBASE\' + ZeroStart (R1.AreaNum, 5) + '.TXT');
              end;
              Close (F3);
            end else begin
              HandleIORes (ConcordPath + 'FILEBASE\' + ZeroStart (R1.AreaNum, 5) + '.HDR');
            end;
            Close (F5);
          end else begin
            HandleIORes (RAFileBasePath + 'HDR\FDB' + ToStr(Num) + '.HDR');
          end;
          Close (F2);
        end else begin
          HandleIORes (RAFileBasePath + 'TXT\FDB' + ToStr(Num) + '.TXT');
        end;
      end;
    end;
    Close (F1);
  end else begin
    HandleIORes (RApath + 'FILES.RA');
  end;
end;

Procedure ConvertUserBase;
var F1: File of USERSrecord;
    R1: USERSrecord;
    F2: File;
    R2: UserRec;
    H2: UserFileHeader;
    F3: File of NameIdxRec;
    I3: NameIdxRec;
    F4: File;
    R4: Array [0..2048] of Char;
    F5: File of FlexUserIdxRec;
    I5: FlexUserIdxRec;
    A:  Integer;
    RAConfigPath, RAUserPath : String;
    SysRec : CONFIGrecord;
    SysFile : File of CONFIGrecord;
    EmptyAreas: Array [1..50] of Byte;
begin
  RAConfigPath:=RAPath+'CONFIG.RA';
  Assign(SysFile,RAConfigPath);
  {$I-}
  Reset(SysFile);
  {$I+}
  If IOResult <> 0 Then Begin
             WriteLn('Error reading ',RAConfigPath);
             Delay(2000);
             Halt(1);
             End;
  Read(SysFile, SysRec);
  Close(SysFile);
  RAUserPath:=AddSlash(SysRec.MsgBasePath);
  WriteLn ('Converting user files...');
  Assign (F1, RAUserPath+'USERS.BBS');
  {$I-} Reset (F1); {$I+} IORes := IOResult;
  if IORes = 0 then begin
    Assign (F2, ConcordPath + 'USERINFO.DAT');
    {$I-} Reset (F2, 1); {$I+} IORes := IOResult;
    if IORes = 2 then begin
      {$I-} Rewrite (F2, 1); {$I+} IORes := IOResult;
      if IORes = 0 then begin
        FillChar (H2, SizeOf (H2), #0);
        H2.Id       := ID_USR_HDR;
        H2.Version  := CURRVERNUM;
        H2.UserSize := SizeOf (UserRec);
        BlockWrite (F2, H2, SizeOf (H2));
      end;
    end;
    if IORes = 0 then begin
      Seek (F2, FileSize (F2));
      Assign (F3, ConcordPath + 'USERINFO.IDX');
      {$I-} Reset (F3); {$I+} IORes := IOResult;
      if IORes = 2 then begin
        {$I-} Rewrite (F3); {$I+} IORes := IOResult;
      end;
      if IORes = 0 then begin
        Seek (F3, FileSize (F3));
        Assign (F4, ConcordPath + 'USERINF2.DAT');
        {$I-} Reset (F4, 1); {$I+} IORes := IOResult;
        if IORes = 2 then begin
          {$I-} Rewrite (F4, 1); {$I+} IORes := IOResult;
        end;
        if IORes = 0 then begin
          Seek (F4, FileSize (F4));
          Assign (F5, ConcordPath + 'USERINF2.IDX');
          {$I-} Reset (F5); {$I+} IORes := IOResult;
          if IORes = 2 then begin
            {$I-} Rewrite (F5); {$I+} IORes := IOResult;
          end;
          if IORes = 0 then begin
            FillChar (EmptyAreas, SizeOf (EmptyAreas), #0);
            Seek (F5, FileSize (F5));
            while not Eof (F1) do begin
              Read (F1, R1);
              FillChar (R2, SizeOf (R2), #0);
              FillChar (I3, SizeOf (I3), #0);
              FillChar (R4, SizeOf (R4), #0);
              FillChar (I5, SizeOf (I5), #0);
              R2.Id            := ID_USR_REC;
              R2.Name          := R1.Name;
              R2.Alias         := R1.Handle;
              R2.City          := R1.Location;
              R2.Voice         := R1.VoicePhone;
              R2.Data          := R1.DataPhone;
              R2.Birthday      := PackDate (R1.Birthdate);
              R2.Password      := R1.Password;
              R2.Sec.SecLvl    := R1.Security;
              for A := 1 to 4 do begin
                R2.Sec.Flags [A] := R1.Flags [A];
              end;
              R2.ScreenLen     := R1.ScreenLength;
              R2.FirstTime     := ToUnixTime2 (R1.FirstDate, '00:00');
              R2.LastTime      := ToUnixTime2 (R1.LastDate, R1.LastTime);
              R2.TimesCalled   := R1.NoCalls;
              R2.TotalMinutes  := 0;
              R2.Pages         := 0;
              R2.PublicMsgs    := R1.MsgsPosted;
              R2.PrivateMsgs   := 0;
              R2.UpK           := R1.UploadsK;
              R2.UpTimes       := R1.Uploads;
              R2.DownK         := R1.DownloadsK;
              R2.DownTimes     := R1.Downloads;
              R2.SysopCmnt     := R1.Comment;
              R2.Expiration    := 0;
              R2.FirstMenu     := '';
              R2.Language      := '';
              R2.MessageArea   := R1.MsgArea;
              R2.FileArea      := R1.FileArea;
              R2.Door          := 0;
              R2.ChatChannel   := 0;
              R2.TodayCalls    := 0;
              R2.TodayElapsed  := R1.Elapsed;
              R2.TodayDownK    := R1.TodayK;
              R2.TodayDowns    := 0;
              R2.TimeInBank    := 0;
              R2.DLLimitInBank := 0;
              R2.ViewFileName  := '';
              R2.OfflineFmt    := 0;
              R2.OfflineDays   := 0;
              R2.ReadMsgNum    := 0;
              R2.FileListNum   := 0;
              R2.TodayLastPkt  := 0;
              R2.VerifyCalls   := 0;
              R2.PasswordTries := 0;
              R2.OfflineMaxNum := 1000;
              R2.FlexPos       := FilePos (F5);
              R2.LastPktDl     := 0;
              R2.BBSCRC        := -1;
              if R1.Attribute and (1 shl 3) <> 0 then begin
                if R1.Attribute2 and (1 shl 1) <> 0 then begin
                  R2.Emulation := 2;
                end else begin
                  R2.Emulation := 1;
                end;
              end else begin
                R2.Emulation   := 4;
              end;
              R2.TextFileType  := 0;
              R2.DateFormat    := 0;
              R2.PasswordCRC   := R1.PasswordCRC;
              R2.LastVoteChk   := 0;
              R2.TodayLastDesc := 0;
              R2.TimeUnits     := 0;
              R2.KBUnits       := 0;
              R2.Attrib1 := USER_MAILCHK or USER_FILECHK or USER_COLORS;
              if R1.Attribute and (1 shl 0) <> 0 then begin
                R2.Attrib1 := R2.Attrib1 or USER_DELETED;
              end;
              if R1.Attribute and (1 shl 1) <> 0 then begin
                R2.Attrib1 := R2.Attrib1 or USER_CLRSCR;
              end;
              if R1.Attribute and (1 shl 2) <> 0 then begin
                R2.Attrib1 := R2.Attrib1 or USER_MORE;
              end;
              if R1.Attribute and (1 shl 4) <> 0 then begin
                R2.Attrib1 := R2.Attrib1 or USER_NOKILL;
              end;
              if R1.Attribute and (1 shl 7) <> 0 then begin
                R2.Attrib1 := R2.Attrib1 or USER_NODISTURB;
              end;
              if R1.Attribute2 and (1 shl 0) <> 0 then begin
                R2.Attrib1 := R2.Attrib1 or USER_HOTKEYS;
              end;
              if R1.Sex = 2 then begin
                R2.Attrib1 := R2.Attrib1 or USER_FEMALE;
              end;
              R2.OfflineAttrib := OFFLINE_WELCOME or OFFLINE_NEWS or
                                  OFFLINE_GOODBYE or OFFLINE_LASTREAD or
                                  OFFLINE_RECEIVED;
              I3.NameCRC32  := CRC_32 (Capit (R2.Name));
              I3.AliasCRC32 := CRC_32 (Capit (R2.Alias));
              I5.NameCRC32  := I3.NameCRC32;
              I5.FilePos    := FilePos (F4);
              I5.AddrLen    := 0;
              I5.CmntLen    := 0;
              I5.MailLen    := 0;
              I5.MAreaCnt   := SizeOf (EmptyAreas) * 8;
              I5.FAreaCnt   := SizeOf (EmptyAreas) * 8;
              Move (R1.Address1 [1], R4 [I5.AddrLen], Length (R1.Address1));
              Inc (I5.AddrLen, Length (R1.Address1));
              R4 [I5.AddrLen] := #13;
              Inc (I5.AddrLen);
              Move (R1.Address2 [1], R4 [I5.AddrLen], Length (R1.Address2));
              Inc (I5.AddrLen, Length (R1.Address2));
              R4 [I5.AddrLen] := #13;
              Inc (I5.AddrLen);
              Move (R1.Address3 [1], R4 [I5.AddrLen], Length (R1.Address3));
              Inc (I5.AddrLen, Length (R1.Address3));
              R4 [I5.AddrLen] := #13;
              Inc (I5.AddrLen);
              for A := 4 to 10 do begin
                R4 [I5.AddrLen] := #13;
                Inc (I5.AddrLen);
              end;
              BlockWrite (F2, R2, SizeOf (R2));
              Write (F3, I3);
              BlockWrite (F4, R4, I5.AddrLen);
              BlockWrite (F4, EmptyAreas, SizeOf (EmptyAreas)); { mcomb }
              BlockWrite (F4, EmptyAreas, SizeOf (EmptyAreas)); { mscan }
              BlockWrite (F4, EmptyAreas, SizeOf (EmptyAreas)); { mpkt  }
              BlockWrite (F4, EmptyAreas, SizeOf (EmptyAreas)); { fcomb }
              Write (F5, I5);
            end;
          end else begin
            HandleIORes (ConcordPath + 'USERINF2.IDX');
          end;
        end else begin
          HandleIORes (ConcordPath + 'USERINF2.DAT');
        end;
      end else begin
        HandleIORes (ConcordPath + 'USERINFO.IDX');
      end;
    end else begin
      HandleIORes (ConcordPath + 'USERINFO.DAT');
    end;
  end else begin
    HandleIORes (RApath + 'USERS.BBS');
  end;
end;

Procedure ShowUsage;
begin
  WriteLn ('1: Convert message area list');
  WriteLn ('2: Convert file area list');
  WriteLn ('3: Convert file lists');
  WriteLn ('4: Convert user base');
end;

Procedure CheckOptions;
const OPT_MSGAREAS  = $0001;
      OPT_FILEAREAS = $0002;
      OPT_FILELIST  = $0004;
      OPT_USERBASE  = $0008;
var Options: LongInt;
    A: Integer;
    S: String;
begin
  Options := 0;
  for A := 1 to ParamCount do begin
    S := ParamStr (A);
    case S [1] of
      '1': Options := Options or OPT_MSGAREAS;
      '2': Options := Options or OPT_FILEAREAS;
      '3': Options := Options or OPT_FILELIST;
      '4': Options := Options or OPT_USERBASE;
    end;
  end;
  WriteLn ('RemoteAccess path : ', RApath);
  WriteLn ('Concord path : ', ConcordPath);
  if Options and OPT_MSGAREAS <> 0 then begin
    ConvertMessageAreas;
  end;
  if Options and OPT_FILEAREAS <> 0 then begin
    ConvertFileAreas;
  end;
  if Options and OPT_FILELIST <> 0 then begin
    ConvertFileList;
  end;
  if Options and OPT_USERBASE <> 0 then begin
    ConvertUserBase;
  end;
end;

begin
  Filemode    := ReadWrite + Denynone;
  RApath      := AddSlash (FExpand (GetEnv ('RA')));
  ConcordPath := AddSlash (FExpand (GetEnv ('CONCORD')));
  if ParamCount = 0 then begin
    ShowUsage;
  end else begin
    CheckOptions;
  end;
end.
