(* PB212 (c) Copyright 1996 by Pasi Talliniemi *)

Uses Crt, Dos, Strings, { standard units }
     MyFunc,            { own function library }
     ConcStruct,        { STRUCT.INC }
     RAStruct,          { STRUCT.250 }
     PBStruct;          { PB_STRUC.INC (shortened from PB_STRUC.215) }

var PBpath: DirStr;
    ConcordPath: DirStr;
    IORes: Integer;
    ch: Char;

Procedure HandleIORes (Fname: PathStr);
begin
  WriteLn ('Error ', IORes, ' with ', Fname);
end;

Procedure ConvertSecurity (SecLvl: Word; Flags, NotFlags: AccessFlags;
                           Age: Byte; BpsRate: Byte;
                           var ConcordSecurity: Security);
type FlagType = Array [1..4] of Byte;
var A, B: Integer;
    YesFlags: ^FlagType;
    NoFlags:  ^FlagType;
begin
  FillChar (ConcordSecurity, SizeOf (ConcordSecurity), #0);
  ConcordSecurity.BpsRate := BpsRate;
  ConcordSecurity.Age     := Age;
  ConcordSecurity.SecLvl  := SecLvl;
  YesFlags := @Flags;
  NoFlags  := @NotFlags;
  for A := 1 to 4 do begin
    for B := 0 to 7 do begin
      if YesFlags^[A] and (1 shl B) <> 0 then begin
        ConcordSecurity.Flags [5 - A] := ConcordSecurity.Flags [5 - A] or (1 shl (7-B));
      end;
      if NoFlags^[A] and (1 shl B) <> 0 then begin
        ConcordSecurity.NotFlags [5 - A] := ConcordSecurity.NotFlags [5 - A] or (1 shl (7-B));
      end;
    end;
  end;
end;

Procedure ConvertMessageAreas;
var F1: File of MessagesPb;
    R1: MessagesPb;
    F2: File of MAreaRec;
    R2: MAreaRec;
    A: Integer;
    F3: File of Config_PRO;
    R3: Config_PRO;
    PBmessageBasePath: DirStr;
begin
  PBmessageBasePath := '';
  WriteLn ('Converting message area list...');
  Assign (F3, PBpath + 'CONFIG.PRO');
  {$I-} Reset (F3); {$I+} IORes := IOResult;
  if IORes = 0 then begin
    {$I-} Read (F3, R3); {$I+} IORes := IOResult;
    Close (F3);
    PBmessageBasePath := AddSlash (StrPas (@R3.MsgPath));
  end else begin
    HandleIORes (PBpath + 'CONFIG.PRO');
  end;
  Assign (F1, PBpath + 'MESSAGES.PB');
  {$I-} Reset (F1); {$I+} IORes := IOResult;
  if IORes = 0 then begin
    Assign (F2, ConcordPath + 'MAREAS.DAT');
    {$I-} Reset (F2); {$I+} IORes := IOResult;
    if IORes = 2 then begin
      {$I-} Rewrite (F2); {$I+} IORes := IOResult;
    end;
    if IORes = 0 then begin
      Seek (F2, FileSize (F2));
      while not Eof (F1) do begin
        Read (F1, R1);
        FillChar (R2, SizeOf (R2), #0);
        R2.Id := ID_CFG_MAREA;
        R2.Name := StrPas (@R1.Name);
        if R2.Name <> '' then begin
          R2.Attrib := MAREA_ACTIVE;
        end;
        case R1.MsgBaseType of
          MSGBASE_HUDSON: begin
                            R2.Format := MAREAFMT_HMB;
                            R2.OwnBoard := R1.HudsonBase;
                            R2.PathName := StrPas (@R1.Path);
                            if R2.PathName = '' then begin
                              R2.PathName := PBmessagebasePath;
                            end;
                          end;
          MSGBASE_JAM:    begin
                            R2.Format := MAREAFMT_JAM;
                            R2.OwnBoard := 0;
                            R2.PathName := StrPas (@R1.Path);
                          end;
          MSGBASE_SQUISH: begin
                            R2.Format := MAREAFMT_SQUISH;
                            R2.OwnBoard := 0;
                            R2.PathName := StrPas (@R1.Path);
                          end;
          MSGBASE_SDM:    begin
                            R2.Format := MAREAFMT_MSG;
                            R2.OwnBoard := 0;
                            R2.PathName := StrPas (@R1.Path);
                          end;
        end;
        case R1.MsgKind of
          MSGKIND_LOCAL:   R2.Typ := MAREATYPE_LOCAL;
          MSGKIND_NET:     R2.Typ := MAREATYPE_NET;
          MSGKIND_ECHO:    R2.Typ := MAREATYPE_ECHO;
          MSGKIND_PVTECHO: R2.Typ := MAREATYPE_ECHO; { not supported }
        end;
        R2.ReplyStatus := MAREAREPLY_BOTH;
        case R1.MsgType of
          MSGTYPE_BOTH:   R2.Kinds := MAREAKIND_BOTH;
          MSGTYPE_PVT:    R2.Kinds := MAREAKIND_PRIV;
          MSGTYPE_PUBLIC: R2.Kinds := MAREAKIND_PUB;
          MSGTYPE_TOALL:  begin
                            R2.Kinds := MAREAKIND_BOTH;
                            R2.ReplyStatus := MAREAREPLY_NONE;
                           end;
        end;
        case R1.Flags of
          0: R2.UseAlias := MAREAALIAS_BOTH;
          1: R2.UseAlias := MAREAALIAS_YES;
          2: R2.UseAlias := MAREAALIAS_NO;
        end;
        ConvertSecurity (R1.ReadLevel,  R1.ReadFlags,  R1.ReadFlagsNot,  R1.MinAge, 0, R2.ReadRights);
        ConvertSecurity (R1.WriteLevel, R1.WriteFlags, R1.WriteFlagsNot, R1.MinAge, 0, R2.WriteRights);
        ConvertSecurity (R1.SysopLevel, R1.SysopFlags, R1.SysopFlagsNot, R1.MinAge, 0, R2.SysopRights);
        R2.UseAka       := R1.Aka;
        R2.OriginLine   := StrPas (@R1.Origin);
        R2.DaysKill     := R1.MsgKillDays;
        R2.ReceiveKill  := R1.RcvKillDays;
        R2.CountKill    := R1.MaxMsgs;
        R2.ReplyArea    := R1.ReplyBoard;
        R2.ShortName    := StrPas (@R1.QWKTag);
        R2.Group        := '';
        R2.PassWord     := '';
        R2.SubDirNum    := 0;
        R2.CharTable    := 0;
        R2.OpenFrom     := 0;
        R2.OpenTo       := 1439;
        R2.JumpDirNum   := 0;
        { not supported :
          Sysop: String [35];
          Groups: Array [1..4] of Byte;
          AllGroups: Byte;
        }
        Write (F2, R2);
      end;
      WriteLn ('Conversion finished.');
    end else begin
      HandleIORes (ConcordPath + 'MAREAS.DAT');
    end;
    Close (F1);
  end else begin
    HandleIORes (PBpath + 'MESSAGES.PB');
  end;
end;

Procedure ConvertFileAreas;
var F1: File of FileCfgPro;
    R1: FileCfgPro;
    F2: File of FAreaRec;
    R2: FAreaRec;
    A: Integer;
begin
  WriteLn ('Converting file area list...');
  Assign (F1, Pbpath + 'FILECFG.PRO');
  {$I-} Reset (F1); {$I+} IORes := IOResult;
  if IORes = 0 then begin
    Assign (F2, ConcordPath + 'FAREAS.DAT');
    {$I-} Reset (F2); {$I+} IORes := IOResult;
    if IORes = 2 then begin
      {$I-} Rewrite (F2); {$I+} IORes := IOResult;
    end;
    if IORes = 0 then begin
      Seek (F2, FileSize (F2));
      while not Eof (F1) do begin
        Read (F1, R1);
        FillChar (R2, SizeOf (R2), #0);
        R2.Id           := ID_CFG_FAREA;
        R2.Name         := StrPas (@R1.Name);
        if R2.Name <> '' then begin
          R2.Attrib     := FAREA_ACTIVE;
        end;
        R2.Attrib       := R2.Attrib or FAREA_FILESBBS or FAREA_NEWFILES
                                     or FAREA_DUPECHK or FAREA_VIRUSCHK;
        R2.FILESBBS     := StrPas (@R1.ListPath);
        R2.DownloadPath := AddSlash (StrPas (@R1.FilePath));
        ConvertSecurity (R1.Level, R1.Flags, R1.FlagsNot, R1.MinAge, 0, R2.UploadSec);
        ConvertSecurity (R1.Level, R1.Flags, R1.FlagsNot, R1.MinAge, 0, R2.DownloadSec);
        ConvertSecurity (R1.Level, R1.Flags, R1.FlagsNot, R1.MinAge, 0, R2.FilelistSec);
        if R1.Typ <> 0 { = 1 } then begin
          R2.Attrib := R2.Attrib or FAREA_CDROM;
        end;
        if R1.Free <> 0 { = 1 } then begin
          R2.Attrib := R2.Attrib or FAREA_FREE;
        end;
        R2.Password     := '';
        R2.UploadArea   := 0;
        R2.ArchiveFmt   := 0;
        R2.KillDaysDL   := 0;
        R2.KillDaysFD   := 0;
        R2.FilePoints   := 0;
        R2.Basename     := '';
        R2.OpenFrom     := 0;
        R2.OpenTo       := 1439;
        R2.Group        := '';
        (* not supported :
           groups: array [1..4] of byte;
           allgroups: byte;
           dateformat: byte;
           maxfiles: word;
           maxkb: word;
           notops: byte;
        *)
        Write (F2, R2);
      end;
      WriteLn ('Conversion finished.');
    end else begin
      HandleIORes (ConcordPath + 'FAREAS.DAT');
    end;
    Close (F1);
  end else begin
    HandleIORes (PBpath + 'FILECFG.PRO');
  end;
end;

Procedure ConvertFileList;
type Buf = Array [1..8192] of Char;
var F1: File of FileCfgPro;
    R1: FileCfgPro;
    F2: Text;
    F3: Text;
    Buf2, Buf3: ^Buf;
    A: Integer;
    FILESBBS: PathStr;
    D: Dos.DirStr;
    N: Dos.NameStr;
    E: Dos.ExtStr;
    Line: Array [0..2048] of Char;
begin
  WriteLn ('Converting file lists...');
  Assign (F1, Pbpath + 'FILECFG.PRO');
  {$I-} Reset (F1); {$I+} IORes := IOResult;
  if IORes = 0 then begin
    New (Buf2);
    New (Buf3);
    while not Eof (F1) do begin
      Read (F1, R1);
      if R1.Name [0] <> #0 then begin
        FILESBBS := StrPas (@R1.ListPath);
        FSplit (FILESBBS, D, N, E);
        if D <> '' then D := AddSlash (D);
        if N = '' then N := 'FILES';
        if E = '' then E := '.BBS';
        WriteLn ('File list : ', D + N + E, '...');
        Assign (F2, D + N + E);
        if Exist (D + N + E) then begin
          if Exist (D + N + '.BAK') then begin
            WriteLn ('- Erasing existing backup file ', D + N + '.BAK');
            EraseFile (D + N + '.BAK');
          end;
          WriteLn ('- Renaming old file list to ', D + N + '.BAK');
          Rename (F2, D + N + '.BAK');
          SetTextBuf (F2, Buf2^);
          {$I-} Reset (F2); {$I+} IORes := IOResult;
          if IORes = 0 then begin
            WriteLn ('- Converting to file ', D + N + E);
            Assign (F3, D + N + E);
            SetTextBuf (F3, Buf3^);
            {$I-} Rewrite (F3); {$I+} IORes := IOResult;
            if IORes = 0 then begin
              while not Eof (F2) do begin
                ReadLn (F2, Line);
                for A := 0 to 2047 do begin
                  if Line [A] = '+' then begin
                    Line [A] := '>';
                    Break;
                  end else begin
                    if (Line [A] = #0) or (Line [A] <> #32) then begin
                      Break;
                    end;
                  end;
                end;
                WriteLn (F3, Line);
              end;
              Close (F3);
            end else begin
              HandleIORes (D + N + E);
            end;
            Close (F2);
          end else begin
            HandleIORes (D + N + '.BAK');
          end;
        end else begin
          WriteLn ('- File list not found -> Cannot be converted');
        end;
      end;
    end;
    Dispose (Buf2);
    Dispose (Buf3);
    WriteLn ('Conversion finished.');
    Close (F1);
  end else begin
    HandleIORes (PBpath + 'FILECFG.PRO');
  end;
end;

Procedure ConvertUserBase;
var F1: File of USERSrecord;
    R1: USERSrecord;
    F2: File;
    R2: UserRec;
    H2: UserFileHeader;
    F3: File of NameIdxRec;
    I3: NameIdxRec;
    F4: File;
    R4: Array [0..2048] of Char;
    F5: File of FlexUserIdxRec;
    I5: FlexUserIdxRec;
    F6: File of UsersPBrecord;
    R6: UsersPBrecord;
    A, B:  Integer;
    EmptyAreas: Array [1..50] of Byte;
    MailAreas: Array [1..50] of Byte;
    MsgbasePath: String;
    F7: File of CONFIG_PRO;
    R7: CONFIG_PRO;
begin
  MsgBasePath := PBpath;
  Assign (F7, PBpath + 'CONFIG.PRO');
  {$I-} Reset (F7); {$I+}
  if IOResult = 0 then begin
    Read (F7, R7);
    Close (F7);
    MsgbasePath := AddSlash (StrPas (@R7.MsgPath));
    WriteLn ('Using user base path: ', MsgbasePath);
  end;
  WriteLn ('Converting user base...');
  FillChar (EmptyAreas, SizeOf (EmptyAreas), #0);
  Assign (F1, MsgBasePath + 'USERS.BBS');
  {$I-} Reset (F1); {$I+} IORes := IOResult;
  if IORes = 0 then begin
    Assign (F6, MsgBasePath + 'USERSPB.BBS');
    {$I-} Reset (F6); {$I+} IORes := IOResult;
    if IORes = 0 then begin
      Assign (F2, ConcordPath + 'USERINFO.DAT');
      {$I-} Reset (F2, 1); {$I+} IORes := IOResult;
      if IORes = 2 then begin
        {$I-} Rewrite (F2, 1); {$I+} IORes := IOResult;
        if IORes = 0 then begin
          FillChar (H2, SizeOf (H2), #0);
          H2.Id       := ID_USR_HDR;
          H2.Version  := CURRVERNUM;
          H2.UserSize := SizeOf (UserRec);
          BlockWrite (F2, H2, SizeOf (H2));
        end;
      end;
      if IORes = 0 then begin
        Seek (F2, FileSize (F2));
        Assign (F3, ConcordPath + 'USERINFO.IDX');
        {$I-} Reset (F3); {$I+} IORes := IOResult;
        if IORes = 2 then begin
          {$I-} Rewrite (F3); {$I+} IORes := IOResult;
        end;
        if IORes = 0 then begin
          Seek (F3, FileSize (F3));
          Assign (F4, ConcordPath + 'USERINF2.DAT');
          {$I-} Reset (F4, 1); {$I+} IORes := IOResult;
          if IORes = 2 then begin
            {$I-} Rewrite (F4, 1); {$I+} IORes := IOResult;
          end;
          if IORes = 0 then begin
            Seek (F4, FileSize (F4));
            Assign (F5, ConcordPath + 'USERINF2.IDX');
            {$I-} Reset (F5); {$I+} IORes := IOResult;
            if IORes = 2 then begin
              {$I-} Rewrite (F5); {$I+} IORes := IOResult;
            end;
            if IORes = 0 then begin
              Seek (F5, FileSize (F5));
              while not Eof (F1) do begin
                Read (F1, R1);
                Read (F6, R6);
                FillChar (R2, SizeOf (R2), #0);
                FillChar (I3, SizeOf (I3), #0);
                FillChar (R4, SizeOf (R4), #0);
                FillChar (I5, SizeOf (I5), #0);
                R2.Id            := ID_USR_REC;
                R2.Name          := R1.Name;
                R2.Alias         := R1.Handle;
                R2.City          := R1.Location;
                R2.Voice         := R1.VoicePhone;
                R2.Data          := R1.DataPhone;
                R2.Birthday      := PackDate (R1.Birthdate);
                R2.Password      := StrPas (@R6.Password);
                R2.Sec.SecLvl    := R1.Security;
                R2.ScreenLen     := R1.ScreenLength;
                for A := 1 to 4 do begin
                  R2.Sec.Flags[A] := R1.Flags [A];
                end;
                if (R1.FirstDate = '')
                or (Pos ('00', R1.FirstDate) > 0) then begin
                  R1.FirstDate := '01-01-96';
                end;
                if (R1.LastDate = '')
                or (Pos ('00', R1.LastDate) > 0) then begin
                  R1.LastDate := R1.FirstDate;
                end;
                if R1.LastTime = '' then begin
                  R1.LastTime := '00:00';
                end;
                R2.FirstTime     := ToUnixTime2 (R1.FirstDate, '00:00');
                R2.LastTime      := ToUnixTime2 (R1.LastDate, R1.LastTime);
                R2.TimesCalled   := R1.NoCalls;
                R2.TotalMinutes  := R6.TotalTimeUsed;
                R2.Pages         := 0;
                R2.PublicMsgs    := R1.MsgsPosted;
                R2.PrivateMsgs   := 0;
                R2.UpK           := R1.UploadsK;
                R2.UpTimes       := R1.Uploads;
                R2.DownK         := R1.DownloadsK;
                R2.DownTimes     := R1.Downloads;
                R2.SysopCmnt     := R1.Comment;
                R2.Expiration    := 0;
                R2.FirstMenu     := '';
                R2.Language      := StrPas (@R6.Language);
                R2.MessageArea   := R1.MsgArea;
                R2.FileArea      := R1.FileArea;
                R2.Door          := 0;
                R2.ChatChannel   := 0;
                R2.TodayCalls    := 0;
                R2.TodayElapsed  := R1.Elapsed;
                R2.TodayDownK    := R1.TodayK;
                R2.TodayDowns    := 0;
                R2.TimeInBank    := R6.TbTimeBalance;
                R2.DLLimitInBank := R6.TbKBBalance;
                R2.ViewFileName  := '';
                R2.OfflineFmt    := 0;
                R2.OfflineDays   := 0;
                R2.ReadMsgNum    := 0;
                R2.FileListNum   := 0;
                R2.TodayLastPkt  := 0;
                R2.VerifyCalls   := 0;
                R2.PasswordTries := 0;
                R2.OfflineMaxNum := R6.QWKMaxMsgs;
                R2.FlexPos       := FilePos (F5);
                R2.LastPktDl     := 0;
                R2.BBSCRC        := -1;
                if R1.Attribute and (1 shl 3) <> 0 then begin
                  if R1.Attribute2 and (1 shl 1) <> 0 then begin
                    R2.Emulation := 2;
                  end else begin
                    R2.Emulation := 1;
                  end;
                end else begin
                  R2.Emulation   := 4;
                end;
                R2.TextFileType  := 0;
                R2.DateFormat    := 0;
                R2.PasswordCRC   := R1.PasswordCRC;
                R2.LastVoteChk   := 0;
                R2.TodayLastDesc := 0;
                R2.TimeUnits     := 0;
                R2.KBUnits       := 0;
                R2.Attrib1 := USER_COLORS;
                if R6.CheckMail <> 0 { = 1 } then begin
                  R2.Attrib1 := R2.Attrib1 or USER_MAILCHK;
                end;
                if R6.CheckNewFiles <> 0 { = 1 } then begin
                  R2.Attrib1 := R2.Attrib1 or USER_FILECHK;
                end;
                if R1.Attribute and (1 shl 0) <> 0 then begin
                  R2.Attrib1 := R2.Attrib1 or USER_DELETED;
                end;
                if R1.Attribute and (1 shl 1) <> 0 then begin
                  R2.Attrib1 := R2.Attrib1 or USER_CLRSCR;
                end;
                if R1.Attribute and (1 shl 2) <> 0 then begin
                  R2.Attrib1 := R2.Attrib1 or USER_MORE;
                end;
                if R1.Attribute and (1 shl 4) <> 0 then begin
                  R2.Attrib1 := R2.Attrib1 or USER_NOKILL;
                end;
                if R1.Attribute and (1 shl 7) <> 0 then begin
                  R2.Attrib1 := R2.Attrib1 or USER_NODISTURB;
                end;
                if R1.Attribute2 and (1 shl 0) <> 0 then begin
                  R2.Attrib1 := R2.Attrib1 or USER_HOTKEYS;
                end;
                if R1.Sex = 2 then begin
                  R2.Attrib1 := R2.Attrib1 or USER_FEMALE;
                end;
                R2.OfflineAttrib := OFFLINE_WELCOME or OFFLINE_NEWS or
                                    OFFLINE_GOODBYE or OFFLINE_LASTREAD or
                                    OFFLINE_RECEIVED;
                I3.NameCRC32  := CRC_32 (Capit (R2.Name));
                I3.AliasCRC32 := CRC_32 (Capit (R2.Alias));
                I5.NameCRC32  := I3.NameCRC32;
                I5.FilePos    := FilePos (F4);
                I5.AddrLen    := 0;
                I5.CmntLen    := 0;
                I5.MailLen    := 0;
                I5.MAreaCnt   := SizeOf (EmptyAreas) * 8;
                I5.FAreaCnt   := SizeOf (EmptyAreas) * 8;
                Move (R1.Address1 [1], R4 [I5.AddrLen], Length (R1.Address1));
                Inc (I5.AddrLen, Length (R1.Address1));
                R4 [I5.AddrLen] := #13;
                Inc (I5.AddrLen);
                Move (R1.Address2 [1], R4 [I5.AddrLen], Length (R1.Address2));
                Inc (I5.AddrLen, Length (R1.Address2));
                R4 [I5.AddrLen] := #13;
                Inc (I5.AddrLen);
                Move (R1.Address3 [1], R4 [I5.AddrLen], Length (R1.Address3));
                Inc (I5.AddrLen, Length (R1.Address3));
                R4 [I5.AddrLen] := #13;
                Inc (I5.AddrLen);
                Move (R6.Country, R4 [I5.AddrLen], Length (StrPas (@R6.Country)));
                Inc (I5.AddrLen, Length (StrPas (@R6.Country)));
                R4 [I5.AddrLen] := #13;
                Inc (I5.AddrLen);
                for A := 5 to 10 do begin
                  R4 [I5.AddrLen] := #13;
                  Inc (I5.AddrLen);
                end;
                for A := 1 to 50 do begin
                  MailAreas [A] := R6.MailCheckBoards [A];
                end;
                BlockWrite (F2, R2, SizeOf (R2));
                Write (F3, I3);
                BlockWrite (F4, R4, I5.AddrLen);
                BlockWrite (F4, EmptyAreas, SizeOf (EmptyAreas)); { mcomb }
                BlockWrite (F4, MailAreas,  SizeOf (EmptyAreas)); { mscan }
                BlockWrite (F4, EmptyAreas, SizeOf (EmptyAreas)); { mpkt  }
                BlockWrite (F4, EmptyAreas, SizeOf (EmptyAreas)); { fcomb }
                Write (F5, I5);
              end;
              { not supported :
                state:             string [25];
                faxphone:          string [15];
                lastpwdchange:     date;
                lastnewfilescheck: date;
                loglevel:          word;
                tbtimewithdrawn:   word;
                tbkbwithdrawn:     word;
                tbtimedeposited:   word;
                tbkbdeposited:     word;
                tbtimeloaned:      word;
                tbkbloaned:        word;
                tbtimepayback:     date;
                tbkbpayback:       date;
                tblastused:        date;
                explevel:          word;
                expflagson:        accessflags;
                expflagsoff:       accessflags;
                uflags:            longint;
                qwkmaxmsgsperarea: word;
                QWKArchiver:       Byte;
                RipFont:           Byte;
              }
            end else begin
              HandleIORes (ConcordPath + 'USERINF2.IDX');
            end;
          end else begin
            HandleIORes (ConcordPath + 'USERINF2.DAT');
          end;
        end else begin
          HandleIORes (ConcordPath + 'USERINFO.IDX');
        end;
      end else begin
        HandleIORes (ConcordPath + 'USERINFO.DAT');
      end;
    end else begin
      HandleIORes (PBpath + 'USERSPB.BBS');
    end;
  end else begin
    HandleIORes (PBpath + 'USERS.BBS');
  end;
end;

Procedure ShowUsage;
begin
  WriteLn ('1: Convert message area list');
  WriteLn ('2: Convert file area list');
  WriteLn ('3: Convert file lists');
  WriteLn ('4: Convert user base');
end;

Procedure CheckOptions;
const OPT_MSGAREAS  = $0001;
      OPT_FILEAREAS = $0002;
      OPT_FILELIST  = $0004;
      OPT_USERBASE  = $0008;
var Options: LongInt;
    A: Integer;
    S: String;
begin
  Options := 0;
  for A := 1 to ParamCount do begin
    S := ParamStr (A);
    case S [1] of
      '1': Options := Options or OPT_MSGAREAS;
      '2': Options := Options or OPT_FILEAREAS;
      '3': Options := Options or OPT_FILELIST;
      '4': Options := Options or OPT_USERBASE;
    end;
  end;
  if Options and OPT_MSGAREAS <> 0 then begin
    ConvertMessageAreas;
  end;
  if Options and OPT_FILEAREAS <> 0 then begin
    ConvertFileAreas;
  end;
  if Options and OPT_FILELIST <> 0 then begin
    ConvertFileList;
  end;
  if Options and OPT_USERBASE <> 0 then begin
    ConvertUserBase;
  end;
end;

begin
  Filemode    := ReadWrite + Denynone;
  PBpath      := AddSlash (FExpand (GetEnv ('PROBOARD')));
  ConcordPath := AddSlash (FExpand (GetEnv ('CONCORD')));
  WriteLn ('Proboard path : ', PBpath);
  WriteLn ('Concord path : ', ConcordPath);
  if ParamCount = 0 then begin
    ShowUsage;
  end else begin
    WriteLn ('Are you sure (y/n) :');
    ReadLn (ch);
    if Upcase (ch) = 'Y' then begin
      CheckOptions;
    end;
  end;
end.
