Unit MyFunc;

(* MYFUNC unit (c) Copyright 1996 by Pasi Talliniemi *)

interface

Uses Crt, Dos; { standard units }

type Str3 = String[3]; Str5 = String[5]; Str8 = String[8]; Str9 = String[9];

const R_Only = $00; DenyAll   = $10;
      W_Only = $01; DenyWrite = $20;
   ReadWrite = $02; DenyRead  = $30;
                    DenyNone  = $40;

function AddSlash (Dir: DirStr): DirStr; (* returns directory name ending with backslash *)
Function Capit (S: String): String; (* returns string uppercased *)
Function CRC_32 (S: String): LongInt; (* returns CRC of string *)
Procedure EraseFile (FilePathName: PathStr); (* Erases file(s) *)
function Exist (Filename: PathStr): Boolean; (* true if file exists *)
Function PackDate (S: Str8): Word; (* returns date in packed DOS format *)
Function ToStr (I: LongInt): String; (* converts integer to string *)
function ToUnixTime(yr,mth,d,hr,min,sec: word): LongInt;
function ToUnixTime2 (D: Str8; T: Str5): LongInt;
Function UnpackDate (T: Word): Str9;
Function Value (S: String): LongInt; (* converts string to number *)
Function ZeroStart (I: LongInt; N: Byte): String; (* adds zeros to beginning of number converted to string *)

implementation

const

  Days: Array [1..12] of Byte = (
              31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
            );

  TYears : Array [0..60] of word = (
            0,
          365,   730,  1096,  1461,  1826,  2191,  2557,  2922,  3287,  3652,
         4018,  4383,  4748,  5113,  5479,  5844,  6209,  6574,  6940,  7305,
         7670,  8035,  8401,  8766,  9131,  9496,  9862, 10227, 10592, 10957,
        11323, 11688, 12053, 12418, 12784, 13149, 13514, 13879, 14245, 14610,
        14975, 15340, 15706, 16071, 16436, 16801, 17167, 17532, 17897, 18262,
        18628, 18993, 19358, 19723, 20089, 20454, 20819, 21184, 21550, 21915
      ); (* Days each year since 1-1-1970 (to year 2030) *)

  TDays       : array [Boolean,0..12] of word =
                  ((0,31,59,90,120,151,181,212,243,273,304,334,365),
                  (0,31,60,91,121,152,182,213,244,274,305,335,366));

  UnixDatum   = longint(25568);
  SecsPerDay  = 86400;
  SecsPerHour = longint(3600);
  SecsPerMin  = longint(60);
  MinsPerHour = 60;

CONST crc_32_tab: ARRAY[0..255] OF LONGINT = (
$00000000, $77073096, $ee0e612c, $990951ba, $076dc419, $706af48f, $e963a535, $9e6495a3,
$0edb8832, $79dcb8a4, $e0d5e91e, $97d2d988, $09b64c2b, $7eb17cbd, $e7b82d07, $90bf1d91,
$1db71064, $6ab020f2, $f3b97148, $84be41de, $1adad47d, $6ddde4eb, $f4d4b551, $83d385c7,
$136c9856, $646ba8c0, $fd62f97a, $8a65c9ec, $14015c4f, $63066cd9, $fa0f3d63, $8d080df5,
$3b6e20c8, $4c69105e, $d56041e4, $a2677172, $3c03e4d1, $4b04d447, $d20d85fd, $a50ab56b,
$35b5a8fa, $42b2986c, $dbbbc9d6, $acbcf940, $32d86ce3, $45df5c75, $dcd60dcf, $abd13d59,
$26d930ac, $51de003a, $c8d75180, $bfd06116, $21b4f4b5, $56b3c423, $cfba9599, $b8bda50f,
$2802b89e, $5f058808, $c60cd9b2, $b10be924, $2f6f7c87, $58684c11, $c1611dab, $b6662d3d,
$76dc4190, $01db7106, $98d220bc, $efd5102a, $71b18589, $06b6b51f, $9fbfe4a5, $e8b8d433,
$7807c9a2, $0f00f934, $9609a88e, $e10e9818, $7f6a0dbb, $086d3d2d, $91646c97, $e6635c01,
$6b6b51f4, $1c6c6162, $856530d8, $f262004e, $6c0695ed, $1b01a57b, $8208f4c1, $f50fc457,
$65b0d9c6, $12b7e950, $8bbeb8ea, $fcb9887c, $62dd1ddf, $15da2d49, $8cd37cf3, $fbd44c65,
$4db26158, $3ab551ce, $a3bc0074, $d4bb30e2, $4adfa541, $3dd895d7, $a4d1c46d, $d3d6f4fb,
$4369e96a, $346ed9fc, $ad678846, $da60b8d0, $44042d73, $33031de5, $aa0a4c5f, $dd0d7cc9,
$5005713c, $270241aa, $be0b1010, $c90c2086, $5768b525, $206f85b3, $b966d409, $ce61e49f,
$5edef90e, $29d9c998, $b0d09822, $c7d7a8b4, $59b33d17, $2eb40d81, $b7bd5c3b, $c0ba6cad,
$edb88320, $9abfb3b6, $03b6e20c, $74b1d29a, $ead54739, $9dd277af, $04db2615, $73dc1683,
$e3630b12, $94643b84, $0d6d6a3e, $7a6a5aa8, $e40ecf0b, $9309ff9d, $0a00ae27, $7d079eb1,
$f00f9344, $8708a3d2, $1e01f268, $6906c2fe, $f762575d, $806567cb, $196c3671, $6e6b06e7,
$fed41b76, $89d32be0, $10da7a5a, $67dd4acc, $f9b9df6f, $8ebeeff9, $17b7be43, $60b08ed5,
$d6d6a3e8, $a1d1937e, $38d8c2c4, $4fdff252, $d1bb67f1, $a6bc5767, $3fb506dd, $48b2364b,
$d80d2bda, $af0a1b4c, $36034af6, $41047a60, $df60efc3, $a867df55, $316e8eef, $4669be79,
$cb61b38c, $bc66831a, $256fd2a0, $5268e236, $cc0c7795, $bb0b4703, $220216b9, $5505262f,
$c5ba3bbe, $b2bd0b28, $2bb45a92, $5cb36a04, $c2d7ffa7, $b5d0cf31, $2cd99e8b, $5bdeae1d,
$9b64c2b0, $ec63f226, $756aa39c, $026d930a, $9c0906a9, $eb0e363f, $72076785, $05005713,
$95bf4a82, $e2b87a14, $7bb12bae, $0cb61b38, $92d28e9b, $e5d5be0d, $7cdcefb7, $0bdbdf21,
$86d3d2d4, $f1d4e242, $68ddb3f8, $1fda836e, $81be16cd, $f6b9265b, $6fb077e1, $18b74777,
$88085ae6, $ff0f6a70, $66063bca, $11010b5c, $8f659eff, $f862ae69, $616bffd3, $166ccf45,
$a00ae278, $d70dd2ee, $4e048354, $3903b3c2, $a7672661, $d06016f7, $4969474d, $3e6e77db,
$aed16a4a, $d9d65adc, $40df0b66, $37d83bf0, $a9bcae53, $debb9ec5, $47b2cf7f, $30b5ffe9,
$bdbdf21c, $cabac28a, $53b39330, $24b4a3a6, $bad03605, $cdd70693, $54de5729, $23d967bf,
$b3667a2e, $c4614ab8, $5d681b02, $2a6f2b94, $b40bbe37, $c30c8ea1, $5a05df1b, $2d02ef8d
);

function AddSlash (Dir: DirStr): DirStr; (* returns directory name ending with backslash *)
begin
  if (Dir <> '') and (Dir [Length (Dir)] <> '\') then begin
    Dir := Dir + '\';
  end;
  AddSlash := Dir;
end;

Function Capit (S: String): String; (* returns string uppercased *)
var A: Integer;
begin
  for A := 1 to Length (S) do begin
    S[A] := Upcase (S[A]);
  end;
  Capit := S;
end;

FUNCTION UpdC32(octet: BYTE; crc: LONGINT) : LONGINT; forward;

Function CRC_32 (S: String): LongInt; (* returns CRC of string *)
var A: Integer;
    C: LongInt;
begin
  C := $FFFFFFFF;
  for A := 1 to Length (S) do
    C := UpdC32 (Ord (S[A]), C);
  CRC_32 := C;
end;

Procedure EraseFile (FilePathName: PathStr); (* Erases file(s) *)
var S: SearchRec;
    F: File;
    D: DirStr;
    N: NameStr;
    E: ExtStr;
begin
  FindFirst (FilePathName, AnyFile - VolumeID - Directory, S);
  while DosError = 0 do begin
    FSplit (FilePathName, D, N, E);
    Assign (F, D + S.Name);
    {$I-} SetFAttr (F, Archive); {$I+} if IOResult <> 0 then begin end;
    {$I-} Erase (F);             {$I+} if IOResult <> 0 then begin end;
    FindNext (S);
  end;
  {$IFDEF OS2} FindClose (S); {$ENDIF}
end;

function Exist (Filename: PathStr): Boolean; (* true if file exists *)
var F: File;
    S: SearchRec;
begin
  FindFirst (Filename, AnyFile, S);
  Exist := (DosError = 0);
  {$IFDEF OS2} FindClose (S); {$ENDIF}
end;

Function LeapYear (Y: Word): Boolean; (* true if this year is leap year *)
begin
  LeapYear := ((Y mod 100 <> 0) and (Y mod 4 = 0))
           or ((Y mod 100 = 0) and (Y mod 400 = 0));
end;

Function ToRight (S: String; N: Byte; C: Char): String; forward;

Function NumRight(I: LongInt; N: Byte; C: Char): String; (* adds chars to beginning of number converted to string *)
begin
  NumRight := ToRight (ToStr (I), N, C);
end;

Function PackDate (S: Str8): Word; (* returns date in packed DOS format *)
var D, M: Byte; Y: Word;
begin
  PackDate := 0;
  D := Value (Copy (S, 4, 2));
  M := Value (Copy (S, 1, 2));
  Y := Value (Copy (S, 7, 2));
  if (D > 0) and (M > 0) and (M <= 12) then begin
    if (D <= Days [M]) or ((D = 29) and (M = 2) and (LeapYear (Y))) then begin
      PackDate := D + Word (M) shl 5 + Word (Y) shl 9;
    end;
  end;
end;

function PackedDate(yr,mth,d : word): word;
var temp  : word;
    lyr   : boolean;
begin
  lyr   := (yr mod 4 = 0);
  if yr >= 1900 then
    dec(yr,1900);
  temp  := yr * word(365) + (yr div 4) - ord(lyr);
  inc(temp,TDays[lyr,mth-1]);
  inc(temp,d);
  PackedDate := temp;
end;

Function ToRight (S: String; N: Byte; C: Char): String; (* adds char to beginning of string until length is n *)
begin
  while Length (S) < N do
    S := Concat (C, S);
  if Length (S) > N then
    S := Copy (S, 1, N);
  ToRight := S;
end;

Function ToStr (I: LongInt): String; (* converts integer to string *)
var S: String;
begin
  Str (I, S);
  ToStr := S;
end;

function ToUnixTime(yr,mth,d,hr,min,sec: word): LongInt;
begin
  ToUnixTime := LongInt (SecsPerDay) * (PackedDate(yr,mth,d) - UnixDatum) +
                LongInt (SecsPerHour) * hr + LongInt (SecsPerMin) * min +
                sec;
end;

function ToUnixTime2 (D: Str8; T: Str5): LongInt;
var Yr, Mth, Day, Hr, Min, Sec: Word;
begin
  Yr  := Value (Copy (D, 7, 2));
  Day := Value (Copy (D, 4, 2));
  Mth := Value (Copy (D, 1, 2));
  Hr  := Value (Copy (T, 1, 2));
  Min := Value (Copy (T, 4, 2));
  Sec := 0;
  ToUnixTime2 := ToUnixTime (Yr, Mth, Day, Hr, Min, Sec);
end;

Function UnpackDate (T: Word): Str9;
var D, M: Byte;
    Y: Word;
begin
  UnpackDate := ''; (* If invalid date *)
  D := T and $1F; (* Get day (bits 0-4) *)
  M := (T shr 5) and $0F; (* Get month (bits 5-8) *)
  Y := T shr 9; (* Get year (bits 9-15 *)
  if (D > 0) and (M > 0) and (M <= 12) then begin
    if (D <= Days [M]) or ((D = 29) and (M = 2) and (LeapYear (Y))) then begin
      UnpackDate := ZeroStart (M, 2)  + '-' +
                    ZeroStart (D, 2)  + '-' +
                    ZeroStart (Y mod 100, 2); (* Format MM-DD-YY *)
    end;
  end;
end;

FUNCTION UpdC32(octet: BYTE; crc: LONGINT) : LONGINT;
BEGIN { UpdC32 }
   UpdC32 := crc_32_tab[BYTE(crc XOR LONGINT(octet))] XOR ((crc SHR 8) AND $00FFFFFF)
END;

Function Value (S: String): LongInt; (* converts string to number *)
var I: LongInt;
    A: Integer;
begin
  Val (S, I, A);
  if A <> 0 then I := 0;
  Value := I;
end;

Function ZeroStart (I: LongInt; N: Byte): String; (* adds zeros to beginning of number converted to string *)
begin
  ZeroStart := NumRight (I, N, '0');
end;

end.
