                          (************)
                          (* USER.BBS *)
                          (************)

Const MAX_ALEN     =64;        { Max length of usr.msg[] and usr.files[]  }

                               { Masks for usr.bits1, below }
      BITS_HOTKEYS     =$0001; { Hotkeys, independent of HOTFLASH level   }
      BITS_NOTAVAIL    =$0002; { If set, user is NOT normally available
                                 for chat.                                }
      BITS_FSR         =$0004; { Full-screen reading in msg areas         }
      BITS_NERD        =$0008; { Yelling makes no noise on sysop console  }
      BITS_NOULIST     =$0010; { Don't display name in userlist           }
      BITS_TABS        =$0020; { User can handle being sent raw tabs      }
      BITS_ENCRYPT     =$0040; { pwd is a MD5 digest, not plaintext       }
      BITS_RIP         =$0080; { Remote Imaging Prototocol support        }

                               { Masks for usr.bits2, below }
      BITS2_BADLOGON   =$0001; { MAX: if user's last logon attempt was bad}
      BITS2_IBMCHARS   =$0002; { MAX: if user can receive high-bit chars  }
      BITS2_RSVD1      =$0004; { MAX: *obsolete* 1.02 avatar flag         }
      BITS2_BORED      =$0008; { Use the line-oriented editor             }
      BITS2_MORE       =$0010; { Wants the "MORE?" prompt                 }
      BITS2_RSVD2      =$0020; { OPUS: set=wants Ansi                     }
      BITS2_CONFIGURED =$0040; { OPUS: set=used Maximus before            }
      BITS2_CLS        =$0080; { OPUS: set=transmit ^L, clear=ignore ^L   }
      BITS2_BIT8       =$0100; { used to be 'usr.keys'                    }
      BITS2_BIT9       =$0200; { used to be 'usr.keys'                    }
      BITS2_BITA       =$0400; { used to be 'usr.keys'                    }
      BITS2_BITB       =$0800; { used to be 'usr.keys'                    }
      BITS2_BITC       =$1000; { used to be 'usr.keys'                    }
      BITS2_BITD       =$2000; { used to be 'usr.keys'                    }
      BITS2_BITE       =$4000; { used to be 'usr.keys'                    }
      BITS2_BITF       =$8000; { used to be 'usr.keys'                    }

      SEX_ALIEN         =$0000;
      SEX_MALE          =$0001;
      SEX_FEMALE        =$0002;

                               { Masks for usr.delflag, below. WARNING!
                                 Only the first eight bits of this flag
                                 should be used for compatibility with
                                 df_save!                                 }
      UFLAG_DEL   =$01;
      UFLAG_PERM  =$02;

                               { Masks for usr.xp_flag, below }
      XFLAG_EXPDATE    =$0001; { Use the xp_date to control access        }
      XFLAG_EXPMINS    =$0002; { Use the xp_mins number to control access }
      XFLAG_DEMOTE     =$0004; { Demote user to priv level in usr.xp_priv }
      XFLAG_AXE        =$0008; { Just hang up on user                     }

                              { Constants for usr.video, below }
      GRAPH_TTY         =$00; { The current user's graphics setting...    }
      GRAPH_ANSI        =$01;
      GRAPH_AVATAR      =$02;
      GRAPH_RIP         =$03;

Type _usr=Record
      name:Array[0..35] of char;  { Caller's name                         0}
      city:Array[0..35] of Char;  { Caller's location                    36}
      alias:Array[0..20] of Char; { MAX: user's alias (handle)           72}
      phone:Array[0..14] of Char; { MAX: user's phone number             93}
      lastread_ptr:Word;    { MAX: a num which points to offset in      108}
                            { file -- Offset of lastread pointer will be   }
                            { lastread_ptr*sizeof(int).                    }
      timeremaining:Word;   { MAX: time left for current call (xtern pro110}
      pwd:Array[0..15] of Char; { Password                              112}
      times:Word;           { Number of previous calls to this system   128}
      help:Byte;            { Help level                                130}
      group:Word;           { Group number (not implemented)            131}
      video:Byte;           { user's video mode (see GRAPH_XXXX)        133}
      nulls:Byte;           { Number of Nulls (delays) after <cr>       134}
      bits:Byte;            { Bit flags for user (number 1)             135}
      dob_year:Word;        { Date of birth: year (1900-)               136}
      bits2:Word;           { Bit flags for user (number 2)             138}
      max2priv:Word;        { Max 2.x priv level (NOT USED)             140}
      dataphone:Array[0..18] of Char; { Data/business phone number      142}
      struct_len:Byte;      { len of struct, divided by 20. SEE ABOVE!  161}
      time:Word;            { Time on-line so far today                 162}
      delflag:Word;         { Used to hold baud rate for O)utside comman164}
                            { In USER.BBS, usr.flag uses the constants     }
                            { UFLAG_xxx, defined earlier in this file.     }
      msgs_posted:Longint;  { Total number of messages posted           166}
      msgs_read:Longint;    { Total number of messages read             170}
      width:Byte;           { Width of the caller's screen              174}
      len:Byte;             { Height of the caller's screen             175}
      credit:Word;          { Matrix credit, in cents                   176}
      debit:Word;           { Current matrix debit, in cents            178}
      xp_priv:Word;         { Priv to demote to, when time or minutes ru180}
                            { out.                                         }
      xp_date:LongInt;      { Bit-mapped date of when user expires      182}
                            { If zero, then no expiry date.                }
      xp_mins:LongInt;      { How many minutes the user has left before 186*
                             * expiring.                                    }
      xp_flag:byte;         { Flags for expiry.  See above XFLAG_XXX def190}
      sex:byte;             { Sex: SEX_MALE or SEX_FEMALE)              191}
      ludate:LongInt;       { Bit-mapped date of user's last call       192}
      xkeys:LongInt;        { User's keys (all 32 of 'em)               196}
      lang :byte;           { The user's current language #             200}
      def_proto:shortint;   { Default file-transfer protocol            201}
      up:LongInt;           { K-bytes uploaded, all calls               202}
      down:LongInt;         { K-bytes downloaded, all calls             206}
      downtoday:LongInt;    { K-bytes downloaded, today                 210}
      rsvd45:Array[1..18] of byte; { Reserved by Maximus for future use 214}
      call:Word;            { Number of previous calls today            232}
      compress:Byte;        { Default compression program to use        234}
      df_save:Byte;         { Used for storing real usr.delflag in      235*
                             * LASTUSxx.BBS while in a door.                }
      extra:LongInt;                                                   {236}
      date_1stcall:LongInt; { Date of first call to system              240}
      date_pwd_chg:LongInt; { Date of last password change              244}
      nup:Longint;          { Number of files uploaded                  248}
      ndown:LongInt;        { Number of files downloaded                252}
      ndowntoday:Longint;   { Number of files downloaded today          256}
      time_added:word;      { Time credited to the user for today       260}
      msg:Array[0..MAX_ALEN-1] of Char;   { Current message area        262}
      files:Array[0..MAX_ALEN-1] of Char; { Current file area           326}
      dob_day:Byte;         { Date of birth: day (1-31)                 390}
      dob_month:Byte;       { Date of birth: month (1-12)               391}
      point_credit:Longint; { Total points allocated                    392}
      point_debit:Longint;  { Total points used                         396}
      date_newfile:LongInt; { Date of last new-files check              400}
      priv:Word;            { Privilege level                           404}
      rsvd6:Array[1..54] of Byte; { Reserved for future use             406}
                                                                       {460}
      End;

     NETADDR = Record
       Zone, Net, Node, Point: Word;
     end;

                   (**************************)
                   (* MESSAGE AND FILE AREAS *)
                   (**************************)

     zstr=Word;     {* Offset of string within area heap *}

     Override=Record
       opt:Word;      { Type of menu option to override     ...OR...     }
       name:Char;     { First letter of command to override              }
       rsvd1:Byte;    { Reserved for future use                          }
       acs:zstr;      { New ACS required to access option                }
       menuname:zstr; { Use this access level on the given menu only     }
     end;

                           { Bit masks for the ma.attribs field }
Const MA_PVT      =$0001;  { Private msgs allowed }
      MA_PUB      =$0002;  { Public msgs allowed }
      MA_HIBIT    =$0004;  { High bit msgs allowed }
      MA_NET      =$0008;  { Netmail area }
      MA_ECHO     =$0010;  { Echomail area }
      MA_CONF     =$0020;  { Conference area }
      MA_ANON     =$0040;  { Anonymous messages are OK }
      MA_NORNK    =$0080;  { Don't use the REALNAME kludge for this area }
      MA_REAL     =$0100;  { Force  use of       real name for this area }
      MA_ALIAS    =$0200;  { Force  use of alias      name for this area }
      MA_AUDIT    =$0400;  { Use auditing (msg tracking) controls in area}
      MA_READONLY =$0800;  { Area is read-only                           }
      MA_HIDDN    =$1000;  { Area does not display on normal area list   }
      MA_ATTACH   =$2000;  { Area allows local file attaches             }
      MA_DIVBEGIN =$4000;  { A message area division, not a real area    }
      MA_DIVEND   =$8000;  { End of the message area division            }
      MA2_NOMCHK  =$0001;  { Don't do personal mail check in this area   }
      MA_SHARED   =MA_ECHO Or MA_CONF;

      MSGTYPE_SDM    = 1;
      MSGTYPE_SQUISH = 2;

                           { Bit masks for fa.attribs }
      FA_SLOW     =$0001;  { Slow-access medium: skip existence checks }
      FA_STAGED   =$0002;  { Used staged transfer area for downloads }
      FA_NONEW    =$0004;  { Permanent storage - skip for new file checks }
      FA_HIDDN    =$0008;  { Area does not display on normal area list }
      FA_DIVBEGIN =$4000;  { A file area division, not a real area }
      FA_DIVEND   =$8000;  { End of file area division }
      FA_AUTODATE =$0010;  { Auto-date override }
      FA_MANDATE  =$0020;  { Manual date override }
      FA_LISTDATE =$0040;  { List-date override }
      FA_FREETIME =$0100;  { Free download time for all files }
      FA_FREESIZE =$0200;  { Free download bytes for all files }
      FA_NOINDEX  =$0400;  { Don't add this area to maxfiles.idx }
      FA_CDROM    =(FA_SLOW or FA_STAGED or FA_NONEW);
      FA_FREEALL  =(FA_FREETIME or FA_FREESIZE);

type marea=Record
  cbArea:Word;          { Length of THIS INDIVIDUAL RECORD                0}
  num_override:Word;    { Number of overrides following this record       2}
  cbHeap:Word;          { Length of the zstr heap following the overrides 4}
  division:Word;        { Reserved for future use                         6}
  name:ZStr;            { String format of area's name.                   8}
  acs:ZStr;             { Access control string for this area            10}
  path:ZStr;            { Path to messages (but for MA_DIVBEGIN only,    12*
                         * used instead as name of custom .bbs file).       }
  echo_tag:ZStr;        { The 'tag' of the area, for use in ECHOTOSS.LOG 14}
  descript:ZStr;        { The DIR.BBS-like description for msg section   16}
  origin:ZStr;          { The ORIGIN line for this area                  18}
  menuname:ZStr;        { Custom menu name                               20}
  menureplace:ZStr;     { Replace this menu name with menuname from above22}
  attribs:Word;         { Attributes for this area                       24}
  primary:NetAddr;      { Use as primary address for this area           26}
  seenby:NetAddr;       { Use as address in seen-bys                     34}
  attribs_2:Word;       { More attributes                                42}
  atype:Word;           { Message base type.  MSGTYPE_SDM = *.MSG.       44*
                         * MSGTYPE_SQUISH = SquishMail.  (Constants are     *
                         * in MSGAPI.H)                                     }
  killbyage:Word;       { Make sure msgs are less than X days old        46}
  killbynum:Word;       { Make sure there are less than X msgs           48}
  killskip:Word;        { Exempt the first X msgs from this processing   50}
  barricade:ZStr;       { Barricade file                                 52}
  barricademenu:ZStr;   { Apply barricade priv while using this menu     54}
  cbPrior:LongInt;      { Seek offset from start of this area to get back56*
                         * to prior area.                                   }
  attachpath:ZStr;      { Reserved for future use                        58}
  rsvd4:Longint;                                                        {60}
  End;                                                                  {64}

type farea=Record
  cbArea:Word;          { Length of THIS INDIVIDUAL RECORD                0}
  num_override:Word;    { Number of overrides following this record       2}
  cbHeap:Word;          { Length of the zstr heap following the overrides 4}
  division:Word;        { Reserved for future use                         6}
  acs:ZStr;             { Access control string for this area             8}
  name:ZStr;            { String format of area's name.                  10}
  downpath:ZStr;        { Path for downloads.                            12}
  uppath:ZStr;          { Path for uploads                               14}
  filesbbs:ZStr;        { Path to FILES.BBS-like catalog for this area   16*
                         * (For FA_DIVBEGIN only, also used as name of      *
                         * custom .bbs display file.)                       }
  descript:ZStr;        { The DIR.BBS-like description for file section  18}
  menuname:ZStr;        { Custom menu for this file area                 20}
  menureplace:ZStr;     { Replace this menu name with menuname from above22}
  barricade:ZStr;       { Barricade file                                 24}
  barricademenu:ZStr;   { Barricade file                                 26}
  cbPrior:LongInt;      { Offset to prior area                           28}
  attribs:Word;         { Attributes for this file area                  32}
  date_style:Integer;   { Date style override for this area              34}
  rsvd1:Array[1..28] of byte;  { Reserved by Maximus for future use      36}
  end;                                                                  {64}

                         (**************)
                         (* ACCESS.DAT *)
                         (**************)

type clshdr=Record
       ulclhid:longint;                                      { ID signature }
       usclfirst:Word;                             { Offset of first record }
       usn:Word;                     { Number of user class records present }
       ussize:Word;                      { Size of individual class records }
       usstr:Word;                                    { Size of all strings }
     end;

     clsrec=Record
       usLevel :Word;                              { Numeric security level }
       usKey   :Word;           { Keyletter for MECCA [?below] [?above] etc }
       zAbbrev :ZStr;                         { Abbreviation for this class }
       zDesc   :ZStr;                                     { Long class name }
       zAlias  :ZStr;                          { Alias for the abbreviation }
       usTimeDay,                         { Daily time allowance in minutes }
       usTimeCall,                         { Call time allowance in minutes }
       usCallsDay,                                  { Max calls/day -1=none }
       usMinBaud,                                { Minimum logon baud / 100 }
       usFileBaud,                            { Minimum download baud / 100 }
       usFileRatio,                            { File upload:download ratio }
       usFreeRatio:Word;     { Download allowance before ratio takes effect }
       ulFileLimit:LongInt;       { Maximum download allowance in kilobytes }
       usUploadReward:Word;                               { % upload reward }
       zLoginFile:ZStr;       { Show this file (in misc directory) on login }
       ulAccFlags:LongInt;                     { Access related class flags }
       ulMailFlags:LongInt;                      { Mail related class flags }
       ulUsrFlags:LongInt;                       { User-defined class flags }
       usOldPriv:Word;      { 'old' user priv equivalent, for compatibility }
     End;

