(* MAX301 (c) Copyright 1996 by Pasi Talliniemi *)

Uses Crt, Dos, Strings, { standard units }
     MyFunc,            { own function library }
     ConcStruct,        { STRUCT.INC }
     MaxStruct;         { MAXSTRUC.INC (shortened from Max 3.01 STRUCTS.ZIP) }

const MAX_LIMITS = 100;

type LimitRec = Record
       Sec: Word;
       Desc: String [20];
     end;

var MaximusPath: DirStr;
    ConcordPath: DirStr;
    IORes: Integer;
    LimitCnt: Byte;
    Limit: Array [1..MAX_LIMITS] of LimitRec;
    Ch: Char;

Procedure HandleIORes (Fname: PathStr);
begin
  WriteLn ('Error ', IORes, ' with ', Fname);
end;

Procedure ConvertSecurity (AccessLevel: String; var Sec: Security);
var A: Integer;
begin
  WriteLn ('Accesslevel : ', AccessLevel);
  FillChar (Sec, SizeOf (Sec), #0);
  AccessLevel := Copy (AccessLevel, 1, 20);
  for A := 1 to LimitCnt do begin
    if AccessLevel = Limit[A].Desc then begin
      Sec.SecLvl := Limit[A].Sec;
      WriteLn ('Sec : ', Sec.SecLvl);
    end;
  end;
end;

Procedure ConvertAka (Netaddress: NetAddr; var Aka: Byte);
begin
end;

Procedure ConvertMessageAreas;
type HeapRec = Array [0..4096] of Char;
var F1: File;
    R1: MArea;
    F2: File of MAreaRec;
    R2: MAreaRec;
    A: Integer;
    NumRead: Word;
    ZStrHeap: ^HeapRec;

  Function MAS (S: ZStr): PChar;
  begin
    MAS := @ZStrHeap^[S];
  end;

begin
  WriteLn ('Converting message area list...');
  New (ZStrHeap);
  FillChar (ZStrHeap^, SizeOf (ZStrHeap^), #0);
  Assign (F1, MaximusPath + 'MAREA.DAT');
  {$I-} Reset (F1, 1); {$I+} IORes := IOResult;
  if IORes = 0 then begin
    Assign (F2, ConcordPath + 'MAREAS.DAT');
    {$I-} Reset (F2); {$I+} IORes := IOResult;
    if IORes = 2 then begin
      {$I-} Rewrite (F2); {$I+} IORes := IOResult;
    end;
    if IORes = 0 then begin
      Seek (F1, 4);
      Seek (F2, FileSize (F2));
      while not Eof (F1) do begin
        if KeyPressed then Break;
        FillChar (R1, SizeOf (R1), #0);
        BlockRead (F1, R1, SizeOf (R1), NumRead);
        if NumRead < SizeOf (R1) then Break;
        if (R1.CBArea <> 0)
        and (R1.CBArea <> SizeOf (R1)) then begin
          WriteLn ('Hmm...');
          Seek (F1, FilePos (F1) + R1.CBArea - SizeOf (R1));
        end;
        Seek (F1, FilePos (F1) + LongInt (R1.Num_OverRide) * SizeOf (OverRide));
        if R1.CBHeap > SizeOf (ZStrHeap^) then begin
          WriteLn ('Area record too big, aborting...');
          Break;
        end;
        BlockRead (F1, ZStrHeap^, R1.CBHeap, NumRead);
        FillChar (R2, SizeOf (R2), #0);
        R2.Id := ID_CFG_MAREA;
        R2.Attrib := MAREA_ACTIVE;
        R2.SubDirNum := R1.Division;
        R2.Name := StrPas (MAS (R1.Descript));
        R2.Group := StrPas (MAS (R1.Name));
        ConvertSecurity (StrPas (MAS (R1.Acs)), R2.ReadRights);
        Move (R2.ReadRights, R2.WriteRights, SizeOf (R2.WriteRights));
        Move (R2.ReadRights, R2.SysopRights, SizeOf (R2.SysopRights));
        R2.SysopRights.SecLvl := 32000; { just in case }
        R2.PathName   := StrPas (MAS (R1.Path));
        R2.ShortName  := StrPas (MAS (R1.Echo_Tag));
        R2.OriginLine := StrPas (MAS (R1.Origin));
        R2.Kinds := MAREAKIND_PUB;
        if R1.Attribs and MA_PVT <> 0 then begin
          if R1.Attribs and MA_PUB <> 0 then begin
            R2.Kinds := MAREAKIND_BOTH;
          end else begin
            R2.Kinds := MAREAKIND_PRIV;
          end;
        end else begin
          if R1.Attribs and MA_READONLY <> 0 then begin
            R2.Kinds := MAREAKIND_RO;
          end;
        end;
        R2.Typ := MAREATYPE_LOCAL;
        if R1.Attribs and MA_NET <> 0 then begin
          R2.Typ := MAREATYPE_NET;
        end else begin
          if R1.Attribs and MA_ECHO <> 0 then begin
            R2.Typ := MAREATYPE_ECHO;
          end;
        end;
        R2.ReplyStatus := MAREAREPLY_BOTH;
        R2.UseAlias := MAREAALIAS_BOTH;
        if R1.Attribs and MA_ANON <> 0 then begin
          R2.UseAlias := MAREAALIAS_ASK;
        end else begin
          if R1.Attribs and MA_REAL <> 0 then begin
            R2.UseAlias := MAREAALIAS_NO;
          end else begin
            if R1.Attribs and MA_ALIAS <> 0 then begin
              R2.UseAlias := MAREAALIAS_YES;
            end;
          end;
        end;
        if R1.Attribs and MA_DIVBEGIN <> 0 then begin
          R2.Attrib := R2.Attrib or MAREA_JUMP;
        end;
        if R1.Attribs and MA_ATTACH <> 0 then begin
          R2.Attrib := R2.Attrib or MAREA_FATTACH;
        end;
        ConvertAka (R1.Primary, R2.UseAka);
        R2.Format := MAREAFMT_SQUISH;
        case R1.Atype of
          MSGTYPE_SQUISH: begin
                            R2.Format := MAREAFMT_SQUISH;
                            R2.OwnBoard := 0;
                          end;
          MSGTYPE_SDM:    begin
                            R2.Format := MAREAFMT_MSG;
                            R2.OwnBoard := 0;
                          end;
        end;
        R2.OpenFrom     := 0;
        R2.OpenTo       := 1439;
        R2.DaysKill     := R1.KillByAge;
        R2.CountKill    := R1.KillByNum;
        { not supported :
          menuname:ZStr;
          menureplace:ZStr;
          seenby:NetAddr;
          attribs_2:Word;
          killskip:Word;
          barricade:ZStr;
          barricademenu:ZStr;
          attachpath:ZStr;
        }
        Write (F2, R2);
      end;
      WriteLn ('Conversion finished.');
    end else begin
      HandleIORes (ConcordPath + 'MAREAS.DAT');
    end;
    Close (F1);
  end else begin
    HandleIORes (MaximusPath + 'MAREA.DAT');
  end;
  Dispose (ZStrHeap);
end;

Procedure ConvertFileAreas;
type HeapRec = Array [0..4096] of Char;
var F1: File;
    R1: FArea;
    F2: File of FAreaRec;
    R2: FAreaRec;
    A: Integer;
    NumRead: Word;
    ZStrHeap: ^HeapRec;

  Function FAS (S: ZStr): PChar;
  begin
    FAS := @ZStrHeap^[S];
  end;

begin
  WriteLn ('Converting file area list...');
  New (ZStrHeap);
  FillChar (ZStrHeap^, SizeOf (ZStrHeap^), #0);
  Assign (F1, MaximusPath + 'FAREA.DAT');
  {$I-} Reset (F1, 1); {$I+} IORes := IOResult;
  if IORes = 0 then begin
    Assign (F2, ConcordPath + 'FAREAS.DAT');
    {$I-} Reset (F2); {$I+} IORes := IOResult;
    if IORes = 2 then begin
      {$I-} Rewrite (F2); {$I+} IORes := IOResult;
    end;
    if IORes = 0 then begin
      Seek (F1, 4);
      Seek (F2, FileSize (F2));
      while not Eof (F1) do begin
        if KeyPressed then Break;
        FillChar (R1, SizeOf (R1), #0);
        BlockRead (F1, R1, SizeOf (R1), NumRead);
        if NumRead < SizeOf (R1) then Break;
        if (R1.CBArea <> 0)
        and (R1.CBArea <> SizeOf (R1)) then begin
          WriteLn ('Hmm...');
          Seek (F1, FilePos (F1) + R1.CBArea - SizeOf (R1));
        end;
        Seek (F1, FilePos (F1) + LongInt (R1.Num_OverRide) * SizeOf (OverRide));
        if R1.CBHeap > SizeOf (ZStrHeap^) then begin
          WriteLn ('Area record too big, aborting...');
          Break;
        end;
        BlockRead (F1, ZStrHeap^, R1.CBHeap, NumRead);
        FillChar (R2, SizeOf (R2), #0);
        R2.Id           := ID_CFG_FAREA;
        R2.Attrib       := FAREA_ACTIVE or FAREA_FILESBBS;
        R2.SubDirNum    := R1.Division;
        ConvertSecurity (StrPas (FAS (R1.ACS)), R2.DownloadSec);
        Move (R2.DownloadSec, R2.UploadSec, SizeOf (R2.UploadSec));
        Move (R2.DownloadSec, R2.FileListSec, SizeOf (R2.FileListSec));
        R2.Name         := StrPas (FAS (R1.Descript));
        R2.Group        := StrPas (FAS (R1.Name));
        R2.FILESBBS     := StrPas (FAS (R1.FILESBBS));
        R2.DownloadPath := AddSlash (StrPas (FAS (R1.DownPath)));
        if R1.Attribs and FA_SLOW <> 0 then begin
          R2.Attrib := R2.Attrib or FAREA_CDROM;
        end;
        if R1.Attribs and FA_NONEW = 0 then begin
          R2.Attrib := R2.Attrib or FAREA_NEWFILES;
        end;
        if R1.Attribs and FA_DIVBEGIN <> 0 then begin
          R2.Attrib := R2.Attrib or FAREA_JUMP;
        end;
        if (R1.Attribs and FA_FREETIME <> 0)
        and (R1.Attribs and FA_FREESIZE <> 0) then begin
          R2.Attrib := R2.Attrib or FAREA_FREE;
        end;
        R2.OpenFrom     := 0;
        R2.OpenTo       := 1439;
        { not supported :
          uppath:ZStr;
          menuname:ZStr;
          menureplace:ZStr;
          barricade:ZStr;
          barricademenu:ZStr;
          date_style:sword;
        }
        Write (F2, R2);
      end;
      WriteLn ('Conversion finished.');
    end else begin
      HandleIORes (ConcordPath + 'MAREAS.DAT');
    end;
    Close (F1);
  end else begin
    HandleIORes (MaximusPath + 'MAREA.DAT');
  end;
  Dispose (ZStrHeap);
end;

Procedure ConvertFileList;
begin
  { not implemented ; only /b and /t switches would be needed to convert }
end;

Procedure ConvertUserBase;
var F1: File;
    R1: _usr;
    F2: File;
    R2: UserRec;
    H2: UserFileHeader;
    F3: File of NameIdxRec;
    I3: NameIdxRec;
    F4: File;
    R4: Array [0..2048] of Char;
    F5: File of FlexUserIdxRec;
    I5: FlexUserIdxRec;
    A:  Integer;
    EmptyAreas: Array [1..50] of Byte;
    MailAreas: Array [1..50] of Byte;
    NumRead: Word;
    DT: DateTime;
begin
  WriteLn ('Converting user base...');
  FillChar (EmptyAreas, SizeOf (EmptyAreas), #0);
  Assign (F1, MaximusPath + 'USER.BBS');
  {$I-} Reset (F1, 1); {$I+} IORes := IOResult;
  if IORes = 0 then begin
    Assign (F2, ConcordPath + 'USERINFO.DAT');
    {$I-} Reset (F2, 1); {$I+} IORes := IOResult;
    if IORes = 2 then begin
      {$I-} Rewrite (F2, 1); {$I+} IORes := IOResult;
      if IORes = 0 then begin
        FillChar (H2, SizeOf (H2), #0);
        H2.Id       := ID_USR_HDR;
        H2.Version  := CURRVERNUM;
        H2.UserSize := SizeOf (UserRec);
        BlockWrite (F2, H2, SizeOf (H2));
      end;
    end;
    if IORes = 0 then begin
      Seek (F2, FileSize (F2));
      Assign (F3, ConcordPath + 'USERINFO.IDX');
      {$I-} Reset (F3); {$I+} IORes := IOResult;
      if IORes = 2 then begin
        {$I-} Rewrite (F3); {$I+} IORes := IOResult;
      end;
      if IORes = 0 then begin
        Seek (F3, FileSize (F3));
        Assign (F4, ConcordPath + 'USERINF2.DAT');
        {$I-} Reset (F4, 1); {$I+} IORes := IOResult;
        if IORes = 2 then begin
          {$I-} Rewrite (F4, 1); {$I+} IORes := IOResult;
        end;
        if IORes = 0 then begin
          Seek (F4, FileSize (F4));
          Assign (F5, ConcordPath + 'USERINF2.IDX');
          {$I-} Reset (F5); {$I+} IORes := IOResult;
          if IORes = 2 then begin
            {$I-} Rewrite (F5); {$I+} IORes := IOResult;
          end;
          if IORes = 0 then begin
            Seek (F5, FileSize (F5));
            while not Eof (F1) do begin
              if keypressed then break;
              FillChar (R1, SizeOf (R1), #0);
              BlockRead (F1, R1, SizeOf (R1), NumRead);
              if NumRead < SizeOf (R1) then Break;
              if (Word (R1.Struct_Len) * 20 <> SizeOf (_usr)) then begin
                Seek (F1, FilePos (F1) + R1.Struct_Len - SizeOf (_usr));
              end;
              FillChar (R2, SizeOf (R2), #0);
              FillChar (I3, SizeOf (I3), #0);
              FillChar (R4, SizeOf (R4), #0);
              FillChar (I5, SizeOf (I5), #0);
              R2.Id            := ID_USR_REC;
              R2.Name          := StrPas (@R1.Name);
              R2.Alias         := StrPas (@R1.Alias);
              R2.City          := StrPas (@R1.City);
              R2.Voice         := StrPas (@R1.Phone);
              R2.Data          := StrPas (@R1.Dataphone);
              R2.Birthday      := PackDate (ZeroStart (R1.Dob_Month, 2) + '-' +
                                            ZeroStart (R1.Dob_Day, 2) + '-' +
                                            ZeroStart (R1.Dob_Year mod 100, 2));
              R2.Password      := StrPas (@R1.Pwd);
              if R1.Bits and BITS_ENCRYPT <> 0 then begin
                { password encrypted }
              end;
              R2.Sec.SecLvl    := R1.Priv;
              Move (R1.Xkeys, R2.Sec.Flags [1], SizeOf (R1.Xkeys));
              R2.ScreenLen     := R1.Len;
              R2.FirstTime := 0; { R1.Date_1stCall }
              R2.LastTime  := 0; { R1.Ludate }
              R2.TimesCalled   := R1.Times;
              R2.TotalMinutes  := 0;
              R2.Pages         := 0;
              R2.PublicMsgs    := R1.Msgs_Posted;
              R2.PrivateMsgs   := 0;
              R2.UpK           := R1.Up;
              R2.UpTimes       := R1.NUp;
              R2.DownK         := R1.Down;
              R2.DownTimes     := R1.NDown;
              R2.SysopCmnt     := '';
              R2.Protocol      := R1.Def_Proto;
              R2.Editor        := 0;
              R2.Viewer        := 0;
              R2.Packer        := R1.Compress;
              R2.CharSet       := 0;
              R2.LastFileChk   := R1.Date_Newfile;
              R2.LastBullChk   := 0;
              R2.Expiration    := R1.XP_Date and $FFFF0000;
              R2.FirstMenu     := '';
              R2.Language      := '';
              R2.MessageArea   := 1;
              R2.FileArea      := 1;
              R2.Door          := 1;
              R2.ChatChannel   := 0;
              R2.TodayCalls    := R1.Call;
              R2.TodayElapsed  := R1.Time;
              R2.TodayDownK    := R1.DownToday;
              R2.TodayDowns    := R1.NDownToday;
              R2.TimeInBank    := 0;
              R2.DLLimitInBank := 0;
              R2.ViewFileName  := '';
              R2.OfflineFmt    := OFFLINEPKT_NONE;
              R2.OfflineDays   := 0;
              R2.ReadMsgNum    := 0;
              R2.FileListNum   := 0;
              R2.TodayLastPkt  := 0;
              R2.VerifyCalls   := 0;
              if R1.Bits and BITS2_BADLOGON <> 0 then begin
                R2.PasswordTries := 1;
              end;
              R2.OfflineMaxNum := 1000;
              R2.FlexPos       := FilePos (F5);
              R2.LastPktDl     := 0;
              R2.BBSCRC        := -1;
              case R1.Video of
                GRAPH_TTY:    R2.Emulation := 4;
                GRAPH_ANSI:   R2.Emulation := 1;
                GRAPH_AVATAR: R2.Emulation := 2;
                GRAPH_RIP:    R2.Emulation := 1;
              end;
              R2.TextFileType  := 0;
              R2.DateFormat    := 0;
              R2.PasswordCRC   := -1;
              R2.LastVoteChk   := 0;
              R2.TodayLastDesc := 0;
              R2.TimeUnits     := 0;
              R2.KBUnits       := 0;
              R2.Attrib1 := USER_COLORS or USER_MAILCHK or USER_FILECHK;
              if R1.DelFlag and UFLAG_DEL <> 0 then begin
                R2.Attrib1 := R2.Attrib1 or USER_DELETED;
              end;
              if R1.Bits2 and BITS2_CLS <> 0 then begin
                R2.Attrib1 := R2.Attrib1 or USER_CLRSCR;
              end;
              if R1.Bits2 and BITS2_MORE <> 0 then begin
                R2.Attrib1 := R2.Attrib1 or USER_MORE;
              end;
              if R1.Bits and BITS_NOTAVAIL <> 0 then begin
                R2.Attrib1 := R2.Attrib1 or USER_NODISTURB;
              end;
              if R1.Bits and BITS_HOTKEYS <> 0 then begin
                R2.Attrib1 := R2.Attrib1 or USER_HOTKEYS;
              end;
              if R1.Sex = SEX_FEMALE then begin
                R2.Attrib1 := R2.Attrib1 or USER_FEMALE;
              end;
              R2.OfflineAttrib := OFFLINE_WELCOME or OFFLINE_NEWS or
                                  OFFLINE_GOODBYE or OFFLINE_LASTREAD or
                                  OFFLINE_RECEIVED;
              I3.NameCRC32  := CRC_32 (Capit (R2.Name));
              I3.AliasCRC32 := CRC_32 (Capit (R2.Alias));
              I5.NameCRC32  := I3.NameCRC32;
              I5.FilePos    := FilePos (F4);
              I5.AddrLen    := 10;
              for A := 1 to 10 do begin
                R4 [A] := #13;
              end;
              I5.CmntLen    := 0;
              I5.MailLen    := 0;
              I5.MAreaCnt   := SizeOf (EmptyAreas) * 8;
              I5.FAreaCnt   := SizeOf (EmptyAreas) * 8;
              BlockWrite (F2, R2, SizeOf (R2));
              Write (F3, I3);
              BlockWrite (F4, R4, I5.AddrLen);
              BlockWrite (F4, EmptyAreas, SizeOf (EmptyAreas)); { mcomb }
              BlockWrite (F4, EmptyAreas, SizeOf (EmptyAreas)); { mscan }
              BlockWrite (F4, EmptyAreas, SizeOf (EmptyAreas)); { mpkt  }
              BlockWrite (F4, EmptyAreas, SizeOf (EmptyAreas)); { fcomb }
              Write (F5, I5);
            end;
            { not supported :
              lastread_ptr:Word;
              help:Byte;
              nulls:Byte;
              msgs_read:Longint;
              width:Byte;
              credit:Word;
              debit:Word;
              xp_priv:Word;
              xp_mins:LongInt;
              xp_flag:byte;
              xkeys:LongInt;
              date_pwd_chg:LongInt;
              point_credit:Longint;
              point_debit:Longint;
            }
          end else begin
            HandleIORes (ConcordPath + 'USERINF2.IDX');
          end;
        end else begin
          HandleIORes (ConcordPath + 'USERINF2.DAT');
        end;
      end else begin
        HandleIORes (ConcordPath + 'USERINFO.IDX');
      end;
    end else begin
      HandleIORes (ConcordPath + 'USERINFO.DAT');
    end;
  end else begin
    HandleIORes (MaximusPath + 'USER.BBS');
  end;
end;

Procedure ShowUsage;
begin
  WriteLn ('1: Convert message area list');
  WriteLn ('2: Convert file area list');
  {WriteLn ('3: Convert file lists');}
  WriteLn ('4: Convert user base');
end;

Procedure CheckOptions;
const OPT_MSGAREAS  = $0001;
      OPT_FILEAREAS = $0002;
      OPT_FILELIST  = $0004;
      OPT_USERBASE  = $0008;
var Options: LongInt;
    A: Integer;
    S: String;
begin
  Options := 0;
  for A := 1 to ParamCount do begin
    S := ParamStr (A);
    case S [1] of
      '1': Options := Options or OPT_MSGAREAS;
      '2': Options := Options or OPT_FILEAREAS;
     {'3': Options := Options or OPT_FILELIST;}
      '4': Options := Options or OPT_USERBASE;
    end;
  end;
  WriteLn ('Maximus path : ', MaximusPath);
  WriteLn ('Concord path : ', ConcordPath);
  if Options and OPT_MSGAREAS <> 0 then begin
    ConvertMessageAreas;
  end;
  if Options and OPT_FILEAREAS <> 0 then begin
    ConvertFileAreas;
  end;
  if Options and OPT_FILELIST <> 0 then begin
    ConvertFileList;
  end;
  if Options and OPT_USERBASE <> 0 then begin
    ConvertUserBase;
  end;
end;

Function GetMaximusPath: DirStr;
var D: Dos.DirStr; N: Dos.NameStr; E: Dos.ExtStr;
begin
  FSplit (FExpand (GetEnv ('MAXIMUS')), D, N, E);
  GetMaximusPath := D;
end;

Procedure ReadAccess;
type HeapRec = Array [0..4096] of Char;
var F1: File;
    R1: ClsHdr;
    R2: ClsRec;
    NumRead: Word;
    ZStrHeap: ^HeapRec;
    A: Integer;

  Function AS (S: ZStr): PChar;
  begin
    AS := @ZStrHeap^[S];
  end;

begin
  LimitCnt := 0;
  FillChar (Limit, SizeOf (Limit), #0);
  WriteLn ('Reading user limits...');
  New (ZStrHeap);
  FillChar (ZStrHeap^, SizeOf (ZStrHeap^), #0);
  Assign (F1, MaximusPath + 'ACCESS.DAT');
  {$I-} Reset (F1, 1); {$I+} IORes := IOResult;
  if IORes = 0 then begin
    BlockRead (F1, R1, SizeOf (R1), NumRead);
    Seek (F1, R1.UsclFirst + LongInt (R1.UsSize) * R1.UsN);
    if R1.UsStr > SizeOf (ZStrHeap^) then begin
      WriteLn ('Limit record too big, aborting...');
    end else begin
      BlockRead (F1, ZStrHeap^, R1.UsStr, NumRead);
      Seek (F1, R1.UsclFirst);
      for A := 1 to R1.UsN do begin
        BlockRead (F1, R2, SizeOf (R2), NumRead);
        if NumRead < SizeOf (R2) then begin
          WriteLn ('Hmm...');
          Break;
        end;
        if R1.UsSize <> SizeOf (R2) then begin
          Seek (F1, FilePos (F1) + R1.UsSize - SizeOf (R2));
        end;
        Inc (LimitCnt);
        Limit[LimitCnt].Sec := R2.UsLevel;
        Limit[LimitCnt].Desc := StrPas (AS (R2.ZDesc));
        WriteLn (Limit[LimitCnt].Sec, ' : ', Limit[LimitCnt].Desc);
        if LimitCnt = MAX_LIMITS then begin
          Break;
        end;
      end;
    end;
    Close (F1);
  end else begin
    HandleIORes (MaximusPath + 'ACCESS.DAT');
  end;
  Dispose (ZStrHeap);
end;

begin
  Filemode    := ReadWrite + Denynone;
  MaximusPath := AddSlash (GetMaximusPath);
  ConcordPath := AddSlash (FExpand (GetEnv ('CONCORD')));
  if ParamCount = 0 then begin
    ShowUsage;
  end else begin
    ReadAccess;
    WriteLn ('Are you sure (y/n) :');
    ReadLn (ch);
    if Upcase (ch) = 'Y' then begin
      CheckOptions;
    end;
  end;
end.
