Program Celerity_To_Vision_Convert;

{ Written by: The Elemental }
{ There's no stop'n US! }

Uses Gentypes,Configrt,Crt;

Type CELConfType=(lowerc,eightyc,linef,postp,morep,asciig,ansig,udsys,bulletinsys,
                  votingsys,emailsys,doorssys,mainsys,databasesys,NewUserSys,
                  gfsys,want,showt,vt522,fsedit);
     CELFListType=(ffname,ffext,fffulnam,ffofwhat,ffsize,ffpoints,ffuploader,
                   ffuploaded,ffdown,ffdescript);
     NuvSet = set of 1..255;

     CELURec = Record
       Handle,RealName,Note:MStr;
       Macro1,Macro2,Macro3:LStr;
       Password:Sstr;
       PhoneNum:String[12];
       Laston:Longint;
       Numon,TimeToday,Nup,Ndn,Nbu,Uploads,Downloads:Integer;
       TotalTime:Real;
       Voted:Array [1..5] of Byte;
       UdLevel,UdPoints,Level,EmailAnnounce,BeepedPwd:Integer;
       Infoforms:array [1..5] of Integer;
       RegularColor,PromptColor,StatColor,InputColor,FifthColor,SixthColor,
       SeventhColor,EighthColor,DisplayLen:Byte;
       LastMessages,LastUps,LastGfiles,LastDBases,Integer1:Integer;
       DownK,UpK:Longint;
       GFLevel,GfUploads,GFDownloads:Integer;
       MenuType,Byte1:Byte;
       DefProto,Char1:Char;
       Hack:Byte;
       Config:Set of CELConfType;
       NewScanConfig,Access1,Access2:Set of Byte;
       TimeinStorage:Word;
       LastRead:Array [0..20,1..5] of Word;
       ConfAccess:Array [0..5] of Boolean;
       LastCps,CpsTimes:Word;
       FileList:Set of CELFListType;
       CommPoints,ValPoints:Integer;
       ScanNet:Boolean;
       QuikConf:Array [1..5] of Boolean;
       UserPcr,UserUdr,Age:Byte;
       UserSex:Boolean;
       VoteYes,VoteNo,TimePerDay:Byte;
     End;

Procedure CelerityUserConvert;
Var UFile:File of CELURec;
    CEL:CELURec;
    VFile:File of UserRec;
    VIS:UserRec;
    Cnt,I:Integer;
Begin
  Writeln ('Converting: Celerity User List to Vision Format!');
  Assign (UFile,'USERS');       { Open And Rename Celerity Users File }
  Reset (UFile);
  If IOResult <> 0 Then Begin
    Writeln ('File: USERS not found.. Cannot continue!');
    Close (UFile);
    Exit
  End;
  Rename (UFile,'USERS.CEL');
  Assign (VFile,'USERS.');      { Open and Create Vision Users File }
  Rewrite (VFile);
  Seek (UFile,1);
  Seek (VFile,0);
  Cnt:=0;
  TextAttr:=11;
  While Not Eof(UFile) Do Begin
    Read (UFile,CEL);
    For I:=1 to Length(VIS.Handle) Do
     Write (#8#32#8);
    FillChar (VIS,SizeOf(VIS),0);
    If Length(CEL.Handle) > 0 Then Begin
      Cnt:=Cnt + 1;
      Write (VIS.Handle);
      VIS.Handle:=CEL.Handle;
      VIS.RealName:=CEL.RealName;
      VIS.UserNote:=CEL.Note;
      VIS.Macro1:=CEL.Macro1;
      VIS.Password:=CEL.Password;
      VIS.PhoneNum:=Copy(CEL.PhoneNum,1,3) + Copy(CEL.PhoneNum,5,3) +
                    Copy(CEL.PhoneNum,9,4);
      VIS.Level:=CEL.Level;
      VIS.Numon:=CEL.Numon;
      VIS.NBu:=CEL.NBu;
      VIS.UdLevel:=CEL.UdLevel;
      VIS.UdPoints:=CEL.UdPoints;
      VIS.Uploads:=CEL.Uploads;
      VIS.Downloads:=CEL.Downloads;
      VIS.RegularColor:=CEL.RegularColor;
      VIS.StatColor:=CEL.StatColor;
      VIS.InputColor:=CEL.InputColor;
      VIS.PromptColor:=CEL.PromptColor;
      VIS.MenuBoard:=CEL.FifthColor;
      VIS.MenuBack:=CEL.SixthColor;
      VIS.MenuHighLight:=CEL.SeventhColor;
      VIS.DisplayLen:=CEL.DisplayLen;
      VIS.BlowInside:=7;
      VIS.BlowBoard:=7;
      VIS.StatusBoxColor:=7;
      VIS.Config:=[LowerCase,LineFeeds,AnsiGraphics,AsciiGraphics,Fseditor,
                   EightyCols];
      Seek (VFile,Cnt - 1);
      Write (VFile,VIS);
    End;
  End;
  Writeln (Cnt,' Users Converted over to Vision!');
  If Cnt > 70 Then Writeln ('Ahh.. Busy Day!!');
  Close (UFile);
  Close (VFile);
End;

Var K:Char;
Begin
  ReadConfig;
  TextAttr:=7;
  ClrScr;
  TextAttr:=12;
  Write (#13#10#13#10'Celerity to ');
  TextAttr:=13;
  Write ('ViSiON ');
  TextAttr:=12;
  Writeln ('User Converter!');
  TextAttr:=9;
  Writeln ('Written by: The Elemental - ViSiON Programming Staff Member');
  TextAttr:=10;
  Writeln ('(C)opyright 1991 Ruthless Enterprises!!');
  Writeln;
  Repeat
   Write ('Continue with Conversion [y/N]? ');
   K:=Upcase(ReadKey);
  Until K in [#13,'Y','N'];
  If K = 'Y' Then Begin
    CelerityUserConvert;
    Writeln ('Celerity Users List Saved as USERS.CEL');
  End;
End.