unit useredu;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, TB97, ExtCtrls, Buttons, Mask, tGlob, tMisc, Users, tMainOvr,
  Resource;

type
  TUserEdForm = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label17: TLabel;
    Location: TEdit;
    Organization: TEdit;
    Address1: TEdit;
    Comment: TEdit;
    Alias: TEdit;
    Address3: TEdit;
    Address2: TEdit;
    Protocol: TEdit;
    Language: TEdit;
    Password: TEdit;
    Label18: TLabel;
    Label19: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label28: TLabel;
    GroupBox1: TGroupBox;
    More: TCheckBox;
    Hotkeys: TCheckBox;
    Frames: TCheckBox;
    Guest: TCheckBox;
    FSeditor: TCheckBox;
    EmuGroup: TRadioGroup;
    HPhone: TMaskEdit;
    DPhone: TMaskEdit;
    Birthdate: TMaskEdit;
    Security: TMaskEdit;
    Lines: TMaskEdit;
    Flags: TMaskEdit;
    Downloads: TMaskEdit;
    DownloadsK: TMaskEdit;
    UploadsK: TMaskEdit;
    MsgsPosted: TMaskEdit;
    TodayK: TMaskEdit;
    Uploads: TMaskEdit;
    SaveButton: TBitBtn;
    CancelButton: TBitBtn;
    procedure BitBtn2Click(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  UserEdForm: TUserEdForm;

implementation

uses tor32u;

{$R *.DFM}

Var
  S, S1 : PChar;

procedure TUserEdForm.BitBtn2Click(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TUserEdForm.SaveButtonClick(Sender: TObject);
begin
  AnsiToOem (PChar (Location. Text), S1); R. Location := S1;
  AnsiToOem (PChar (Organization. Text), S1); R. Organization := S1;
  AnsiToOem (PChar (Address1. Text), S1); R. Address1 := S1;
  AnsiToOem (PChar (Address2. Text), S1); R. Address2 := S1;
  AnsiToOem (PChar (Address3. Text), S1); R. Address3 := S1;
  AnsiToOem (PChar (Alias. Text), S1); R. Alias := S1;
  AnsiToOem (PChar (Comment. Text), S1); R. Comment := S1;
  AnsiToOem (PChar (Password. Text), S1); R. Password := S1;
  AnsiToOem (PChar (HPhone. Text), S1); R. HPhone := S1;
  AnsiToOem (PChar (DPhone. Text), S1); R. BPhone := S1;

  R. BirthDate := Date2Long (ReformatDate (Birthdate. Text, 'MM.DD.YY', DefaultDateMask));
  R. Lang := Language. Text;
  R. Lines := Str2Long (Lines. Text);
  R. Security := Str2Long (Security. Text);
  R. Flags := Flags. Text;
  R. Protocol := Protocol. Text [1];

  Case EmuGroup. ItemIndex Of
    0 : R. Emu := teANSI;
    1 : R. Emu := teAvatar;
    2 : R. Emu := teTTY;
  End;

  R. More := More. Checked;
  R. Hotkeys := Hotkeys. Checked;
  R. Frames := Frames. Checked;
  R. Guest := Guest. Checked;
  R. FSeditor := FSeditor. Checked;

  R. Downloads := Str2Long (Downloads. Text);
  R. DownloadsK := Str2Long (DownloadsK. Text);
  R. Uploads := Str2Long (Uploads. Text);
  R. UploadsK := Str2Long (UploadsK. Text);
  R. MsgsPosted := Str2Long (MsgsPosted. Text);

  SaveUser (R);
  MainForm. Console1. ShowCursor;
  ShowUsualBar;
  MainForm. miEditUser := True;
  Close;
end;

procedure TUserEdForm.CancelButtonClick(Sender: TObject);
begin
  MainForm. Console1. ShowCursor;
  MainForm. miEditUser := True;
  Close;
end;

procedure TUserEdForm.FormActivate(Sender: TObject);
begin
  StrPCopy (S, R. Location); OemToAnsi (S, S1); Location. Text := S1;
  StrPCopy (S, R. Organization); OemToAnsi (S, S1); Organization. Text := S1;
  StrPCopy (S, R. Address1); OemToAnsi (S, S1); Address1. Text := S1;
  StrPCopy (S, R. Address2); OemToAnsi (S, S1); Address2. Text := S1;
  StrPCopy (S, R. Address3); OemToAnsi (S, S1); Address3. Text := S1;
  StrPCopy (S, R. Alias); OemToAnsi (S, S1); Alias. Text := S1;
  StrPCopy (S, R. Comment); OemToAnsi (S, S1); Comment. Text := S1;
  StrPCopy (S, R. Password); OemToAnsi (S, S1); Password. Text := S1;
  StrPCopy (S, R. HPhone); OemToAnsi (S, S1); HPhone. Text := S1;
  StrPCopy (S, R. BPhone); OemToAnsi (S, S1); DPhone. Text := S1;

  Birthdate. Text := ReformatDate (Long2Date (R. BirthDate), DefaultDateMask, 'MM.DD.YY');
  Language. Text := R. Lang;
  Security. Text := Long2Str (R. Security);
  Flags. Text := R. Flags;
  Protocol. Text := R. Protocol;
  Lines. Text := Long2Str (R. Lines);

  Case R. Emu Of
    teANSI   : EmuGroup. ItemIndex := 0;
    teAvatar : EmuGroup. ItemIndex := 1;
    teTTY    : EmuGroup. ItemIndex := 2;
  End;

  More. Checked := R. More;
  Hotkeys. Checked := R. Hotkeys;
  Frames. Checked := R. Frames;
  Guest. Checked := R. Guest;
  FSeditor. Checked := R. FSeditor;

  Downloads. Text := Long2Str (R. Downloads);
  DownloadsK. Text := Long2Str (R. DownloadsK);
  Uploads. Text := Long2Str (R. Uploads);
  UploadsK. Text := Long2Str (R. UploadsK);
  TodayK. Text := Long2Str (R. TodayK);
  MsgsPosted. Text := Long2Str (R. MsgsPosted);

  StrPCopy (S, R. Name); OemToAnsi (S, S1);
  Caption := 'Edit user parameters: ' + S1;
end;

initialization

  GetMem (S, 256);
  GetMem (S1, 256);

finalization

  FreeMem (S, 256);
  FreeMem (S1, 256);

end.
