unit wapro;

interface

Uses
  tGlob,
  tMisc,
  Console;

Function ProtocolInProgress (Var Dummy): Boolean;
Function CheckDCD (Var Dummy): Boolean;
Function CharReady (Var Dummy): Boolean;
Procedure GetChar (Var Dummy; Var C: Char);
Procedure PutChar (Var Dummy; C: Char);
Procedure PutString (Var Dummy; S: String);
Procedure SetDTR (Var Dummy; Stat: Boolean);
Procedure SetModem (Var Dummy; DTR, RTS: Boolean);
Function OutBuffUsed (Var Dummy): LongInt;
Function GetElapsedTics (Var Dummy): LongInt;
Function GetFileSize (Var Dummy): LongInt;
Function GetInitialFilePos (Var Dummy): LongInt;
Procedure ClrScr;
Procedure TextColor (B: Byte);
Procedure GoToXY (X, Y: Byte);
Function WhereX : Byte;
Function WhereY : Byte;
Procedure HiddenCursor;
Procedure NormalCursor;
Procedure TextBackGround (B: Byte);
Procedure ClrEOL;
Function ReadKey: Char;
Function KeyPressed: Boolean;
Function GetPathName (Var Dummy): String;
Function GetBytesTransferred (Var Dummy): LongInt;
Procedure SetRecoverOption (Var Dummy; B: Boolean);
Procedure SetDestinationDirectory (Var Dummy; Dir: String);
Procedure SetFileMask (Var Dummy; FileName: String);

implementation

{$IFDEF WIN32}
Uses
  tor32u;
{$ENDIF}

Function ProtocolInProgress (Var Dummy): Boolean;
Begin
  ProtocolInProgress := Prot. InProgress;
End;

Function CheckDCD (Var Dummy): Boolean;
Begin
  CheckDCD := P. DCD;
End;

Function CharReady (Var Dummy): Boolean;
Begin
  CharReady := P. CharReady;
End;

Procedure GetChar (Var Dummy; Var C: Char);
Begin
  C := P. GetChar;
End;

Procedure PutChar (Var Dummy; C: Char);
Begin
  Try P. PutChar (C); Except End;
End;

Procedure PutString (Var Dummy; S: String);
Begin
  Try P. PutString (S); Except End;
End;

Procedure SetDTR (Var Dummy; Stat: Boolean);
Begin
  P. DTR := Stat;
End;

Procedure SetModem (Var Dummy; DTR, RTS: Boolean);
Begin
  P. DTR := DTR;
  P. RTS := RTS;
End;

Function OutBuffUsed (Var Dummy): LongInt;
Begin
  OutBuffUsed := P. OutBuffUsed;
End;

Function GetElapsedTics (Var Dummy): LongInt;
Begin
  GetElapsedTics := Prot. ElapsedTicks;
End;

Function GetFileSize (Var Dummy): LongInt;
Begin
  GetFileSize := Prot. FileLength;
End;

Function GetInitialFilePos (Var Dummy): LongInt;
Begin
  GetInitialFilePos := Prot. InitialPosition;
End;

Function GetPathName (Var Dummy): String;
Begin
  GetPathName := Prot. FileName;
End;

Function GetBytesTransferred (Var Dummy): LongInt;
Begin
  GetBytesTransferred := Prot. BytesTransferred;
End;

Procedure SetDestinationDirectory (Var Dummy; Dir: String);
Begin
  Prot. DestinationDirectory := Dir;
End;

Procedure SetFileMask (Var Dummy; FileName: String);
Begin
  Prot. FileMask := FileName;
End;

Procedure SetRecoverOption (Var Dummy; B: Boolean);
Begin
  Prot. ZModemRecover := B;
End;

Procedure ClrScr;
Begin
  MainForm. Console1. ClrScr;
End;

Procedure GoToXY (X, Y: Byte);
Begin
  MainForm. Console1. CursorTo (X-1, Y-1);
  MainForm. Console1. ShowCursor;
End;

Function WhereX : Byte;
Begin
  WhereX := MainForm. Console1. WhereX;
End;

Function WhereY : Byte;
Begin
  WhereY := MainForm. Console1. WhereY;
End;

Procedure HiddenCursor;
Begin
  {Cons. HideCursor;}
End;

Procedure NormalCursor;
Begin
  {Cons. ShowCursor;}
End;

Procedure TextColor (B: Byte);
Begin
  TextAttr := b + Hi4 (TextAttr) * 16;
End;

Procedure TextBackGround (B: Byte);
Begin
  TextAttr := Lo4 (TextAttr) + b * 16;
End;

Procedure ClrEOL;
Begin
  MainForm. Console1. ClrEOL;
End;

Function KeyPressed: Boolean;
Begin
  KeyPressed := MainForm. Console1. KeyPressed;
End;

Function ReadKey: Char;
Begin
  ReadKey := MainForm. Console1. ReadKey;
End;

end.