{$IFNDEF OS2}
{$O+,F+}
{$ENDIF}
{$I-}

Unit Upgrader;

{*********************************************************}
{*                   UPGRADER.PAS                        *}
{*                                                       *}
{*  Copyright (c) Konstantin Klyagin, 1995-98,           *}
{*                exspecially for Tornado BBS System     *}
{*                                                       *}
{*********************************************************}

Interface

Procedure Upgrade;

Implementation

Uses
  tMisc,
  Parse,
  Log,
  Users,
  Areas,
  Resource,
  TGlob,
  MainComm;

Type
  UURec = Record
    Name        : String [36];
    Date        : LongInt;
    OldSec      : Word;
  End;

Procedure CheckTodayList;
Var
  F, FO : File Of UURec;
  UUR   : UURec;

Begin
  Assign (F, Cnf. Path + 'upgrdat.tor');
  ReSet (F);
  If IOResult <> 0 Then Exit;

  While Not EoF (F) Do
  Begin
    Read (F, UUR);

    If UUR. Name = R. Name Then
    If UUR. Date <> DateL Then
    Begin
      R. Security := UUR. OldSec;      {⠭ security}

      ReadLimit (Lim, R. Security);
      R. TotalTime := Lim. Time * 60;

      Assign (FO, Cnf. TempDir + 'upgrdat.$$$');
      ReWrite (FO);
      Seek (F, 0);

      While Not EoF (F) Do
      Begin
        Read (F, UUR);
        If Trim (UpString (UUR. Name)) <> Trim (UpString (R. Name)) Then
           Write (FO, UUR);
      End;
      Close (FO);

      tRenameFile (Cnf. TempDir + 'upgrdat.$$$', Cnf. Path + 'upgrdat.tor');
      Break;
    End;
  End;
  Close (F);
End;

Function AddToTodayList: Boolean;
Var
  UUR   : UURec;
  F, FO : File Of UURec;

Begin
  AddToTodayList := True;
  Assign (F, Cnf. Path + 'upgrdat.tor');
  ReSet (F);
  If IOResult <> 0 Then ReWrite (F);

  Assign (FO, Cnf. TempDir + 'upgrdat.t$$');
  ReWrite (FO);
  If IOResult <> 0 Then
  Begin
    AddToTodayList := False;
    Exit;
  End;

  While Not EoF (F) Do
  Begin
    Read (F, UUR);
    Write (FO, UUR);
  End;

  UUR. Name := R. Name;
  UUR. Date := DateL;
  UUR. OldSec := R. Security;

  Write (FO, UUR);
  Close (FO);
  Close (F);
  Erase (F);

  tRenameFile (Cnf. TempDir + 'upgrdat.t$$', Cnf. Path + 'upgrdat.tor');
End;

Procedure Upgrade;
Var
  UR              : UpgradeRec;
  OK              : Boolean;
  Sec, oSec       : Word;
  i               : LongInt;
  CheckItem       : String [10];

Label
  NotOK,
  EoP;

Begin
  oSec := R. Security;

  CheckTodayList;
  If Not opUpgrades (Cnf. UpgraderCTL) Then Exit;

  If Long2Date (R. BirthDate) = Long2Date (DateL) Then
  Begin
    If (R. LastDate <> DateL) or (R. NoCalls = 1) Then
    Begin
      If Not rUpgrade (-1, UR) Then
      If Not rUpgrade (R. NoCalls, UR) Then Exit;
      LogWrite ('+', sm (smUserBirthDay));
    End Else Exit;
  End Else
    If Not rUpgrade (R. NoCalls, UR) Then GoTo EoP;

  {஢塞 ᫮ Check}
  OK := True;
  For i := 1 To WordCount (UR. Check, [' ', ',']) Do
  Begin
    CheckItem := ExtractWord (i, UR. Check, [' ', ',']);
    Sec := Str2Long (Copy (CheckItem, 2, 255));

    Case CheckItem [1] Of
      '!' : If R. Security = Sec Then
            Begin
              NotOK:
              OK := False;
              Break;
            End;
      '>' : If R. Security <= Sec Then GoTo NotOK;
      '<' : If R. Security >= Sec Then GoTo NotOK;
    Else Continue;
    End;
  End;
  If Not OK Then GoTo EoP;
  {稫 ஢}

  Case UR. Mode Of
    umForever : OK := True;
    umToday   : OK := AddToTodayList;
  End;

  If OK Then
  Begin
    Case UR. Security [1] Of
       '+' : Begin
               Inc (R. Security, Str2Long (Copy (UR. Security, 2, 255)));
               LogWrite ('+', sm (smSecRaiseBy) + Copy (UR. Security, 2, 255));
             End;

       '-' : Begin
               Dec (R. Security, Str2Long (Copy (UR. Security, 2, 255)));
               LogWrite ('+', sm (smSecDecBy) + Copy (UR. Security, 2, 255));
             End;
    Else
             Begin
               R. Security := Str2Long (UR. Security);
               LogWrite ('+', sm (smSecChangeTo) + UR. Security);
             End;
    End;

    If UR. InformVia = 'DISPLAY' Then EmuDispFile (UR. Filename) Else
    Begin
      If FileExists (UR. FileName)
      Then
        PostFile (UR. FileName, Str2Long (Trim (ExtractWord (2,
          UR. InformVia, ['(', ')']))), Cnf. SysOp,
          R. Name, 'Message from the Tornado upgrade manager',
          MsgArea. Address, MsgArea. Address,
          pfAutoOpen+pfUpgrader+pfUseDefaultAddr)
      Else
        LogWrite ('!', sm (smFile) + UR. FileName + sm (smNotFound));
    End;
  End
  Else
    LogWrite ('!', 'Can''t write file ' + Cnf. Path + 'upgrdat.tor');

  EoP:
  pUpgradeDone;

  If R. Security <> oSec Then SetSecurity;
End;

End.
