{$F+}
Unit
  tModem;

Interface

Uses
{$IFNDEF WIN32}
  ApSame,
  ApTimer,
{$ELSE}
  AdPort,
  ooMisc,
{$ENDIF}
  tMisc,
  tGlob;

Const
  LastResponse  : String  = 'OK';

Type
  tModemResponse = (mdmrOk, mrConnect, mrNoCarrier, mrError, mrNoResponse, mrRing);
  tResponseMode  = (rmRingWait, rmConnectWait, rmInit);
  tBGProc        = Function: Boolean;

Function GetModemResponse (Mode: tResponseMode; TimeOut: LongInt; BGProc: tBGProc): tModemResponse;
Procedure SetConnectSpeed (Speed: LongInt);

Implementation

Const
  ConnectSpeed  : LongInt = 300;

Function GetModemResponse;
Var
  Timer : EventTimer;
  C     : Char;
  S, S1 : String;

Begin
  NewTimer (Timer, TimeOut);
  S := '';

  While Not TimerExpired (Timer) Do
  Begin
    If {$IFNDEF WIN32} CharReady (P) {$ELSE} P. CharReady {$ENDIF} Then
    Begin
    {$IFNDEF WIN32}
      GetChar (P, C);
    {$ELSE}
      C := P. GetChar;
    {$ENDIF}

      If (C = #13) and (S <> '') Then
      Begin
      {$IFNDEF WIN32}
        If CharReady (P) Then GetChar (P, C);
      {$ELSE}
        If P. CharReady Then P. GetChar;
      {$ENDIF}

        S := Trim (PlaceSubStr (PlaceSubStr (S, #13, ''), #10, ''));

        If (Mode in [rmRingWait, rmConnectWait]) And
           (Copy (S, 1, Length (Cnf. ConnectStr)) =
            Cnf. ConnectStr) Then
        Begin
          LastResponse := S;
          S := Trim (Copy (S, Length (Cnf. ConnectStr)+1, 255)); i := 1; S1 := '';
          While (i <= Length (S)) And (S [i] in ['0'..'9']) Do
          Begin
            S1 := S1 + S [i];
            Inc (i);
          End;
          GetModemResponse := mrConnect;
          ConnectSpeed := Str2Long (S1);
          Exit;
        End;

        If (Mode in [rmRingWait, rmInit]) and (S = Cnf. RingStr) Then
        Begin
          LastResponse := S;
          GetModemResponse := mrRing;
          Exit;
        End;

        If (Mode = rmInit) and (S = Cnf. OkStr) Then
        Begin
          LastResponse := S;
          GetModemResponse := mdmrOk;
          Exit;
        End;

        If (Mode = rmConnectWait) and
           (S = Cnf. NoCarrierStr) Then
        Begin
          LastResponse := S;
          GetModemResponse := mrNoCarrier;
          Exit;
        End;

        LastResponse := S;
        S := '';
      End
        Else If C <> #10 Then S := S + C;
    End Else
      If Not BGProc
      Then Break;
  End;

  GetModemResponse := mrNoResponse;
  S := Trim (PlaceSubStr (PlaceSubStr (S, #13, ''), #10, ''));
  LastResponse := S;
End;

Function fGetConnectSpeed: LongInt;
Begin
  fGetConnectSpeed := 0;
  If Not Local Then fGetConnectSpeed := ConnectSpeed;
End;

Procedure SetConnectSpeed (Speed: LongInt);
Begin
  ConnectSpeed := Speed;
End;

Begin
  GetConnectSpeed := fGetConnectSpeed;
End.