{$IFDEF MSDOS}
{$O+,F+}
{$ENDIF}
{$I-}

Unit
  tFSed;

Interface

Uses
{$IFNDEF NOT_TOR}
  MainComm,
  tGlob,
{$ENDIF}
  OpCrt,
{$IFNDEF WIN32}
  DOS,
{$ELSE}
  Forms,
{$ENDIF}
  tMisc;

Type
  tsChar = Set Of Char;
  tLineEditResult =
    (mpSave, mpAbort, mpContinue, mpEditLine,
     mpShow, mpDeleteLine
    );

  tEditMenuProc = Function (Var S: String): tLineEditResult;
  tEditLineProc = Procedure (Var S: String);

Const
  ofsQuoting = $01;

Function fsEditFile (FN: PathStr; ExitKeys: tsChar; Options, aQuote, aNormal, X1, Y1, X2, Y2: Byte): Char;
Function lnEditFile (FN: PathStr; Menu: tEditMenuProc; EditLineProc: tEditLineProc; aQuote, aNormal: Byte): tLineEditResult;

Implementation

Const
  kbUp        = #1;
  kbDown      = #2;
  kbRight     = #3;
  kbLeft      = #4;
  kbEscape    = #27;
  kbDel       = #127;
  kbBackSpace = #8;
  kbHome      = #5;
  kbEnd       = #6;
  kbEnter     = #13;
  kbCtrlY     = #25;

  WordDelims = [' '];

Type
  pTextBuffer = ^tTextBuffer;
  tTextBuffer = Array [1..120] Of String [100];

Var
  F                     : Text;
  TextBuf               : pTextBuffer;
  BottomLine, Current,
  MaxStrLen             : Byte;
  FName                 : PathStr;
  S, S1, S2             : String;
  Modified, Finished    : Boolean;

Procedure Load;
Var
  i : Byte;

Begin
  i := 0;
  BottomLine := 1;
  Current := 1;

  Assign (F, FName);
  ReSet (F);

  If IOResult = 0 Then
  Begin
    While Not EoF (F) Do
    Begin
      Inc (i);
      ReadLn (F, S);
      TextBuf^ [i] := Copy (S, 1, MaxStrLen);
      If i = 255 Then Break;
    End;

    If i > 0 Then BottomLine := i+1;
    Close (F);
  End;

  Modified := False;
End;

Procedure Save;
Var
  i : Byte;

Begin
  Assign (F, FName);
  ReWrite (F);
  For i := 1 To BottomLine Do WriteLn (F, TextBuf^ [i]);
  Close (F);
End;

{$IFDEF NOT_TOR}

Function ComReadKey: Char;
Var
  C : Char;

Begin
  C := ReadKey;
  If C = #0 Then
  Case ReadKey Of
    #72 : C := #1;
    #80 : C := #2;
    #77 : C := #3;
    #75 : C := #4;
    #83 : C := #127;
    #71 : C := #5;
    #79 : C := #6;
  End;

  ComReadKey := C;
End;

Procedure ComWrite (S: String; N: Byte);
Begin
  Write (S);
End;

Procedure ComWriteLn (S: String; N: Byte);
Begin
  WriteLn (S);
End;

{$ENDIF}

Procedure tGoToXY (X, Y: Byte);
Begin
{$IFDEF NOT_TOR}
  GoToXY (X, Y);
{$ELSE}
  ComWrite (EmuGoToXY (X, Y), 0);
{$ENDIF}
End;

Procedure tClrEOL;
Begin
{$IFDEF NOT_TOR}
  ClrEOL;
{$ELSE}
  ComWrite (EmuClrEOL, 0);
{$ENDIF}
End;

Procedure SetAttr (A: Byte);
Begin
{$IFDEF NOT_TOR}
  TextAttr := A;
{$ELSE}
  ComWrite (EmuColor (A), 0);
{$ENDIF}
End;

Function fsEditFile (FN: PathStr; ExitKeys: tsChar; Options, aQuote, aNormal, X1, Y1, X2, Y2: Byte): Char;
Var
  i, X, Y                      : Byte;
  TopLine                      : Integer;
  Quote, Vizualize,
  NotColoredYet                : Boolean;
  C                            : Char;

Procedure WriteLine (S: String);
Begin
  If Pos ('>', Copy (S, 1, 7)) > 0 Then SetAttr (aQuote) Else SetAttr (aNormal);
  ComWrite (S, 0);
  tClrEOL;
End;

Procedure VizOff;
Begin
  Vizualize := False;
End;

Procedure VizOn;
Begin
  Vizualize := True;
End;

Procedure DispCursor;
Var
  X2, Y2 : Byte;

Begin
  If X = 0 Then X2 := 1 Else X2 := X;
  If Y = 0 Then Y2 := 1 Else Y2 := Y;
  tGoToXY (X1+X2-1, Y1+Y2-1);
End;

Procedure ReDraw;
Var
  i : Byte;

Begin
  If Vizualize Then
  For i := TopLine To TopLine+Y2-Y1 Do
  Begin
    tGoToXY (X1, Y1+i-TopLine);
    WriteLine (TextBuf^ [i]);
    If i >= BottomLine Then Break;
  End;
End;

Procedure MoveText (C: Char);
Var
  oQuote : Boolean;

Begin
  Case C Of
       kbUp : If Current > 1 Then
              Begin
                If X > Length (TextBuf^ [Current-1]) Then X := Length (TextBuf^ [Current-1])+1;
                Dec (Y);
                Dec (Current);

                If Y < 1 Then
                Begin
                  Y := Trunc ((Y2-Y1+2)/2);
                  Dec (TopLine, Y);

                  If TopLine < 1 Then
                  Begin
                    TopLine := 1;
                    Y := Current;
                  End;

                  ReDraw;
                End;
              End;

     kbDown : If Current < BottomLine Then
              Begin
                If X > Length (TextBuf^ [Current+1]) Then X := Length (TextBuf^ [Current+1])+1;
                Inc (Y);
                Inc (Current);

                If Y > Y2-Y1+1 Then
                Begin
                  Inc (TopLine, Trunc ((Y2-Y1+2)/2));
                  Y := Current-TopLine+1;
                  If TopLine+Y2-Y1 > BottomLine Then
                  Begin
                    TopLine := BottomLine-Y2+Y1;
                    Y := Current-TopLine+1;
                  End;

                  ReDraw;
                End;
              End;

     kbLeft : If X > 1 Then
              Begin
                Dec (X);
                ComWrite (#8, 0);
              End Else
              If Current > 1 Then
              Begin
                VizOff; MoveText (kbUp); VizOn;
                X := Length (TextBuf^ [Current])+1;
                DispCursor;
              End;

    kbRight : If X <= Length (TextBuf^ [Current]) Then
              Begin
                If NotColoredYet Then
                If Quote Then SetAttr (aQuote) Else SetAttr (aNormal);

                ComWrite (TextBuf^ [Current] [X], 0);
                Inc (X);
              End Else
              If Current < BottomLine Then
              Begin
                VizOff; MoveText (kbDown); VizOn;
                X := 1;
                DispCursor;
              End;
  End;

  If (C in [kbUp, kbDown]) And Vizualize Then DispCursor;

  oQuote := Quote;
  Quote := Pos ('>', Copy (TextBuf^ [Current], 1, 7)) > 0;
  NotColoredYet := NotColoredYet Or (Quote <> oQuote);
End;

Procedure InsLine;
Var
  i : Byte;

Begin
  If BottomLine < 255 Then
  Begin
    For i := BottomLine+1 DownTo Current Do
    If i > 1 Then TextBuf^ [i] := TextBuf^ [i-1];

    TextBuf^ [Current] := '';
    Inc (BottomLine);

    If Y = Y2-Y1+1 Then MoveText (kbDown) Else
    Begin
      If Vizualize Then
      For i := TopLine+Y-1 To TopLine+Y2-Y1 Do
      Begin
        tGoToXY (X1, Y1+i-TopLine);
        WriteLine (TextBuf^ [i]);
        If i >= BottomLine Then Break;
      End;

      Inc (Y);
      Inc (Current);
    End;
  End;
End;

Procedure DelLine;
Var
  i : Byte;

Begin
  For i := Current To BottomLine-1 Do TextBuf^ [i] := TextBuf^ [i+1];
  If Current = BottomLine Then
  If Current > 1 Then MoveText (kbUp) Else
  Begin
    tGoToXY (X1, Y1);
    tClrEOL;
    TextBuf^ [Current] := '';
    Exit;
  End;

  Dec (BottomLine);

  If Vizualize Then
  Begin
    For i := TopLine+Y-1 To TopLine+Y2-Y1 Do
    Begin
      tGoToXY (X1, Y1+i-TopLine);
      If i <= BottomLine
      Then
        WriteLine (TextBuf^ [i])
      Else
        tClrEOL;
    End;

    DispCursor;
  End;
End;

Procedure InsChar (C: Char);
Var
  Longer : Boolean;

Begin
  If NotColoredYet Then
  If Quote Then SetAttr (aQuote) Else SetAttr (aNormal);

  Insert (C, TextBuf^ [Current], X); Inc (X);

  If Length (TextBuf^ [Current]) > MaxStrLen Then
  Begin
    i := Current;
    Longer := X > Length (TextBuf^ [Current]);

    Repeat

      S1 := TrimTrail (TextBuf^ [i]);
      S := Copy (S1, MaxStrLen+1, 255);
      S1 := Copy (S1, 1, MaxStrLen);

      If Not (S1 [Length (S1)] in WordDelims) Then
      Begin
        S2 := ExtractWord (WordCount (S1, WordDelims), S1, WordDelims);

        If S1 <> S2 Then
        Begin
          S := S2 + S;
          S1 := Copy (S1, 1, Length (S1)-Length (S2));
        End;
      End;

      If S1 = S Then
      Begin
        S := Copy (S1, MaxStrLen+1, 255);
        S1 := Copy (S1, 1, MaxStrLen);
      End Else
      Begin
        While Length (S1) > 0 Do
        If S1 [Length (S1)] in WordDelims
        Then
          Delete (S1, Length (S1), 1)
        Else
          Break;
      End;

      TextBuf^ [i] := S1;

      If Longer Then
      Begin
        Inc (Current);
        VizOff;
        InsLine;
        TextBuf^ [Current-1] := S;

          Y := Current-TopLine;
          X := Length (S)+1;

        Dec (Current);
        VizOn;
      End Else
      Begin
        Inc (i);

        If S1 <> S2
        Then
          TextBuf^ [i] := S + ' ' + TrimLead (TextBuf^ [i])
        Else
          TextBuf^ [i] := S + TrimLead (TextBuf^ [i]);
      End;

    Until Length (TextBuf^ [i]) <= MaxStrLen;

    ReDraw;
    DispCursor;
    Exit;
  End Else
    WriteLine (Copy (TextBuf^ [Current], X-1, MaxStrLen-X+2));

  If X < Length (TextBuf^ [Current])+1 Then
    DispCursor;
End;

Procedure DelChar;
Var
  Dont : Boolean;

Begin
  If (TextBuf^ [Current] = '') And (Current < BottomLine) Then DelLine Else
  If X = Length (TextBuf^ [Current])+1 Then
  Begin
    If Current = BottomLine Then Exit;

    If TextBuf^ [Current+1] = '' Then
    Begin
      i := X;
      Dont := BottomLine-Current = 1;
      VizOff; MoveText (kbDown); VizOn;
      DelLine;

      If Not Dont Then
      Begin
        VizOff;
        MoveText (kbUp);
        VizOn;
      End;

      X := i;
    End Else
    Begin
      S := Copy (TextBuf^ [Current+1], 1, MaxStrLen-Length (TextBuf^ [Current]));

      If (Length (TextBuf^ [Current+1]) > Length (S)+1) And Not
         (TextBuf^ [Current+1] [Length (S)+1] in WordDelims) Then
      Begin
        S1 := ExtractWord (WordCount (S, WordDelims), S, WordDelims);
        S := Copy (S, 1, Length (S)-Length (S1)-1);
      End;

      i := Length (TextBuf^ [Current]);
      Delete (TextBuf^ [Current+1], 1, Length (S));
      TextBuf^ [Current+1] := Trim (TextBuf^ [Current+1]);
      TextBuf^ [Current] := TextBuf^ [Current] + S;

      If TextBuf^ [Current+1] = '' Then
      Begin
        MoveText (kbDown);
        DelLine;
        MoveText (kbUp);
        MoveText (kbEnd);
        X := i+1;
        DispCursor;
      End;

      ReDraw;
    End;
  End Else
  Begin
    Delete (TextBuf^ [Current], X, 1);
    ComWrite (Copy (TextBuf^ [Current], X, MaxStrLen-X) + ' ', 0);
  End;

  DispCursor;
End;

Procedure BackSpace;
Var
  Also : Boolean;

Begin
  If X > 1 Then
  Begin
    Dec (X);
    Delete (TextBuf^ [Current], X, 1);
    ComWrite (#8, 0);
    ComWrite (Copy (TextBuf^ [Current], X, MaxStrLen-X) + ' ', 0);
    DispCursor;
  End Else
  If (Current > 1) And (Length (TextBuf^ [Current]) < MaxStrLen-Length (TextBuf^ [Current-1])) Then
  Begin
    i := Length (TextBuf^ [Current-1]);
    Also := BottomLine-Current = 1;
    TextBuf^ [Current-1] := TextBuf^ [Current-1] + TextBuf^ [Current];
    DelLine;
    VizOff;
    If (Current <> BottomLine) Or Also Then MoveText (kbUp);
    X := i+1;
    VizOn;
    ReDraw;
    DispCursor;
  End;
End;

Procedure Enter;
Var
  Ex : Byte;

Begin
  Ex := X;
  If Ex = 1 Then
  Begin
    InsLine;
    DispCursor;
  End Else
  If X <= Length (TextBuf^ [Current]) Then
  Begin
    VizOff;

    If BottomLine = Current Then
    Begin
      Inc (BottomLine);
      TextBuf^ [BottomLine] := '';
    End;

    MoveText (kbDown);
    InsLine;
    Dec (Current, 2);
    TextBuf^ [Current+1] := Copy (TextBuf^ [Current], Ex, 255);
    TextBuf^ [Current] := Copy (TextBuf^ [Current], 1, Length (TextBuf^ [Current])-Length (TextBuf^ [Current+1]));
    Inc (Current);
    Dec (Y);
    X := 1;
    VizOn;
    ReDraw;
    DispCursor;
  End Else
  Begin
    VizOff;

    If Current = BottomLine Then
    Begin
      Inc (BottomLine);
      TextBuf^ [BottomLine] := '';
      MoveText (kbDown);
    End Else
    Begin
      MoveText (kbDown);
      InsLine;
      MoveText (kbUp);
    End;

    VizOn;
    ReDraw;
    DispCursor;
  End;
End;

Begin
  VizOn;
  FName := FN;
  MaxStrLen := X2-X1;
  New (TextBuf);
  FillChar (TextBuf^, SizeOf (TextBuf^), #0);
  Load;
  TopLine := 1;

  For i := TopLine To TopLine+Y2-Y1 Do
  Begin
    tGoToXY (X1, Y1+i-TopLine);
    WriteLine (TextBuf^ [i]);
  End;

  Finished := False;
  NotColoredYet := True;
  X := 1; Y := 1;
  Current := 1;
  DispCursor;
  Quote := Pos ('>', Copy (TextBuf^ [Current], 1, 7)) > 0;

  While Not Finished Do
  Begin
    C := ComReadKey;
  {$IFDEF WIN32}
    If Application. Terminated Then Exit;
  {$ENDIF}

    Case C Of

    {$IFDEF NOT_TOR}
     kbEscape : Finished := True;
    {$ENDIF}

      kbUp,
      kbDown,
      kbLeft,
      kbRight : MoveText (C);
        kbDel : DelChar;
  kbBackSpace : BackSpace;
       kbHome : Begin
                  X := 1;
                  DispCursor;
                End;
        kbEnd : Begin
                  X := Length (TextBuf^ [Current])+1;
                  DispCursor;
                End;
      kbEnter : Enter;
      kbCtrlY : DelLine;

    Else
      If C in ExitKeys Then
      Begin
        fsEditFile := C;
        Finished := True;
      End Else
      Begin
        InsChar (C);
        Modified := True;
      End;
    End;

    If C in [kbDel, kbEnter, kbCtrlY, kbBackSpace] Then Modified := True;
  End;

  If Modified Then Save;
  Dispose (TextBuf);
End;



Function lnEditFile;

Procedure EnterText;
Var
  Finish        : Boolean;
  K             : Char;

Procedure EndOfLine;
Begin
  If S = '' Then
  Begin
    Finish := True;
    ComWriteLn ('', 0);
    Exit;
  End;

  TextBuf^ [BottomLine] := S;
  Inc (BottomLine);
  ComWrite (#13#10 + LeftPadCh (Long2Str (BottomLine), ' ', 2) + ': ', 0);
  S := '';
End;

Procedure DoChar (K: Char);
Var
 LastWord       : String;

Begin
  If K = '' Then K := 'H';
  S := S + K;
  ComWrite (K, 0);

  If Length (S) > 73 Then
  Begin
    If WordCount (S, [' ']) > 1 Then
    Begin
      If S [74] = ' ' Then
        LastWord := ''
      Else
        LastWord := ExtractWord (WordCount (S, [' ']), S, [' ']);
    End Else
    Begin
      LastWord := Copy (S, 75, 255);
      S [0] := Chr (72);
    End;
    ComWrite (Replicate (#8, Length (LastWord)), 0);
    tClrEOL;
    S := Copy (S, 1, Length (S)-Length (LastWord));
    EndOfLine;
    S := LastWord;
    ComWrite (S, 0);
  End;
End;

Begin
  S := '';
  Finish := False;
  SetAttr (aNormal);
  ComWrite (LeftPadCh (Long2Str (BottomLine), ' ', 2) + ': ' , 0);

  Repeat
  Begin
    K := ComReadKey;
  {$IFDEF WIN32}
    If Application. Terminated Then Exit;
  {$ENDIF}

    Case K Of
      #8: If Length (S) > 0 Then
          Begin
            S [0] := Chr (Length (S) - 1);
            ComWrite (#8#32#8, 0);
          End;

     #13: EndOfLine;
    Else
      If Not (K In [#10, #0]) Then
      If K in [#32..#255] Then DoChar (K);
    End;
  End;
  Until Finish;
End;

Procedure ListMsg (Pause: Boolean);
Var
  ChangeColor : Boolean;
  i           : LongInt;

Begin
  ChangeColor := True;
{$IFNDEF NOT_TOR}
  If Pause Then InitMore (0);
{$ENDIF}
  For i := 1 To BottomLine-1 Do
  Begin
    If ChangeColor Then SetAttr (aNormal);
    ComWrite (LeftPadCh (Long2Str (i), ' ', 2) + ': ', 0);
    S := TextBuf^ [i];

    If Pos ('>', Copy (S, 1, 5)) <> 0 Then
    Begin
      SetAttr (aQuote);
      ChangeColor := True;
    End;

    ComWriteLn (S, 0);

    If Pause Then
  {$IFNDEF NOT_TOR}
    If Not More Then Exit;
  {$ENDIF}
  End;
End;

Var
  R : tLineEditResult;
  i, j, sLine, eLine, Deleted : Byte;

Const
  DelMark = #253#254#255;

Begin
  FName := FN;
  MaxStrLen := 78;
  New (TextBuf);
  FillChar (TextBuf^, SizeOf (TextBuf^), #0);
  Load;
  Modified := True;
  Finished := False;
  ListMsg (False);
  EnterText;

  Repeat
    R := Menu (S);
  {$IFDEF WIN32}
    If Application. Terminated Then Exit;
  {$ENDIF}

    Case R Of
       mpSave, mpAbort : Begin
                           lnEditFile := R;
                           Break;
                         End;
            mpContinue : EnterText;
            mpEditLine : Begin
                           i := Str2Long (S);
                           If i <= BottomLine Then
                           Begin
                             S := TextBuf^ [i];
                             If Pos ('>', Copy (S, 1, 7)) > 0 Then SetAttr (aQuote) Else SetAttr (aNormal);
                             ComWrite (LeftPadCh (Long2Str (i), ' ', 2) + ': ', 0);
                             EditLineProc (S);
                             TextBuf^ [i] := S;
                           End Else
                             Continue;
                         End;
                mpShow : ListMsg (True);
          mpDeleteLine : If BottomLine > 1 Then
                         Begin
                           For i := 1 To WordCount (S, [' ', ',']) Do
                           Begin
                             S1 := ExtractWord (i, S, [' ', ',']);
                             If Not ConsistsOf (S1, ['0'..'9', '-']) Then Continue;

                             If Pos ('-', S1) > 0 Then
                             Begin
                               sLine := Str2Long (ExtractWord (1, S1, ['-']));
                               eLine := Str2Long (ExtractWord (2, S1, ['-']));

                               If (sLine <= BottomLine) And (sLine < eLine) Then
                               Begin
                                 If eLine > BottomLine Then eLine := BottomLine;
                                 For j := sLine To eLine Do TextBuf^ [j] := DelMark;
                               End;

                             End Else
                             Begin
                               j := Str2Long (S1);
                               If j <= BottomLine Then TextBuf^ [j] := DelMark;
                             End;
                           End;

                           i := 0;
                           Deleted := 0;

                           While i <= BottomLine Do
                           Begin
                             Inc (i);
                             If TextBuf^ [i] = DelMark Then
                             Begin
                               For j := i To BottomLine-1 Do TextBuf^ [j] := TextBuf^ [j+1];
                               Inc (Deleted);
                               Dec (i);
                             End;
                           End;

                           Dec (BottomLine, Deleted);
                         End;
    End;

  Until False;

  If Modified Then Save;
  Dispose (TextBuf);
End;

End.
