Unit Resource;

Interface

Uses
  TGlob,
  Objects,
  OpCrt,
  tMsgLib,
{$IFNDEF WIN32}
  DOS,
{$ELSE}
  Classes,
  Dialogs,
{$ENDIF}
{$IFDEF OS2}
  {Crt,}
{$ENDIF}
  tMisc;

{$I INC\language.inc}

Const
  MsgFileName : PathStr = 'tornado.msg';
  BoolMsg     : Array [Boolean] Of String [10] = ('', '');
  Letters     : Array ['A'..'P'] Of Byte = (1, 2, 3, 4, 5, 6, 7, 8, 9,
                                            10, 11, 12, 13, 14, 15, 16);

Procedure ResRead (FileName: String);
Function Int2Month (Num: Byte): String;
Function Sm (Index: LongInt): String;

Var
  SysMes : PBigCollection;

Implementation

Var
  S      : String;

Procedure ResRead (FileName: String);
Begin
  MsgFileName := FileName;

  If Not FileExists (MsgFileName) Then
  Begin
    S := 'Tornado messages file open error';
  {$IFNDEF WIN32}
    TextAttr := 12;
    WriteLn ('! ' + S);
    TextAttr := 7;
    WriteLn;
  {$ELSE}
    ShowMessage (S);
  {$ENDIF}
    ExitProc := Nil;
    Halt (210);
  End;

  SysMes := New (PBigCollection, Init (30, 3));
  ParamNames := New (PBigCollection, Init (10, 1));

  If Not ReadCollection (MsgFileName, SysMes, 'Messages', NameVer, False) Then
  Begin
    S := 'Tornado messages file read error or version mismatch';
  {$IFNDEF WIN32}
    TextAttr := 12;
    WriteLn ('! ' + S);
    TextAttr := 7;
    WriteLn;
  {$ELSE}
    ShowMessage (S);
  {$ENDIF}
    ExitProc := Nil;
    Halt (210);
  End;

  ReadCollection (MsgFileName, ParamNames, 'Params', NameVer, False);

  BoolMsg [True] := Sm (smYes);
  BoolMsg [False] := Sm (smNo);
End;

Function Sm (Index: LongInt): String;
Begin
  If Index <= SysMes^. Count Then Sm := PString (SysMes^. At (Index-1))^ Else Sm := '';
End;

Function Int2Month (Num: Byte): String;
Begin
  Case Num Of
    01 : Int2Month := sm (smJan);
    02 : Int2Month := sm (smFeb);
    03 : Int2Month := sm (smMar);
    04 : Int2Month := sm (smApr);
    05 : Int2Month := sm (smMay);
    06 : Int2Month := sm (smJun);
    07 : Int2Month := sm (smJul);
    08 : Int2Month := sm (smAug);
    09 : Int2Month := sm (smSep);
    10 : Int2Month := sm (smOct);
    11 : Int2Month := sm (smNov);
    12 : Int2Month := sm (smDec);

    Else
      Int2Month := '???';
  End;
End;

End.