{$IFNDEF OS2}
{$O+,F+}
{$ENDIF}

Unit IFace;

{*********************************************************}
{*                      IFACE.PAS                        *}
{*                                                       *}
{*  Copyright (c) Konstantin Klyagin, 1995-98,           *}
{*                exspecially for Tornado BBS System     *}
{*                                                       *}
{*********************************************************}

Interface

Uses
  MainComm,
{$IFNDEF WIN32}
  ApAbsPcl,
  ApCom,
  DOS,
  tWin,
{$ELSE}
  AdProtcl,
  SysUtils,
{$ENDIF}
  Users,
  TGlob,
  Log,
  OpCrt,
  tMisc,
  Resource,
  tModem,
  Parse,
  TimeTask;

Var
  TotalBytesTrans     : LongInt;
  oX                  : Byte;

Procedure DrawTornadoScreen (TotalCalls, UpLoads, DownLoads, TotalUsers, MsgsPosted: LongInt);
Procedure AddResponse (S: String; Attribute: Byte);
Procedure AddMsg (Msg: String; CR: Boolean; Attribute: Byte);
Procedure AddUsr (Name, LogTime: String; Time, DL, UL: Integer);
Procedure DoneTornadoScreen;

Procedure InitProtBox (Prot: ProtocolRecPtr; Mode: TransferModeType);
Procedure UpdateProtBox (Prot: ProtocolRecPtr);
Procedure ProtocolMsg (Msg: String);
Procedure DoneProtBox;

Procedure UserParams;
Function NoInfo: Boolean;
Procedure Clock;

Procedure SizeScroller (CurTot,            { 騩 䠩 : ꥬ        }
                        CurPos,            { 騩 䠩 :       }
                        Total,             { . ꥬ   : ᥣ        }
                        Current : LongInt; { . ꥬ   :       }
                        Len,               {  ஫             }
                        X,                 { न X                }
                        Y,                 { न X                }
                        BkgCol,            { BackGround Color            }
                        TotCol,            {  ப 饣 ꥬ   }
                        CurCol: Byte);     {  ப ⥪饣 䠩  }

Implementation

Const
  oFName        : PathStr = '';

Var
  Coverz                        : Pointer;
  FilesSize                     : LongInt;
  MainBox, ProtBox              : PBoxRec;
  MsgColor                      : Byte;
  trMode                        : TransferModeType;

Procedure DrawTornadoScreen;
Var
  i     : Byte;

Begin
  SaveWindow (1, 1, ScrX+1, ScrY+1, True, Coverz);
  InitWindow (MainBox, 1, 1, ScrX + 1, Hi (WindMax), 4, Cnf.
              ColorScheme [cmFrame], '', $00, 0, False);

  DrawWindow (MainBox);

  FastWrite ('' + Replicate ('', 78) + '', 3, 1, Cnf. ColorScheme [cmFrame]);
  For i := Hi (WindMax) - 10 To
           Hi (WindMax) - 1
  Do FastWrite ('', i, 33, Cnf. ColorScheme [cmFrame]);

  FastWrite ('' + Replicate ('', 31) + '' + Replicate ('', 46) + '',
            Hi (WindMax) - 11, 1, Cnf. ColorScheme [cmFrame]);

  FastWrite ('' + Replicate ('', 31) + '' + Replicate ('', 46) + '',
            Hi (WindMax) - 9, 1, Cnf. ColorScheme [cmFrame]);

  FastWrite ('', 3, 60, Cnf. ColorScheme [cmFrame]);
  FastWrite ('', Hi (WindMax) - 11, 60, Cnf. ColorScheme [cmFrame]);
  For i := 4 To Hi (WindMax) - 12 Do FastWrite ('', i, 60, Cnf. ColorScheme [cmFrame]);

  FastWrite ('', Hi (WindMax), 33, Cnf. ColorScheme [cmFrame]);
  FastWrite (sm (smsStatLine) + Replicate (' ', 29), Hi (WindMax) + 1, 1, Cnf. ColorScheme [cmStatusLine]);
  FastWrite (' Com0 CTS DSR DR RI CD', Hi (WindMax) + 1, 57, Cnf. ColorScheme [cmLamps]);
  FastWrite (sm (smsLogEcho), 2, 2, Cnf. ColorScheme [cmMsgs]);
  FastWrite (sm (smsStatus), Hi (WindMax) - 10, 2, Cnf. ColorScheme [cmMsgs]);
  FastWrite (sm (smsUsers), Hi (WindMax) - 10, 34, Cnf. ColorScheme [cmMsgs]);
  FastWrite (sm (smsSysCalls) + Long2Str (TotalCalls), Hi (WindMax) - 8, 2, Cnf. ColorScheme [cmOther]);
  FastWrite (sm (smsUsersNum) + Long2Str (TotalUsers), Hi (WindMax) - 7, 2, Cnf. ColorScheme [cmOther]);
  FastWrite (sm (smsPosted) + Long2Str (MsgsPosted), Hi (WindMax) - 6, 2, Cnf. ColorScheme [cmOther]);
  FastWrite (sm (smsDownLoads) + Long2Str (DownLoads), Hi (WindMax) - 5, 2, Cnf. ColorScheme [cmOther]);
  FastWrite (sm (smsUpLoads) + Long2Str (UpLoads), Hi (WindMax) - 4, 2, Cnf. ColorScheme [cmOther]);
  MsgColor := Cnf. ColorScheme [cmUsers];
  oX := 2;
  If Cnf. Clock Then FastWrite (StrTime, 1, ScrX-6, Cnf. ColorScheme [cmClock]);
  TextAttr := Cnf. ColorScheme [cmFrame];
End;

Procedure AddResponse;
Begin
  If Length (S) > 18 Then S [0] := Chr (18);
  S := CenterCh (S, ' ', 18);
  FastWrite (S, Hi (WindMax) - 12, 70 - Round (Length (S)/2), Attribute);
End;

Procedure AddMsg;
Begin
  If Length (Msg) > 58 Then Msg [0] := Chr (58);
  FastWrite (Msg, Hi (WindMax) - 12, oX, Attribute);

  If CR Then
  Begin
    ScrollWindowUp (2, 4, ScrX - 20, Hi (WindMax) - 12, 1);
    ScrollWindowUp (61, 4, ScrX, Hi (WindMax) - 12, 1);
    oX := 2;
  End Else
    oX := Length (Msg) + 2;

  If Cnf. Clock Then FastWrite (StrTime, 1, ScrX-6, Cnf. ColorScheme [cmClock]);
End;

Procedure AddUsr;
Var
  UsrStr                : String [55];

Begin
  ScrollWindowUp (34, Hi (WindMax) - 8, ScrX - 1, Hi (WindMax) - 1, 1);
  If Time < 0 Then Time := 0;
  UsrStr := LogTime + ' ' + Name + ' (' + Long2Str (Time) + ' min., ' +
            Long2Str (DL) + '/' + Long2Str (UL) + ')';

  If Length (UsrStr) > 44 Then UsrStr := Copy (UsrStr, 1, 41) + '..';
  FastWrite (UsrStr, Hi (WindMax) - 1, 34, MsgColor);
End;

Procedure DoneTornadoScreen;
Begin
  CloseWindow (MainBox);
  RestoreWindow (1, 1, ScrX+1, ScrY+1, True, Coverz);
End;

Procedure InitProtBox;
Var
  i : Integer;
  C : Char;

Begin
  If R. AvgCPS > 0
   Then ApAbsPcl. AvgCPS := R. AvgCPS
   Else ApAbsPcl. AvgCPS := Round (GetConnectSpeed/9);

  trMode := Mode;
  oFName := '';

  InitWindow (ProtBox, 10, 5, 70, 20, 4, Cnf. ColorScheme [cpFrame],
              '  ' + ULorDL [Mode] + '  ', Cnf. ColorScheme [cpHeader],
              ZoomSpeed, True);

  DrawWindow (ProtBox);
  FastWrite ('' + Replicate ('', 31) + '' + Replicate ('', 27) + '', ProtBox^. Y1 + 4, 10, Cnf. ColorScheme [cpFrame]);

  If trMode = Transmit Then C := ''
                       Else C := '';

  FastWrite ('' + Replicate ('', 31) + '' + Replicate ('', 3) + '[' +
            Replicate (C, 20) + ']' + '͵', ProtBox^. Y1 + 10, 10, Cnf.
            ColorScheme [cpFrame]);

  For i := ProtBox^. Y1 + 5 To ProtBox^. Y1 + 9 Do
  FastWrite ('', i, 42, Cnf. ColorScheme [cpFrame]);

  FastWrite (sm (smpFileName), ProtBox^. Y1 + 5, 12, Cnf. ColorScheme [cpFieldNames]);
  FastWrite (sm (smpDate), ProtBox^. Y1 + 6, 12, Cnf. ColorScheme [cpFieldNames]);
  FastWrite (sm (smpBlock), ProtBox^. Y1 + 7, 12, Cnf. ColorScheme [cpFieldNames]);
  FastWrite (sm (smpTotalErr), ProtBox^. Y1 + 8, 12, Cnf. ColorScheme [cpFieldNames]);
  FastWrite ('CPS    :', ProtBox^. Y1 + 9, 12, Cnf. ColorScheme [cpFieldNames]);
  FastWrite (sm (smpMode), ProtBox^. Y1 + 5, 44, Cnf. ColorScheme [cpFieldNames]);
  FastWrite (sm (smpSize), ProtBox^. Y1 + 6, 44, Cnf. ColorScheme [cpFieldNames]);
  FastWrite (sm (smpBytesTransf), ProtBox^. Y1 + 7, 44, Cnf. ColorScheme [cpFieldNames]);
  FastWrite (sm (smpTime), ProtBox^. Y1 + 8, 44, Cnf. ColorScheme [cpFieldNames]);
  FastWrite (sm (smpTimeLeft), ProtBox^. Y1 + 9, 44, Cnf. ColorScheme [cpFieldNames]);

  FastWrite (CenterCh (NameVer + ' Internal ' +
  ProtocolTypeString [GetProtocol (Prot)], ' ', 59),
  ProtBox^. Y1 + 1, 11, Cnf. ColorScheme [cpHeadText]);

  FastWrite (CenterCh ('(c) 1995-98, Konstantin Klyagin & Tornado Team,', ' ',
             59), ProtBox^. Y1 + 2, 11, Cnf. ColorScheme [cpHeadText]);
  FastWrite (CenterCh ('Kharkov, Ukraine.', ' ', 59), ProtBox^. Y1 + 3, 11,
             Cnf. ColorScheme [cpHeadText]);

  FilesSize := 0;
  TotalBytesTrans := 0;

  For i := 0 To F2Transfer^. Count-1
  Do Inc (FilesSize, PTagFileRec (F2Transfer^. At (i))^. Size);
End;

Procedure UpdateProtBox;
Var
  ActualCPS, R  : Real;
  S             : String [18];
  Tmp           : Byte;
  DT            : DateTime;
  FSize         : LongInt;

Begin
  If GetFileName (Prot) = '' Then Exit;

  If GetElapsedTics (Prot) > 0 Then
  Begin
    R := GetBytesTransferred (Prot) - GetInitialFilePos (Prot);
    ActualCPS := R / (GetElapsedTics (Prot) / 18.2);
    If ActualCPS < 0 Then ActualCPS := 0.0;
  End Else
    ActualCPS := 0.0;

  If oFName <> GetPathName (Prot) Then
  Begin
    oFName := GetPathName (Prot);

    FastWrite (PadCh (UpString (JustFileName (oFName)), ' ', 13), ProtBox^.
    Y1 + 5, 21, Cnf. ColorScheme [cpFieldValues]);

    If trMode = Receive Then
    Begin
      UnixDate2DateTime (Prot^. PData^. SrcFileDate, DT);
      FSize := GetFileSize (Prot);
    End Else
    Begin
      UnpackTime (FileDate (oFName), DT);
      FSize := gFileSize (oFName);
    End;

    S := LeftPadCh (Long2Str (DT. Day), '0', 2) + '-' + Int2Month (DT. Month) + '-' +
         Long2Str (DT. Year) + '  ' + LeftPadCh (Long2Str (DT. Hour), '0', 2) + ':' +
         LeftPadCh (Long2Str (DT. Min), '0', 2);

    FastWrite (S, ProtBox^. Y1 + 6, 21, Cnf. ColorScheme [cpFieldValues]);

    If GetInitialFilePos (Prot) = 0 Then S := 'New      ' Else S := 'Recovery ';

    Case GetCheckType (Prot) Of
      bcCrc16 : S := S + '(CRC-16)';
      bcCrc32 : S := S + '(CRC-32)';
    End;

    FastWrite (S, ProtBox^. Y1 + 5, 53, Cnf. ColorScheme [cpFieldValues]);
    FastWrite (PadCh (Long2Str (FSize), ' ', 15), ProtBox^. Y1 +
    6, 53, Cnf. ColorScheme [cpFieldValues]);
  End;

  FastWrite (PadCh (Long2Str (GetBlockSize (Prot)),
             ' ', 15), ProtBox^. Y1 + 7, 21, Cnf. ColorScheme [cpFieldValues]);
  FastWrite (PadCh (Long2Str (GetTotalErrors (Prot)),
             ' ', 15), ProtBox^. Y1 + 8, 21, Cnf. ColorScheme [cpFieldValues]);
  FastWrite (PadCh (Long2Str (Trunc (ActualCPS)), ' ', 15), ProtBox^. Y1 + 9, 21, Cnf. ColorScheme [cpFieldValues]);

  S := HowTime (EstimatedTransferTime (GetFileSize (Prot), Trunc (ActualCPS), GetConnectSpeed));
  FastWrite (S, ProtBox^. Y1 + 8, 53, Cnf. ColorScheme [cpFieldValues]);

  S := HowTime (EstimatedTransferTime (GetFileSize (Prot) -
       GetBytesTransferred (Prot), Trunc (ActualCPS), GetConnectSpeed));
  FastWrite (S, ProtBox^. Y1 + 9, 53, Cnf. ColorScheme [cpFieldValues]);

  If GetFileSize (Prot) < 0 Then Exit;

  If trMode = Receive Then
  Begin
    If GetFileSize (Prot) > 0 Then
    Begin
      Tmp := Round (GetBytesTransferred (Prot) / (GetFileSize (Prot) / 100));
      If Tmp > 100 Then Tmp := 100;
      Tmp := Round (Tmp / 5);
    End Else
      Tmp := 0;

    FastWrite (Replicate ('', Tmp), ProtBox^. Y1 + 10, 47, Cnf. ColorScheme [cpScrollBar]);
    FastWrite (Replicate ('', 20 - Tmp), ProtBox^. Y1 + 10, 47 + Tmp, Cnf. ColorScheme [cpFrame]);

  End Else
    SizeScroller (GetFileSize (Prot), GetBytesTransferred (Prot),
    FilesSize, TotalBytesTrans + GetBytesTransferred (Prot), 20, 47,
    ProtBox^. Y1 + 10, Hi4 (Cnf. ColorScheme [cpScrollBar]), 7,
    Lo4 (Cnf. ColorScheme [cpScrollBar]));

  FastWrite (PadCh (Long2Str (GetBytesTransferred (Prot)), ' ', 15), ProtBox^. Y1 + 7, 53,
             Cnf. ColorScheme [cpFieldValues]);
End;

Procedure ProtocolMsg;
Var
  oAttr : Byte;

Begin
  oAttr := TextAttr;
  TextAttr := Cnf. ColorScheme [cpMessages];
  ScrollWindowUp (12, ProtBox^. Y1 + 11, 69, ProtBox^. Y1 + 14, 1);

  If Length (Msg) > 56 Then Msg := Copy (Msg, 1, 56) + '..';
  FastWrite (' ' + Msg, ProtBox^. Y1 + 14, 11, Cnf. ColorScheme [cpMessages]);
  TextAttr := oAttr;
End;

Procedure DoneProtBox;
Begin
  CloseWindow (ProtBox);
End;

Procedure UserParams;
Var
  InfoBox     : pBoxRec;
  Str_EMSI    : Array [Boolean] Of String [50];
  Age         : Byte;
  C           : Char;
  k           : LongInt;

Begin
  If NoInfo Then Exit;
  HiddenCursor;
  str_EMSI [False] := sm (smibIEMSI_no);
  str_EMSI [True] := sm (smibIEMSI_yes);

  InitWindow (InfoBox, 10, 4, 70, 19, 4, Cnf. ColorScheme [cdFrame],
              '  ' +  sm (smibTitle) + '  ',
              Cnf. ColorScheme [cdTitle], ZoomSpeed, True);

  DrawWindow (InfoBox);

  FastWrite ('' + Replicate ('', 59) + '', InfoBox^. Y1 + 9, 10, Cnf. ColorScheme [cdFrame]);
  FastWrite ('' + Replicate ('', 59) + '', InfoBox^. Y1 + 12, 10, Cnf. ColorScheme [cdFrame]);
  FastWrite (sm (smibSpeed), InfoBox^. Y1 + 1, 12, Cnf. ColorScheme [cdText]);
  FastWrite (sm (smibAvgCPS), InfoBox^. Y1 + 2, 12, Cnf. ColorScheme [cdText]);
  FastWrite (sm (smibName), InfoBox^. Y1 + 3, 12, Cnf. ColorScheme [cdText]);
  FastWrite (sm (smibBirthdate), InfoBox^. Y1 + 4, 12, Cnf. ColorScheme [cdText]);
  FastWrite (sm (smibAge), InfoBox^. Y1 + 5, 12, Cnf. ColorScheme [cdText]);
  FastWrite (sm (smibLocation), InfoBox^. Y1 + 6, 12, Cnf. ColorScheme [cdText]);
  FastWrite (sm (smibPassword), InfoBox^. Y1 + 7, 12, Cnf. ColorScheme [cdText]);
  FastWrite (sm (smibSecurity), InfoBox^. Y1 + 8, 12, Cnf. ColorScheme [cdText]);
  FastWrite (sm (smibLastDate), InfoBox^. Y1 + 10, 12, Cnf. ColorScheme [cdText]);
  FastWrite (sm (smibFirstDate), InfoBox^. Y1 + 11, 12, Cnf. ColorScheme [cdText]);
  FastWrite (sm (smibDailyTime), InfoBox^. Y1 + 10, 41, Cnf. ColorScheme [cdText]);
  FastWrite (sm (smibTimeLeft), InfoBox^. Y1 + 11, 41, Cnf. ColorScheme [cdText]);
  FastWrite (str_EMSI [EMSI. Session], InfoBox^. Y1 + 13, 12, Cnf. ColorScheme [cdText]);

  Age := Str2Long (Copy (StrDate, 7, 4)) - Str2Long (Copy (Long2Date (R. BirthDate), 7, 4));
  If Str2Long (Copy (ReFormatDate (Long2Date (R. BirthDate), DefaultDateMask, 'DD-MM-YY'), 4, 2)) >
     Str2Long (Copy (StrDate, 4, 2)) Then Dec (Age) Else
  If (Copy (ReFormatDate (Long2Date (R. BirthDate), DefaultDateMask, 'DD-MM-YY'), 4, 2) =
     Copy (StrDate, 4, 2)) And (Str2Long (Copy (ReFormatDate (Long2Date
     (R. BirthDate), DefaultDateMask, 'DD-MM-YY'), 1, 2)) > Str2Long (Copy (StrDate, 1, 2)))
  Then Dec (Age);

  FastWrite (Long2Str (GetConnectSpeed), InfoBox^. Y1 + 1, 31, Cnf. ColorScheme [cdInput]);
  FastWrite (Long2Str (R. AvgCPS), InfoBox^. Y1 + 2, 31, Cnf. ColorScheme [cdInput]);
  FastWrite (R. Name, InfoBox^. Y1 + 3, 31, Cnf. ColorScheme [cdInput]);
  FastWrite (ReFormatDate (Long2Date (R. BirthDate), DefaultDateMask,
            Cnf. DateMask), InfoBox^. Y1 + 4, 31, Cnf. ColorScheme [cdInput]);
  FastWrite (Long2Str (Age) + ' ' + sm (smibYears), InfoBox^. Y1 + 5, 31, Cnf. ColorScheme [cdInput]);
  FastWrite (PadCh (R. Location, ' ', 38), InfoBox^. Y1 + 6, 31, Cnf. ColorScheme [cdInput]);
  FastWrite (R. Password, InfoBox^. Y1 + 7, 31, Cnf. ColorScheme [cdInput]);
  FastWrite (Long2Str (R. Security), InfoBox^. Y1 + 8, 31, Cnf. ColorScheme [cdInput]);
  FastWrite (ReFormatDate (Long2Date (R. LastDate), DefaultDateMask,
            Cnf. DateMask), InfoBox^. Y1 + 10, 31, Cnf. ColorScheme [cdInput]);
  FastWrite (ReFormatDate (Long2Date (R. FirstDate), DefaultDateMask,
            Cnf. DateMask), InfoBox^. Y1 + 11, 31, Cnf. ColorScheme [cdInput]);
  FastWrite (Long2Str (Lim. Time) + ' ' + sm (smsMin), InfoBox^. Y1 + 10, 60,
            Cnf. ColorScheme [cdInput]);

  If InChat Then k := ChatStartTime Else k := MidSec;
  FastWrite (Long2Str (Round ((R. TotalTime - k + EnterTime)/60)) + ' ' + sm
            (smsMin), InfoBox^. Y1 + 11, 60, Cnf. ColorScheme [cdInput]);

  If EMSI. Session Then
  Begin
    FastWrite (sm (smibSoftWare), InfoBox^. Y1 + 14, 12, Cnf. ColorScheme [cdText]);
    FastWrite (PadCh (EMSI. SoftWare, ' ', 38), InfoBox^. Y1 + 14, 31, Cnf. ColorScheme [cdInput]);
  End;

  WaitForKey (C);
  If C = #0 Then WaitForKey (C);

  CloseWindow (InfoBox);
  NormalCursor;
End;

Function NoInfo;
Begin
  NoInfo := False;
  If ((R. Name = '') Or Registering) Then
  Begin
    HiddenCursor;
    CenterTempBox (Cnf. ColorScheme [cdFrame], Cnf. ColorScheme [cdButton],
                   1, sm (smiNotLogined), ZoomSpeed,
                   sm (smWarningWinTitle));
    NormalCursor;
    NoInfo := True;
  End;
End;

Procedure SizeScroller;
Var
  CLen, TLen, i, Attr   : Byte;

Begin
  CLen := 0; TLen := 0;

  If Not ((CurTot < 1) Or (CurPos < 1))
  Then CLen := Round (1/(CurTot/CurPos)*Len);

  If (Total <> 0) And (Current <> 0) Then
  If Not ((CurTot < 1) Or (CurPos < 1))
  Then TLen := Round (1/(Total/Current)*Len);

  If (TLen = 0) And (CLen = 0) Then
  Begin
    FastWrite (Replicate ('', Len), Y, X, BkgCol * 16 + TotCol);
    Exit;
  End;

  For i := 1 To Len Do
  Begin
    Attr := CurCol * 16 + BkgCol;
    If (CLen < i) and (TLen >= i) Then Attr := TotCol * 16 + BkgCol;
    If (CLen >= i) and (TLen < i) Then Attr := BkgCol * 16 + CurCol;
    If (CLen >= i) and (TLen >= i) Then Attr := TotCol * 16 + CurCol;
    If (CLen < i) and (TLen < i) Then
      FastWrite ('', Y, X, BkgCol * 16 + TotCol)
    Else
      FastWrite ('', Y, X, Attr);

    Inc (X);
  End;
End;

Procedure Clock;
Begin
  If Cnf. Clock Then FastWrite (StrTime, 1, ScrX-6, Cnf. ColorScheme [cmClock]);
  TimeSlice;

  If Not Local Then
  Begin
    {$IFNDEF OS2}
    FastWrite (' Com' + ComPorts [GetComName (P)] + ' ',
    Hi (WindMax) + 1, 57, Cnf. ColorScheme [cmLamps]);
    {$ELSE}
    FastWrite (CenterCh (Cnf. ComPort, ' ', 6),
    Hi (WindMax) + 1, 57, Cnf. ColorScheme [cmLamps]);
    {$ENDIF}

    If CheckCTS (P)
    Then FastWrite ('CTS ', Hi (WindMax) + 1, 63, Cnf. ColorScheme [cmHighlight])
    Else FastWrite ('CTS ', Hi (WindMax) + 1, 63, Cnf. ColorScheme [cmLamps]);

    If {$IFNDEF WIN32} CheckDSR (P) {$ELSE} P. DSR {$ENDIF}
    Then FastWrite ('DSR ', Hi (WindMax) + 1, 67, Cnf. ColorScheme [cmHighlight])
    Else FastWrite ('DSR ', Hi (WindMax) + 1, 67, Cnf. ColorScheme [cmLamps]);

    If {$IFDEF MSDOS} CheckDataReady (P) {$ELSE} True {$ENDIF}
    Then FastWrite ('DR ', Hi (WindMax)+1, 71, Cnf. ColorScheme [cmHighlight])
    Else FastWrite ('DR ', Hi (WindMax)+1, 71, Cnf. ColorScheme [cmLamps]);

    If {$IFNDEF WIN32} CheckRI (P) {$ELSE} P. RI {$ENDIF}
    Then FastWrite ('RI ', Hi (WindMax)+1, 74, Cnf. ColorScheme [cmHighlight])
    Else FastWrite ('RI ', Hi (WindMax)+1, 74, Cnf. ColorScheme [cmLamps]);

    If {$IFNDEF WIN32} CheckDCD (P) {$ELSE} P. DCD {$ENDIF}
    Then FastWrite ('CD ', Hi (WindMax)+1, 77, Cnf. ColorScheme [cmHighlight])
    Else FastWrite ('CD', Hi (WindMax)+1, 77, Cnf. ColorScheme [cmLamps]);
  End;
End;

End.