{$IFNDEF OS2}
{$F+,O+}
{$ENDIF}

Unit DispTim;

Interface

Procedure InitTimer (Row, Col: Byte; Sec: Word; Attr: Byte);
Procedure TickTimer;
Procedure DoneTimer;

Implementation

Uses
  OpCrt,
{$IFNDEF WIN32}
  DOS,
{$ENDIF}
  tMisc;

Const
  TimerPresent  : Boolean = False;

Var
  StartTime, LastUpd    : LongInt;
  TimerRow, TimerCol,
  TimerAttr             : Byte;
  Counter               : Word;
  Covers                : Pointer;

Function Sec2Period (Sec: LongInt): String;
Var
  Min   : Byte;

Begin
  Min := Trunc (Sec/60);
  Sec := Sec-Min*60;
  Sec2Period := LeftPadCh (Long2Str (Min), '0', 2) + ':' +
                LeftPadCh (Long2Str (Sec), '0', 2);
End;

Procedure InitTimer (Row, Col: Byte; Sec: Word; Attr: Byte);
Begin
  If Sec > 6039 Then Exit;
  TimerPresent := True;
  StartTime := MidSec;
  LastUpd := StartTime;
  Counter := Sec;
  TimerRow := Row;
  TimerCol := Col;
  TimerAttr := Attr;

  SaveWindow (Row-1, Col-1, Row+5, Col+1, True, Covers);
  FastWrite (Sec2Period (Sec), Col, Row, Attr);
End;

Procedure TickTimer;
Var
  i  : Word;

Begin
  i := Counter-(MidSec-StartTime);
  If (i < 0) or (MidSec-LastUpd < 1) Then Exit;
  FastWrite (Sec2Period (i), TimerCol, TimerRow, TimerAttr);
  LastUpd := MidSec;
End;

Procedure DoneTimer;
Begin
  RestoreWindow (TimerRow-1, TimerCol-1, TimerRow+5, TimerCol+1, True, Covers);
  TimerPresent := False;
End;

End.