{$IFNDEF OS2}
{$F+,O+}
{$ENDIF}
{$I-}

Unit DirSize;

Interface

Function DirSizeWSb (Directory: String): LongInt;

{=======================================================}
{ 楤  ࠧ ४ਨ  ﬨ }
{          (c) Alex Y. Radzishevskiy (1995-1996)        }
{=======================================================}

Implementation

Uses
{$IFNDEF WIN32}
  DOS,
  Objects,
{$ELSE}
  Classes,
  SysUtils,
  OpCrt,
{$ENDIF}
  tGlob;

Var
  DelDirs         : PNotSortedCollection;
  Name            : NameStr;
  Dir             : DirStr;
  Ext             : ExtStr;
  TempStr         : PathStr;
  GlobalSize      : LongInt;

Function LastDir (SRec : {$IFNDEF WIN32} SearchRec {$ELSE} TSearchRec {$ENDIF}) : Boolean;
Var
  ErrorDos : Integer;
  LDir     : Boolean;

Begin
  LDir := True;
  ErrorDos := DosError;
{$IFDEF WIN32}
  DOSerror :=
{$ENDIF}
  FindNext (SRec);

  While (DosError = 0) And LDir Do
  Begin
    LDir := (SRec. Attr And Directory = 0);
  {$IFDEF WIN32}
    DOSerror :=
  {$ENDIF}
    FindNext (SRec);
  End;

  DosError := ErrorDos;
  LastDir := LDir;
End;

Procedure Tree (Dir : PathStr);

  Procedure SearchDir (Dir, GrDir : PathStr);
  Var
    SRec : {$IFNDEF WIN32} SearchRec {$ELSE} TSearchRec {$ENDIF};

  Begin
    If Dir [Length (Dir) ] <> '\' Then Dir := Dir + '\';
  {$IFDEF WIN32}
    DOSerror :=
  {$ENDIF}
    FindFirst (Dir + '*.*', Directory + Hidden, SRec);
    While DosError = 0 Do
    Begin
      With SRec Do
      If (Attr And Directory <> 0) And (Name [1] <> '.') Then
      If LastDir (SRec) Then
      Begin
        DelDirs^. Insert (NewStr (Dir + Name));
        SearchDir (Dir + Name, GrDir + '   ');
      End Else
      Begin
        DelDirs^. Insert (NewStr (Dir + Name));
        SearchDir (Dir + Name, GrDir + '  ');
      End;
    {$IFDEF WIN32}
      DOSerror :=
    {$ENDIF}
      FindNext (SRec);
    End;
    {$IFDEF OS2}
    FindClose (SRec);
    {$ENDIF}
  End;

Begin
  DelDirs^. Insert (NewStr (Dir) );
  SearchDir (Dir, ' ');
End;

Procedure ScanDirs;
Begin
  FSplit ({$IFNDEF WIN32} FExpand {$ELSE} ExpandFileName {$ENDIF} (''), Dir, Name, Ext);
  Tree (Dir);
End;

Procedure CalcSize (Files: String);
Var
  SrD : {$IFNDEF WIN32} SearchRec {$ELSE} TSearchRec {$ENDIF};
  F   : File;
Begin;
{$IFDEF WIN32}
  DOSerror :=
{$ENDIF}
  FindFirst (Files, AnyFile, SrD);

  While DosError = 0 Do
  Begin
    System. FileMode := 0;
    Assign (F, Srd. Name);
    Reset (F, 1);
    System. FileMode := 2;
    GlobalSize := GlobalSize + FileSize (F);
    Close (f);
  {$IFDEF WIN32}
    DOSerror :=
  {$ENDIF}
    FindNext (SrD);
  End;

  {$IFDEF OS2}
  FindClose (SrD);
  {$ENDIF}

  If IOResult <> 0 Then;
End;

Function DirSizeWSb (Directory: String): LongInt;
Var
  i      : Word;

Begin
  GlobalSize := 0;
  ChDir (Directory);
  DelDirs := New (PNotSortedCollection, Init (10, 1));
  ScanDirs;

  For i := DelDirs^. Count - 1 Downto 0 Do
  Begin
    TempStr := PString (DelDirs^. At (i))^;
    If TempStr [Length (TempStr) ] = '\' Then
       TempStr := Copy (TempStr, 1, Length (TempStr) - 1);
    ChDir (TempStr);
    CalcSize ('*.*');
  End;

  DirSizeWSb := GlobalSize;

  While DelDirs^. Count > 0 Do
  Begin
    DisposeStr (DelDirs^. At (0));
    DelDirs^. AtDelete (0);
  End;

  Dispose (DelDirs, Done);
End;

End.