{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : RUMORS.PAS                                                    
  Description: Rumor System                                                  
  Version    : v0.1100                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
Unit Rumors;

Interface

Uses Dos,Crt,Overlay,Common,Emulate;

Procedure Rumor_View(RumorNum:integer);
Procedure Rumor_Add;
Procedure Rumor_List;
Procedure Rumor_Delete;

Implementation

Const
 RumorFileName:String[10]='RUMORS.LST';
 TempRumorFileName:String[10]='RUMORS.$$$';

Var
 RumorNum:integer;
 s:string[3];
 tmprumorf:file of rumorrec;
 tmprumor:rumorrec;
 NoRumors:boolean;

Procedure Rumor_View(RumorNum:integer);
Var
 s:string;
Begin
 NoRumors:=FALSE;
 Assign(rumorf, systat.SystemPath+rumorfilename);
 {$I-} Reset(rumorf); {$I-}
 If IOResult<>0 then NoRumors:=TRUE
 Else begin
  If (FileSize(rumorf)<1) then NoRumors:=TRUE;
  If (RumorNum>FileSize(rumorf)) then NoRumors:=TRUE;
  If (RumorNum<1) then NoRumors:=TRUE;
  Close(rumorf);
 End;

 If NoRumors then begin
  nl;
  If (menur.emulation>=20) and (menur.emulation<=29) then begin
   sprint('^5Number Out Of Range.');
   nl;
  End
  Else sprint('^5Number Out Of range.');
  Exit;
 End;

 s:=rumorviewstring;

 If pos('R#',s)=0 then s:='^5Undefined Rumor Placement [Cmdkeys: R#, "R#" Defines Rumor Placement]^M^M'
 Else Begin
  Reset(rumorf);
  Seek(rumorf,RumorNum-1);
  Read(rumorf,rumor);
  Close(rumorf);
  Insert(rumor.rumor,s,pos('R#',s));
  Delete(s,pos('R#',s),3);
 End;

 sprompt(s);
End;

Procedure Rumor_Add;
Var
 s:string;
Begin
 Assign(rumorf, systat.SystemPath+rumorfilename);
 {$I-} Reset(rumorf); {$I-}
 If IOResult<>0 then begin
  {$I-} Rewrite(rumorf); {$I+}
  If IOResult<>0 then begin
   sprint('I/O Error Accessing Rumor File.');
   Exit;
  End;
 End;

 Seek(rumorf,FileSize(rumorf));

 rumor.date:=date;
 rumor.author:=thisuser.name;

 If (menur.emulation>=20) and (menur.emulation<=29) then begin
  sprint(#3#9'       ');
  prt('Title: ');
  inputl(s,20);
  rumor.title:=s;
  nl;
  If rumor.title='' then exit;
  prt('Post Rumor Anonymous [y/N]: ');
  inputl(s,3);
  If allcaps(s)<>'Y' then rumor.anonymous:=FALSE
  Else rumor.anonymous:=TRUE;
  nl;
  prt('Level required to read rumor [CR/0]: ');
  inputl(s,3);
  rumor.accessreq:=bytevalue(s);
  nl;
  sprint(#3#5'Enter Rumor [CR to Abort]  Use |## (01-15) For Color');
  sprint(#3#9' ');
  prt('> ');
  inputl(s,75);
  rumor.rumor:=s;
  If s<>'' then begin
   write(rumorf,rumor);
   nl;
   sprint(#3#5'Rumor Created!');
  End;
  nl;
 End
 Else Begin
  rumor.title:='';
  rumor.anonymous:=FALSE;
  rumor.accessreq:=0;
  NL;
  sprint('^1Enter Rumor ^9[^275 Chars Max^9/^2CR to Abort^9]');
  prt(' ');
  inputl(s,75);
  rumor.rumor:=s;
  NL;
  If s<>'' then begin
   write(rumorf,rumor);
   sprint(#3#5'Rumor Added.');
  End
  Else sprint(#3#5'Nothing Saved.');
 End;

 close(rumorf);
End;


Procedure Rumor_List;
Var
 Temp,
 Count,
 Range:integer;
 Abort,Next:Boolean;
 AuthorStr:String[21];

Begin
 NoRumors:=FALSE;
 Assign(rumorf, systat.SystemPath+rumorfilename);
 {$I-} Reset(rumorf); {$I-}
 If IOResult<>0 then NoRumors:=TRUE
 Else If (FileSize(rumorf)<1) then begin close(rumorf); NoRumors:=TRUE; end;

 If (menur.emulation>=20) and (menur.emulation<=29) then begin
  If NoRumors then begin
   sprint('^5There Aren''t Any Rumors.');
   nl;
   Exit;
  End;

  sprompt('^9[^2Range^9][^21-'+cstr(FileSize(rumorf))+'^9]:');
  input(s,9);
  count:=0;
  If s<>'' then begin
   If pos('-',s)<>0 then begin
    Temp:=value(copy(s,1,pos('-',s)-1));
    If Temp>0 then count:=Temp-1;
    Temp:=value(copy(s,pos('-',s)+1,length(s)-pos('-',s)+1));
    If Temp>0 then range:=Temp-1;
   End
   Else If (value(s)>0) then begin
    range:=value(s)-1;
    count:=value(s)-1;
   End
   Else range:=FileSize(rumorf)-1;
  End
  Else range:=FileSize(rumorf)-1;
  If range<count then begin
   nl;
   Exit;
  End;

  If range>FileSize(rumorf)-1 then range:=FileSize(rumorf)-1;
  If count>FileSize(rumorf)-1 then count:=FileSize(rumorf)-1;
  Abort:=FALSE; Next:=FALSE;
  cls;
  printacr(#3#5'Numb  '#3#1'Rumor Title                     '#3#2'Date     '#3#7'Author',Abort,Next);
  printacr(#3#9'',Abort,Next);

  While (Count<=Range) and (Not Abort) and (Not Hangup) do begin
   Seek(rumorf,count);
   Read(rumorf,rumor);

   If (not rumor.anonymous) then AuthorStr:=Rumor.Author
   Else begin
    If (cso) then AuthorStr:='Anon ['+copy(rumor.author,1,21)+']'
    Else AuthorStr:='Anonymous';
   End;
   printacr(#3#9'['#3#5+cstr(count+1)+#3#9']'+ins(4,cstr(count+1))
    +' '#3#1+rumor.title+ins(30,rumor.title)
    +' '#3#2+rumor.date+ins(8,rumor.date)+' '+#3#7+AuthorStr,Abort,Next);
   Inc(Count);
  End;
 End

 Else Begin
  If NoRumors then begin
   sprint(#3#5'There Aren''t Any Rumors.');
   Exit;
  End;

  count:=0;
  range:=FileSize(rumorf)-1;

  Abort:=FALSE; Next:=FALSE;
  cls;
  printacr(#3#5'###   The Rumor',Abort,Next);
  printacr(#3#9'',Abort,Next);

  While (Count<=Range) and (Not Abort) and (Not Hangup) do begin
   Seek(rumorf,count);
   Read(rumorf,rumor);
   printacr(#3#9'['#3#5+cstr(count+1)+#3#9']'+ins(3,cstr(count+1))+
   ' '#3#5+copy(stripcolor(rumor.rumor),1,73),Abort,Next);
   Inc(Count);
  End;
 End;

 close(rumorf);
End;


Procedure Rumor_Delete;

 Procedure DeleteIt(DeleteNum:integer);
 Var
  i:integer;
 Begin
  Assign(tmprumorf, systat.SystemPath+temprumorfilename);
  {$I-} Rewrite(tmprumorf); {$I-}
  If IOResult<>0 then Exit;
  Dec(deletenum);
  Reset(rumorf);

  Seek(rumorf,DeleteNum);
  Read(rumorf,tmprumor);
  close(rumorf);
  close(tmprumorf);
  NL;
  If (cso) or (allcaps(thisuser.name)=allcaps(tmprumor.author)) then begin
   If (cso) and (allcaps(thisuser.name)<>allcaps(tmprumor.author)) then
    sprint('^3Rumor Created by "'+tmprumor.author+'"');
   sprint('^9"^2'+tmprumor.rumor+'^9"');
   nl;
   If (menur.emulation>=20) and (menur.emulation<=29) then sprompt('^1Delete It? ^9[^2N^9]:')
   Else sprompt('^1Delete It? ^9[^2No^9]: ');
   If (yn) then begin
    {$I-} Rewrite(tmprumorf); {$I-}
    If IOResult<>0 then Exit;
    Reset(rumorf);

    For i:=0 to DeleteNum-1 do begin
     Seek(rumorf,i);
     Seek(tmprumorf,i);
     Read(rumorf,rumor);
     Write(tmprumorf,rumor);
    End;

    For i:=DeleteNum+1 to FileSize(rumorf)-1 do begin
     Seek(rumorf,i);
     Seek(tmprumorf,i-1);
     Read(rumorf,rumor);
     Write(tmprumorf,rumor);
    End;
    close(rumorf);
    close(tmprumorf);
    Erase(rumorf);
    Rename(tmprumorf, systat.SystemPath+rumorfilename);
   End;
  End
  Else begin
   sprint('^5You Didn''t Make That Rumor.');
  End;
 End;

Begin
 NoRumors:=FALSE;
 Assign(rumorf, systat.SystemPath+rumorfilename);
 {$I-} Reset(rumorf); {$I-}
 If IOResult<>0 then NoRumors:=TRUE
 Else If (FileSize(rumorf)<1) then begin close(rumorf); NoRumors:=TRUE; end;

 If (menur.emulation>=20) and (menur.emulation<=29) then begin
  If NoRumors then begin
   sprint('^5There Aren''t Any Rumors.');
   nl;
   Exit;
  End;
  Close(rumorf);

  Repeat
   sprompt('^1Rumor Number To Delete ^9[^2?^9/^2List^9]: ');
   input(s,4);
   If s='?' then begin nl; Rumor_List; s:='?'; end;
  Until s<>'?';
  if value(s)>0 then DeleteIt(value(s));
  nl;

 End

 Else Begin
  If NoRumors then begin
   sprint('^5There Aren''t Any Rumors.');
   Exit;
  End;
  Close(rumorf);


  Repeat
   nl;
   sprompt('^1Rumor to Delete ^9[^2L^9/^2List^9]: ');
   input(s,4);
   If allcaps(s)='L' then begin Rumor_List; s:='L'; end;
  Until s<>'L';
  If value(s)>0 then DeleteIt(value(s));

 End;
End;


End.
