{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : REGCODE.PAS                                                   
  Description: Returns Registration Code                                     
  Version    : v0.1000                                                       
                                                                             
                                                                           
 Ľ}

Function FindRegCode(BoardName : String;
                     SysOpName : String;
                     Nodes     : Integer) : String;

Var Work   : String;
    Code   : String;
    b      : Byte;
    i      : Integer;

Begin
 Code := '';
 Work := AllCaps(BoardName +' '+ SysOpName);  {* Case Insensitive *}

 For b := 1 To Length(Work) Do
 Begin
  Code := Code + cstr( Ord(Work[b]) * (Nodes+1) * 7); (* Added times 7 *)
  Code := Code + cstr( Ord(Work[b]) );
 End;

 Work := '';

 i := Length(Code) Div 10;  {* 10 = Length of Software RegCode Field *}
 b := i;

 While b <= Length(Code) Do Begin
  Work := Work + Code[b];
  Inc(b, i);
 End;

 While Length(Work) < 10 Do Work := Work + cstr( Value(Work) * (Nodes+1) );
 If Length(Work) > 10 Then Work[0]:=Chr(10);

 FindRegCode := Work;
End;
