
  NewConfRec=                      { CONFREC.DAT : Conference Configuration }
  Record
   ConferenceNum:integer;
   Description:string;
   ACS:ACString;
   DoMessage,DoFile:boolean;
  End;

  newrumorrec=                            { RUMORS.LST : Rumor list }
  record
    Title:string[20];
    Author:string[36];
    Date:string[8];
    Rumor:string[75];
    Anonymous:boolean;
    AccessReq:byte;
  end;

  newuserrec=                            { USER.LST : User account records }
  record
    name:string[36];                        { user name        }
    realname:string[36];                    { real name        }
    pw:string[20];                          { user password    }
    ph:string[12];                          { user phone #     }
    bday:string[8];                         { user birthdate   }
    firston:string[8];                      { firston date     }
    laston:string[8];                       { laston date      }

    AccountNote:String[30];
    ModemType:String[30];
    Computer:String[30];
    Note:String[39];

    lockedout:boolean;                      { if locked out    }
    deleted:boolean;                        { if deleted       }
    lockedfile:string[8];                   { lockout msg to print }

    ac:set of uflags;                       { user flags   }
    ar:FlagSet;                         { AR flags     }

    zzqscan:array[1..64] of word;           { last read msg pointers }
    xqxxx:array[1..64] of word;
    zzqscn:array[1..64] of boolean;         { scan boards flags  }
    zzdlnscn:dlnscan;                       { scan uboards flags }

    vote:array[1..20] of byte;              { voting data  }
    nuv:array[1..20] of byte;

    useautosigs:boolean;

    sex:char;                               { user sex }

    ttimeon:longint;                        { total mins spent on  }
    uk:longint;                             { UL k                 }
    dk:longint;                             { DL k                 }

    uploads,downloads,                      { # of ULs / # of DLs  }
    loggedon,                               { # times logged on    }
    tltoday,                                { # min left today     }
    msgpost,                                { # public posts       }
    emailsent,                              { # email sent         }
    filepoints:integer;                     { # of file points     }

    linelen,                                { line length (# cols) }
    pagelen,                                { page length (# rows) }
    ontoday,                                { # times on today     }
    illegal,                                { # illegal logon attempts }
    sl,dsl:byte;                            { SL / DSL }

    cols:clrs;                              { user colors }

    lastmsg,lastfil:byte;                   { last msg/file areas   }
    timebank:integer;                       { # mins in Time Bank   }

    trapactivity,                           { if trapping users activity }
    trapseperate:boolean;                   { if trap to seperate TRAP file }

    timebankadd:integer;                    { time added to timebank TODAY }
    mpointer:longint;                       { pointer to entry in MACRO.LST }
    chatauto,                               { if auto chat trapping }
    chatseperate:boolean;                   { if seperate chat file to trap to }
    slogseperate:boolean;                   { seperate SysOp log? }
    ClsMsg:Boolean;                         { 1 if clear-screen msg, 2 if not }

    AvatarColorAdjust:Boolean;              { AVATAR Color Adjust }

    HeaderNumber:Integer;
    HideName:Boolean;

    Res:array[1..15] of Byte;                { RESERVED }


    MsgConf,
    FilConf  : FlagSet;

    IncomingMail,
    OutGoingMail,
    AreaListNumber:Integer;
  end;

  NewAuxUserRec=Record                   { AUXUSER.DAT : Auxiliary User Recs }
    wallread,                               { The Wall: Scan Pointer }
    newsread:integer;                       { AstuteNews: Scan Pointer }
    haspickit:boolean;                      { Do You Have A Ticket? }
    pickit:array[1..6] of integer;          { The Actual Ticket }
  end;


  NewOnLineRec=
  Record
   Handle:String[30];
   Status:String[40];
   AllowPage:Boolean;
  End;


  Newzscanrec=                       { ZSCAN.DAT : NewScan recs (file/msg) }
  record                          { ** b0..b3 }
    mhiread:mhireadr;             { NewScan high message pointers }
    mzscan:mzscanr;               { NewScan message bases }
    fzscan:fzscanr;               { NewScan file bases }
  end;

  NewFromInfoRec = Record
   Zone,
   Net,
   Node,
   Point      : Word;
   UserName   : String[30];
   UserNote   : String[25];
  End;

  NewToInfoRec = Record
   Zone,
   Net,
   Node,
   Point      : Word;
   UserName   : String[30];
  End;

  NewMsgIndexRec = Record                {* .IDX Records *}
   MsgPtr      : LongInt;             {* Pointer to Message Text *}
   MsgLength   : LongInt;             {* Length of Message Text *}
   MsgAttr     : Word;                {* Message Attributes *}
   FidoAttr    : Word;                {* Standard FidoNet Attribute Set *}
   Cost        : Word;                {* NetMail Cost - if any *}
   Anon        : Byte;
   ReplyTo,
   NextReply,
   TimesRead   : Word;

   MsgPostDateTime,                   {* NewScan Date/Time Stamp *}
   MsgDateTime : CPackDateTime;       {* Date/Time Stamp of Message *}

   FromInfo    : FromInfoRec;         {* From User Address/Name/User Note *}
   ToInfo      : ToInfoRec;           {* To User Address/Name *}
   Title       : String[72];          {* Message Title *}

   MsgIndexRec_FutureExpansion : Array[1..38] of Byte;
  End;

{* Format:

  Each message board has a .IDX file specific to it, which stores the
  information for the messages in that board.  Messages are stored starting
  at record 0, with record 0 being treated as message 1, record 1 being
  message 2, etc.  The IDX entry contains the variable "MsgPtr" to point to
  the start of the message in the .MTX file, with the "MsgLength" variable
  determining how long the message is (in bytes).

*}


  Newzlogrec=                        { ZLOG.DAT : System log }
  record
    date:string[8];
    userbaud:array[0..4] of integer;
    active,calls,newusers,pubpost,privpost,fback,criterr:integer;
    uploads,downloads:integer;
    uk,dk:longint;
  end;

  Newfilearcinforec=                 { Archive configuration records }
  record
    active:boolean;               { whether this archive format is active }
    ext:string[3];                { 3-chr file extension }
    listline,                     { /x for internal;
                                     x: 1=ZIP, 2=ARC/PAK, 3=ZOO, 4=LZH }
    arcline,                      { compression cmdline }
    unarcline,                    { de-compression cmdline }
    testline,                     { integrity test cmdline, '' for *None* }
    cmtline:string[25];           { comment cmdline, '' for *None* }
    succlevel:integer;            { success ERRORLEVEL, -1=ignore results }
  end;

  Newmodemrec=
  record
    maxbaud:word;                { Max Baud }
    comport:byte;                { COM Port # }


    init:string[80];             { Init String }
    answer:string[40];           { Answer string }
    hangup:string[40];           { Hangup string }
    offhook:string[40];          { Phone off-hook string }


    nocallinittime:integer;      { reinit modem after xx mins of inactivity }
    lockedport:boolean;          { Locked Port - Y/N }
    lockedbaud:longint;          { Locked baud rate }
(*
    arq9600rate:word;            { baud rate to USE when 9600 ARQ result code }
*)
    forcerate:boolean;         { whether to force baud rate}

    CONNECT_300,
    CONNECT_1200,
    CONNECT_2400,
    CONNECT_4800,
    CONNECT_9600,
    CONNECT_14400,
    CONNECT_19200,
    CONNECT_38400: String[20];  {*}

    ERROR,
    BUSY,        {*}
    NO_CARRIER,
    OK,
    RING,
    NO_DIALTONE, {*}
    NO_ANSWER,   {*}
    VOICE: String[14];  {*}

    ctschecking,
    dsrchecking,
    usexonxoff,
    hardwired:boolean;
  end;

  Newfstringrec=
  record
    ansiq:string[80];                 { "Do you want ANSI? " string }
    note:array[1..2] of string[80];   { Logon notes (L #1-2) }
    lprompt:string[80];               { Logon prompt (L #3) }
    echoc:char;                       { Echo char for PWs }
    TypeFile,                         { "Enter Filename to display: "}
    FileScan,                         { File Scan prompt }
    engage,                           { "Engage Chat" }
    endchat,                          { "End Chat" }
    wait,                             { "SysOp Working" }
    pause,                            { "Pause" }
    entermsg1,                        { "Enter Message" line #1 }
    entermsg2,                        { "Enter Message" line #2 }
    newscan1,                         { "NewScan begin" }
    newscan2,                         { "NewScan done" }
    scanmessage,                      { Message scanning prompt }
    automsgt:string[80];              { Auto-Message title }
    autom:char;                       { Auto-Message border characters }

    shelldos1,                        { " >> SysOp shelling to DOS ..." }
    shelldos2,                        { " ... thank you for waiting." }
    chatcall1,                        { "Paging SysOp, please wait..." }
    chatcall2,                        { ">>><*><<<" }
    guestline,                        { "To be a guest ... " }
    namenotfound,                     { "Name NOT found in user list." }
    bulletinline,                     { Bulletin line }
    thanxvote,                        { "Thanks for voting" }

    listline,                         { "List files - P to pause" }
    newline,                          { "Search for new files -" }
    searchline,                       { "Search all dirs for file mask" }
    findline1,                        { "Search for descriptions... " }
    findline2,                        { "Enter the string to search for.." }
    downloadline,                     { "Download - " }
    uploadline,                       { "Upload - " }
    viewline,                         { "View interior files - " }
    nofilepts,                        { "Insufficient file points." }
    unbalance,                        { "Your UL/DL ratio is unbalanced" }

    pninfo,                           { "P to Pause, N for next dir" }
    gfnline1,                         { "[Enter]=All files" }
    gfnline2,                         { "File mask: " }
    batchadd:string[80];              { "File added to batch queue." }
  end;

  NewSystatRec = Record
   SystemPath,
   TextPath,
   MsgPath,
   MenuPath,
   ExternalEditor,
   ProtocolPath,
   ArchivePath:String[60];
   SysOpName,
   BBSName:String[30];
   BBSPhone:String[12];

    lowtime,                          { SysOp begin minute (in minutes) }
    hitime,                           { SysOp end time }
    dllowtime,                        { normal downloading hours begin.. }
    dlhitime:integer;                 { ..and end }
    shuttlelog,                       { is Shuttle Logon active? }
    lock9600:boolean;                 { lock out under 9600 baud? }

    SystemPW,                         { SysOp PW }
    NewUserPW,                        { NewUser PW (or NULL if none) }
    LockOutPW,
    System1PW,
    System2PW,
    System3PW,
    System1Security,
    System2Security,
    System3Security:String[20];         

    blowtime,                         { Under 9600 baud calling hours begin.. }
    bhitime,                          { ..and end }
    bdllowtime,                       { Under 9600 baud downloading hours begin.. }
    bdlhitime:integer;                { ..and end }

    MultiLine:Boolean;
    AllowNewUsers:Boolean;
    SwapShell,
    EMS_Overlay:Boolean;
    EventWarningTime:Integer;
    AutoSysOpFastLogon:Boolean;

    phonepw,                          { use phone number password in logon? }
    Unused_localsec,                         { is local security ON? }
    localscreensec,                   { is local screen-security ON? }
    localpass:boolean;                { whether to hide PW's locally }
    usebios:boolean;                  { use ROM BIOS for local video output }
    cgasnow:boolean;                  { suppress snow on CGA systems }
    globaltrap,                       { trap ALL USER'S activity? }
    autochatopen:Boolean;             { does chat buffer auto-open? }


    sop,                              { SysOp }
    csop,                             { Co-SysOp }
    msop,                             { Message SysOp }
    fsop,                             { File SysOp }
    spw,                              { SysOp PW at logon }
    seepw,                            { see SysOp PWs remotely  }
    normpubpost,                      { make normal public posts }
    normprivpost,                     { send normal e-mail }
    anonpubread,                      { see who posted public anon }
    anonprivread,                     { see who sent anon e-mail }
    anonpubpost,                      { make anon posts }
    anonprivpost,                     { send anon e-mail }
    seeunval,                         { see unvalidated files }
    dlunval,                          { DL unvalidated files }
    nodlratio,                        { no UL/DL ratio }
    nopostratio,                      { no post/call ratio }
    nofilepts,                        { no file points checking }
    ulvalreq:acstring;                { uploads require validation by SysOp }

    Unused_LastMsgId:LongInt;


    Default_Onek,
    Default_ClrMsg,
    Default_Expert,
    Default_Pause:boolean;

    maxprivpost,                      { max e-mail can send per call }
    maxpubpost,                       { max posts per call }
    maxchat,                          { max chat-pages per call }
    maxwaiting,                       { max mail in mail-box }
    csmaxwaiting,                     { max mail in mail-box for Co-SysOp + }
    maxlogontries,                    { tries allowed for PW's at logon }
    sysopcolor,                       { SysOp color in chat mode }
    usercolor:byte;                   { user color in chat mode }
    minspaceforpost,                  { minimum K drive space left to post }
    minspaceforupload:integer;        { minimum K drive space left to upload }
    backsysoplogs,                    { days to keep SYSOP##.LOG }
    wfcblanktime:byte;                { minutes after which to blank WFC menu }

{^} linelen,                          { default video line length }
{^} pagelen:byte;                     { default video page length }


    offhooklocallogon,                { take phone off-hook for local logons? }
    forcevoting,                      { is manditory logon voting active? }
    compressbases,                    { "compress" file/message base numbers? }

    searchdup:boolean;                { search for dup. filenames when UL? }

    stripclog:boolean;                { strip colors from SysOp log output? }

    timeoutbell,                      { minutes before time-out bell }
    timeout:integer;                  { minutes before timeout (logoff) }

    filearcinfo:array[1..maxarcs] of filearcinforec; { archive specs }

    filearccomment:array[1..3] of string[80]; { BBS comments for archives }
    uldlratio,                        { are UL/DL ratios active? }
    fileptratio:boolean;              { is auto file-pt compensation active? }
    fileptcomp,                       { file point compensation ratio }
    fileptcompbasesize,               { file point "base compensation size" }
    ulrefund,                         { percent time refund for ULs }
    tosysopdir:byte;                  { "To SysOp" file base }
    validateallfiles:boolean;         { validate ALL FILES automatically? }
    remdevice:string[10];             { remote output device (GATEx,COMx,etc) }
    maxintemp,                        { max K allowed in TEMP\3\ }
    minresume:integer;                { min K to allow resume-later }
    maxdbatch,                        { max files in DL batch queue }
    maxubatch:byte;                   { max files in UL batch queue }

    newsl,                            { newuser SL }
    newdsl:byte;                      { newuser DSL }
    newar:FlagSet;                { newuser AR }
    newac:set of uflags;              { newuser AC }
    newfp:integer;                    { newuser file points }
    autosl,                           { auto-validation SL }
    autodsl:byte;                     { auto-validation DSL }
    autoar:FlagSet;               { auto-validation AR }
    autoac:set of uflags;             { auto-validation AC }

    allstartmenu:string[8];           { logon menu to start ALL users on }
    bulletprefix:string[8];           { default bulletins filename prefix }

    lastdate:string[8];               { last system date }
    curwindow:byte;                   { type of SysOp window currently in use }
    istopwindow:boolean;              { is SysOp window on top of screen? }
    callernum:longint;                { total number of callers }
    numusers:integer;                 { number of users }

    todayzlog:zlogrec;                { TODAY's ZLOG record }

    postcredits:integer; {file points/upload credit compensation for posts}
    rebootforevent:boolean;           { reboot before events? }
    watchdogdoor:boolean;             {  WatchDog active in doors? }

    MaxUsers:Integer;

    windowon:boolean;
    RegCode:String[10];

    EMailBoard : Word;

    ReservedSpace:Array[1..187] Of Byte;
  end;

  newsmr=                            { SHORTMSG.DAT : One-line messages }
  record
    msg:astr;
    destin:integer;
  end;


(*
  NewUserVotingIndexRec = Record
   UserName:String[30];
   Vote:Byte;

  End;
*)


  newNUVRec=     { NUV.DAT : New User Voting }
  Record
   UserNum:Integer;
   Votes:Array[1..9999] of Byte;
  End;

  newvdatar=                         { VOTING.DAT : Voting records }
  record
    question:string[79];          { voting question }
    numa:integer;                 { number of user's who have answered }
    answ:array[0..numvoteas] of
    record
      ans:string[40];             { answer description }
      numres:integer;             { # user's who picked this answer }
    end;
  end;

  newboardrec=                       { BOARDS.DAT : Message base records }
  record
    name:string[40];              { message base description }
    filename:string[8];           { BRD/MIX data filename }
    lastmsgid:longint;            { last message ID number }
    msgpath:string[40];           { messages pathname   }
    acs,                          { access requirement }
    postacs,                      { post access requirement }
    mciacs:acstring;              { MCI usage requirement }
    maxmsgs:word;                 { max message count }
    anonymous:anontyp;            { anonymous type }
    password:string[20];          { base password }
    mbstat:set of mbflags;        { message base status vars }
    permindx:longint;             { permanent index # }
    mbtype:integer;               { base type (0=Local,1=Echo) }
    origin:string[50];            { origin line }
    text_color,                   { color of standard text }
    quote_color,                  { color of quoted text }
    tear_color,                   { color of tear line }
    origin_color:byte;            { color of origin line }
    zone,                         { alternate address     }
    net,                          { (zone:net/node.point) }
    node,
    point:integer;
    {* Conference *}
    res:array[1..1] of byte;      { RESERVED }
    MsgStatus:Byte;
    AddAccNote:Boolean;
  end;

(*
  BaseType=(
   Local,
   NetMail,
   EchoMail,
   UnusedBT
  );

  newNBoardRec=Record  { BOARDS.DAT : Message Bases }
   Name:String[40];
   FileName:String[8];
   MsgPath:String[60];
   Acs,
   PostAcs:AcString;
   MaxMsgs:Word;
   Origin:String[50];

   MsgBaseType:BaseType;
   MsgPostType:PostType;
   AnonLevel:AnonType;
   Flags:Set Of BaseFlags;

   Zone,
   Net,
   Node,
   Point:Word;

   UnusedFiller:Array[1..200] of Byte;
  End;

*)


  newulrec=                          { UPLOADS.DAT : File base records }
  record
    name:string[40];              { area description  }
    filename:string[12];          { filename + ".DIR" }
    dlpath,                       { download path     }
    ulpath:string[40];            { upload path       }
    maxfiles:integer;             { max files allowed }
    password:string[20];          { password required }
    arctype,                      { wanted archive type (1..max,0=inactive) }
    cmttype:byte;                 { wanted comment type (1..3,0=inactive) }
    fbdepth:integer;              { file base dir depth }
    fbstat:set of fbflags;        { file base status vars }
    acs,                          { access requirements }
    ulacs,                        { upload requirements }
    nameacs:acstring;             { see-names requirements }
    permindx:longint;             { permanent index # }
    res:array[1..6] of byte;      { RESERVED }
    {res[1]=conference 0-255}
  end;

  newulfrec=                         { *.DIR : File records }
  record
    filename:string[12];          { Filename }
    description:string[60];       { File description }
    filepoints:integer;           { File points }
    nacc:integer;                 { Number DLs }
    ft:byte;                      { File type (useless?) }
    blocks:integer;               { # 128 byte blks }
    owner:integer;                { ULer of file }
    stowner:string[36];           { ULer's name }
    date:string[8];               { Date ULed }
    daten:integer;                { Numeric date ULed }
    vpointer:longint;             { Pointer to verbose descr, -1 if none }
    filestat:set of filstat;      { File status }
    res:array[1..2] of byte;      { Disk #'s } {Change to DiskNumbers}

    FileInfo:String[6];
    CrackGroup:String[8];

    reservedpassword:string[10];
    reservedstring:string[10];
    reserved:array[1..4] of byte;
  end;

  newverbrec=                        { VERBOSE.DAT : Verbose descriptions }
  record
    descr:array[1..4] of string[50];
  end;

  newLastCallRec=
  Record
   UserName:String[30];
   BaudRate:String[20];
   Date:String[8];

   TimeOn:String[5];
   TimeOff:String[5];
   TotalTimeOn:String[3];

   DaysOld,
   NodeID:Byte;
   CallerNum:LongInt;  {Not Currently Displayed Anywhere}
  End;

  neweventrec=                       { EVENTS.DAT : Event records }
  record
    active:boolean;               { whether active }
    description:string[30];       { event description (for logs) }
    etype:char;                   { A:CS, C:hat, D:os call, E:xternal }
    execdata:string[20];          { errorlevel if "E", commandline if "D" }
    busytime:integer;             { off-hook time before; 0 if none }
    exectime:integer;             { time of execution }
    busyduring:boolean;           { busy phone DURING event? }
    duration:integer;             { length of time event takes }
    execdays:byte;                { bitwise execution days or day of month if monthly }
    monthly:boolean;              { monthly event? }
  end;

  newmacrorec=                       { MACROS.LST : Macro records }
  record
    macro:array[1..4] of string[240];
  end;

  newmenurec=                        { *.MNU : Menu records }
  record
    menuname:array[1..3] of string[100]; { menu name }
    directive,                           { help file displayed }
    tutorial:string[12];                 { tutorial help file }
    menuprompt:string[120];              { menu prompt }
    acs:acstring;                        { access requirements }
    password:string[15];                 { password required }
    fallback:string[8];                  { fallback menu }
    forcehelplevel:byte;                 { forced help level for menu }
    gencols:byte;                        { generic menus: # of columns }
    gcol:array[1..3] of byte;            { generic menus: colors }
    inputcase,                           { forced upppercase input }
    inputstyle,                          { full line vs onekey input }
(*    rumorshow,   *)                        { Show A Rumor B4 Prompt }
    emulation:byte;                      { OS/Emulation <tm> }
    menuflags:set of mnuflags;           { menu status variables }
  end;

  newcommandrec=                       { *.MNU : Command records }
  record
(*
    ldesc:string[35];               { long command description }
*)
    sdesc:string[80];               { short command description }
    ckeys:string[14];               { command-execution keys }
    acs:acstring;                   { access requirements }
    cmdkeys:string[2];              { command keys: type of command }
    mstring:string[80];             { MString: command data }
    commandflags:set of cmdflags;   { command status variables }
  end;

  newprotrec=
  record
    xbstat:set of xbflags;                       { protocol flags }
    ckeys:string[14];                            { command keys }
    descr:string[40];                            { description }
    acs:acstring;                                { access string }
    templog:string[25];                          { temp. log file }
    uloadlog,dloadlog:string[25];                { permanent log files }
    ulcmd,dlcmd:string[78];                      { UL/DL commandlines }
    ulcode,dlcode:array [1..6] of string[6];     { UL/DL codes }
    envcmd:string[60];                        {B}{ environment setup cmd }
    dlflist:string[25];                       {B}{ DL file lists }
    maxchrs:integer;                             { max chrs in cmdline }
    logpf,logps:integer;                      {B}{ pos in log file for data }
    permindx:longint;                            { permanent index # }
    res:array[1..11] of byte;                    { RESERVED }
  end;

  newdatetimerec=
  record
    day,hour,min,sec:longint;
  end;

  newcfilterrec=array[0..255] of byte;          { color filter record }


  newNetworkRec=Record  { NETWORK.DAT : Network Info }
   Origin,
   NetMailPath,              { NetMail path }
   EchoMailPath,             { EchoMail path }
   NodeListPath:string[60];  { Nodelist path }

   nholduser,        { hold all non-SysOp NetMail? }
   nhold,            { default NetMail to "hold"? }
   ncrash,           { default NetMail to "crash"? }
   nkill:Boolean;    { default NetMail to "kill/sent"? }
  End;


