{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : MSG2.PAS                                                      
  Description: Message System Stat Screens, Area Lists, Etc.                 
  Version    : v0.2000                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B-,E+,F+,I+,L-,N-,O+,R-,S+,V-}

Unit Msg2;

Interface

Uses Crt,
     Common,
     Msg0,
     Emulate;

procedure mbaselist;
procedure mbasechange(var done:boolean; mstr:astr);
procedure mbasestats;
procedure chbds;


Implementation

Procedure mbaselist;
var AreaFileName,s1,os:astr;
    TotMessages,b,b2,i,nd:integer;
    AreaListF:text;
    mixr:msgindexrec;
    InF:Text;


  Procedure AreaList;
  Var
    Acc,Abort,Next,FoundFile:Boolean;
    InF:Text;
    AreaFile,Temp,Work:String;
    BoardNum,BType:String[5];

    Function YesNo(InBoo:Boolean):String;
    Begin
      If InBoo then YesNo:='Yes'
      Else YesNo:='No ';
    End;

  Begin
    If ThisUser.AreaListNumber>0 then begin
      AreaFile:=Systat.TextPath+'MSG'+cstr(ThisUser.AreaListNumber);
      AreaFile:=GetTextFileName(AreaFile);
      If AreaFile='' then FoundFile:=FALSE
      Else FoundFile:=TRUE;
    End Else FoundFile:=FALSE;
    Abort:=FALSE;
    Next:=FALSE;
    If Not FoundFile then begin
      Cls;
      PrintAcr(#3#9'ķ',Abort,Next);
      PrintAcr(#3#9' '#3#7'#   '#3#2'Base Description                        Scan Type  Real ANSI Msgs '#3#9'',Abort,Next);
      PrintAcr(#3#9'Ķ',Abort,Next);
    End Else begin
      Assign(InF,AreaFile);
      Reset(InF);
      ReadLn(InF,Temp);
      If Temp<>'' then Printacr(Temp,abort,next);
      ReadLn(InF,Temp);
      If Temp<>'' then Printacr(Temp,abort,next);
      ReadLn(InF,Temp);
      If Temp<>'' then Printacr(Temp,abort,next);
      ReadLn(InF,Temp);
      If Temp<>'' then Printacr(Temp,abort,next);
      ReadLn(InF,Temp);
    End;

    i:=1;
    While (i<=numboards) and (not abort) do begin
      acc:=mbaseac(mconfpk^[i]); { mbaseac will load memboard }

      If ((mbunhidden in memboard.mbstat) or (acc)) then begin
        If (Not FoundFile) or (Pos('AT',Temp)<>0) then begin
          InitMsgFiles(MemBoard.FileName);
          TotMessages := HiMsg + 1;
        End;
        Case memboard.mbtype of
          0:BType:='Local';
          1:BType:='Echo ';
          2:BType:='Group';
          Else BType:='     ';
        End;

        If (acc) then BoardNum:=cstr(i) Else BoardNum:='';

        If Not FoundFile then
          PrintAcr(#3#9' '#3#7+BoardNum+Ins(3,BoardNum)
           +' '+memboard.name+Ins(40,StripColor(memboard.name))+' '#3#2+YesNo(checkzscanm(mconfpk^[i]))
           +' '+BType+'  '+YesNo(mbrealname in memboard.mbstat)+' '+YesNo(Not (mbfilter in memboard.mbstat))+
           +'  '#3#7+cstr(TotMessages)+Ins(4,cstr(TotMessages))+#3#9' ',abort,next)
        Else begin
          Work:=Temp;
          ReplaceCode('AA',YesNo(Not (mbfilter in memboard.mbstat)),0,Work);
          ReplaceCode('AB',BType,0,Work);
          ReplaceCode('AD',memboard.name,40,Work);
          ReplaceCode('AN',BoardNum,0,Work);
          ReplaceCode('AO',Ins(3,BoardNum),0,Work);
          ReplaceCode('AR',YesNo(mbrealname in memboard.mbstat),0,Work);
          ReplaceCode('AS',YesNo(checkzscanm(mconfpk^[i])),0,Work);
          ReplaceCode('AT',cstr(TotMessages),4,Work);
          PrintAcr(Work,Abort,Next);
        End;
        Inc(nd);
      End;
      inc(i);
    End;
    If Not FoundFile then begin
      PrintAcr(#3#9'Ľ',Abort,Next);
    End Else
      While (Not Eof(InF)) and (Not Abort) do begin
        ReadLn(InF,Temp);
        printacr(Temp,abort,next);
      End;
    If FoundFile then Close(InF);
  End;

begin
  b:=1; nd:=0;
  AreaList;
  if (nd=0) then sprint(#3#7+'No Message bases available.');
end;

procedure mbasechange(var done:boolean; mstr:astr);
var s:astr;
    i,temp:integer;
begin
  if mstr<>'' then
    case mstr[1] of
      '+':begin
            i:=realmbase(board);
            if i<numboards then begin
              changeboard(mconfpk^[i+1]);
              lastcommandovr:=true;
            end else sprint('Highest Accessable Message Base.');
          end;

      '-':begin
            i:=realmbase(board);
            if i>1 then begin
              changeboard(mconfpk^[i-1]);
              lastcommandovr:=true;
            end else sprint('Lowest Accessable Message Base.');
          end;
      'L':mbaselist;
      else begin
            temp:=value(mstr);
            if (temp>0) and (temp<=numboards) then begin
              changeboard(mconfpk^[temp]);
              lastcommandovr:=true;
            end else sprint('Base Not Within Acceptable Range.');
          end;
    end
  else begin
    if (novice in thisuser.ac) then mbaselist;
    nl;
    s:='?';
    repeat
      sprompt('^5^1Change Message Base ^9[^2?^9/^2List^9]: ^1');
      input(s,3);
      if s[1] in ['0'..'9'] then begin
        i:=value(s);  (*PACK*)
        if (i>=1) and (i<=numboards) then
          changeboard(mconfpk^[i]);
      end;
      if s='?' then begin mbaselist; nl; end;
    until (s<>'?') or (hangup);
    lastcommandovr:=TRUE;
  end;
end;


procedure mbasestats;
var s:astr;
    abort,next:boolean;
    ft,ctr:integer;
    ft2:string;

  procedure dd(var abort,next:boolean; s1,s2:astr; b:boolean);
  begin
    s1:=#3#5+#3#9+s1+#3#1+' ';
    if (b) then printacr(s1+s2,abort,next)
      else printacr(s1+'None.',abort,next);
  end;

begin
  abort:=FALSE; next:=FALSE;
  nl;
  loadboard(board);
  with memboard do begin

    ft:=length(stripcolor(memboard.name))+2;
    ft2:='^5^9'; for ctr:=1 to ft do ft2:=ft2+''; ft2:=ft2+'';
    sprint(ft2);
    prt('^5^9 '+memboard.name+'^5^9 '); nl;
    ft2:='^5^9'; for ctr:=1 to ft do ft2:=ft2+''; ft2:=ft2+'';
    sprint(ft2);
    ft2:='^5^9  '; for ctr:=1 to ft+1 do ft2:=ft2+'';
    sprint(ft2); nl;

    nl;
    dd(abort,next,'Message Base Password į','"'+password+'"',(password<>''));
    dd(abort,next,'Maximum Messages į',cstr(maxmsgs),(maxmsgs<>0));
    case anonymous of
      atno      :s:='None allowed';
      atyes     :s:='Anonymous posts allowed';
      atforced  :s:='All posts forced anonymous';
      atdearabby:s:='Dear Abby base';
      atanyname :s:='Any Name Goes';
    end;
    dd(abort,next,'Anonymous Type į',s,TRUE);
    if (fso) then begin
      nl;
      dd(abort,next,'Access ACS į',acs,TRUE);
      dd(abort,next,'Post ACS į',postacs,TRUE);
      dd(abort,next,'MCI ACS į',mciacs,TRUE);
      nl;
      dd(abort,next,'FileName į','"'+filename+'.BRD"',TRUE);
      dd(abort,next,'Message Path į','"'+msgpath+'"',(mbtype<>0));
    end;
  end;
end;

procedure chbds;
var s:astr;
    i:integer;
    done:boolean;
    tempboard:integer;
begin
  nl;
  if (novice in thisuser.ac) then begin mbaselist; nl; end;
  done:=FALSE;
  repeat
    prt('^5^1Set NewScan Of Message Bases ^9[^2Q^9/^2Quit^9, ^2?^9/^2List^9, ^2#^9/^2Toggle Base^9]: ^1');
    Input(s,3);
    if (s='Q') then done:=TRUE;
    if (s='?') then begin mbaselist; nl; end;
    {$B-}
    if (length(s)>0) and (s[1] in ['0'..'9']) and (value(s)<=numboards) then
      i:=value(s);
    {$B+}
    if (mbaseac(mconfpk^[i])) then { loads memboard }
      If (i>=1) and (length(s)>0) and (s[1] in ['0'..'9']) then begin
        nl;
        sprompt(#3#5+memboard.name+#3#1);
        tempboard:=board;
        if (checkzscanm(mconfpk^[i])) then begin
          sprint(' Will ^8NOT^1 Be Scanned.');
          loadboard(mconfpk^[i]);
          zscanm.zscan:=false;
          savezscanm;
          loadboard(tempboard);
        end else begin
          sprint(' ^8WILL^1 Be Scanned.');
          loadboard(mconfpk^[i]);
          zscanm.zscan:=true;
          savezscanm;
          loadboard(tempboard);
        end;
        nl;
      end;
  until (done) or (hangup);
  lastcommandovr:=TRUE;
end;


End.
