{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : MSG1.PAS                                                      
  Description: Messages - Post/Read                                          
  Version    : v0.2000                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B-,E+,F+,I+,L-,N-,O+,R-,S+,V-}

Unit Msg1;

Interface

Uses Crt,  Common,  TimeJunk,  Msg0,  File8,  UEdit;

Function ToUser(TestMsgIdx: MsgIndexRec): Boolean;
Function WhatAnon(AnonTyp:Byte; s:String) : String;
Function LoadConfigurablePrompt:String;
Procedure ViewMsg(MsgNum:LongInt; Var Abort: Boolean);
Procedure WriteMsg(ReplyToNum: LongInt; ForcedDestination, ForcedTitle: String; EMail: Boolean);
Procedure PostMsg(ForcedDestination, ForcedTitle: String);
Procedure SendEMail(ForcedDestination, ForcedTitle: String);
Procedure ReadMsgs(WaitingOnly: Boolean);
Procedure ReplyMsg(MsgNum: LongInt; Public: Boolean);
Procedure NewScanMsgs(Options: String);

Implementation
uses scrlbk;

Function ToUser(TestMsgIdx: MsgIndexRec): Boolean;
Begin
  If MsgNameMatch(TestMsgIdx.ToInfo.UserName, ThisUser.Name, ThisUser.RealName)
    Then ToUser := TRUE Else ToUser := FALSE;
End;

Function WhatAnon(AnonTyp:Byte; s:String) : String;
Begin
  Case AnonTyp Of
    1,2 : s := '**Anonymous**';
    3 : s := '"Abby"';
    4 : s := '"Problemed Person"';
    Else s := s;
  End;
  WhatAnon := s;
End;

Function LoadConfigurablePrompt:String;
Var
 InF:Text;
 FoundFile:Boolean;
 HeaderFile:String;

Begin
  If ThisUser.HeaderNumber>0 then begin
    HeaderFile:=Systat.TextPath+'HEAD'+cstr(ThisUser.HeaderNumber);
    HeaderFile:=GetTextFileName(HeaderFile);
    If HeaderFile='' then FoundFile:=FALSE Else FoundFile:=TRUE;
  End Else FoundFile:=FALSE;
  If FoundFile then begin
    Assign(InF,HeaderFile);
    Reset(InF);
    ReadLn(InF,HeaderFile);
    LoadConfigurablePrompt:=HeaderFile;
    Close(InF);
  End Else LoadConfigurablePrompt:='';
End;

Procedure ViewMsg(MsgNum:LongInt; Var Abort: Boolean); {* Pass Actual .IDX Number *}
Var
 MsgIdx      : MsgIndexRec;
 s1,
 s2,
 Ft,  Ft2,
 Work,
 ReadStr,
 HeaderFile  : String;
 Public,
 SeeAnon,
 FoundFile,
 Next        : Boolean;
 Author,
 Destination,
 Subject     : String[30];
 UserNote    : String[25];
 InF         : Text;
 BodyCount   : Integer;
 TotLen      : LongInt;
 Ft4,
 Ft3,
 QuotePos,
 QuoteColor,
 TxtColor,pass    : Byte;

 function readdelete:boolean;
 var tmp:boolean;
 begin
   tmp:=FALSE;
   if AttrOn(MsgIdx.MsgAttr, Deleted) then
     if (mso) then tmp:=TRUE else tmp:=FALSE
   else tmp:=TRUE;
   readdelete:=tmp;
 end;


Begin
  {$I-} Reset(MsgTxtF,1); {$I+}
  If IOResult <> 0 Then Exit;
  Close(MsgTxtF);

  {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
  If IOResult <> 0 Then Exit;
  Seek(MsgIdxF, MsgNum);
  BlockRead(MsgIdxF, MsgIdx, 1);
  Close(MsgIdxF);

  With MsgIdx Do Begin
    Public := TRUE;

    If Public then seeanon:=aacs(systat.anonpubread) Else seeanon:=aacs(systat.anonprivread);
    If (MsgIdx.Anon=2) then SeeAnon:=aacs(systat.csop);

    If ThisUser.HeaderNumber>0 then begin
      HeaderFile:=Systat.TextPath+'HEAD'+cstr(ThisUser.HeaderNumber);
      HeaderFile:=GetTextFileName(HeaderFile);
      If HeaderFile='' then FoundFile:=FALSE Else FoundFile:=TRUE;
    End Else FoundFile:=FALSE;

    Abort:=FALSE;
    Next:=FALSE;

    Author:=FromInfo.UserName;
    If (not seeanon) then Author:=WhatAnon(MsgIdx.Anon,Author);
    If (ToInfo.UserName='') then Destination:='All' Else Destination:=ToInfo.UserName;
    If (MsgIdx.Anon=0) then UserNote:=FromInfo.UserNote Else UserNote:='';

    Subject:=Copy(Title,1,30);
    Subject:=Subject+Ins(30,Subject);

    If Not FoundFile then
      printacr(#3#9'ķ',abort,next)
    Else begin
      Assign(InF,HeaderFile);
      Reset(InF);
      ReadLn(InF,ReadStr);  {* First Line=Prompt *}
      ReadLn(InF,ReadStr);
      If ReadStr<>'' then Printacr(ReadStr,abort,next);
      ReadLn(InF,ReadStr);
      If ReadStr<>'' then Printacr(ReadStr,abort,next);
    End;

    BodyCount:=1;
    While (Not Abort) and (BodyCount<=3) do begin
      If Not FoundFile then
        Case BodyCount of
          1:begin
            s1:=cstr(Msg_On + 1); s2:=cstr(Msg_Total);
            ft2:=s1+#3#5+' of '+#3#2+s2; for ft3:=length(stripcolor(Ft2)) to 25 do ft2:=ft2+' ';
            ft:=#3#5+#3#9+' '+#3#5+'Message   : '+#3#2+ft2;
            ft:=ft+#3#5+'Posted    : '+#3#2;
            if (seeanon) or (msgidx.anon=0) then ft2:=msgdt(@msgdatetime) else ft2:='  * Unknown *  ';
            for ft3:=length(ft2) to 25 do ft2:=ft2+' ';
            ft:=ft+ft2+#3#9+'';
            printacr(Ft,abort,next);
         end;
       2:begin
           ft:=#3#5+#3#9+' '+#3#5+'From      : '+#3#2;
           ft2:=author; ft4:=length(Ft2);
           if ft4 >= 14 then ft2[0]:=chr(14) else ft2:=ft2+' ';
           ft2:=ft2+#3#9+'['; work:=usernote;
           if ft4 < 14 then
             if length(work) > 8+(14-ft4) then work[0]:=chr(9+(14-ft4))
             else for ft3:=length(work) to 8+(14-ft4) do work:=work+' '
           else
             if length(work) > 8 then work[0]:=chr(8)
             else for ft3:=length(work) to 8 do work:=work+' ';
           ft2:=ft2+#3#5+work+#3#9+']';
           ft:=ft+ft2+#3#5+'To        : '+#3#2;
           ft2:=destination;
           if length(ft2) >= 25 then ft2[0]:=chr(25) else
             for ft3:=length(ft2) to 25 do ft2:=ft2+' ';
           ft:=ft+ft2+#3#9+'';
           printacr(ft,abort,next);
         end;
       3:begin
           ft:=#3#5+#3#9+' '+#3#5+'Subject   : '+#3#2+subject;
           for ft3:=length(stripcolor(ft)) to 79 do ft:=ft+' ';
           ft:=ft+#3#9+'';
           printacr(ft,abort,next);
         end;
(*
       1:PrintAcr(' From: '+Author+' ['+UserNote+']'+Ins(30,Author)
                  +Ins(25,UserNote)+'            ',abort,next);
       2:Begin
          If (SeeAnon) or (MsgIdx.Anon=0) then s1:=msgdt(@MsgDateTime)
          Else s1:='  * Unknown *  ';
          s1:=s1+Ins(15,s1);
          PrintAcr(' To: '+Destination+Ins(30,Destination)+'                    Date: '+s1+' ',Abort,Next);
         End;
       3:Begin
          s1:=cstr(Msg_On + 1);
          s1:='#'+s1;
          While Length(s1)<9 do s1:=' '+s1;
          s2:=cstr(Msg_Total);
          While Length(s2)<4 do s2:=s2+' ';
          PrintAcr(' Subject: '+Subject+'                          '+s1+'/'+s2+' ',Abort,Next);
         End; *)
      End
     Else begin
      ReadLn(InF,ReadStr);
      If ReadStr<>'' then begin
       Work:=ReadStr;

       ReplaceCode('HA',Author,0,Work);
       ReplaceCode('HB',Ins(30,Author),0,Work);

       If SeeAnon Or (MsgIdx.Anon=0) Then s1:=Msgdt(@MsgDateTime)
       Else s1:='  * Unknown *  ';

       ReplaceCode('HD',s1,15,Work);
       ReplaceCode('HF',Destination,0,Work);
       ReplaceCode('HG',Ins(30,Destination),0,Work);
       ReplaceCode('HN',UserNote,0,Work);
       ReplaceCode('HO',Ins(25,UserNote),0,Work);
       ReplaceCode('HR',cstr(Msg_On + 1),4,Work);
       ReplaceCode('HS',Subject,0,Work);
       ReplaceCode('HT',cstr(Msg_Total),4,Work);

       PrintAcr(Work,Abort,Next);
      End;
     End;
     Inc(BodyCount);
    End;

    If Not FoundFile then begin
     printacr(#3#9'Ľ',abort,next);
     printacr('',abort,next);
    End
    Else While (Not Eof(InF)) and (Not Abort) do begin
     ReadLn(InF,ReadStr);
     Printacr(ReadStr,abort,next);
    End;
    If FoundFile then Close(InF);

    If Not Abort then begin
      reading_a_msg:=TRUE; read_with_mci:=FALSE;
      Abort:=FALSE; Next:=FALSE;

      QuoteColor := 5;  TxtColor := 1;
      If MemBoard.MBType In [1,2] Then Begin
       QuoteColor := MemBoard.Quote_Color;
       TxtColor := MemBoard.Text_Color;
      End;

      Reset(MsgTxtF,1);
      Seek(MsgTxtF, MsgIdx.MsgPtr);

      TotLen:=0;
      If (ReadDelete) Then
        Repeat
          BlockReadStr(MsgTxtF, ReadStr);
          Inc(TotLen, Length(ReadStr) + 2);

          QuotePos := Pos('>', StripColor(ReadStr));
          If Not (Pos(^[, ReadStr) > 0) And Not DosAnsiOn Then
            If (QuotePos > 0) And (QuotePos < 5) Then ReadStr := #3+Chr(QuoteColor) + ReadStr + #3+Chr(TxtColor);
          if (okscrollback) and not (pos(#27+'[A',readstr)=1) then addtoscroll(wherey-1);
          PrintAcr(ReadStr, Abort, Next);
          if (okscrollback) and (totlen>=msgidx.msglength) then addtoscroll(wherey-1);
        Until Abort Or (TotLen >= MsgIdx.MsgLength);

      Close(MsgTxtF);
      myscrolly:=wherey;
      read_with_mci:=FALSE;
      reading_a_msg:=FALSE;

      PrintAcr('', Abort, Next);
      If AttrOn(MsgIdx.MsgAttr, Deleted) Then Begin
        PrintAcr(#3#8'Message Deleted', Abort, Next);
        PrintAcr('', Abort, Next);
      End;

      If DosAnsiOn Then RedrawForAnsi;
    End;

  End;
End;


Procedure WriteMsg(ReplyToNum: LongInt; ForcedDestination, ForcedTitle: String; EMail: Boolean);
Var Ok         : Boolean;
    TempMsgIdx,
    MsgIdx     : MsgIndexRec;
    ValidName  : Boolean;
    i,
    UserCount  : Integer;

  Procedure Nope(s:String);
  Begin
   If Ok Then sprint(s);
   Ok:=FALSE;
  End;

  Procedure IncrementOther;
  Var tmpu:userrec; d:boolean;
      tmpuf:file of userrec;
  Begin
    assign(tmpuf,systat.systempath+'USER.LST');
    reset(tmpuf); d:=FALSE;
    while (not (eof (tmpuf))) and (not (d)) do begin
      read(tmpuf,tmpu);
      if ((allcaps(tmpu.name))=allcaps(msgidx.toinfo.username)) then begin
        inc(tmpu.incomingmail);
        seek(tmpuf,filepos(tmpuf)-1); write(tmpuf,tmpu);
        d:=TRUE;
      end;
   end;
   close(tmpuf);
 End;


Begin
  Ok:=TRUE;
  LoadBoard(Board);

  If Not EMail Then Begin
   if (not aacs(memboard.postacs)) then
    nope('Your Access Does Not Allow You To Post On This Board.');
   if ((rpost in thisuser.ac) or (not aacs(systat.normpubpost))) then
    nope('Your Access Privledges Do Not Include Posting.');
   if ((ptoday>=systat.maxpubpost) and (not mso)) then
    nope('Too Many Messages Posted Today.');
  End
  Else Begin
   if ((remail in thisuser.ac) or (not (aacs(systat.normprivpost)))) then
    nope('Your Access Privledges Do Not Include Sending Mail.');
   if ((etoday>=systat.maxprivpost) and (not mso)) then
      nope('Too Much Mail Sent Today Already.');
  End;

  If Ok Then Begin
   ClearMsgIdx(MsgIdx);
   MsgIdx.FromInfo.UserName := ThisUser.Name;
   MsgIdx.FromInfo.UserNote := ThisUser.AccountNote;
   MsgIdx.ToInfo.UserName := ValidUser(ForcedDestination);

   If ReplyToNum <> -1 Then Begin
    {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
    If IOResult <> 0 Then Exit;
    Seek(MsgIdxF, ReplyToNum);
    BlockRead(MsgIdxF, TempMsgIdx, 1);
    Close(MsgIdxF);
    MsgIdx.ToInfo.UserName := TempMsgIdx.FromInfo.UserName;
    If MsgIdx.ToInfo.UserName = '' Then MsgIdx.ToInfo.UserName := ' ';
    MsgIdx.Title := TempMsgIdx.Title;
   End
   Else If MsgIdx.ToInfo.UserName = '' Then Begin
    ValidName := FALSE;
    NL;
    If MemBoard.MsgStatus <> 0 Then sprint(#3#3'Press <CR> to use "All"')
    Else sprint(#3#3'Press <CR> to Abort');
    Repeat
     Prt('To: ');  Mpl(30);
     If MemBoard.MsgStatus <> 0 Then MsgIdx.ToInfo.UserName := 'All'
     Else MsgIdx.ToInfo.UserName := '';
     InputMain(MsgIdx.ToInfo.UserName,30,'DL');

     If MemBoard.MsgStatus = 0 Then Begin
      ForcedDestination := ValidUser(MsgIdx.ToInfo.UserName);

      If ForcedDestination <> '' Then Begin
       ValidName := TRUE;
       For i := 1 to Length(MsgIdx.ToInfo.UserName) Do sprompt(^H' '^H);
       MsgIdx.ToInfo.UserName := ForcedDestination;
       sprompt(MsgIdx.ToInfo.UserName);
      End;

      If MsgIdx.ToInfo.UserName = '' Then ValidName := TRUE; {* Abort *}
     End
     Else ValidName := TRUE;

     NL;
     If Not ValidName then Begin sprint(#3#5'Invalid User Name'); NL; End;
    Until (Hangup) Or (ValidName);
   End;

   If MsgIdx.ToInfo.UserName <> '' Then If Not Hangup Then Begin
    GetPackDateTime(@MsgIdx.MsgDateTime);
    GetPackDateTime(@MsgIdx.MsgPostDateTime);

    If InputMsg(MsgIdx, ForcedTitle) Then Begin
     SysOpLog('+ "'+MsgIdx.Title+'" posted on '+#3#5+memboard.name);
     SysOpLog('  To: "'+MsgIdx.ToInfo.UserName+'"');

     TopScr;

     NL;

     If (MemBoard.MsgStatus=0) Then Inc(ThisUser.EMailSent) Else Inc(ThisUser.MsgPost);
     Inc(PToday);
     Inc(Systat.TodayZLog.PubPost);
     If (MemBoard.MsgStatus=0) And (MemBoard.MBType=0) Then IncrementOther;
     InitMsgFiles(MemBoard.FileName);
    End;
   End;

  End;

End;

Procedure PostMsg(ForcedDestination, ForcedTitle: String);
Begin
 WriteMsg(-1, ForcedDestination, ForcedTitle, FALSE);
End;
(*
Procedure SendEMail(ForcedDestination, ForcedTitle: String);
Var   SavBoard    : Integer;
Begin
 Board := SavBoard;

 If Board <> Systat.EMailBoard Then ChangeBoard(Systat.EMailBoard);
 If Board = Systat.EMailBoard Then WriteMsg(-1, ForcedDestination, ForcedTitle, TRUE);

 SavBoard := Board;
 Board := SavBoard;
 LoadBoard(Board);
End;
*)
Procedure SendEMail(ForcedDestination, ForcedTitle: String);
Var SavBoard : Integer;
Begin
  SavBoard:=Board;

  If Board <> Systat.EMailBoard Then ChangeBoard(Systat.EMailBoard);
  If Board = Systat.EMailBoard Then WriteMsg(-1, ForcedDestination, ForcedTitle, TRUE);

  Board := SavBoard;
  LoadBoard(Board);
End;

Procedure DoRead(Var Quit:Boolean; StartMsgNum:Word; WaitingOnly, IsNewScan: Boolean);  {* Undefined *}
Var Done          : Boolean;
    ValidCmds,
    Cheddar,
    Cheese,
    CmdStr        : String;
    Cheddar2      : Astr;
    Cmd           : Char;

    FirstMsg,
    LastMsg,
    WorkMsgNum,
    GetMsg,
    MsgNum        : LongInt;
    EditAuthorName: String[30];
    EditAuthor,
    TempConf,
    ThreadCode,
    TotLoad       : Integer;
    B,
    Compress,
    PubReply,
    AskPost,
    ContinousList,
    Abort, Ok,
    ShowMsg,
    WasOut,
    ZScanUp       : Boolean;
    MIdx,
    MsgIdx        : MsgIndexRec;
    T             : Text;

  Procedure CBounds;
  Begin
    WasOut:=((MsgNum<0) or (MsgNum>Msg_Total-1));
    If (Not WasOut) Then Exit;
    If (MsgNum>Msg_Total) Then MsgNum:=Msg_Total
      Else If (MsgNum<0) Then MsgNum:=0;
  End;

  Procedure ScanTitles;
  Var MIdx:MsgIndexRec;
      S,Alias:String;
      FTo,FFrom,FTit:String;
      FCtr,FZ1,FZ2,FL,FL2,FL3:Integer;
      J,NumDone:Word;
      Public,SeeAnon,Abort,Next,NDone:Boolean;

  Begin
    fctr:=1; fz1:=0; fz2:=0; ndone:=TRUE; abort:=FALSE; numdone:=0; Public:=TRUE;
    If Public Then SeeAnon:=AACS(Systat.Anonpubread) Else Seeanon:=Aacs(Systat.Anonprivread);
    If (MsgIdx.Anon=2) Then SeeAnon:=Aacs(Systat.csop);
    NL;

    CBounds; If WasOut Then Exit;

    SPrint(#3#1+'Flg/[###] Date     Subject              From            To             ');
    SPrint(#3#9+'    ');
    lil:=2;
    While ((Not HangUp) And (Not Abort) And (NumDone<((thisuser.pagelen)-4)) And (NDone)) Do Begin
    CBounds; If (WasOut) Then NDone:=FALSE;
      If (NDone) Then Begin
        {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
        If IOResult <> 0 Then Exit;
        Seek(MsgIdxF, MsgNum);
        BlockRead(MsgIdxF, MIdx, 1);
        Close(MsgIdxF);
        With MIdx Do Begin
          Alias:=AllCaps(ThisUser.Name);
          FFrom:=FromInfo.UserName;
          If (Not SeeAnon) Then FFrom:=WhatAnon(Anon,FFrom);
          If (ToInfo.UserName='') Then FTo:='All' Else FTo:=ToInfo.UserName;
          If (Copy(AllCaps(FromInfo.UserName),1,Length(Alias))=Alias) Then FZ1:=1;
          If (Copy(AllCaps(ToInfo.UserName),1,Length(Alias))=Alias) Then FZ2:=1;
          S:=#3#5+#3#9+'['+#3#1+Cstr(MsgNum+1)+#3#9+']';
        End;

        Cheese:=MsgDT(@MIdx.MsgDateTime);
        If (Length(Cheese) > 8) Then Cheese[0]:=Chr(8)
        Else For J:=Length(Cheese) To 8 Do Cheese[J]:=' ';
        {Cheese[8]:=' ';}
        If (Cheese[3] <> '/') then Cheese[8]:=' ';
        S:=#3#2+Mrn(S,8)+#3#2+' '+Cheese+' ';

(*        for j:=1 to 6 do dt[j]:=msgdatetime[j];
        s:=#3#2+mrn(s,7)+#3#2+'  '+mrn(cstr(dt.month),2)+'/'+
           tch('0',dt.day)+'/'+copy(tch('0',dt.year),3,2)+' '; *)

(*        if (isnew(msgnum)) then begin
          delete(s,1,4);
          s:=#3#8+' * '+s;
        end *)

        If (IsNewMsg(MIdx)) Then Begin
          Delete(S,1,4);
          S:=#3#8+' * '+S;
        End
        Else If (AttrOn(MIdx.MsgAttr,UnValidated)) Then Begin
          Delete(S,1,4);
          S:=#3#8+'NV '+S;
        End
        Else If (MIdx.ToInfo.UserName = ThisUser.Name) then Begin
          Delete(S,1,4);
          S:=#3#8+' > '+S;
        End Else Begin
          Delete(S,1,4);
          S:='   '+S;
        End;

        If ((Not (AttrOn(MIdx.MsgAttr,UnValidated))) Or (Mso)) Then Begin
          FTit:=MIdx.Title; FL3:=Length(FTit);
          If (FL3 > 20) then FTit[0]:=Chr(20)
            Else Begin
              FCtr:=1;
              While (FCtr < 21) Do Begin
                If (FCtr > FL3) Then FTit:=FTit+' ';
                Inc(FCtr);
              End;
            End;
          S:=S+#3#5+FTit+' ';
        End;

        If ((Not (AttrOn(MIdx.MsgAttr,UnValidated))) Or (Mso)) Then Begin
          FL:=Length(FFrom);
          If (FL > 15) Then FFrom[0]:=Chr(15)
            Else Begin
              FCtr:=1;
              While (FCtr < 16) Do Begin
                If (FCtr > FL) Then FFrom:=FFrom+' ';
                Inc(FCtr);
              End;
            End;
          If (FZ1=1) Then Begin
            S:=S+#3#1+FFrom+' '; FZ1:=0;
          End Else
            S:=S+#3#3+FFrom+' ';
        End;

        If ((Not (AttrOn(MIdx.MsgAttr,UnValidated))) Or (Mso)) Then Begin
          FL2:=Length(FTo);
          If (FL2 > 15) Then FTo[0]:=Chr(15)
            Else Begin
              FCtr:=1;
              While (FCtr < 16) Do Begin
                If (FCtr > FL2) Then FTo:=FTo+' ';
                Inc(FCtr);
              End;
            End;
          If (FZ2=1) Then Begin
            S:=S+#3#5+#3#1+FTo+' '; FZ2:=0;
          End Else
            S:=S+#3#3+FTo+' ';
        End;

        PrintAcr(S,Abort,Next);

        WKey(Abort,Next);
        Inc(NumDone);
        Inc(MsgNum); Inc(Msg_On);
      End;
    lil:=0
    End;
    Dec(MsgNum); Dec(Msg_On);
    NL;
  End;

  Function Threading(Forward:Boolean;TTit:String):Integer;
  Var MIdx:MsgIndexRec;
      MTit:String;
      TempReturn,MNum:Integer;
      Abort,Next,NDone:Boolean;

    Procedure CBound;
    Begin
      WasOut:=((MNum<0) or (MNum>Msg_Total-1));
      If (Not WasOut) Then Exit;
      If (MNum>Msg_Total) Then MNum:=Msg_Total
        Else If (MNum<0) Then MNum:=0;
    End;

    Function Match:Boolean;
    Var Temp:String;
        LthM,LthT,C:Integer;

    Begin
      Match:=FALSE; Temp:='';

      LthM:=Length(MTit); LthT:=Length(Ttit);  (* Set Lengths *)
      Mtit:=allcaps(Mtit); TTit:=allcaps(Ttit); (* Set To Caps *)

      Temp:=MTit;
      If Length(Temp) > 1 Then
        Temp[0]:=Chr(2); (* Remove any RE:'s from the string *)
      If (Temp='RE') then
        delete(Mtit,1,4);

      Temp:=TTit;
      If Length(Temp) > 1 Then
        Temp[0]:=Chr(2); (* Remove any RE:'s from the string *)
      If (Temp='RE') then
        delete(Ttit,1,4);

      If (MTit=TTit) then Match:=TRUE;
    End;


  Begin
    ndone:=TRUE; abort:=FALSE; TempReturn:=-1; MNum:=Msg_On;
    If Forward then Inc(MNum) else Dec(MNum);

    CBound; If WasOut Then Exit;

    While ((Not HangUp) And (Not Abort) And (NDone)) Do Begin
      CBound;
      If (WasOut) Then NDone:=FALSE;
      If (NDone) Then Begin
        {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
        If IOResult <> 0 Then Exit;
        Seek(MsgIdxF, MNum);
        BlockRead(MsgIdxF, MIdx, 1);
        Close(MsgIdxF);

        MTit:=MIdx.Title;
        If Match then begin TempReturn:=MNum; NDone:=FALSE; end;

        WKey(Abort,Next);
        If Forward Then Inc(MNum) Else Dec(MNum);
      End;
    End;
    Threading:=TempReturn;
  End;

  procedure scaninput(var s:string; allowed:string);
  var os:string;
      i:integer;
      c:char;
      gotcmd:boolean;
  begin
    gotcmd:=FALSE; s:='';
    repeat
      getkey(c); c:=upcase(c);
      os:=s;
      if ((pos(c,allowed)<>0) and (s='')) then begin gotcmd:=TRUE; s:=c; end
      else
      if (pos(c,'0123456789')<>0) then begin
        if (length(s)<5) then s:=s+c;
      end
      else
      if ((s<>'') and (c=^H)) then s:=copy(s,1,length(s)-1)
      else
      if (c=^X) then begin
        for i:=1 to length(s) do prompt(^H' '^H);
        s:=''; os:='';
      end
      else
      if (c=#13) then gotcmd:=TRUE;

      if (length(s)<length(os)) then prompt(^H' '^H);
      if (length(s)>length(os)) then prompt(copy(s,length(s),1));
    until ((gotcmd) or (hangup));
    nl;
  end;

  Procedure UpdatePtr;
  Begin
   Reset(MsgIdxF, SizeOf(MsgIndexRec));
   Seek(MsgIdxF, MsgNum);
   BlockRead(MsgIdxF, MsgIdx, 1);
   Close(MsgIdxF);

   If IsNewMsg(MsgIdx) Then Begin
    loadboard(board);
    ZScanm.HiRead := MsgIdx.MsgPostDateTime;
    savezscanm;
    ZscanUp := TRUE;
   End;
  End;

  Procedure ToggleAttr(Attribute: Word; OnStr, OffStr: String);
  Begin
   Reset(MsgIdxF, SizeOf(MsgIndexRec));
   Seek(MsgIdxF, MsgNum);
   BlockRead(MsgIdxF, MsgIdx, 1);

   NL;
   If Not AttrOn(MsgIdx.MsgAttr, Attribute) Then Begin
    SetAttr(MsgIdx.MsgAttr, Attribute, TRUE);
    sprint(#3#5+OnStr);
   End
   Else Begin
    SetAttr(MsgIdx.MsgAttr, Attribute, FALSE);
    sprint(#3#5+OffStr);
   End;
   NL;

   Seek(MsgIdxF, MsgNum);
   BlockWrite(MsgIdxF, MsgIdx, 1);
   Close(MsgIdxF);
  End;

  Procedure CheckBounds;

   Procedure LastMessage;
   Begin
    WorkMsgNum := MsgNum;
    Dec(WorkMsgNum);
    Seek(MsgIdxF, WorkMsgNum);
    BlockRead(MsgIdxF, MsgIdx, 1);

    While Not ToUser(MsgIdx) And (WorkMsgNum > 0) Do Begin
     Dec(WorkMsgNum);
     Seek(MsgIdxF, WorkMsgNum);
     BlockRead(MsgIdxF, MsgIdx, 1);
    End;

    If ToUser(MsgIdx) Then Begin
     MsgNum := WorkMsgNum;
     If Compress Then Dec(Msg_On) Else Msg_On := MsgNum;
    End;
   End;

   Procedure NextMessage;
   Begin
    WorkMsgNum := MsgNum;
    Inc(WorkMsgNum);
    Seek(MsgIdxF, WorkMsgNum);
    BlockRead(MsgIdxF, MsgIdx, 1);

    While Not ToUser(MsgIdx) And (WorkMsgNum < HiMsg) Do Begin
     Inc(WorkMsgNum);
     Seek(MsgIdxF, WorkMsgNum);
     BlockRead(MsgIdxF, MsgIdx, 1);
    End;

    If ToUser(MsgIdx) And (MsgNum <> WorkMsgNum) Then Begin
     MsgNum := WorkMsgNum;
     If Compress Then Inc(Msg_On) Else Msg_On := MsgNum;
    End
    Else Begin
     If Not ContinousList Then Done := TRUE
     Else ContinousList := FALSE;
    End;
   End;

  Begin
   ShowMsg := FALSE;

   If Not WaitingOnly Then Begin
    If GetMsg <> 0 Then Begin
     If (GetMsg = -3) Then Dec(MsgNum)
     Else If (GetMsg = -1) Then Inc(MsgNum)
     Else If (GetMsg > 0) Then MsgNum := GetMsg - 1;

     Msg_On := MsgNum;
     ShowMsg := TRUE;

     If ((MsgNum < 0) Or (MsgNum > HiMsg)) Then Begin
      If Not ContinousList Then Done := TRUE
      Else ContinousList := FALSE;
     End;

    End;
   End

   Else Begin
    Reset(MsgIdxF, SizeOf(MsgIndexRec));

    If GetMsg <> 0 Then Begin

     If (GetMsg = -3) And (MsgNum > 0) Then LastMessage
     Else If (GetMsg = -1) And (MsgNum < HiMsg) Then NextMessage

     Else If (GetMsg > 0) And (GetMsg <= Msg_Total) Then Begin
      If (GetMsg <= LastMsg + 1) And (GetMsg > Msg_On + 1) Then
       Repeat NextMessage; Until Done Or (Msg_On + 1 >= GetMsg)
      Else If (GetMsg >= FirstMsg + 1) And (GetMsg < Msg_On + 1) Then
       Repeat LastMessage; Until Done Or (Msg_On + 1 <= GetMsg)
      Else If (GetMsg > LastMsg + 1) Then NextMessage
      Else If (GetMsg < LastMsg + 1) Then LastMessage;
     End

     Else If (MsgNum > HiMsg) Or ((GetMsg = -1) And (MsgNum = HiMsg)) Then Begin
      If Not ContinousList Then Done := TRUE
      Else ContinousList := FALSE;
     End;

     ShowMsg := TRUE;
    End;

    Close(MsgIdxF);
   End;

   GetMsg := 0;
  End;

  Procedure ScanFirstLast;
  Begin
   If WaitingOnly Then Begin
    Reset(MsgIdxF, SizeOf(MsgIndexRec));
    Seek(MsgIdxF, MsgNum);
    BlockRead(MsgIdxF, MsgIdx, 1);
    While Not ToUser(MsgIdx) And (MsgNum < HiMsg) Do Begin
     BlockRead(MsgIdxF, MsgIdx, 1);
     Inc(MsgNum);
    End;

    If Not Compress Then Begin
     Msg_On := MsgNum;
     FirstMsg := MsgNum;
    End
    Else FirstMsg := 0;

    If Not ToUser(MsgIdx) Then Begin
     Done := TRUE; AskPost := FALSE;
     NL;
     sprint(#3#5'No Waiting Messages');
     NL;
    End
    Else Begin
     LastMsg := MsgNum;
     WorkMsgNum := HiMsg;
     While (WorkMsgNum > MsgNum) And (LastMsg = MsgNum) Do Begin
      Seek(MsgIdxF, WorkMsgNum);
      BlockRead(MsgIdxF, MsgIdx, 1);
      If ToUser(MsgIdx) Then LastMsg := WorkMsgNum;
      Dec(WorkMsgNum);
     End;
    End;

    Close(MsgIdxF);
   End

   Else Begin
    FirstMsg := Msg_On;
    LastMsg := Msg_Total;
   End;
  End;

  Procedure MsgTotal;

  Begin
   If Compress And WaitingOnly Then Msg_Total := GetMsgTotal(ThisUser.Name, ThisUser.RealName)
   Else Msg_Total := HiMsg + 1;
  End;

Begin

 Done := FALSE; Quit := FALSE; Abort := FALSE;
 ContinousList := FALSE; AskPost := TRUE;
 ZScanUp := FALSE;
 Compress := MemBoard.MsgStatus = 0;

 If (MemBoard.MsgStatus = 0) And (Not MSo Or IsNewScan) Then WaitingOnly := TRUE;

 MsgNum := StartMsgNum;

 If Compress And WaitingOnly Then Begin
  Msg_On := 0;
  Reset(MsgIdxF, SizeOf(MsgIndexRec));
  For WorkMsgNum := MsgNum -1 DownTo 0 Do Begin
   Seek(MsgIdxF, WorkMsgNum);
   BlockRead(MsgIdxF, MsgIdx, 1);
   If ToUser(MsgIdx) Then Inc(Msg_On);
  End;
  Close(MsgIdxF);
 End
 Else Msg_On := MsgNum;

 MsgTotal;
 ScanFirstLast;

 GetMsg := -2;

 While Not Done And Not Hangup Do Begin
  CheckBounds;

  If Not Done Then Begin
   If ShowMsg Then Begin
    If ThisUser.ClsMsg And Not ContinousList Then Cls;
    ViewMsg(MsgNum, Abort);
    UpdatePtr;
   End;

   If ContinousList And Not Abort Then
    If MsgNum = HiMsg Then Abort := TRUE;

   If Not ContinousList Or Abort Then Begin
    If ContinousList Then Begin
     ContinousList := FALSE;
     NL;
     sprint(#3#3'Continuous Message Listing Off');
     NL;

    End;

    sprompt(fstring.scanmessage); (* CONFIG. PROMPT GOES HERE *)
    ValidCmds := '-=ACDEHNPQRTZ?\{}';
    if mso then validcmds:=validcmds+'X';
    if mso and (memboard.mbtype in [1,2]) then validcmds := validcmds + 'SK';
    if mso and (memboard.msgstatus <> 0) then validcmds := validcmds + '!V';
    ScanInput(CmdStr, ValidCmds);
   End
   Else CmdStr := '';

   If CmdStr = '' Then CmdStr := '=';
   GetMsg := Value(CmdStr);
   If (GetMsg = 0) Then Cmd := CmdStr[1]
   Else Cmd := #0;

   Case Cmd Of
    '-':Begin
         If (MsgNum = FirstMsg) Or (MsgNum = 0) Or (Msg_On = 0) Then Begin
          NL;
          sprint(#3#5'You are at the first message.');
          NL;
         End
         Else GetMsg := -3;
        End;
    '=':GetMsg := -1;
    'A':GetMsg := -2; {* Ignore & Re-Display *}
    'C':Begin
         ContinousList := TRUE; Abort := FALSE;
         GetMsg := -1;
         NL;
         sprint(#3#3'Continuous Message Listing On');
         NL;
        End;
    'D':Begin
         Reset(MsgIdxF, SizeOf(MsgIndexRec));
         Seek(MsgIdxF, MsgNum);
         BlockRead(MsgIdxF, MsgIdx, 1);
         Close(MsgIdxF);
         If WaitingOnly Or Mso Or MsgNameMatch(MsgIdx.FromInfo.UserName, ThisUser.Name, ThisUser.RealName) Then Begin
          If Not AttrOn(MsgIdx.MsgAttr, Permanent) Then ToggleAttr(Deleted, 'Message Deleted', 'Message UnDeleted')
          Else Begin NL; sprint(#3#5'This Message Is Permanent'); NL; End;
         End
         Else Begin NL; sprint(#3#5'Insufficient Access'); NL; End;
        End;

    'E':if thisuser.sl>=250 then begin
{           Reset(MsgIdxF, SizeOf(MsgIndexRec));
           Seek(MsgIdxF, MsgNum);
           BlockRead(MsgIdxF, MsgIdx, 1);
           Close(MsgIdxF);
           EditAuthorName := MsgIdx.FromInfo.UserName;    }
           Search4user(MsgIdx.FromInfo.UserName, EditAuthor);
           EditUsers(EditAuthor);      { User Editor w/ Current Poster }
        End;

    'H':Begin
         Reset(MsgIdxF, SizeOf(MsgIndexRec));
         Seek(MsgIdxF, MsgNum);
         BlockRead(MsgIdxF, MsgIdx, 1);
         Close(MsgIdxF);
         loadboard(board);
         zscanm.hiread:=Msgidx.MsgPostDateTime;
         SaveZScanm;
         NL;
         sprint(#3#5'Hi-Message Pointer Set To Message #'+cstr(Msg_On + 1));
         NL;
        End;
    'N':Begin
         Done := TRUE;
         AskPost := FALSE;
        End;
    'P':Begin
         PostMsg('', '');
         NL;
         MsgTotal;
        End;
    'Q':Begin
         Quit := TRUE;
         Done := TRUE;
        End;
    'R':Begin
         NL;
         PubReply := TRUE;
         ReplyMsg(MsgNum, PubReply);
         NL;
         MsgTotal;
        End;
    'T':if memboard.msgstatus<>0 then ScanTitles else
          sprint('^7Title Scan Not Available In Private Mail.');
    '{':Begin
          If (Msg_On=0) Then
            sprint('^7Can''t Scan In This Direction!')
          else begin
            Reset(MsgIdxF, SizeOf(MsgIndexRec));
            Seek(MsgIdxF, MsgNum);
            BlockRead(MsgIdxF, MsgIdx, 1);
            Close(MsgIdxF);
            ThreadCode:=-1; ThreadCode:=Threading(FALSE,MsgIdx.Title);
            If ThreadCode>-1 then begin
              Msg_On:=ThreadCode; MsgNum:=ThreadCode;
              GetMsg:=-2;
            end else sprint('^7This Is The First Message In This Chain.');
          end;
        end;
    '}':Begin
          If (Msg_On=Msg_Total-1) Then
            sprint('^7Can''t Scan In This Direction!')
          else begin
            Reset(MsgIdxF, SizeOf(MsgIndexRec));
            Seek(MsgIdxF, MsgNum);
            BlockRead(MsgIdxF, MsgIdx, 1);
            Close(MsgIdxF);
            ThreadCode:=-1; ThreadCode:=Threading(TRUE,MsgIdx.Title);
            If ThreadCode>-1 then begin
              Msg_On:=ThreadCode; MsgNum:=ThreadCode;
              GetMsg:=-2;
            end else sprint('^7This Is The Last Message In This Chain.');
          end;
        end;
    'X':if (mso) then begin
          nl;
          prt('Filename for Message [MSGEXT.TXT]: ');
          input(cheddar,40);
          if (cheddar='') then cheddar:='MSGEXT.TXT';
          if pynq('Write Message To File') then begin
            b:=pynq('Strip Color Codes From File');

            Reset(MsgTxtF,1);
            Seek(MsgTxtF, MsgIdx.MsgPtr);

            assign(t,cheddar);
            {$I-} append(t); {$I+}
            if (ioresult<>0) then rewrite(t);
            totload:=0;
            repeat
              BlockReadStr(MsgTxtF,cheddar);
              inc(totload,length(cheddar)+2);
              if ((b) and (pos(#3,cheddar)<>0)) then cheddar:=stripcolor(cheddar);
              writeln(t,cheddar);
            until (totload>=MsgIdx.msglength);
            close(MsgTxtF);
            close(t);

            nl;
            print('<Burp> Done.');
          end;
        end;
    '\':begin
          nl;
          cheddar:=systat.textpath+'MSGDLTMP.TXT';
          cheddar2:=cheddar;
          b:=pynq('Strip Color Codes From Message');

          Reset(MsgTxtF,1);
          Seek(MsgTxtF, MsgIdx.MsgPtr);

          assign(t,cheddar);
          {$I-} append(t); {$I+}
          if (ioresult<>0) then rewrite(t);
          totload:=0;
          repeat
            BlockReadStr(MsgTxtF,cheddar);
            inc(totload,length(cheddar)+2);
            if ((b) and (pos(#3,cheddar)<>0)) then cheddar:=stripcolor(cheddar);
            writeln(t,cheddar);
          until (totload>=MsgIdx.msglength);
          close(MsgTxtF);
          close(t);
          erase(t);
          nl;
          send1(cheddar2,ok,abort);
        end;
    'Z':Begin
         NL;
         If checkzscanm(Board) Then Begin
           loadboard(board);
           zscanm.zscan:=false;
           savezscanm;
           sprint(#3#5+StripColor(MemBoard.Name)+' will NOT be Scanned');
         End Else Begin
           loadboard(board);
           zscanm.zscan:=true;
           savezscanm;
           sprint(#3#5+StripColor(MemBoard.Name)+' WILL be Scanned');
         End;
         NL;
        End;
    '!':ToggleAttr(Permanent, 'Message Permanent', 'Message Not Permanent');
    'S':ToggleAttr(Scanned, 'Message Scanned', 'Message UnScanned');
    'V':ToggleAttr(UnValidated, 'Message UnValidated', 'Message Validated');
    'K':ToggleAttr(DelSent, 'Message will be Deleted', 'Message will be Saved');
    '?':Begin
         NL;
         sprint('^9[^2#^9] ^1Goto Message        ^9[^2-^9] ^1Previous Message    ^9[^2=/CR^9] ^1Next Message');
         sprint('^9[^2A^9] ^1Re-Display Message  ^9[^2C^9] ^1Continous List      ^9[^2H^9] ^1Set Hi-Msg Pointer');
         sprint('^9[^2R^9] ^1Reply To Message    ^9[^2P^9] ^1Post Message        ^9[^2D^9] ^1(Un)Delete Message');
         sprint('^9[^2T^9] ^1Scan Titles         ^9[^2N^9] ^1Jump To Next Board  ^9[^2Z^9] ^1Toggle New/QWK Scan');
         sprint('^9[^2\^9] ^1Download Message    ^9[^2{^9] ^1Thread Backwards    ^9[^2}^9] ^1Thread Foreward');
         sprint('^9[^2Q^9] ^1Quit');
         if mso and (memboard.msgstatus <> 0) then begin
           sprint('^9[^2!^9] ^1Permanent           ^9[^2V^9] ^1Validated           ^9[^2X^9] ^1Extract To File');
         end;
         if mso and (memboard.msgstatus = 0) then begin
           sprint('^9[^2X^9] ^1Extract To File');
         end;
         if mso and (memboard.mbtype in [1,2]) then begin
          sprint('^9[^2S^9] ^1Net-Scanned         ^9[^2K^9] ^1Delete After Sent'); {^2[^3F^2] ^4Modify Fido Attributes}
         end;
         if (thisuser.sl>=250) then sprint('^9[^2E^9] ^1Edit Author');
         nl;
        End;
   End;

  End;

 End; {* While Do Loop *}

 If AskPost And (Not Quit) And (aacs(MemBoard.PostACS))
      And ((Not (rpost in thisuser.ac)) and (ptoday<systat.maxpubpost)) Then Begin
  NL;
  If Pynq('Post On '+MemBoard.Name+'') Then PostMsg('', '');
 End;
 If (Memboard.MsgStatus=0) And (MemBoard.MbType=0) Then Thisuser.IncomingMail:=Msg_Total;
End;


Procedure ReadMsgs(WaitingOnly: Boolean);
Var Quit : Boolean;
Begin
  LoadBoard(Board);
  if (memboard.msgstatus=0) and (connectspd<>'KB') then waitingonly:=TRUE;
  InitMsgFiles(MemBoard.FileName);
  If HiMsg <> -1 Then DoRead(Quit, 0, WaitingOnly, FALSE)
    Else sprint('No Messages On '+memboard.name+#3#3+'.');
End;


Procedure ReplyMsg(MsgNum: LongInt; Public: Boolean);
Var QuoteF  : Text;
    MsgIdx  : MsgIndexRec;
    TotLen  : LongInt;
    ReadStr : String;

Begin
  Assign(QuoteF, 'MSGTMP');
  Rewrite(QuoteF);

  {$I-} Reset(MsgTxtF,1); {$I+}
  If IOResult <> 0 Then Exit;
  Close(MsgTxtF);

  {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
  If IOResult <> 0 Then Exit;
  Seek(MsgIdxF, MsgNum);
  BlockRead(MsgIdxF, MsgIdx, 1);
  Close(MsgIdxF);

  Reset(MsgTxtF,1);
  Seek(MsgTxtF, MsgIdx.MsgPtr);
  TotLen:=0;
  Repeat
    BlockReadStr(MsgTxtF, ReadStr);
    Inc(TotLen, Length(ReadStr) + 2);
    WriteLn(QuoteF, '> '+StripColor(ReadStr));
  Until TotLen >= MsgIdx.MsgLength;

  Close(MsgTxtF);
  Close(QuoteF);

  WriteMsg(MsgNum, '', '', FALSE);
  NL;
End;


Procedure NewScanMsgs(Options:String);
Var SavBoard    : Integer;
    Next,
    Quit        : Boolean;
    MsgNum      : LongInt;
    MsgIdx      : MsgIndexRec;
    WaitingOnly : Boolean;

 Procedure NewScanBoard(BoardNumber: Integer);
 Begin
  If Not Quit Then Begin
    If Board <> BoardNumber Then ChangeBoard(BoardNumber);
    If Board = BoardNumber Then Begin
      WaitingOnly := MemBoard.MsgStatus = 0;
      lil := 0;
      BlockAbort:=TRUE; PrintF('NEWSCANM');

      InitMsgFiles(MemBoard.FileName);

      If HiMsg > -1 Then Begin
        MsgNum := 0;

        Reset(MsgIdxF, SizeOf(MsgIndexRec));
        BlockRead(MsgIdxF, MsgIdx, 1);

        While (MsgNum < HiMsg) And Not (IsNewMsg(MsgIdx) And ((Not WaitingOnly) Or ToUser(MsgIdx))) Do Begin
          Inc(MsgNum);
          BlockRead(MsgIdxF, MsgIdx, 1);
        End;

        Close(MsgIdxF);

        If (MsgNum <= HiMsg) And (IsNewMsg(MsgIdx) And ((Not WaitingOnly) Or ToUser(MsgIdx)))
        Then DoRead(Quit, MsgNum, FALSE, TRUE);

      End;
    End;
    WKey(Quit, Next);
  End;
 End;

 Procedure NewScanAllBoards;
 Var b:longint;
 Begin
   NodeUpDate('NewScanning ALL Message Boards');
   SysOpLog('NewScan of All Message Boards in Current Conference');
   quit:=false;
   b:=1;
   while (b<=numboards) and (not quit) and (not hangup) do begin
     If checkzscanm(mconfpk^[b]) Then NewScanBoard(mconfpk^[b]);
     inc(b);
   end;
   NodeUpDate('Available for Page');
 End;

Begin
 SavBoard := Board;
 Options := AllCaps(Options);
 Quit := FALSE; Next := FALSE;
 If Options = 'C' Then NewScanBoard(board)
 Else If Options = 'G' Then NewScanAllBoards
 Else If Value(Options) > 0 Then NewScanBoard(Value(Options))
 Else Begin
  If Pynq('NewScan All Areas') Then NewScanAllBoards Else NewScanBoard(Board);
 End;

 Board := SavBoard;
 LoadBoard(Board);
End;

End.
