{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : MSG0.PAS                                                      
  Description: Low-Level Message Base Handling Procedures                    
  Version    : v0.2000                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B-,E+,F+,I+,L-,N-,O+,R-,S+,V-}

Unit Msg0;

Interface

Uses Crt,
     Common,
     Doors;

Procedure BlockReadStr(Var F:File; Var S:String);
Procedure BlockWriteStr(Var F:File; S:String);
Procedure DumpMsg(MsgIdx:MsgIndexRec; InFileName, BoardFileName:String);
Procedure InitMsgFiles(FName:String);
Procedure ClearMsgIdx(Var MsgIdx:MsgIndexRec);
Function InputMsg(Var MsgIdx:MsgIndexRec; ForcedSubject:String) : Boolean;
Function GetMsgTotal(Name1, Name2: String): LongInt;
Function IsNewMsg(MsgIdx: MsgIndexRec): Boolean;

Implementation

Uses File2, File8, FSE;

Procedure BlockReadStr(Var F:File; Var S:String);
Begin
 BlockRead(F,S[0],1);    { Filler Character }
 If Ord(S[0])=$FF Then
 Begin
  BlockRead(F,S[0],1);
  BlockRead(F,S[1],Ord(S[0]));
 End;
End;

Procedure BlockWriteStr(Var F:File; S:String);
Var bb : Byte;
Begin
 bb := $FF;
 BlockWrite(F, bb, 1);
 BlockWrite(F, s[0], 1);
 BlockWrite(F, s[1], Ord(s[0]));
End;

Procedure DumpMsg(MsgIdx:MsgIndexRec; InFileName, BoardFileName:String);
Var InF   : Text;
    InStr : String;
Begin
 If (InFileName = '') Then Exit;
 Assign(InF, InFileName);
 {$I-} Reset(InF); {$I+}
 If (IOResult <> 0) Then Exit;

 InitMsgFiles(BoardFileName);

 Reset(MsgTxtF,1);
 MsgIdx.MsgPtr := FileSize(MsgTxtF);

 Seek(MsgTxtF, MsgIdx.MsgPtr);

 MsgIdx.MsgLength := 0;
 While Not Eof(InF) Do Begin
  ReadLn(InF, InStr);
  Inc(MsgIdx.MsgLength, Length(InStr) + 2);
  BlockWriteStr(MsgTxtF, InStr);
 End;

 Close(InF);
 Close(MsgTxtF);

 Reset(MsgIdxF, SizeOf(MsgIndexRec));
 Seek(MsgIdxF, FileSize(MsgIdxF));
 BlockWrite(MsgIdxF, MsgIdx, 1);
 Close(MsgIdxF);
End;

Procedure InitMsgFiles(FName:String);
Begin
 FName := AllCaps(FName);

 Assign(MsgIdxF, Systat.MsgPath + FName + '.IDX');
 {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
 If IOResult <> 0 Then Rewrite(MsgIdxF, SizeOf(MsgIndexRec));
 HiMsg := FileSize(MsgIdxF)-1;
 Close(MsgIdxF);

 Assign(MsgTxtF, Systat.MsgPath + FName + '.MTX');
 {$I-} Reset(MsgTxtF,1); {$I+}
 If IOResult <> 0 Then Rewrite(MsgTxtF, 1);
 Close(MsgTxtF);

End;

Procedure ClearMsgIdx(Var MsgIdx:MsgIndexRec);
Var b : Byte;
Begin
  With MsgIdx Do Begin
   MsgPtr := 0;
   MsgLength := 0;
   MsgAttr := 0;
   FidoAttr := 0;
   Cost := 0;
   Anon := 0;
   ReplyTo := 0;
   NextReply := 0;
   TimesRead := 0;

   For b := 1 To 6 Do MsgPostDateTime[b]:=0;
   For b := 1 To 6 Do MsgDateTime[b]:=0;

   FromInfo.Zone := 0;
   FromInfo.Net := 0;
   FromInfo.Node := 0;
   FromInfo.Point := 0;
   FromInfo.UserName := '';
   FromInfo.UserNote := '';

   ToInfo.Zone := 0;
   ToInfo.Net := 0;
   ToInfo.Node := 0;
   ToInfo.Point := 0;
   ToInfo.UserName := '';

   Title := '';
   For b := 1 To SizeOf(MsgIndexRec_FutureExpansion) Do MsgIndexRec_FutureExpansion[b]:=0;
  End;
End;

Function InputMsg(Var MsgIdx:MsgIndexRec; ForcedSubject:String) : Boolean;
Var MsgFile     : Text;
    MsgInfoFile : Text;
    Subject     : String;
    Upload      : Boolean;

 Procedure MsgUpload;
 Var
  NoSpace,Ok,kabort,addbatch:boolean;
  SourceFile:String;
 Begin
  If Exist('MSGTMP') then Erase(MsgFile);
  If ConnectSpd='KB' then begin
   NL;
   Prt('File:  ');  Mpl(60);
   Input(SourceFile,60);
   If (SourceFile <> '') Then CopyFile(Ok,NoSpace,FALSE,SourceFile,'MSGTMP');
  End
  Else begin
   Ok:=TRUE;  KAbort:=TRUE;  AddBatch:=FALSE;
   Receive1('MSGTMP',TRUE,false,Ok,kabort,addbatch);
  End;
 End;


 Function DoFirst : Boolean;
 Begin
  DoFirst := FALSE;

  If ForcedSubject = '' Then Begin
   NL;
   If (Subject <> '') Then Begin
    If AllCaps(Copy(Subject,1,3)) <> 'RE:' Then Subject := 'Re: ' + Subject;
    sprint(#3#3'Press <CR> to use "'+Subject+'"');
   End;

   Prt('Subject: ');  Mpl(30);
   InputMain(Subject,30,'DL');
   If Subject <> '' Then NL;
  End
  Else Subject := ForcedSubject;

  If Subject='' then Begin sprint('Aborted.'); NL; End Else Begin
   NL;
   Upload := Pynq('Upload A Pre-Written Message');

   If Upload then MsgUpload Else Begin
    Rewrite(MsgInfoFile);
    If (MBRealName IN MemBoard.MBStat) then WriteLn(MsgInfoFile,ThisUser.RealName)
    Else WriteLn(MsgInfoFile,ThisUser.Name);         {* By *}
    WriteLn(MsgInfoFile,MsgIdx.ToInfo.UserName);     {* To *}
    WriteLn(MsgInfoFile,Subject);                    {* Re *}
    Close(MsgInfoFile);
   End;

   DoFirst := TRUE;
  End;

 End;

 Procedure CleanUp;
 Begin
  If (Exist('MSGTMP')) then begin
   {$I-} Reset(MsgFile); {$I+}
   If (IOResult = 0) then begin
    Close(MsgFile);
    Erase(MsgFile);
   End;
  End;
  If (Exist('MSGINF')) then begin
   {$I-} Reset(MsgInfoFile); {$I+}
   If (IOResult = 0) then begin
    Close(MsgInfoFile);
    Erase(MsgInfoFile);
   End;
  End;
 End;

    function getaddr(zone,net,node,point:integer):string;
    Var
     TempStr:string;
    begin
     TempStr:=cstr(zone)+':'+cstr(net)+'/'+cstr(node);
     If (point<>0) then TempStr:=TempStr+'.'+cstr(point);
     GetAddr:=TempStr;
    end;

  function getorigin:string;
  var s:astr;
  begin
    if (memboard.origin<>'') then s:=memboard.origin
      else if (Network.origin<>'') then s:=Network.origin
        else s:=copy(stripcolor(systat.bbsname),1,50);
    while (copy(s,length(s),1)=' ') do
      s:=copy(s,1,length(s)-1);
    getorigin:=s;
  end;


 Function InputMessage : Boolean;
 Var OutFile : Text;
     s       : String;
     c       : Char;
     saveit  : boolean;
 Begin
  saveit:=true;
  InputMessage:=FALSE;
  If (Freek(ExDrv(Systat.MsgPath))<Systat.MinSpaceForPost) then begin
   NL;
   sprint(#3#5'Not enough disk space to save a message.');
   c:=chr(exdrv(systat.msgpath)+64);
   If (c='@') then sysoplog(#3#8+'>>>>'+#3#3+' Main BBS drive full!  Insufficient space to save a message!')
     else sysoplog(#3#8+'>>>>'+#3#3+' '+c+': drive full!  Insufficient space to save a message!');
  End Else begin
    If Not Upload then begin
      if exist(systat.externaleditor) then begin
        if not pynq('Do You Want To Use The External Editor') then saveit:=ansireedit(memboard.maxfselines) else
          DoDoorFunc('D',Systat.ExternalEditor+' '+cstr(NodeNumber)+' '+cstr(ModemR.ComPort)+' '+cstr(Value(ConnectSpd)));
      end else saveit:=ansireedit(memboard.maxfselines);
      NL;
      NL;
    End;

    NL;

   {$I-} Reset(MsgFile); {$I+}
   If (IOResult=0) and (saveit) then begin
    InputMessage:=TRUE;
    Append(MsgFile);
    If (MemBoard.MBType IN [1,2]) and (MBAddTear IN MemBoard.MBStat) then With MemBoard do begin
     WriteLn(MsgFile);
     s:=#3+chr(tear_color)+'--- '+softwarename+' v'+ver+verstatus;
     writeln(MsgFile,s);
     s:=#3+chr(origin_color)+' * Origin: '+getorigin+' (';
     s:=s+getaddr(zone,net,node,point);
     s:=s+')';
     writeln(MsgFile,s);
    End;
    Close(MsgFile);

    sprint(#3#5'Saving Message.');
    Assign(OutFile,'MSGTMP$$');
    Rewrite(OutFile);
    {$I-} Reset(MsgFile); {$I+}
    While Not Eof(MsgFile) Do Begin
     Read(MsgFile,c);

     If c=#141 Then Begin
      WriteLn(OutFile);
      Read(MsgFile,c);  {* Filler *}
     End
     Else If (c=^M) Then WriteLn(OutFile)
     Else If (c<>^J) Then Write(OutFile,c);
    End;
    Close(MsgFile);
    Close(OutFile);
    Erase(MsgFile);
    Rename(OutFile,'MSGTMP');
   End;

  End;
 End;

Begin
 InputMsg:=FALSE;
 Assign(MsgFile,'MSGTMP');
 Assign(MsgInfoFile,'MSGINF');
 Subject := MsgIdx.Title;

{ If Public then} 
  If (RValidate In ThisUser.AC) then SetAttr(MsgIdx.MsgAttr, UnValidated, TRUE);

 If DoFirst And Not Hangup Then Begin
  If InputMessage Then Begin
   MsgIdx.Title := Subject;
   DumpMsg(MsgIdx, 'MSGTMP', MemBoard.FileName);
   InputMsg := TRUE;
  End
  Else sprint(#3#5'Message Aborted.');
  CleanUp;
 End;
End;

Function GetMsgTotal(Name1, Name2: String): LongInt;
Var WorkTotal : LongInt;
    MsgIdx    : MsgIndexRec;
Begin
 WorkTotal := 0;

  {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
  If IOResult = 0 Then Begin
   Repeat
    BlockRead(MsgIdxF, MsgIdx, 1);
    If MsgNameMatch(MsgIdx.ToInfo.UserName, Name1, Name2)
      { And Not AttrOn(MsgIdx.MsgAttr, Deleted)} Then Inc(WorkTotal);
   Until Eof(MsgIdxF);
   Close(MsgIdxF);
  End;

 GetMsgTotal := WorkTotal;
End;

Function IsNewMsg(MsgIdx: MsgIndexRec): Boolean;
Var l1,
    l2,
    l3     : LongInt;

  Function zzzb(xx,yy: LongInt): LongInt;
  Begin
   xx:=xx shl yy;
   zzzb:=xx;
  End;

Begin
 IsNewMsg := FALSE;

 With MsgIdx Do
  With ZScanm do begin
    l1:=zzzb(MsgPostDateTime[1],16);
    inc(l1,zzzb(MsgPostDateTime[2],8));
    inc(l1,MsgPostDateTime[3]);
    l2:=zzzb(hiread[1],16);
    inc(l2,zzzb(hiread[2],8));
    inc(l2,hiread[3]);
    if (l1<l2) then exit;
    if (l1=l2) then begin
      l1:=zzzb(MsgPostDateTime[4],16);
      inc(l1,zzzb(MsgPostDateTime[5],8));
      inc(l1,MsgPostDateTime[6]);
      l2:=zzzb(hiread[4],16);
      inc(l2,zzzb(hiread[5],8));
      inc(l2,hiread[6]);
      if (l1<=l2) then Exit;
    end;
    IsNewMsg:=TRUE;
  End;

End;


End.
