{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : MISC4.PAS                                                     
  Description: Infoform/Questionnaire System                                 
  Version    : v0.2000                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
Unit Misc4;

Interface

Uses
  crt, dos, overlay,
  doors, misc3,
  common;

Procedure AskInfoform(InfoFormFile:String);
Procedure ShowInfoform(InfoFormFile:String);

procedure readq(filen:astr; infolevel:integer);
procedure readasw(usern:integer; fn:astr);
procedure readasw1(fn:astr);

Implementation

Procedure AskInfoform(InfoFormFile:String);
Var
 InF,OutF1,OutF2:Text;
 ps,ns,es:Astr;
 OutFName:String;
 ReadStr:String;
 ReadChar:Char;
 InputStr:String;
 InLenStr:String[2];
 InLen:Integer;

 Procedure DumpInfoForm;   {* Move OutF1 (Temp File) to OutF2 (.ASW file) *}
 Begin
  If Hangup then Erase(OutF1)
  Else begin
   Reset(OutF1);
   {$I-} Append(OutF2); {$I+}
   If (IOResult<>0) then Rewrite(OutF2);

   While Not Eof(OutF1) do begin
    Read(OutF1,ReadChar);
    Write(OutF2,ReadChar);
   End;

   Close(OutF1);
   Close(OutF2);
   Erase(OutF1);
  End;
 End;

Begin
 If (not exist(InfoFormFile)) then begin
  FSplit(InfoFormFile,ps,ns,es);
  InfoFormFile:=ps+ns+'.INF';
  If (not exist(InfoFormFile)) then begin
   InfoFormFile:=systat.TextPath+ns+'.INF';
   If (not exist(InfoFormFile)) then begin
    SysOpLog('** InfoForm not found: "'+InfoFormFile);
    Print('** InfoForm not found: "'+InfoFormFile);
    Exit;
   End;
  End;
 End;

 Assign(InF,InfoFormFile);
 {$I-} Reset(InF); {$I+}
 If (IOResult<>0) then begin
  SysOpLog('** InfoForm not found: "'+InfoFormFile+'"');
  Print('** InfoForm not found: "'+InfoFormFile+'"');
  Exit;
 End;

 FSplit(InfoFormFile,ps,ns,es);
 OutFName:=Systat.TextPath+ns+'.ASW';

 Assign(OutF1,Systat.TextPath+'TEMP$$'+cstr(NodeNumber)+'.ASW');
 Assign(OutF2,OutFName);
 SysOpLog('** Answered InfoForm "'+InfoFormFile+'"');
 Rewrite(OutF1);
 WriteLn(OutF1,'User: '+nam);
{ WriteLn(OutF1,'Date: '+dat);}

 PrintingFile:=TRUE;
 InLenStr:='';
 Repeat
  Read(InF,ReadChar);
  If ReadChar<>'*' then begin
   If InLenStr<>'' then begin
    sprompt(InLenStr);
    Write(OutF1,InLenStr);
   End;
   sprompt(ReadChar);
   Write(OutF1,ReadChar);
  End
  Else begin
   Read(InF,InLenStr);
   InLen:=Value(InLenStr);
   If Not ((InLen>=1) and (InLen<=78)) then InLen:=78
   Else InLenStr:='';

   InputL(InputStr,InLen);
   WriteLn(OutF1,InputStr);
  End;
 Until (Eof(InF)) or (Hangup);
 Close(InF);
 Close(OutF1);

 DumpInfoForm;

 SetC(7);
 PrintingFile:=FALSE;
End;


Procedure ShowInfoform(InfoFormFile:String);
Begin

End;

procedure readq(filen:astr; infolevel:integer);
const level0name:string='';
var infile,outfile,outfile1:text;
    outp,lin,s,mult,got,lastinp,ps,ns,es,infilename,outfilename:astr;
    i:integer;
    abort,next,plin:boolean;
    c:char;

  procedure gotolabel(got:astr);
  var s:astr;
  begin
    got:=':'+allcaps(got);
    reset(infile);
    repeat
      readln(infile,s);
    until (eof(infile)) or (allcaps(s)=got);
  end;

  procedure dumptofile;
  begin
      { output answers to *.ASW file, and delete temporary file }
    reset(outfile1);
    {$I-} append(outfile); {$I+}
    if (ioresult<>0) then rewrite(outfile);

    while (not eof(outfile1)) do begin
      readln(outfile1,s);
      writeln(outfile,s);
    end;
    close(outfile1); close(outfile);
    erase(outfile1);
  end;

begin
  infilename:=filen;
  if (not exist(infilename)) then begin
    fsplit(infilename,ps,ns,es);
    infilename:=ps+ns+'.INF';
    if (not exist(infilename)) then begin
      infilename:=systat.TextPath+ns+'.INF';
      if (not exist(infilename)) then begin
        sysoplog('** InfoForm not found: "'+filen);
{        print('** InfoForm not found: "'+filen); }
        exit;
      end;
    end;
  end;

  assign(infile,infilename);
  {$I-} reset(infile); {$I+}
  if (ioresult<>0) then begin
    sysoplog('** InfoForm not found: "'+filen+'"');
{    print('** InfoForm not found: "'+filen+'"'); }
    exit;
  end;

  fsplit(infilename,ps,ns,es);
  outfilename:=systat.TextPath+ns+'.ASW';

  assign(outfile1,systat.TextPath+'TEMP$'+cstr(infolevel)+'.ASW');
  if (infolevel=0) then begin
    level0name:=outfilename;
    assign(outfile,outfilename);
    sysoplog('** Answered InfoForm "'+filen+'"');
    rewrite(outfile1);
    writeln(outfile1,'User: '+nam);
    writeln(outfile1,'Date: '+dat);
    writeln(outfile1);
  end else begin
    sysoplog('**>> Answered InfoForm "'+filen+'"');
    rewrite(outfile1);
    assign(outfile,level0name);
  end;

  nl;
  printingfile:=TRUE;

  repeat
    abort:=FALSE;
    readln(infile,outp);
    if (pos('*',outp)<>0) and (copy(outp,1,1)<>';') then outp:=';A'+outp;
    if (length(outp)=0) then nl else
      case outp[1] of
        ';':begin
              if (pos('*',outp)<>0) then
                if (outp[2]<>'D') then outp:=copy(outp,1,pos('*',outp)-1);
              lin:=copy(outp,3,length(outp)-2);
              i:=80-length(lin);
              s:=copy(outp,1,2);
              if (s[1]=';') then
                case s[2] of
                  'C','D','G','I','K','L','Q','T',';':i:=1; { do nothing }
                else
                      sprompt(lin);
                end;
              s:=#1#1#1;
              case outp[2] of
                'A':inputl(s,i);
                'B':input(s,i);
                'C':begin
                      mult:=''; i:=1;
                      s:=copy(outp,pos('"',outp),length(outp)-pos('"',outp));
                      repeat
                        mult:=mult+s[i];
                        inc(i);
                      until (s[i]='"') or (i>length(s));
                      lin:=copy(outp,i+3,length(s)-(i-1));
                      sprompt(lin);
                      onek(c,mult);
                      s:=c;
                    end;
                'D':begin
                      dodoorfunc(outp[3],copy(outp,4,length(outp)-3));
                      s:=#0#0#0;
                    end;
                'G':begin
                      got:=copy(outp,3,length(outp)-2);
                      gotolabel(got);
                      s:=#0#0#0;
                    end;
                'H':hangup:=TRUE;
                'I':begin
                      mult:=copy(outp,3,length(outp)-2);
                      i:=pos(',',mult);
                      if i<>0 then begin
                        got:=copy(mult,i+1,length(mult)-i);
                        mult:=copy(mult,1,i-1);
                        if allcaps(lastinp)=allcaps(mult) then
                          gotolabel(got);
                      end;
                      s:=#0#0#0;
                    end;
                'K':begin
                      close(infile);
                      close(outfile1); erase(outfile1);
                      if (infolevel<>0) then begin
                        {$I-} append(outfile); {$I+}
                        if (ioresult<>0) then rewrite(outfile);
                        writeln(outfile,'** Aborted InfoForm: "'+filen+'"');
                        close(outfile);
                      end;
                      sysoplog('** Aborted InfoForm.  Answers not saved.');
                      printingfile:=FALSE;
                      exit;
                    end;
                'L':begin
                      writeln(outfile1,copy(outp,3,length(outp)-2));
                      s:=#0#0#0;
                    end;
                'Q':begin
                      close(outfile1);
                      dumptofile;
                      readq(copy(outp,3,length(outp)-2),infolevel+1);
                      rewrite(outfile1);
                      s:=#0#0#0;
                    end;
                'T':begin
                      s:=copy(outp,3,length(outp)-2);
                      printf(s);
                      s:=#0#0#0;
                    end;
                'Y':if yn then s:='YES' else s:='NO';
                ';':s:=#0#0#0;
              end;
              if (s<>#1#1#1) then begin
                outp:=lin+s;
                lastinp:=s;
              end;
              if (s=#0#0#0) then outp:=#0#0#0;
            end;
        ':':outp:=#0#0#0;
      else
            printacr(outp,abort,next);
      end;
    if (outp<>#0#0#0) then begin
      if (pos('@7',outp)<>0) then delete(outp,pos('@7',outp),2);
      writeln(outfile1,outp);
    end;
  until ((eof(infile)) or (hangup));

  if (hangup) then begin
    writeln(outfile1);
    writeln(outfile1,'** HUNG UP **');
  end;

  close(outfile1);
  dumptofile;
  close(infile);

  printingfile:=FALSE;
end;

procedure readasw(usern:integer; fn:astr);
var qf:text;
    user:userrec;
    qs,ps,ns,es:astr;
    i,userntimes:integer;
    abort,next,userfound,usernfound,ufo:boolean;

  procedure exactmatch;
  begin
    reset(qf);
    repeat
      readln(qf,qs);
      if (copy(qs,1,6)='User: ') then begin
        i:=value(copy(qs,pos('#',qs)+1,length(qs)-pos('#',qs)));
        if (i=usern) then begin
          inc(userntimes); usernfound:=TRUE;
          if (allcaps(qs)=allcaps('User: '+user.name+' #'+cstr(usern))) then
            userfound:=TRUE;
        end;
      end;
      if (not empty) then wkey(abort,next);
    until (eof(qf)) or (userfound) or (abort);
  end;

  procedure usernmatch;
  begin
    sprompt(#3#7+'No exact user name matches; user number was found ');
    if (userntimes=1) then sprompt('once')
      else sprompt(cstr(userntimes)+' times');
    sprint('.');
    nl;

    reset(qf);
    repeat
      readln(qf,qs);
      if (copy(qs,1,6)='User: ') then begin
        i:=value(copy(qs,pos('#',qs)+1,length(qs)-pos('#',qs)));
        if (i=usern) then
          if (userntimes=1) then userfound:=TRUE
          else begin
            sprompt(#3#4+'User: '+#3#3+copy(qs,7,length(qs)-6));
            userfound:=pynq('  -- Is This Right');
          end;
      end;
      if (not empty) then wkey(abort,next);
    until (eof(qf)) or (userfound) or (abort);
    nl;
  end;

begin
  ufo:=(filerec(UserF).mode<>fmclosed);
  if (not ufo) then reset(UserF);
  if ((usern>=1) and (usern<=filesize(UserF)-1)) then begin
    seek(UserF,usern); read(UserF,user);
  end else begin
    print('Invalid user number: '+cstr(usern));
    exit;
  end;
  if (not ufo) then close(UserF);

  nl;
  abort:=FALSE; next:=FALSE;
  fn:=allcaps(fn);
  fsplit(fn,ps,ns,es);
  fn:=allcaps(systat.TextPath+ns+'.ASW');
  if (not exist(fn)) then begin
    fn:=allcaps(systat.SystemPath+ns+'.ASW');
    if (not exist(fn)) then begin
      print('InfoForm answer file not found: "'+fn+'"');
      exit;
    end;
  end;
  assign(qf,fn);
  {$I-} reset(qf); {$I+}
  if (ioresult<>0) then print('"'+fn+'": unable to open.')
  else begin
    userfound:=FALSE; usernfound:=FALSE; userntimes:=0;
    exactmatch;
    if (not userfound) and (usernfound) and (not abort) then usernmatch;

    if (not userfound) and (not abort) then
      print('Questionairre answers not found.')
    else begin
      sprint(qs); (*(#3#4+'User: '+#3#3+caps(user.name)+' #'+cstr(usern));*)
      repeat
        readln(qf,qs);
        if (copy(qs,1,6)<>'User: ') then printacr(qs,abort,next)
          else userfound:=FALSE;
      until eof(qf) or (not userfound) or (abort);
    end;
    close(qf);
  end;
end;

procedure readasw1(fn:astr);
var ps,ns,es:astr;
    usern:integer;
begin
  nl;
  print('Read InfoForm answers -');
  nl;
  if (fn='') then begin
    prt('Enter filename: '); mpl(8); input(fn,8);
    nl;
    if (fn='') then exit;
  end;
  fsplit(fn,ps,ns,es);
  fn:=allcaps(systat.SystemPath+ns+'.ASW');
  if (not exist(fn)) then begin
    fn:=allcaps(systat.TextPath+ns+'.ASW');
    if (not exist(fn)) then begin
      print('InfoForm answer file not found: "'+fn+'"');
      exit;
    end;
  end;
  print('Enter user number, user name, or partial search string:');
  prt(':'); finduserws(usern);
  if (usern<>0) then
    readasw(usern,fn)
  else begin
    nl;
    if pynq('List Entire Answer File') then begin
      nl;
      printf(ns+'.ASW');
    end;
  end;
end;

end.
