{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit file6;

interface
uses
  crt,dos,overlay,
  file0, file2,
  execbat,
  common;


procedure delbatch(n:integer);
procedure mpkey(var s:astr);
function bproline1(cline:astr):astr;
procedure bproline(var cline:astr; filespec:astr);
function okprot(prot:protrec; ul,dl,batch,resume:boolean):boolean;
procedure showprots(ul,dl,batch,resume:boolean);
function findprot(cs:astr; ul,dl,batch,resume:boolean):integer;
procedure batchdl;
procedure listbatchfiles;
procedure removebatchfiles;
procedure clearbatch;

implementation

Uses file1,file9, file12, mmodem;

procedure delbatch(n:integer);
var c:integer;
begin
  if ((n>=1) and (n<=numbatchfiles)) then begin
    batchtime:=batchtime-batch[n].tt;
    if (n<>numbatchfiles) then
      for c:=n to numbatchfiles-1 do batch[c]:=batch[c+1];
    dec(numbatchfiles);
  end;
end;

procedure mpkey(var s:astr);
var sfqarea,smqarea:boolean;
begin
  sfqarea:=fqarea; smqarea:=mqarea;
  fqarea:=FALSE; mqarea:=FALSE;

  mmkey(s);

  fqarea:=sfqarea; mqarea:=smqarea;
end;

function bproline2(cline:astr):astr;
var s:astr;
begin
  s:=substall(cline,'%C',start_dir);
  s:=substall(s,'%G',copy(systat.SystemPath,1,length(systat.SystemPath)-1));
  bproline2:=s;
end;

function bproline1(cline:astr):astr;
var s,s1:astr;
begin
  if ((not incom) and (not outcom)) then s1:=cstrl(modemr.maxbaud) else s1:=connectspd;
  s:=substall(cline,'%B',s1);
  s:=substall(s,'%L',bproline2(protocol.dlflist));
  s:=substall(s,'%P',cstr(modemr.comport));
  s:=substall(s,'%T',bproline2(protocol.templog));
  bproline1:=bproline2(s);
end;

procedure bproline(var cline:astr; filespec:astr);
const lastpos:integer=-1;
begin
  if (pos('%F',cline)<>0) then begin
    lastpos:=pos('%F',cline)+length(filespec);
    cline:=substall(cline,'%F',filespec);
  end else begin
    insert(' '+filespec,cline,lastpos);
    inc(lastpos,length(filespec)+1);
  end;
end;

function okprot(prot:protrec; ul,dl,batch,resume:boolean):boolean;
var s:astr;
begin
  okprot:=FALSE;
  with prot do begin
    if (ul) then s:=ulcmd else if (dl) then s:=dlcmd else s:='';
    if (s='NEXT') and ((ul) or (batch) or (resume)) then exit;
    if (s='BATCH') and ((batch) or (resume)) then exit;
    if (batch<>(xbisbatch in xbstat)) then exit;
    if (resume<>(xbisresume in xbstat)) then exit;
    if (not (xbactive in xbstat)) then exit;
    if (not aacs(acs)) then exit;
    if (s='') then exit;
  end;
  okprot:=TRUE;
end;

procedure showprots(ul,dl,batch,resume:boolean);
var s:astr;
    i:integer;
    abort,next:boolean;
begin
  nofile:=TRUE;
  if (resume) then printf('protres')
  else begin
    if (batch) and (ul) then printf('protbul');
    if (batch) and (dl) then printf('protbdl');
    if (not batch) and (ul) then printf('protsul');
    if (not batch) and (dl) then printf('protsdl');
  end;
  if (nofile) then begin
    {$I-} reset(xf); {$I+}
    seek(xf,0);
    abort:=FALSE; next:=FALSE; i:=0;
    while ((i<=filesize(xf)-1) and (not abort)) do begin
      read(xf,protocol);
      if (okprot(protocol,ul,dl,batch,resume)) then sprint(protocol.descr);
      if (not empty) then wkey(abort,next);
      inc(i);
    end;
  end;
end;

(* XF should be OPEN  --
   returns:
     (-1):Ascii   (xx):Xmodem   (xx):Xmodem-CRC   (xx):Ymodem
     (-10):Quit   (-11):Next    (-12):Batch       (-99):Invalid (or no access)
   else, the protocol #
*)
function findprot(cs:astr; ul,dl,batch,resume:boolean):integer;
var s:astr;
    i:integer;
    done:boolean;
begin
  findprot:=-99;
  if (cs='') then exit;
  {$I-} reset(xf); {$I+}
  seek(xf,0);
  done:=FALSE; i:=0;
  while ((i<=filesize(xf)-1) and (not done)) do begin
    read(xf,protocol);
    with protocol do
      if (cs=ckeys) then
        if (okprot(protocol,ul,dl,batch,resume)) then begin
          if (ul) then s:=ulcmd else if (dl) then s:=dlcmd else s:='';
          if (s='ASCII') then begin done:=TRUE; findprot:=-1; end
          else if (s='QUIT') then begin done:=TRUE; findprot:=-10; end
          else if (s='NEXT') then begin done:=TRUE; findprot:=-11; end
          else if (s='BATCH') then begin done:=TRUE; findprot:=-12; end
          else if (s<>'') then begin done:=TRUE; findprot:=i; end;
        end;
    inc(i);
  end;
end;

procedure batchdl;
var batfile,tfil:text;  {@4 file list file}
    xferstart,xferend,tooktime,batchtime1:datetimerec;
    nfn,snfn,s,s1,s2,i,logfile:astr;
    st,tott,tooktime1:real;
    tblks,tblks1,cps,lng:longint;
    tpts,tpts1,tnfils,tnfils1:integer;
    sx,sy,hua,n,p,toxfer,rcode:integer;
    c:char;
    swap,done1,dok,kabort,nomore,readlog:boolean;

  function tempfile(i:integer):astr;
  begin
    tempfile:='temp'+cstr(i)+'.$$$';
  end;

  procedure sprtcl(c:char; s:astr);
  var wnl:boolean;
  begin
    if copy(s,length(s),1)<>#0 then wnl:=TRUE else wnl:=FALSE;
    if not wnl then s:=copy(s,1,length(s)-1);
    sprompt('^3'+c+'^1) ^4'+s);
    if wnl then nl;
  end;

  procedure addnacc(i:integer; s:astr);
  var f:ulfrec;
      oldboard,pl,rn:integer;
  begin
    if (i<>-1) then begin
      oldboard:=fileboard; fileboard:=i;
      s:=sqoutsp(stripname(s));
      recno(s,pl,rn); {* opens ulff *}
      if rn<>0 then begin
        {$I-} reset(ulff); {$I+}
        seek(ulff,rn); read(ulff,f);
        inc(f.nacc);
        seek(ulff,rn); write(ulff,f);
      end;
      fileboard:=oldboard;
      if (filerec(ulff).mode<>fmclosed) then close(ulff);
    end;
  end;

  procedure figuresucc;
  var filestr,statstr:astr;
      foundit:boolean;

    function wasok:boolean;
    var i:integer;
        foundcode:boolean;

    begin
      foundcode:=FALSE; i:=0;
      while ((i<6) and (not foundcode)) do begin
        inc(i);
         if (protocol.dlcode[i]<>'') and
            (protocol.dlcode[i]=copy(statstr,1,length(protocol.dlcode[i]))) then
            foundcode := true
      end;
      wasok:=TRUE;
      if ((foundcode) and (not (xbxferokcode in protocol.xbstat))) then dok:=FALSE;
      if ((not foundcode) and (xbxferokcode in protocol.xbstat)) then dok:=FALSE;
    end;

    Procedure KillRemoteSerNo(var FileStr:astr);  { Kills Remote's Serial Number from DSZLOG }
    var i:integer;
    begin
      i:=0;
      repeat
        inc(i)
      until FileStr[i] = ' ';
      Delete(FileStr,i,10);
    end;

  begin
    readlog:=FALSE;
    if (protocol.templog<>'') then begin
      assign(batfile,bproline1(protocol.templog));
      {$I-} reset(batfile); {$I+}
      if (ioresult=0) then begin
        assign(tfil,bproline1(protocol.dloadlog));

        {$I-} append(tfil); {$I+}
        if (ioresult<>0) then rewrite(tfil);

        readlog:=TRUE;
        while (not eof(batfile)) do begin
          readln(batfile,s); writeln(tfil,s);
          filestr:=copy(s,protocol.logpf,length(s)-(protocol.logpf-1));
          statstr:=copy(s,protocol.logps,length(s)-(protocol.logps-1));
          if filestr[1] = ' ' then delete(filestr,1,1);
          KillRemoteSerNo(filestr);
          foundit:=FALSE; n:=0;
          while ((n<numbatchfiles) and (not foundit)) do begin
            inc(n);
            if (allcaps(batch[n].fn)=allcaps(filestr)) then foundit:=TRUE;
          end;

          if (foundit) then begin
            if (wasok) then begin
              sysoplog(#3#5+'Batch downloaded "'+stripname(batch[n].fn)+'"');

              tnfils:=tnfils+1;
              tblks:=tblks+batch[n].blks;
              tpts:=tpts+batch[n].pts;
              loaduboard(batch[n].section);

              if (not (fbnoratio in memuboard.fbstat)) then begin
                thisuser.dk:=thisuser.dk+(batch[n].blks div 8);
                thisuser.downloads:=thisuser.downloads+1;
                thisuser.filepoints:=thisuser.filepoints-batch[n].pts;
              end;

              {****if (not (fbnoratio in memuboard.fbstat)) then begin
                inc(tnfils1);
                inc(tblks1,batch[n].blks);
                inc(tpts1,batch[n].pts);
              end;****}

              addnacc(batch[n].section,batch[n].fn);
              delbatch(n);
            end else
              sysoplog(#3#7+'Tried batch download "'+stripname(batch[n].fn)+'"');
          end else
            sysoplog(#3#7+'*Batch downloaded unauthorized file? "'+filestr+'"');
        end;
        close(batfile);
        close(tfil);
      end;
    end;
    if (not readlog) then begin
      while (toxfer>0) do begin
        sysoplog(#3#5+'Batch download "'+stripname(batch[1].fn)+'"');
        tnfils:=tnfils+1;
        tblks:=tblks+batch[1].blks;
        tpts:=tpts+batch[1].pts;
        loaduboard(batch[1].section);
        if (not (fbnoratio in memuboard.fbstat)) then begin
          thisuser.dk:=thisuser.dk+(batch[1].blks div 8);
          thisuser.downloads:=thisuser.downloads+1;
          thisuser.filepoints:=thisuser.filepoints-batch[1].pts;
        end;
 {         inc(tnfils1);
          inc(tblks,batch[1].blks);
          inc(tpts1,batch[1].pts);
        end;       }
        addnacc(batch[1].section,batch[1].fn);
        delbatch(1); dec(toxfer);
      end;
    end;
  end;

procedure _batchul;
var fi:file of byte;
    dirinfo:searchrec;
    f:ulfrec;
    v:verbrec;
    xferstart,xferend,tooktime,takeawayulrefundgot1,ulrefundgot1:datetimerec;
    tconvtime1,st1:datetimerec;
    pc,fn,s:astr;
    st,tconvtime,convtime,ulrefundgot,takeawayulrefundgot:real;
    totb,totfils,totb1,totfils1,cps,lng,totpts:longint;
    i,p,hua,pl,dbn,blks,gotpts,ubn,filsuled,oldboard,passn:integer;
    c:char;
    abort,ahangup,next,done,dok,kabort,wenttosysop,ok,convt,
      beepafter,dothispass,fok,nospace,savpause:boolean;

  function notinubatch(fn:astr):boolean;
  var i:integer;
  begin
    notinubatch:=FALSE;
    for i:=1 to numubatchfiles do
      if (sqoutsp(fn)=sqoutsp(ubatch[i].fn)) then exit;
    notinubatch:=TRUE;
  end;

  function ubatchnum(fn:astr):integer;
  var i:integer;
  begin
    fn:=sqoutsp(fn);
    ubatchnum:=0;
    for i:=1 to numubatchfiles do
      if (fn=sqoutsp(ubatch[i].fn)) then ubatchnum:=i;
  end;

  function plural:string;
  begin
    if (totfils<>1) then plural:='s' else plural:='';
  end;

begin
      ulrefundgot:=(dt2r(tooktime))*(systat.ulrefund/100.0);
      freetime:=freetime+ulrefundgot;

      {*****}

      lil:=0;
      nl;
      nl;
      star('Checking for Uploaded Files.');
      nl;
      lil:=0;

      tconvtime:=0.0; takeawayulrefundgot:=0.0;
      totb:=0; totfils:=0; totb1:=0; totfils1:=0; totpts:=0;

      findfirst(WorkPath+'2\*.*',anyfile-directory-volumeid,dirinfo);  {iM Test " -volumeid ".}
      while (doserror=0) do begin
        inc(totfils1);
        inc(totb1,dirinfo.size);
        findnext(dirinfo);
      end;
      cps:=trunc(totb1/dt2r(tooktime));

      abort:=FALSE; next:=FALSE;

      if (totfils1=0) then begin
        star('No Files Detected!');
        exit;
      end;

      ahangup:=FALSE;
      if (hangup) then begin
        if (spd<>'KB') then begin
          commandline('Hanging up and taking phone off hook...');
          dophonehangup(FALSE);
          dophoneoffhook(FALSE);
          spd:='KB';
        end;
        hangup:=FALSE; ahangup:=TRUE;
      end;

      r2dt(ulrefundgot,ulrefundgot1);
      if (not ahangup) then begin
        prt('Press Any Key For Upload Stats: ');
        if (beepafter) then begin
          i:=1;
          repeat
            if (s<>time) then begin prompt(^G#0#0#0^G); s:=time; inc(i); end;
          until ((i=30) or (not empty) or (hangup));
        end;
        getkey(c);
        for i:=1 to 33 do prompt(^H' '^H);

        print('Uploads Detected:');
        nl;
        dir(WorkPath+'2\','*.*',TRUE);
        nl;
        star('# Files Uploaded į '+cstr(totfils1)+' files.');
        star('File Size Uploaded į '+cstrl(totb1)+' bytes.');
        star('Batch Upload Time į '+longtim(tooktime)+'.');
        star('Transfer Rate į '+cstr(cps)+' cps');
        star('Time Refund į '+longtim(ulrefundgot1)+'.');
        nl;
        pausescr;
      end;

      fiscan(pl);

      {  iM Test -- Nuke entire "pass" bullshit  }
      {* files not in upload batch queue are ONLY done during the first pass *}
      {* files already in the upload batch queue done during the second pass *}
        dbn := fileboard;
        findfirst(WorkPath+'2\*.*',anyfile-directory-volumeid,dirinfo);  {iM Test " -volumeid ".}
        while (doserror=0) do begin
          fn:=sqoutsp(dirinfo.name);
          nl;
          dothispass:=FALSE;
          if (notinubatch(fn)) then begin
            ubn:=0;
            dothispass:=TRUE;
            star('"'+fn+'" - File Not In Upload Batch Queue.');

            fiscan(pl);
            wenttosysop:=FALSE;
            f.filename:=fn;
            dodescrs(f,v,pl,wenttosysop,FALSE,fok);
            if fok then begin
              if (ahangup) then begin
                f.description:='Not In Upload Batch Queue - Hungup After Transfer';
                f.vpointer:=-1; v.descr[1]:='';  {iM Process FILE_ID.DIZ?}
              end;
              if (not wenttosysop) then begin
                nl;
                done:=FALSE;
                fileboard:=oldboard;     {iM Test (WORKS?)- change dbn to oldboard}
                nl;
              end;
            end;
          end else
            begin
              dothispass:=TRUE;
              star('"'+fn+'" - File Found.');
              ubn:=ubatchnum(fn);

              f.description:=ubatch[ubn].description;
              f.disknums[1]:=ubatch[ubn].DiskNumbers[1];
              f.disknums[2]:=ubatch[ubn].DiskNumbers[2];
              f.fileto:=ubatch[ubn].fileto;
              f.FileInfo:=ubatch[ubn].FileInfo;
              f.CrackGroup:=ubatch[ubn].CrackGroup;

              fileboard:=ubatch[ubn].section;
              v.descr[1]:='';
              if (ubatch[ubn].vr<>0) then v:=ubatchv[ubatch[ubn].vr]^;
              f.vpointer:=-1;
              if (v.descr[1]<>'') then f.vpointer:=nfvpointer;
              wenttosysop:=(fileboard=systat.tosysopdir);
            end;

          if (dothispass) then begin
            if (wenttosysop) then fileboard:=systat.tosysopdir;

            fiscan(pl);

            arcstuff(ok,convt,blks,convtime,TRUE,WorkPath+'2\',
                     fn,f.description);
            tconvtime:=tconvtime+convtime; f.blocks:=blks;
            doffstuff(f,fn,gotpts);

            fok:=TRUE;
            loaduboard(fileboard);
            if (ok) then begin
              star('Moving File To '+#3#5+memuboard.name);
              sprompt(#3#5+'Progress: ');
              movefile(fok,nospace,TRUE,WorkPath+'2\'+fn,memuboard.dlpath+fn);
              if (fok) then begin
                nl;
                newff(f,v);
                star('"'+fn+'" Successfully Uploaded.');
                sysoplog(#3#3+'Batch uploaded "'+sqoutsp(fn)+'" on '+
                         memuboard.name);
                inc(totfils);
                lng:=blks; lng:=lng*128;
                inc(totb,lng);
                inc(totpts,gotpts);
              end else begin
                star('Error Moving File Into Directory - Upload Voided.');
                sysoplog(#3#3+'Error moving batch upload "'+sqoutsp(fn)+'" into directory');
              end;
            end else begin
              star('Upload not received.');
              if ((thisuser.sl>0) and
                  (f.blocks div 8>systat.minresume)) then begin
                nl;
                dyny:=TRUE;
                if pynq('Save File For A Later Resume') then begin
                  sprompt(#3#5+'Progress: ');
                  movefile(fok,nospace,TRUE,WorkPath+'2\'+fn,memuboard.dlpath+fn);
                  if (fok) then begin
                    nl;
                    doffstuff(f,fn,gotpts);
                    f.filestat:=f.filestat+[resumelater];
                    newff(f,v);
                    s:='file saved for later resume';
                  end else begin
                    star('Error Moving File Into Directory - Upload Voided.');
                    sysoplog(#3#3+'Error moving batch upload "'+sqoutsp(fn)+'" into directory');
                  end;
                end;
              end;
              if (not (resumelater in f.filestat)) then begin
                s:='File Deleted';
                assign(fi,WorkPath+'2\'+fn); erase(fi);
              end;
              sysoplog(#3#3+'Errors Batch Uploading "'+sqoutsp(fn)+'" - '+s);
            end;

            if (not ok) then begin
              st:=(rte*f.blocks);
              takeawayulrefundgot:=takeawayulrefundgot+st;
              r2dt(st,st1);
              star('Time Refund Of '+longtim(st1)+' Will Be Taken Away.');
            end else
              if (ubn<>0) then delubatch(ubn);
          end;

          findnext(dirinfo);
        end;

      fileboard:=oldboard;
      fiscan(pl);
      if (filerec(ulff).mode<>fmclosed) then close(ulff);

      nl;
      star('# Files Uploaded į '+cstr(totfils1)+' files.');
      if (totfils<>totfils1) then
        star('Files Successful į '+cstr(totfils)+' files.');
      star('File Size Uploaded į '+cstrl(totb1)+' bytes.');
      star('Batch Upload Time į '+longtim(tooktime)+'.');
      r2dt(tconvtime,tconvtime1);
      if (tconvtime<>0.0) then
        star('Total Convert Time į '+longtim(tconvtime1)+' (not refunded)');
      star('Transfer Rate į '+cstr(cps)+' cps');
      nl;
      r2dt(ulrefundgot,ulrefundgot1);
      star('Time Refund į '+longtim(ulrefundgot1)+'.');

      inc(systat.todayzlog.uploads,totfils);
      inc(systat.todayzlog.uk,totb1 div 1024);
      if (aacs(systat.ulvalreq)) then begin
        if (totpts<>0) then
        star('File Points į '+cstr(totpts)+' pts.');
        star('Upload Credits Got į '+cstr(totfils)+' files, '+cstr(totb1 div 1024)+'k.');
        nl;
        star('Thanks For The File'+plural+', '+thisuser.name+'!');
        inc(thisuser.uploads,totfils);
        inc(thisuser.filepoints,totpts);
        thisuser.uk:=thisuser.uk+(totb1 div 1024);
      end else begin
        nl;
        sprint(#3#5+'Thanks For The Upload'+plural+', '+thisuser.name+'!');
        sprompt(#3#5+'You Will Receive File ');
        if (systat.uldlratio) then
          sprompt('Credit')
        else
          sprompt('Points');
        sprint(' As Soon As '+systat.sysopname+' Validates The File'+plural+'!');
      end;
      nl;

      if (choptime<>0.0) then begin
        choptime:=choptime+ulrefundgot;
        freetime:=freetime-ulrefundgot;
        star('Sorry, No Upload Time Refund May Be Given At This Time.');
        star('You Will Get Your Refund After The Event.');
        nl;
      end;

      if (takeawayulrefundgot<>0.0) then begin
        nl;
        r2dt(takeawayulrefundgot,takeawayulrefundgot1);
        star('Taking Away Time Refund Of '+longtim(takeawayulrefundgot1));
        freetime:=freetime-takeawayulrefundgot;
      end;

      if (ahangup) then begin
        commandline('Hanging up phone again...');
        dophonehangup(FALSE);
        hangup:=TRUE;
      end;

    end;
  {end;}
{  if (savpause) then thisuser.ac:=thisuser.ac+[pause];
end; }


begin
  if (numbatchfiles=0) then begin
    nl; print('Batch Queue Empty.');
  end else begin
    nl;
    print('Checking Batch Download Request...');

    tott:=0.0;
    for n:=1 to numbatchfiles do
      tott:=tott+batch[n].tt;

    nl;
    writetop('Batch Request');
    writebox2('^1Number Files In Batch ^9į ^2'+cstr(numbatchfiles));
    writebox2('^1Batch Download Time ^9į ^2'+ctim(tott));
    writebox2('^1Time Left Online ^9į ^2'+ctim(nsl));
    writebottom;

    if (tott>nsl) then begin
      nl;
      sprint('^7Insufficient Time For Download!!');
      sprint('^5You Must Remove Some Files From Your Batch Queue.');
      exit;
    end;

    reset(xf);
    done1:=FALSE;
    repeat
      nl;
      sprompt('^1Batch Protocol ^9[^2?^9/^2List^9]: ^1'); mpkey(i);
      if (i='?') then begin
        nl;
        showprots(FALSE,TRUE,TRUE,FALSE);
      end else begin
        p:=findprot(i,FALSE,TRUE,TRUE,FALSE);
        if (p=-99) then print('Invalid Entry.') else done1:=TRUE;
      end;
    until (done1) or (hangup);
    if (p<>-10) then begin
      seek(xf,p); read(xf,protocol); close(xf);
      nl; sprompt(#3#7+'Hangup After Transfer [A/Abort, N/No, Y/Yes, M/Maybe]: ^2');
      onek(c,'ANYM'^M); if (c=^M) then c:='N';
      hua:=pos(c,'ANYM');
      dok:=TRUE;
      if (hua<>1) then begin
        tblks:=0; tpts:=0; tnfils:=0;
        tblks1:=0; tpts1:=0; tnfils1:=0;
        nl; nl;

        nfn:=bproline1(Systat.ProtocolPath+protocol.dlcmd);
        toxfer:=0; tott:=0.0;
        if (pos('%F',Systat.ProtocolPath+protocol.dlcmd)<>0) then begin
          done1:=FALSE;
          while ((not done1) and (toxfer<numbatchfiles)) do begin
            inc(toxfer); snfn:=nfn;
            bproline(nfn,batch[toxfer].fn);
            if (length(nfn)>protocol.maxchrs) then done1:=TRUE
              else tott:=tott+batch[toxfer].tt;
          end;
        end;

        if (protocol.dlflist<>'') then begin
          tott:=0.0;
          assign(batfile,bproline1(protocol.dlflist));
          rewrite(batfile);
          for n:=1 to numbatchfiles do begin
            writeln(batfile,batch[n].fn);
            inc(toxfer); tott:=tott+batch[n].tt;
          end;
          close(batfile);
        end;

        (* output x-fer batch file *)
        assign(batfile,'TEMP$$$$.BAT'); rewrite(batfile);
        if (protocol.envcmd<>'') then
          writeln(batfile,bproline1(protocol.envcmd));
        writeln(batfile,nfn);
        writeln(batfile,'exit');
        close(batfile);

        (* delete old log file *)
        if (exist(bproline1(protocol.templog))) then begin
          assign(batfile,bproline1(protocol.templog));
          {$I-} erase(batfile); {$I+}
        end;

        r2dt(batchtime,batchtime1);
        if (useron) then
          print('Transmitting Batch  -  Time: '+longtim(batchtime1));

        if (useron) then shel(caps(thisuser.name)+' Is Batch Downloading!')
                    else shel('Sending File(s)...');

        getdatetime(xferstart);
        swap:=systat.swapshell;
        systat.swapshell:=FALSE;
        NodeUpDate('Batch Downloading Files');
        shelldos('TEMP$$$$.BAT',rcode);
        NodeUpDate('Available for Page');
        systat.swapshell:=swap;
        shel2;
        getdatetime(xferend);
        timediff(tooktime,xferstart,xferend);

        (* delete TEMP$$$$.BAT batch file *)
        assign(batfile,'TEMP$$$$.BAT');
        {$I-} erase(batfile); {$I+}

        figuresucc;      { Checks Transfers If They exist, and Users Ration STuff }

        tooktime1:=dt2r(tooktime);
        if (tooktime1>=1.0) then begin
          cps:=tblks; cps:=cps*128;
          cps:=trunc(cps/tooktime1);
        end else
          cps:=0;

        showuserfileinfo;
        commandline('');
        nl; nl;

        {The Start Of Some Bullshit, That I do Not Know If It Works}
        s:='Download Totals į  ';
        if (tnfils=0) then s:=s+'No' else s:=s+cstr(tnfils);
        s:=s+' file'; if (tnfils<>1) then s:=s+'s';
        lng:=tblks; lng:=lng*128;
        s:=s+', '+cstrl(lng)+' bytes';
        if (tpts<>0) then begin
          s:=s+', '+cstr(tpts)+' file point';
          if (tpts<>1) then s:=s+'s';
        end;
        s:=s+'.';
        star(s);

        if (tnfils1<>tnfils) then begin
          if (tnfils<tnfils1) then tnfils1:=tnfils;

          s:='Download Charges į ';
          if (tnfils1=0) then s:=s+'No' else s:=s+cstr(tnfils1);
          s:=s+' file'; if (tnfils1<>1) then s:=s+'s';
          lng:=tblks1; lng:=lng*128;
          s:=s+', '+cstrl(lng)+' bytes';
          if (tpts1<>0) then begin
            s:=s+', '+cstr(tpts1)+' file point';
            if (tpts1<>1) then s:=s+'s';
          end;
          s:=s+'.';
          star(s);
        end;
        {The End Of The Bullshit That Might Not Work Properly}

        star('Download Time į  '+longtim(tooktime));
        star('Transfer Rate į  '+cstr(cps)+' cps');

    {    thisuser.dk:=thisuser.dk+(tblks1 div 8);
        inc(thisuser.downloads,tnfils1);
        dec(thisuser.filepoints,tpts1);    }

        systat.todayzlog.downloads:=systat.todayzlog.downloads+tnfils;
        systat.todayzlog.dk:=systat.todayzlog.dk + (tblks div 8);
        {These Two Might Not Work}

        if (numbatchfiles<>0) then begin
          tblks:=0; tpts:=0;
          for n:=1 to numbatchfiles do begin
            tblks:=tblks+batch[n].blks;
            tpts:=tpts+batch[n].pts;
          end;
          lng:=tblks; lng:=lng*128;
          s:='Not Transferred į '+cstr(numbatchfiles)+' file';
          if (numbatchfiles<>1) then s:=s+'s';
          s:=s+', '+cstrl(lng)+' bytes';
          if (tpts<>0) then begin
            s:=s+', '+cstr(tpts)+' file point';
            if (tpts<>1) then s:=s+'s';
          end;
          s:=s+'.';
          star(s);
        end;

        if (xbisbidirectional in protocol.xbstat) then begin
           _batchul;
        end;

        case hua of
          3:hangup:=TRUE;
          4:begin
              nl;
              nl;
              print('System will automatically hang up in 30 seconds.');
              print('Hit [H] to hang up now, any other key to abort.');
              st:=timer;
              while (tcheck(st,30)) and (empty) do;
              if (empty) then hangup:=TRUE;
              if (not empty) then
                if upcase(inkey)='H' then
                  hangup:=TRUE;
            end;
        end;
      end;
    end;
  end;
end;

procedure listbatchfiles;
var tot:record
          pts:integer;
          blks:longint;
          tt:real;
        end;
    s:astr;
    i:integer;
    abort,next:boolean;
begin
  if (numbatchfiles=0) then begin
    nl; print('Batch Queue Empty.');
  end else begin
    abort:=FALSE; next:=FALSE;
    with tot do begin
      pts:=0; blks:=0; tt:=0.0;
    end;

  cls;
  sprint(#3#5+#3#9+'['+#3#2+'File Section'+#3#9+'] ['+#3#2+'Batch Download Queue'+#3#9+']');
  printacr(#3+#5+#3+#9+'͸',abort,next);
  printacr(#3+#5+#3+#9+''+#3+#5+'#   FName    Ext   Area   FPts   Size   Download Time                       '+
    #3+#9+'',abort,next);
  printacr(#3+#5+#3+#9+';',
    abort,next);

    i:=1;
    while (not abort) and (not hangup) and (i<=numbatchfiles) do begin
      with batch[i] do begin
        if section=-1 then s:=#3#7+'Unlist ' else s:=#3#5+mrn(cstr(section),4)+'   ';
        s:=#3#3+' '+mn(i,4)+#3#5+align(stripname(fn))+'   '+
           s+#3#4+mrn(cstr(pts),4)+'   '+
           #3#4+mrn(cstrl(blks div 8),4)+'k  '+#3#7+ctim(tt);
        if (section<>-1) then begin
          loaduboard(section);
          if (fbnoratio in memuboard.fbstat) then s:=s+#3#5+' <No-Ratio>';
        end;
        printacr(s,abort,next);
        tot.pts:=tot.pts+pts;
        tot.blks:=tot.blks+blks;
        tot.tt:=tot.tt+tt;
      end;
      inc(i);
    end;
      printacr(#3+#5+#3+#9+'',abort,next);
    with tot do
      s:=#3#3+mln('Totals:',26)+' '+#3#4+mrn(cstr(pts),4)+'   '+
         #3#4+mrn(cstrl(blks div 8),4)+'k  '+#3#7+ctim(tt);
    printacr(s,abort,next);
  end;
end;

procedure removebatchfiles;
var s:astr;
    i:integer;
begin
  if numbatchfiles=0 then begin
    nl; print('Batch queue empty.');
  end else
    repeat
      nl;
      prt('^5^1File Number To Remove ^9[^21^9-^2'+cstr(numbatchfiles)+'^9, ^2?^9/^2List^9]: ^1');
      input(s,2); i:=value(s);
      if (s='?') then listbatchfiles;
      if (i>0) and (i<=numbatchfiles) then begin
        print('"'+stripname(batch[i].fn)+'" Deleted Out Of Queue.');
        delbatch(i);
      end;
      if (numbatchfiles=0) then print('Queue Now Empty.');
    until (s<>'?');
end;

procedure clearbatch;
begin
  nl;
  if pynq('Clear Queue') then begin
    numbatchfiles:=0;
    batchtime:=0.0;
    print('Queue Now Empty.');
  end;
end;

end.
