{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit file12;

interface

uses
  crt,dos,overlay,
  file0, file1, file2, file6, file9,
  execbat,
  mmodem,
  common;

procedure delubatch(n:integer);
procedure listubatchfiles;
procedure removeubatchfiles;
procedure clearubatch;
procedure batchul;
procedure batchinfo;

implementation

procedure delubatch(n:integer);
var c:integer;
begin
  if ((n>=1) and (n<=numubatchfiles)) then begin
    if (n<>numubatchfiles) then
      for c:=n to numubatchfiles-1 do ubatch[c]:=ubatch[c+1];
    dec(numubatchfiles);
  end;
end;

procedure listubatchfiles;
var s,s1:astr;
    i,j:integer;
    abort,next:boolean;
begin
  if (numubatchfiles=0) then begin
    nl; print('Upload Batch Queue Empty.');
  end else begin
    abort:=FALSE; next:=FALSE;
    cls;
    sprint(#3#5+#3#9+'['+#3#2+'File Section'+#3#9+'] ['+#3#2+'Batch Upload Queue'+#3#9+']');
    printacr(#3+#5+#3+#9+'͸',abort,next);
    printacr(#3+#5+#3+#9+''+#3+#5+'#   FName    Ext   Area   Description                                '+
      #3+#9+'',abort,next);
    printacr(#3+#5+#3+#9+';',
      abort,next);

    i:=1;
    while ((not abort) and (i<=numubatchfiles) and (not hangup)) do begin
      with ubatch[i] do begin
        if (section=systat.tosysopdir) then s1:=#3#7+'SysOp '
          else s1:=mrn(cstr(section),6);
        s:=#3#3+' '+mn(i,3)+' '+#3#5+align(fn)+'   '+s1+' '+#3#3+mln(description,55);
        printacr(s,abort,next);
        if (vr<>0) then
          if (ubatchv[vr]^.descr[1]<>'') then begin

            {$I-} reset(verbf); {$I+}
            if (ioresult=0) then
              for j:=1 to 4 do
                if ubatchv[vr]^.descr[j]='' then j:=4 else
                  printacr('                               '+#3#2+':'+
                           #3#4+ubatchv[vr]^.descr[j],abort,next);

            if (filerec(verbf).mode<>fmclosed) then close(verbf);
          end;
      end;
      inc(i);
    end;
  end;
end;

procedure removeubatchfiles;
var s:astr;
    i:integer;
begin
  if (numubatchfiles=0) then begin
    nl; print('Upload Batch Queue Empty.');
  end else
    repeat
      nl;
      prt('^5^1File Number To Remove ^9[^21^9-^2'+cstr(numubatchfiles)+'^9, ^2?^9/^2List^9]: ^1');
      input(s,2); i:=value(s);
      if (s='?') then listubatchfiles;
      if ((i>0) and (i<=numubatchfiles)) then begin
        print('"'+stripname(ubatch[i].fn)+'" Deleted Out Of Upload Queue.');
        delubatch(i);
      end;
      if (numubatchfiles=0) then print('Upload Queue Now Empty.');
    until (s<>'?');
end;

procedure clearubatch;
begin
  nl;
  if pynq('Clear Upload Queue') then begin
    numubatchfiles:=0;
    print('Upload Queue Now Empty.');
  end;
end;

procedure batchul;
var fi:file of byte;
    dirinfo:searchrec;
    f:ulfrec;
    v:verbrec;
    xferstart,xferend,tooktime,takeawayulrefundgot1,ulrefundgot1:datetimerec;
    tconvtime1,st1:datetimerec;
    pc,fn,s:astr;
    st,tconvtime,convtime,ulrefundgot,takeawayulrefundgot:real;
    totb,totfils,totb1,totfils1,cps,lng,totpts:longint;
    i,p,hua,pl,dbn,blks,gotpts,ubn,filsuled,oldboard,passn,dump:integer;
    c:char;
    abort,ahangup,next,done,dok,kabort,wenttosysop,ok,convt,
      beepafter,dothispass,fok,nospace,savpause:boolean;
    diz:text;
    dizcnt:byte;
    dizstr:string[80];

  function notinubatch(fn:astr):boolean;
  var i:integer;
  begin
    notinubatch:=FALSE;
    for i:=1 to numubatchfiles do
      if (sqoutsp(fn)=sqoutsp(ubatch[i].fn)) then exit;
    notinubatch:=TRUE;
  end;

  function ubatchnum(fn:astr):integer;
  var i:integer;
  begin
    fn:=sqoutsp(fn);
    ubatchnum:=0;
    for i:=1 to numubatchfiles do
      if (fn=sqoutsp(ubatch[i].fn)) then ubatchnum:=i;
  end;

  function plural:string;
  begin
    if (totfils<>1) then plural:='s' else plural:='';
  end;

begin
  savpause:=(pause in thisuser.ac);
  if (savpause) then thisuser.ac:=thisuser.ac-[pause];

  oldboard:=fileboard;
  beepafter:=FALSE; done:=FALSE;
  nl;
  if (numubatchfiles=0) then begin
    printf('batchul0');
    if (nofile) then begin
      sprint('Warning!  No upload batch files specified yet.');
      sprint('If you continue, and batch upload files, you will have to');
      sprint('enter file descriptions for each file after the batch upload');
      sprint('is complete.');
    end;
  end else begin
    printf('batchul');
    if (nofile) then begin
      sprint('If you batch upload files IN ADDITION to the files already');
      sprint('specified in your upload batch queue, you must enter file');
      sprint('descriptions for them after the batch upload is complete.');
    end;
  end;
  reset(xf);
  done:=FALSE;
  repeat
    nl;
    sprompt('^1Batch Protocol ^9[^2?^9=^2List^9]: ^1'); mpkey(s);
    if (s='?') then begin
      nl;
      showprots(TRUE,FALSE,TRUE,FALSE);
    end else begin
      p:=findprot(s,TRUE,FALSE,TRUE,FALSE);
      if (p=-99) then print('Invalid Entry.') else done:=TRUE;
    end;
  until (done) or (hangup);
  if (p<>-10) then begin
    seek(xf,p); read(xf,protocol); close(xf);
    nl;
    sprompt(#3#7+'Hangup After Transfer [A/Abort, N/No, Y/Yes, M/Maybe]: ^2');
    onek(c,'ANYM'^M); if c=^M then c:='N';
    hua:=pos(c,'ANYM');
    dok:=TRUE;
    if (hua<>1) then begin
      if (hua<>3) then begin
        nl;
        dyny:=TRUE;
        beepafter:=pynq('Beep After Transfer');
      end;

      lil:=0;
      nl; nl;
      if (useron) then print('Ready To Receive Batch Queue!');
      lil:=0;

      getdatetime(xferstart);
      if (useron) then shel(caps(thisuser.name)+' Is Batch Uploading!')
                  else shel('Receiving File(s)...');
      NodeUpDate('Batch Uploading Files');
      execbatch(dok,FALSE,'tgtemp1.bat','tgtest1.$$$',WorkPath+'2\',
                bproline1(Systat.ProtocolPath+protocol.ulcmd),-1);
      NodeUpDate('Testing Uploaded Files');
      shel2;
      getdatetime(xferend);
      timediff(tooktime,xferstart,xferend);

      showuserfileinfo;

      ulrefundgot:=(dt2r(tooktime))*(systat.ulrefund/100.0);
      freetime:=freetime+ulrefundgot;

      {*****}

      lil:=0;
      nl;
      nl;
      star('Batch Upload Transfer Complete.');
      nl;
      lil:=0;

      tconvtime:=0.0; takeawayulrefundgot:=0.0;
      totb:=0; totfils:=0; totb1:=0; totfils1:=0; totpts:=0;

      findfirst(WorkPath+'2\*.*',anyfile-directory-volumeid,dirinfo);  {iM Test " -volumeid ".}
      while (doserror=0) do begin
        inc(totfils1);
        inc(totb1,dirinfo.size);
        findnext(dirinfo);
      end;
      cps:=trunc(totb1/dt2r(tooktime));

      abort:=FALSE; next:=FALSE;

      if (totfils1=0) then begin
        star('No Files Detected!  Transfer Aborted.');
        exit;
      end;

      case hua of
        3:hangup:=TRUE;
        4:begin
            lil:=0;
             nl;
             nl;
             print('System will automatically hang up in 30 seconds.');
             print('Hit [H] to hang up now, any other key to abort.');
             st:=timer;
             while (tcheck(st,30)) and (empty) do;
             if (empty) then hangup:=TRUE;
             if (not empty) then
               if upcase(inkey)='H' then hangup:=TRUE;
            lil:=0;
          end;
      end;

      ahangup:=FALSE;
      if (hangup) then begin
        if (spd<>'KB') then begin
          commandline('Hanging up and taking phone off hook...');
          dophonehangup(FALSE);
          dophoneoffhook(FALSE);
          spd:='KB';
        end;
        hangup:=FALSE; ahangup:=TRUE;
      end;

      r2dt(ulrefundgot,ulrefundgot1);
      if (not ahangup) then begin
        prt('Press Any Key For Upload Stats: ');
        if (beepafter) then begin
          i:=1;
          repeat
            if (s<>time) then begin prompt(^G#0#0#0^G); s:=time; inc(i); end;
          until ((i=30) or (not empty) or (hangup));
        end;
        getkey(c);
        for i:=1 to 33 do prompt(^H' '^H);

        print('Uploads Detected:');
        nl;
        dir(WorkPath+'2\','*.*',TRUE);
        nl;
        star('# Files Uploaded į '+cstr(totfils1)+' files.');
        star('File Size Uploaded į '+cstrl(totb1)+' bytes.');
        star('Batch Upload Time į '+longtim(tooktime)+'.');
        star('Transfer Rate į '+cstr(cps)+' cps');
        star('Time Refund į '+longtim(ulrefundgot1)+'.');
        nl;
        pausescr;
      end;

      fiscan(pl);

      {  iM Test -- Nuke entire "pass" bullshit  }
      {* files not in upload batch queue are ONLY done during the first pass *}
      {* files already in the upload batch queue done during the second pass *}
        dbn := fileboard;
        findfirst(WorkPath+'2\*.*',anyfile-directory-volumeid,dirinfo);  {iM Test " -volumeid ".}
        while (doserror=0) do begin
          fn:=sqoutsp(dirinfo.name);
          nl;
          dothispass:=FALSE;
          if (notinubatch(fn)) then begin
            ubn:=0;
            dothispass:=TRUE;
            star('"'+fn+'" - File Not In Upload Batch Queue.');

            fiscan(pl);
            wenttosysop:=FALSE;
            f.filename:=fn;
            dodescrs(f,v,pl,wenttosysop,FALSE,fok);
            if fok then begin
              if (ahangup) then begin
                f.description:='Not In Upload Batch Queue - Hungup After Transfer';
                f.vpointer:=-1; v.descr[1]:='';  {iM Process FILE_ID.DIZ?}

                (* FILE_ID.DIZ *)
                shelldos('PKUNZIP -O '+WorkPath+'2\'+fn+' FILE_ID.DIZ '+memuboard.ulpath,dump);
                if exist(memuboard.ulpath+'FILE_ID.DIZ') then begin
                   assign(diz,memuboard.ulpath+'FILE_ID.DIZ');
                   reset(diz);
                   for dizcnt:=1 to 10 do v.descr[dizcnt]:='';
                   dizcnt:=1; dizstr:='';
                   while (dizcnt<=10) and (not (eof(diz))) do begin
                         readln(diz,dizstr);
                         v.descr[dizcnt]:=dizstr;
                         inc(dizcnt);
                   end;
                   close(diz);
                   erase(diz);
                   if (v.descr[1]<>'') then f.vpointer:=nfvpointer;
                end;

              end;
              if (not wenttosysop) then begin
                nl;
                done:=FALSE;
                fileboard:=oldboard;     {iM Test (WORKS?)- change dbn to oldboard}
                nl;
              end;
            end;
          end else
            begin
              dothispass:=TRUE;
              star('"'+fn+'" - File Found.');
              ubn:=ubatchnum(fn);

              f.description:=ubatch[ubn].description;
              f.disknums[1]:=ubatch[ubn].DiskNumbers[1];
              f.disknums[2]:=ubatch[ubn].DiskNumbers[2];
              f.fileto:=ubatch[ubn].fileto;
              f.FileInfo:=ubatch[ubn].FileInfo;
              f.CrackGroup:=ubatch[ubn].CrackGroup;

              fileboard:=ubatch[ubn].section;
              v.descr[1]:='';
              if (ubatch[ubn].vr<>0) then v:=ubatchv[ubatch[ubn].vr]^;
              f.vpointer:=-1;
              if (v.descr[1]<>'') then f.vpointer:=nfvpointer;
              wenttosysop:=(fileboard=systat.tosysopdir);
            end;

          if (dothispass) then begin
            if (wenttosysop) then fileboard:=systat.tosysopdir;

            fiscan(pl);

            arcstuff(ok,convt,blks,convtime,TRUE,WorkPath+'2\',
                     fn,f.description);
            tconvtime:=tconvtime+convtime; f.blocks:=blks;
            doffstuff(f,fn,gotpts);

            fok:=TRUE;
            loaduboard(fileboard);
            if (ok) then begin
              star('Moving File To '+#3#5+memuboard.name);
              sprompt(#3#5+'Progress: ');
              movefile(fok,nospace,TRUE,WorkPath+'2\'+fn,memuboard.dlpath+fn);
              if (fok) then begin
                nl;
                newff(f,v);
                star('"'+fn+'" Successfully Uploaded.');
                sysoplog(#3#3+'Batch uploaded "'+sqoutsp(fn)+'" on '+
                         memuboard.name);
                inc(totfils);
                lng:=blks; lng:=lng*128;
                inc(totb,lng);
                inc(totpts,gotpts);
              end else begin
                star('Error Moving File Into Directory - Upload Voided.');
                sysoplog(#3#3+'Error moving batch upload "'+sqoutsp(fn)+'" into directory');
              end;
            end else begin
              star('Upload not received.');
              if ((thisuser.sl>0) and
                  (f.blocks div 8>systat.minresume)) then begin
                nl;
                dyny:=TRUE;
                if pynq('Save File For A Later Resume') then begin
                  sprompt(#3#5+'Progress: ');
                  movefile(fok,nospace,TRUE,WorkPath+'2\'+fn,memuboard.dlpath+fn);
                  if (fok) then begin
                    nl;
                    doffstuff(f,fn,gotpts);
                    f.filestat:=f.filestat+[resumelater];
                    newff(f,v);
                    s:='file saved for later resume';
                  end else begin
                    star('Error Moving File Into Directory - Upload Voided.');
                    sysoplog(#3#3+'Error moving batch upload "'+sqoutsp(fn)+'" into directory');
                  end;
                end;
              end;
              if (not (resumelater in f.filestat)) then begin
                s:='File Deleted';
                assign(fi,WorkPath+'2\'+fn); erase(fi);
              end;
              sysoplog(#3#3+'Errors Batch Uploading "'+sqoutsp(fn)+'" - '+s);
            end;

            if (not ok) then begin
              st:=(rte*f.blocks);
              takeawayulrefundgot:=takeawayulrefundgot+st;
              r2dt(st,st1);
              star('Time Refund Of '+longtim(st1)+' Will Be Taken Away.');
            end else
              if (ubn<>0) then delubatch(ubn);
          end;

          findnext(dirinfo);
        end;

      fileboard:=oldboard;
      fiscan(pl);
      if (filerec(ulff).mode<>fmclosed) then close(ulff);

      nl;
      star('# Files Uploaded į '+cstr(totfils1)+' files.');
      if (totfils<>totfils1) then
        star('Files Successful į '+cstr(totfils)+' files.');
      star('File Size Uploaded į '+cstrl(totb1)+' bytes.');
      star('Batch Upload Time į '+longtim(tooktime)+'.');
      r2dt(tconvtime,tconvtime1);
      if (tconvtime<>0.0) then
        star('Total Convert Time į '+longtim(tconvtime1)+' (not refunded)');
      star('Transfer Rate į '+cstr(cps)+' cps');
      nl;
      r2dt(ulrefundgot,ulrefundgot1);
      star('Time Refund į '+longtim(ulrefundgot1)+'.');

      inc(systat.todayzlog.uploads,totfils);
      inc(systat.todayzlog.uk,totb1 div 1024);
      if (aacs(systat.ulvalreq)) then begin
        if (totpts<>0) then
        star('File Points į '+cstr(totpts)+' pts.');
        star('Upload Credits Got į '+cstr(totfils)+' files, '+cstr(totb1 div 1024)+'k.');
        nl;
        star('Thanks For The File'+plural+', '+thisuser.name+'!');
        inc(thisuser.uploads,totfils);
        inc(thisuser.filepoints,totpts);
        thisuser.uk:=thisuser.uk+(totb1 div 1024);
      end else begin
        nl;
        sprint(#3#5+'Thanks For The Upload'+plural+', '+thisuser.name+'!');
        sprompt(#3#5+'You Will Receive File ');
        if (systat.uldlratio) then
          sprompt('Credit')
        else
          sprompt('Points');
        sprint(' As Soon As '+systat.sysopname+' Validates The File'+plural+'!');
      end;
      nl;

      if (choptime<>0.0) then begin
        choptime:=choptime+ulrefundgot;
        freetime:=freetime-ulrefundgot;
        star('Sorry, No Upload Time Refund May Be Given At This Time.');
        star('You Will Get Your Refund After The Event.');
        nl;
      end;

      if (takeawayulrefundgot<>0.0) then begin
        nl;
        r2dt(takeawayulrefundgot,takeawayulrefundgot1);
        star('Taking Away Time Refund Of '+longtim(takeawayulrefundgot1));
        freetime:=freetime-takeawayulrefundgot;
      end;
      NodeUpDate('Available for Page');
      if (ahangup) then begin
        commandline('Hanging up phone again...');
        dophonehangup(FALSE);
        hangup:=TRUE;
      end;

    end;
  end;
  if (savpause) then thisuser.ac:=thisuser.ac+[pause];
end;

procedure batchinfo;
var anyyet:boolean;

  procedure sayit(s:string);
  begin
    if (not anyyet) then begin anyyet:=TRUE; nl; end;
    sprint(s);
  end;

begin
  anyyet:=FALSE;
  if (numbatchfiles<>0) then
    sayit(#3#9+'>> '+#3#3+'You have '+#3#1+cstr(numbatchfiles)+
          #3#3+' file'+aonoff(numbatchfiles<>1,'s','')+
               ' left in your download batch queue.');
  if (numubatchfiles<>0) then
    sayit(#3#9+'>> '+#3#3+'You have '+#3#1+cstr(numubatchfiles)+
          #3#3+' file'+aonoff(numubatchfiles<>1,'s','')+
               ' left in your upload batch queue.');
end;

end.

