Program Convert(input,output);

uses crt,dos;

{$I REV085.INC}
{$I PARA115.INC}
{$I REV081.INC}
{$I HEADER.INC}

Var i,whichconv:byte;
    sys:file of oldsystatrec; rsys:file of rsystatrec;
    systat:oldsystatrec; rsystat:rsystatrec;

Procedure InitSystat(wh:byte);
Begin
  if wh=1 then begin
    assign(sys,'paragon.dat');
    {$I-} reset(sys); {$I+}
    if ioresult<>0 then begin
      textcolor(12+128);
      writeln('You Must Run Convert From Your Main BBS Directory!');
      textcolor(15);
      halt(1);
    end;
    read(sys,systat);
    close(sys);
  end else begin
    assign(rsys,'status.dat');
    {$I-} reset(rsys); {$I+}
    if ioresult<>0 then begin
      textcolor(12+128);
      writeln('You Must Run Convert From Your Main BBS Directory!');
      textcolor(15);
      halt(1);
    end;
    read(rsys,rsystat);
    close(rsys);
  end;
end;

Procedure ConvertPUsers; { Convert Paragon v1.15 USER.LST }
Var ou:olduserrec;
    tu:userrec;
    ouf:file of olduserrec;
    tuf:file of userrec;

Begin
  assign(ouf,systat.systempath+'user.lst');
  {$I-} reset(ouf); {$I+}
  if ioresult<>0 then begin
    textcolor(LightRed+Blink);
    Writeln('Error Reading USER.LST.');
    textcolor(15);
    HALT(1);
  end;
  assign(tuf,systat.systempath+'user.new');
  rewrite(tuf);
  textcolor(14); write('Converting Paragon v1.15 USER.LST......'); textcolor(15);
  while not eof(ouf) do begin
    read(ouf,ou);
    with tu do begin
      name:=ou.name;
      realname:=ou.realname;
      pw:=ou.pw;
      ph:=ou.ph;
      bday:=ou.bday;
      firston:=ou.firston;
      laston:=ou.laston;
      accountnote:=ou.accountnote;
      computer:=ou.computer;
      note:=ou.note;
      lockedout:=ou.lockedout;
      deleted:=ou.deleted;
      lockedfile:=ou.lockedfile;
      ac:=ou.ac;
      ar:=ou.ar;
      for i:=1 to 64 do zzqscan[i]:=ou.zzqscan[i];
      for i:=1 to 64 do xqxxx[i]:=ou.xqxxx[i];
      for i:=1 to 64 do zzqscn[i]:=ou.zzqscn[i];
      zzdlnscn:=ou.zzdlnscn;
      for i:=1 to 20 do vote[i]:=ou.vote[i];
      for i:=1 to 20 do nuv[i]:=0;
      useautosigs:=false;
      sex:=ou.sex;
      ttimeon:=ou.ttimeon;
      uk:=ou.uk;
      dk:=ou.dk;
      uploads:=ou.uploads;
      downloads:=ou.downloads;
      loggedon:=ou.loggedon;
      tltoday:=ou.tltoday;
      msgpost:=ou.msgpost;
      emailsent:=ou.emailsent;
      filepoints:=ou.filepoints;
      linelen:=ou.linelen;
      pagelen:=ou.pagelen;
      ontoday:=ou.ontoday;
      illegal:=ou.illegal;
      sl:=ou.sl;
      dsl:=ou.dsl;
      cols:=ou.cols;
      lastmsg:=ou.lastmsg;
      lastfil:=ou.lastfil;
      timebank:=ou.timebank;
      trapactivity:=ou.trapactivity;
      trapseperate:=ou.trapseperate;
      timebankadd:=ou.timebankadd;
      mpointer:=ou.mpointer;
      chatauto:=ou.chatauto;
      chatseperate:=ou.chatseperate;
      slogseperate:=ou.slogseperate;
      clsmsg:=ou.clsmsg;
      avatarcoloradjust:=ou.avatarcoloradjust;
      headernumber:=ou.headernumber;
      hidename:=ou.hidename;
      for i:=1 to 11 do flistcfg[i]:=ou.res[i];
      didconfig:=0;
      for i:=13 to 15 do res[i-12]:=ou.res[i];
      msgconf:=ou.msgconf;
      filconf:=ou.filconf;
      incomingmail:=ou.incomingmail;
      outgoingmail:=ou.outgoingmail;
      arealistnumber:=ou.arealistnumber;
      haspickit:=false;
      for i:=1 to 6 do pickit[i]:=0;
      wallread:=0;
      newsread:=0;
    end;
    write(tuf,tu);
  end;
  close(tuf);
  close(ouf);
  writeln('Done!');
end;

Procedure ConvertPSystat; { Convert Paragon v1.15 PARAGON.DAT }
Var ou:oldsystatrec;
    tu:systatrec;
    ouf:file of oldsystatrec;
    tuf:file of systatrec;

Begin
  assign(ouf,'paragon.dat');
  {$I-} reset(ouf); {$I+}
  if ioresult<>0 then begin
    textcolor(LightRed+Blink);
    Writeln('Error Reading PARAGON.DAT.');
    textcolor(15);
    HALT(1);
  end;
  assign(tuf,'revelate.fil');
  rewrite(tuf);
  textcolor(14); write('Converting Paragon v1.15 PARAGON.DAT...'); textcolor(15);
  while not eof(ouf) do begin
    read(ouf,ou);
    with tu do begin
      systempath:=ou.systempath;
      textpath:=ou.textpath;
      msgpath:=ou.msgpath;
      menupath:=ou.menupath;
      externaleditor:=ou.externaleditor;
      protocolpath:=ou.protocolpath;
      archivepath:=ou.archivepath;
      sysopname:=ou.sysopname;
      bbsname:=ou.bbsname;
      bbsphone:=ou.bbsphone;
      lowtime:=ou.lowtime;
      hitime:=ou.hitime;
      dllowtime:=ou.dllowtime;
      dlhitime:=ou.dlhitime;
      shuttlelog:=ou.shuttlelog;
      lock9600:=ou.lock9600;
      systempw:=ou.systempw;
      newuserpw:=ou.newuserpw;
      lockoutpw:=ou.lockoutpw;
      system1pw:=ou.system1pw;
      system2pw:=ou.system2pw;
      system3pw:=ou.system3pw;
      system1security:=ou.system1security;
      system2security:=ou.system2security;
      system3security:=ou.system3security;
      blowtime:=ou.blowtime;
      bhitime:=ou.bhitime;
      bdllowtime:=ou.bdllowtime;
      bdlhitime:=ou.bdlhitime;
      multiline:=ou.multiline;
      allownewusers:=ou.allownewusers;
      swapshell:=ou.swapshell;
      ems_overlay:=ou.ems_overlay;
      eventwarningtime:=ou.eventwarningtime;
      autosysopfastlogon:=ou.autosysopfastlogon;
      phonepw:=ou.phonepw;
      localscreensec:=ou.localscreensec;
      localpass:=ou.localpass;
      usebios:=ou.usebios;
      cgasnow:=ou.cgasnow;
      globaltrap:=ou.globaltrap;
      autochatopen:=ou.autochatopen;
      sop:=ou.sop;
      csop:=ou.csop;
      msop:=ou.msop;
      fsop:=ou.fsop;
      spw:=ou.spw;
      seepw:=ou.seepw;
      normpubpost:=ou.normpubpost;
      normprivpost:=ou.normprivpost;
      anonpubread:=ou.anonpubread;
      anonprivread:=ou.anonprivread;
      anonpubpost:=ou.anonpubpost;
      anonprivpost:=ou.anonprivpost;
      seeunval:=ou.seeunval;
      dlunval:=ou.dlunval;
      nodlratio:=ou.nodlratio;
      nopostratio:=ou.nopostratio;
      nofilepts:=ou.nofilepts;
      ulvalreq:=ou.ulvalreq;
      default_onek:=ou.default_onek;
      default_clrmsg:=ou.default_clrmsg;
      default_expert:=ou.default_expert;
      default_pause:=ou.default_pause;
      maxprivpost:=ou.maxprivpost;
      maxpubpost:=ou.maxpubpost;
      maxchat:=ou.maxchat;
      maxwaiting:=ou.maxwaiting;
      csmaxwaiting:=ou.csmaxwaiting;
      maxlogontries:=ou.maxlogontries;
      sysopcolor:=ou.sysopcolor;
      usercolor:=ou.usercolor;
      minspaceforpost:=ou.minspaceforpost;
      minspaceforupload:=ou.minspaceforupload;
      backsysoplogs:=ou.backsysoplogs;
      wfcblanktime:=ou.wfcblanktime;
      linelen:=ou.linelen;
      pagelen:=ou.pagelen;
      offhooklocallogon:=ou.offhooklocallogon;
      forcevoting:=ou.forcevoting;
      searchdup:=ou.searchdup;
      stripclog:=ou.stripclog;
      timeoutbell:=ou.timeoutbell;
      timeout:=ou.timeout;
      for i:=1 to maxarcs do filearcinfo[i]:=ou.filearcinfo[i];
      for i:=1 to 3 do filearccomment[i]:=ou.filearccomment[i];
      uldlratio:=ou.uldlratio;
      fileptratio:=ou.fileptratio;
      fileptcomp:=ou.fileptcomp;
      fileptcompbasesize:=ou.fileptcompbasesize;
      ulrefund:=ou.ulrefund;
      tosysopdir:=ou.tosysopdir;
      validateallfiles:=ou.validateallfiles;
      remdevice:=ou.remdevice;
      maxintemp:=ou.maxintemp;
      minresume:=ou.minresume;
      maxdbatch:=ou.maxdbatch;
      maxubatch:=ou.maxubatch;
      newsl:=ou.newsl;
      newdsl:=ou.newdsl;
      newar:=ou.newar;
      newac:=ou.newac;
      newfp:=ou.newfp;
      newnote:='';
      autosl:=ou.autosl;
      autodsl:=ou.autodsl;
      autoar:=ou.autoar;
      autoac:=ou.autoac;
      autonote:='';
      allstartmenu:=ou.allstartmenu;
      bulletprefix:=ou.bulletprefix;
      lastdate:=ou.lastdate;
      curwindow:=ou.curwindow;
      istopwindow:=ou.istopwindow;
      callernum:=ou.callernum;
      numusers:=ou.numusers;
      todayzlog:=ou.todayzlog;
      postcredits:=ou.postcredits;
      rebootforevent:=ou.rebootforevent;
      watchdogdoor:=ou.watchdogdoor;
      maxusers:=ou.maxusers;
      windowon:=ou.windowon;
      regcode:=ou.regcode;
      emailboard:=ou.emailboard;
      confactive:=true;
      givegift:=false;
      giftpts:=0;
      yntype:=3;
      noagree:=0;
      shuttlesys:=1;
      newuservoting:=true;
      yesvotes:=3;
      novotes:=3;
      lottonight:=true;
      caneditunote:=false;
      usevalups:=0;
      for i:=1 to 186 do reservedspace[i]:=ou.reservedspace[i];
    end;
    write(tuf,tu);
  end;
  close(tuf);
  close(ouf);
  writeln('Done!');
end;


Procedure ConvertPBoards; { Convert Paragon v1.15 BOARDS.DAT }
Var ou:oldboardrec;
    tu:boardrec;
    ouf:file of oldboardrec;
    tuf:file of boardrec;

Begin
  assign(ouf,systat.systempath+'boards.dat');
  {$I-} reset(ouf); {$I+}
  if ioresult<>0 then begin
    textcolor(LightRed+Blink);
    Writeln('Error Reading BOARDS.DAT.');
    textcolor(15);
    HALT(1);
  end;
  assign(tuf,systat.systempath+'BOARDS.NEW');
  rewrite(tuf);
  textcolor(14); write('Converting Paragon v1.15 BOARDS.DAT....'); textcolor(15);
  while not eof(ouf) do begin
    read(ouf,ou);
    with tu do begin
      name:=ou.name;
      filename:=ou.filename;
      lastmsgid:=ou.lastmsgid;
      msgpath:=ou.msgpath;
      acs:=ou.acs;
      postacs:=ou.postacs;
      mciacs:=ou.mciacs;
      maxmsgs:=ou.maxmsgs;
      anonymous:=ou.anonymous;
      password:=ou.password;
      mbstat:=ou.mbstat;
      permindx:=ou.permindx;
      mbtype:=ou.mbtype;
      origin:=ou.origin;
      text_color:=ou.text_color;
      quote_color:=ou.quote_color;
      tear_color:=ou.tear_color;
      origin_color:=ou.origin_color;
      zone:=ou.zone;
      net:=ou.net;
      node:=ou.node;
      point:=ou.point;
      confnum:=1;
      msgstatus:=ou.msgstatus;
      addaccnote:=ou.addaccnote;
      maxfselines:=300;
    end;
    write(tuf,tu);
  end;
  close(tuf);
  close(ouf);
  writeln('Done!');
end;


Procedure ConvertPUFBoards(FileName:String); { Convert Paragon v1.15 *.DIR }
Var ou:oldulfrec;
    tu:ulfrec;
    ouf:file of oldulfrec;
    tuf:file of ulfrec;

Begin
  assign(ouf,systat.systempath+filename+'.dir');
  {$I-} reset(ouf); {$I+}
  if ioresult<>0 then begin
    textcolor(LightRed+Blink);
    Writeln('Error Reading '+filename+'.DIR.');
    textcolor(15);
    HALT(1);
  end;
  assign(tuf,systat.systempath+filename+'.NEW');
  rewrite(tuf);
  textcolor(11); write('Converting '+filename+'.DIR...'); textcolor(15);
  while not eof(ouf) do begin
    read(ouf,ou);
    with tu do begin
      filename:=ou.filename;
      description:=ou.description;
      filepoints:=ou.filepoints;
      fileto:=0;
      nacc:=ou.nacc;
      ft:=ou.ft;
      blocks:=ou.ft;
      owner:=ou.owner;
      stowner:=ou.stowner;
      date:=ou.date;
      daten:=ou.daten;
      vpointer:=ou.vpointer;
      filestat:=ou.filestat;
      for i:=1 to 2 do disknums[i]:=ou.res[i];
      fileinfo:=ou.fileinfo;
      crackgroup:=ou.crackgroup;
      reservedpassword:=ou.reservedpassword;
      reservedstring:=ou.reservedstring;
      for i:=1 to 4 do reserved[i]:=ou.reserved[i];
    end;
    write(tuf,tu);
  end;
  close(tuf);
  close(ouf);
  for i:=1 to 23 do write(' ');
end;


Procedure ConvertPUBoards; { Convert Paragon v1.15 UPLOADS.DAT }
Var ou:oldulrec;
    tu:ulrec;
    ouf:file of oldulrec;
    tuf:file of ulrec;

Begin
  assign(ouf,systat.systempath+'uploads.dat');
  {$I-} reset(ouf); {$I+}
  if ioresult<>0 then begin
    textcolor(LightRed+Blink);
    Writeln('Error Reading UPLOADS.DAT.');
    textcolor(15);
    HALT(1);
  end;
  assign(tuf,systat.systempath+'UPLOADS.NEW');
  rewrite(tuf);
  textcolor(14); write('Converting Paragon v1.15 UPLOADS.DAT...'); textcolor(15);
  while not eof(ouf) do begin
    read(ouf,ou);
    convertpufboards(ou.filename);
    with tu do begin
      name:=ou.name;
      filename:=ou.filename;
      dlpath:=ou.dlpath;
      ulpath:=ou.ulpath;
      maxfiles:=ou.maxfiles;
      password:=ou.password;
      arctype:=ou.arctype;
      cmttype:=ou.cmttype;
      fbdepth:=ou.fbdepth;
      fbstat:=ou.fbstat;
      acs:=ou.acs;
      ulacs:=ou.ulacs;
      nameacs:=ou.nameacs;
      permindx:=ou.permindx;
      confnum:=1;
      basetype:=0;
      avpoints:=0;
      avfiles:=false;
      creduler:=false;
      for i:=1 to 5 do res[i]:=ou.res[i];
    end;
    write(tuf,tu);
  end;
  close(tuf);
  close(ouf);
  writeln('Done!');
end;

Procedure ConvertRUsers; { Convert Revelation v0.81 TCSB.LST }
Var ou:ruserrec;
    tu:userrec;
    ouf:file of ruserrec;
    tuf:file of userrec;

Begin
  assign(ouf,rsystat.gfilepath+'tcsb.lst');
  {$I-} reset(ouf); {$I+}
  if ioresult<>0 then begin
    textcolor(LightRed+Blink);
    Writeln('Error Reading TCSB.LST.');
    textcolor(15);
    HALT(1);
  end;
  assign(tuf,rsystat.gfilepath+'user.lst');
  rewrite(tuf);
  textcolor(14); write('Converting Revelation v0.81 TCSB.LST......'); textcolor(15);
  while not eof(ouf) do begin
    read(ouf,ou);
    with tu do begin
      name:=ou.name;
      realname:=ou.realname;
      pw:=ou.pw;
      ph:=ou.ph;
      bday:=ou.bday;
      firston:=ou.firston;
      laston:=ou.laston;
      accountnote:=ou.usernote;
      computer:=ou.computer;
      note:=ou.note;
      lockedout:=ou.lockedout;
      deleted:=ou.deleted;
      lockedfile:=ou.lockedfile;
      ac:=ou.ac;
      ar:=ou.ar;
      for i:=1 to 64 do zzqscan[i]:=ou.zzqscan[i];
      for i:=1 to 64 do xqxxx[i]:=ou.xqxxx[i];
      for i:=1 to 64 do zzqscn[i]:=ou.zzqscn[i];
      zzdlnscn:=ou.zzdlnscn;
      for i:=1 to 20 do vote[i]:=ou.vote[i];
      for i:=1 to 20 do nuv[i]:=ou.nuv[i];
      useautosigs:=ou.useautosig;
      sex:=ou.sex;
      ttimeon:=ou.ttimeon;
      uk:=ou.uk;
      dk:=ou.dk;
      uploads:=ou.uploads;
      downloads:=ou.downloads;
      loggedon:=ou.loggedon;
      tltoday:=ou.tltoday;
      msgpost:=ou.msgpost;
      emailsent:=ou.emailsent;
      filepoints:=ou.filepoints;
      linelen:=ou.linelen;
      pagelen:=ou.pagelen;
      ontoday:=ou.ontoday;
      illegal:=ou.illegal;
      sl:=ou.sl;
      dsl:=ou.dsl;
      cols:=ou.cols;
      lastmsg:=ou.lastmsg;
      lastfil:=ou.lastfil;
      timebank:=ou.timebank;
      trapactivity:=ou.trapactivity;
      trapseperate:=ou.trapseperate;
      timebankadd:=ou.timebankadd;
      mpointer:=ou.mpointer;
      chatauto:=ou.chatauto;
      chatseperate:=ou.chatseperate;
      slogseperate:=ou.slogseperate;
      clsmsg:=true;
      avatarcoloradjust:=false;
      headernumber:=0;
      hidename:=false;
      for i:=1 to 11 do flistcfg[i]:=0;
      didconfig:=0;
      for i:=1 to 3 do res[i]:=0;
      wallread:=ou.wallread;
      newsread:=ou.newsread;
      haspickit:=ou.haspickit;
      for i:=1 to 6 do pickit[i]:=ou.pickit[i];
{      msgconf:=ou.msgconf;
      filconf:=ou.filconf;
      incomingmail:=ou.incomingmail;
      outgoingmail:=ou.outgoingmail;
      arealistnumber:=ou.arealistnumber; }
    end;
    write(tuf,tu);
  end;
  close(tuf);
  close(ouf);
  writeln('Done!');
end;

Procedure ConvertRSystat; { Convert Revelation v0.81 STATUS.DAT }
Var ou:rsystatrec;
    tu:systatrec;
    ouf:file of rsystatrec;
    tuf:file of systatrec;

Begin
  assign(ouf,'status.dat');
  {$I-} reset(ouf); {$I+}
  if ioresult<>0 then begin
    textcolor(LightRed+Blink);
    Writeln('Error Reading STATUS.DAT.');
    textcolor(15);
    HALT(1);
  end;
  assign(tuf,'revelate.dat');
  rewrite(tuf);
  textcolor(14); write('Converting Revelation v0.81 STATUS.DAT....'); textcolor(15);
  while not eof(ouf) do begin
    read(ouf,ou);
    with tu do begin
      systempath:=ou.gfilepath;
      textpath:=ou.afilepath;
      msgpath:=ou.msgpath;
      menupath:=ou.menupath;
      externaleditor:='';
      protocolpath:='';
      archivepath:='';
      sysopname:=ou.sysopname;
      bbsname:=ou.bbsname;
      bbsphone:=ou.bbsphone;
      lowtime:=ou.lowtime;
      hitime:=ou.hitime;
      dllowtime:=ou.dllowtime;
      dlhitime:=ou.dlhitime;
      shuttlelog:=ou.shuttlelog;
      lock9600:=false;
      systempw:=ou.sysoppw;
      newuserpw:=ou.newuserpw;
      lockoutpw:='';
      system1pw:=ou.shuttlepw;
      system2pw:=ou.shuttlepw;
      system3pw:=ou.shuttlepw;
      system1security:='';
      system2security:='';
      system3security:='';
      blowtime:=ou.b300lowtime;
      bhitime:=ou.b300hitime;
      bdllowtime:=ou.b300dllowtime;
      bdlhitime:=ou.b300dlhitime;
      multiline:=false;
      allownewusers:=not ou.closedsystem;
      swapshell:=ou.swapshell;
      ems_overlay:=ou.useems;
      eventwarningtime:=ou.eventwarningtime;
      autosysopfastlogon:=false;
      phonepw:=ou.phonepw;
      localscreensec:=ou.localscreensec;
      localpass:=false;
      usebios:=ou.usebios;
      cgasnow:=ou.cgasnow;
      globaltrap:=ou.globaltrap;
      autochatopen:=ou.autochatopen;
      sop:=ou.sop;
      csop:=ou.csop;
      msop:=ou.msop;
      fsop:=ou.fsop;
      spw:=ou.spw;
      seepw:=ou.seepw;
      normpubpost:=ou.normpubpost;
      normprivpost:=ou.normprivpost;
      anonpubread:=ou.anonpubread;
      anonprivread:=ou.anonprivread;
      anonpubpost:=ou.anonpubpost;
      anonprivpost:=ou.anonprivpost;
      seeunval:=ou.seeunval;
      dlunval:=ou.dlunval;
      nodlratio:=ou.nodlratio;
      nopostratio:=ou.nopostratio;
      nofilepts:=ou.nofilepts;
      ulvalreq:=ou.ulvalreq;
      default_onek:=true;
      default_clrmsg:=true;
      default_expert:=false;
      default_pause:=true;
      maxprivpost:=ou.maxprivpost;
      maxpubpost:=ou.maxpubpost;
      maxchat:=ou.maxchat;
      maxwaiting:=ou.maxwaiting;
      csmaxwaiting:=ou.csmaxwaiting;
      maxlogontries:=ou.maxlogontries;
      sysopcolor:=ou.sysopcolor;
      usercolor:=ou.usercolor;
      minspaceforpost:=ou.minspaceforpost;
      minspaceforupload:=ou.minspaceforupload;
      backsysoplogs:=ou.backsysoplogs;
      wfcblanktime:=ou.wfcblanktime;
      linelen:=ou.linelen;
      pagelen:=ou.pagelen;
      offhooklocallogon:=ou.offhooklocallogon;
      forcevoting:=ou.forcevoting;
      searchdup:=ou.searchdup;
      stripclog:=ou.stripclog;
      timeoutbell:=ou.timeoutbell;
      timeout:=ou.timeout;
      for i:=1 to maxarcs do filearcinfo[i]:=ou.filearcinfo[i];
      for i:=1 to 3 do filearccomment[i]:='';
      uldlratio:=ou.uldlratio;
      fileptratio:=ou.fileptratio;
      fileptcomp:=ou.fileptcomp;
      fileptcompbasesize:=ou.fileptcompbasesize;
      ulrefund:=ou.ulrefund;
      tosysopdir:=ou.tosysopdir;
      validateallfiles:=ou.validateallfiles;
      remdevice:=ou.remdevice;
      maxintemp:=ou.maxintemp;
      minresume:=ou.minresume;
      maxdbatch:=ou.maxdbatch;
      maxubatch:=ou.maxubatch;
      newsl:=ou.newsl;
      newdsl:=ou.newdsl;
      newar:=ou.newar;
      newac:=ou.newac;
      newfp:=ou.newfp;
      newnote:=ou.newnote;
      autosl:=ou.autosl;
      autodsl:=ou.autodsl;
      autoar:=ou.autoar;
      autoac:=ou.autoac;
      autonote:=ou.autonote;
      allstartmenu:=ou.allstartmenu;
      bulletprefix:=ou.bulletprefix;
      lastdate:=ou.lastdate;
      curwindow:=ou.curwindow;
      istopwindow:=ou.istopwindow;
      callernum:=ou.callernum;
      numusers:=ou.numusers;
      todayzlog:=ou.todayzlog;
      postcredits:=ou.postcredits;
      rebootforevent:=ou.rebootforevent;
      watchdogdoor:=ou.watchdogdoor;
      maxusers:=ou.maxusers;
      windowon:=ou.windowon;
      regcode:='';
      emailboard:=0;
      confactive:=ou.res1[1]=1;
      givegift:=ou.res1[2]=1;
      giftpts:=ou.res1[3];
      yntype:=3;
      noagree:=ou.res1[5];
      shuttlesys:=ou.res1[4];
      newuservoting:=ou.newuservoting;
      yesvotes:=ou.yesvotes;
      novotes:=ou.novotes;
      lottonight:=ou.lottonight;
      caneditunote:=ou.res1[6]=1;
      usevalups:=0;
      for i:=1 to 186 do reservedspace[i]:=0;
    end;
    write(tuf,tu);
  end;
  close(tuf);
  close(ouf);
  writeln('Done!');
end;

Procedure ConvertRBoards; { Convert Revelation v0.81 BOARDS.DAT }
Var ou:rboardrec;
    tu:boardrec;
    ouf:file of rboardrec;
    tuf:file of boardrec;

Begin
  assign(ouf,rsystat.gfilepath+'boards.dat');
  {$I-} reset(ouf); {$I+}
  if ioresult<>0 then begin
    textcolor(LightRed+Blink);
    Writeln('Error Reading BOARDS.DAT.');
    textcolor(15);
    HALT(1);
  end;
  assign(tuf,rsystat.gfilepath+'BOARDS.NEW');
  rewrite(tuf);
  textcolor(14); write('Converting Revelation v0.81 BOARDS.DAT....'); textcolor(15);
  while not eof(ouf) do begin
    read(ouf,ou);
    with tu do begin
      name:=ou.name;
      filename:=ou.filename;
      lastmsgid:=ou.lastmsgid;
      msgpath:=ou.msgpath;
      acs:=ou.acs;
      postacs:=ou.postacs;
      mciacs:=ou.mciacs;
      maxmsgs:=ou.maxmsgs;
      anonymous:=ou.anonymous;
      password:=ou.password;
      mbstat:=ou.mbstat;
      permindx:=ou.permindx;
      mbtype:=ou.mbtype;
      origin:=ou.origin;
      text_color:=ou.text_color;
      quote_color:=ou.quote_color;
      tear_color:=ou.tear_color;
      origin_color:=ou.origin_color;
      zone:=ou.zone;
      net:=ou.net;
      node:=ou.node;
      point:=ou.point;
      confnum:=ou.res[1];
      msgstatus:=1;
      addaccnote:=TRUE;
      maxfselines:=300;
    end;
    write(tuf,tu);
  end;
  close(tuf);
  close(ouf);
  writeln('Done!');
end;

Procedure ConvertRUFBoards(FileName:String); { Convert Revelation v0.81 *.DIR }
Var ou:rulfrec;
    tu:ulfrec;
    ouf:file of rulfrec;
    tuf:file of ulfrec;

Begin
  assign(ouf,rsystat.gfilepath+filename+'.dir');
  {$I-} reset(ouf); {$I+}
  if ioresult<>0 then begin
    textcolor(LightRed+Blink);
    Writeln('Error Reading '+filename+'.DIR.');
    textcolor(15);
    HALT(1);
  end;
  assign(tuf,rsystat.gfilepath+filename+'.NEW');
  rewrite(tuf);
  textcolor(11); write('Converting '+filename+'.DIR...'); textcolor(15);
  while not eof(ouf) do begin
    read(ouf,ou);
    with tu do begin
      filename:=ou.filename;
      description:=ou.description;
      filepoints:=ou.filepoints;
      fileto:=ou.fileto;
      nacc:=ou.nacc;
      ft:=ou.ft;
      blocks:=ou.blocks;
      owner:=ou.owner;
      stowner:=ou.stowner;
      date:=ou.date;
      daten:=ou.daten;
      vpointer:=ou.vpointer;
      filestat:=ou.filestat;
      for i:=1 to 2 do disknums[i]:=0;
      fileinfo:='';
      crackgroup:='';
      reservedpassword:='';
      reservedstring:='';
      for i:=1 to 4 do reserved[i]:=0;
    end;
    write(tuf,tu);
  end;
  close(tuf);
  close(ouf);
  for i:=1 to 23 do write(' ');
end;


Procedure ConvertRUBoards; { Convert Revelation v0.81 UPLOADS.DAT }
Var ou:rulrec;
    tu:ulrec;
    ouf:file of rulrec;
    tuf:file of ulrec;

Begin
  assign(ouf,rsystat.gfilepath+'uploads.dat');
  {$I-} reset(ouf); {$I+}
  if ioresult<>0 then begin
    textcolor(LightRed+Blink);
    Writeln('Error Reading UPLOADS.DAT.');
    textcolor(15);
    HALT(1);
  end;
  assign(tuf,rsystat.gfilepath+'UPLOADS.NEW');
  rewrite(tuf);
  textcolor(14); write('Converting Revelation v0.81 UPLOADS.DAT...'); textcolor(15);
  while not eof(ouf) do begin
    read(ouf,ou);
    convertrufboards(ou.filename);
    with tu do begin
      name:=ou.name;
      filename:=ou.filename;
      dlpath:=ou.dlpath;
      ulpath:=ou.ulpath;
      maxfiles:=ou.maxfiles;
      password:=ou.password;
      arctype:=ou.arctype;
      cmttype:=ou.cmttype;
      fbdepth:=ou.fbdepth;
      fbstat:=ou.fbstat;
      acs:=ou.acs;
      ulacs:=ou.ulacs;
      nameacs:=ou.nameacs;
      permindx:=ou.permindx;
      confnum:=ou.res[1];
      basetype:=ou.res[2];
      avpoints:=ou.res[4];
      avfiles:=(ou.res[3]=1);
      creduler:=false;
      for i:=1 to 5 do res[i]:=0;
    end;
    write(tuf,tu);
  end;
  close(tuf);
  close(ouf);
  writeln('Done!');
end;


Begin (* Main *)
  header('CONVTO85 v1.00','060192','Convert From Paragon/Revelation To Revelation v0.85 Structures.');
  writeln;
  textcolor(3); writeln('Select Conversion Type:'); writeln;
  textcolor(11); writeln('[1] Paragon v1.15+   -> Revelation v0.85');
  writeln('[2] Revelation v0.81 -> Revelation v0.85');
  writeln; textcolor(3); repeat write('Choose -> '); readln(whichconv); until whichconv in [1..2];
  initsystat(whichconv);
  case whichconv of
    1:begin
        convertpusers;
{        convertpsystat; }
        convertpboards;
        convertpuboards;
      end;
    2:begin
        convertrusers;
        convertrsystat;
        convertrboards;
        convertruboards;
      end;
  end;
End.

