UNIT Users;
{$X+,I-,F+,O+}
INTERFACE

USES Crt,Dos,GenTypes,Modem,Fossil,BcShare,Misc,ConfigU;

FUNCTION OpenUF(Mode:Byte):Boolean;
FUNCTION CloseUF:Boolean;
FUNCTION WriteUf(User:UserRec):Boolean;
FUNCTION ReadUf(VAR User:UserRec):Boolean;
FUNCTION SaveNew:Boolean;
FUNCTION LoadUser(I:Integer; VAR User:UserRec):Boolean;
FUNCTION SaveUser(I:Integer; User:UserRec):Boolean;
FUNCTION LoadSysOp:Boolean;
FUNCTION UserNum:Integer;
FUNCTION UserExist(Alias:String; VAR URT:UserExistRec):Boolean;
PROCEDURE UserEditor;
PROCEDURE ListUsers;

IMPLEMENTATION

VAR Uf:File of UserRec;

FUNCTION OpenUF(Mode:Byte):Boolean;
VAR I:Integer;
Begin
  Repeat Ignore:=IOresult Until Ignore=0;
  OpenUF:=False;
  If Not Exist(Sys.DataDir+'\USER.LST') then
    Begin
      Assign(Uf,Sys.DataDir+'\USER.LST');
      Rewrite(Uf);
      If IOresult<>0 then Exit;
      Close(Uf);
    End;
  Assign(Uf,Sys.DataDir+'\USER.LST');
  SetFileMode(Mode);
  I:=IOresult;
  Repeat
    Reset(Uf);
    I:=IOresult;
    If I=5 then Delay(300);
  Until I<>5;
  SetFileMode(NormalMode);
  If I=0 then OpenUf:=True;
End;

FUNCTION CloseUF:Boolean;
Begin
  Close(Uf);
  CloseUf:=(IOresult=0);
  Repeat Ignore:=IOresult Until Ignore=0;
End;

FUNCTION WriteUf(User:UserRec):Boolean;
VAR I,B:Byte;
Begin
  Repeat Ignore:=IOresult Until Ignore=0;
  I:=FilePos(Uf)*SizeOf(UserRec);
  With FileRec(Uf) do LockFile(Handle,Lock,I,SizeOf(UserRec));
  B:=IOresult;
  Repeat
    Write(Uf,User);
    B:=IOresult;
    If B=5 then Delay(300);
  Until B<>5;
  With FileRec(Uf) do LockFile(Handle,Unlock,I,SizeOf(UserRec));
  WriteUf:=(B=0);
End;

FUNCTION ReadUf(VAR User:UserRec):Boolean;
VAR I,B:Integer;
Begin
  Repeat Ignore:=IOresult Until Ignore=0;
  B:=IOresult;
  Repeat
    Read(Uf,User);
    B:=IOresult;
    If B=5 then Delay(300);
  Until B<>5;
  ReadUf:=(B=0);
  If B=0 then User.Number:=FilePos(Uf);
End;

FUNCTION SaveNew:Boolean;
LABEL Done;
Begin
  Repeat Ignore:=IOresult Until Ignore=0;
  SaveNew:=False;
  If Not OpenUf(WriteDenyNone) then Exit;
  Seek(Uf,FileSize(Uf));
  If Not WriteUf(User) then Goto Done;
  SaveNew:=True;
  Done:
  CloseUf;
End;

FUNCTION LoadUser(I:Integer; VAR User:UserRec):Boolean;
VAR B:Byte;
Begin
  Repeat Until IOresult=0;
  LoadUser:=False;
  If Not OpenUf(ReadDenyNone) then Exit;
  Seek(Uf,I-1);
  Repeat
    Read(Uf,User);
    B:=IOResult;
    If B=5 then Delay(300);
  Until (B<>5);
  If B=0 then
    Begin
      LoadUser:=True;
      User.Number:=FilePos(Uf);
    End;
  CloseUf;
End;

FUNCTION SaveUser(I:Integer; User:UserRec):Boolean;
VAR B:Byte;
Begin
  Repeat Until IOresult=0;
  SaveUser:=False;
  If Not OpenUf(WriteDenyNone) then Exit;
  Seek(Uf,I-1);
  Repeat
    Write(Uf,User);
    B:=IOresult;
    If B=5 then Delay(300);
  Until B<>5;
  SaveUser:=(B=0);
  CloseUf;
End;

FUNCTION LoadSysOp:Boolean;
Begin
  LoadSysOp:=LoadUser(1,User);
End;

PROCEDURE GetStrXY(X,Y:Byte; VAR S:String; Len:Byte);
Begin
  GoXY(X+Length(S),Y);
  Del(Length(S));
  Limit(S,Len,0);
End;

FUNCTION GetVal(X,Y:Byte; S:String):Integer;
Begin
  GoXY(X+Length(S),Y);
  Del(Length(S));
  Limit(S,8,0);
  GetVal:=Intt(S);
End;

FUNCTION UserNum:Integer;
Begin
  UserNum:=1;
  If Not OpenUf(ReadDenyNone) then Exit;
  UserNum:=FileSize(Uf)+1;
  CloseUf;
End;

FUNCTION UserExist(Alias:String; VAR URT:UserExistRec):Boolean;
VAR I:Integer; U:UserRec;
LABEL Finish,Done;
Begin
  UserExist:=False;
  I:=Intt(Alias);
  If I>0 then
    Begin
      If Not LoadUser(I,U) then Goto Finish else Goto Done;
    End;
  If Not OpenUf(ReadDenyNone) then Exit;
  If FileSize(Uf)=0 then Goto Finish;
  I:=0;
  Repeat
    Seek(Uf,I);
    ReadUf(U);
    Inc(I);
  Until (I=FileSize(Uf)) or (Logoff) or (Upper(Alias)=Upper(U.Alias));
  If Upper(Alias)<>Upper(U.Alias) then Goto Finish;
  Done:
  If U.Deleted then Goto Finish;
  Urt.Name:=U.Name;
  Urt.Alias:=U.Alias;
  Urt.Password:=Upper(U.Password);
  Urt.Number:=I;
  Urt.Sl:=U.Sl;
  Urt.Dsl:=U.Dsl;
  Urt.Note:=U.Note;
  UserExist:=True;
  Finish:
  CloseUf; { Closed or not, just ignore result! }
End;

PROCEDURE UserEditor;
VAR TotalUsers:Integer; U:UserRec; CurrentUser:Integer; C:Char;
    S:String;

FUNCTION Emul(Emulation:Emulation_Set):String;
Begin
  Case Emulation of
    Ansi:Emul:='Ansi';
    Avatar:Emul:='Avatar';
    OGi_OGt:Emul:='OGi/OGt';
    Ascii:Emul:='None';
  End;
End;

PROCEDURE Fill(I:Byte); Forward;

PROCEDURE ToggleFlags;
VAR C:Char;
Begin
  Fill(13);
  Repeat
    C:=Upcase(Getkey);
    If C in ['A'..'Z'] then
      Begin
        GoXY(13+Ord(C)-65,14);
        U.Flag[Ord(C)-64]:=Not U.Flag[Ord(C)-64];
        If U.Flag[Ord(C)-64] then Color(15,0) else Color(7,0);
        Print(C);
      End else
    If C in ['1'..'4'] then
      Begin
        GoXY(38+Intt(C),14);
        U.Flag[Intt(C)+26]:=Not U.Flag[Intt(C)+26];
        If U.Flag[Intt(C)+26] then Color(15,0) else Color(7,0);
        Print(C);
      End;
  Until (C=^M) or ((C=#27) and (Not ChWait)) or (Logoff);
End;

PROCEDURE PrintFlags;
VAR I:Byte; C:Boolean;
Begin
  C:=False;
  For I:=1 to 30 do
    Begin
      If (U.Flag[I]) and (Not C) then
        Begin
          C:=True;
          Color(15,0);
        End;
      If (Not U.Flag[I]) and (C) then
        Begin
          C:=False;
          Color(7,0);
        End;
      If I in [1..26] then Print(Chr(Ord('A')-1+I));
      If I in [27..30] then Print(Chr(Ord('1')-27+I));
    End;
End;

PROCEDURE Fill(I:Byte);
Begin
 If I=1 then GoXY(12,2) else
 If I in [2..11] then GoXY(16,I+1) else
 If I=12 then GoXY(18,13) else
 If I=13 then GoXY(13,14) else
 If I in [14,15] then GoXY(24,I+1) else
 If I>15 then GoXY(66,I-14);
 Case I of
   1:Begin
       Print(Strr(CurrentUser)+'/'+Strr(TotalUsers));
       If U.Deleted then
         Begin
           Print(#32);
           Color(12,0);
           Print('<D>');
           Color(7,0);
         End else Print('    ');
     End;
   2:Print(U.Alias);
   3:Print(U.Name);
   4:Print(U.Note);
   5:If Carrier then Print('[ Classified ]') else Print(U.Password);
   6:Print(U.Address);
   7:Print(U.City);
   8:Print(U.State);
   9:Print(U.Zip);
   10:Print(U.Phone);
   11:Print(U.BirthDay);
   12:Print(U.Expiration);
   13:PrintFlags;
   14:Print(Strr(U.FilePointRatio)+'fps:1fp');
{   15:?!?                                 }
   16:Print(Strr(U.Sl));
   17:Print(Strr(U.Dsl));
   18:Print(Strr(U.TimeLimit));
   19:Print('N/A');
   20:Print('N/A');
   21:Print(Strr(U.PostCallRatio)+'%');
   22:Print('N/A');
   23:Print(Strr(U.FilesRatio)+'k:1k');
   24:Print(Strr(U.Posts));
   25:Print('N/A');
   26:Print('N/A');
   27:Print(Strr(U.Kuploaded));
   28:Print(Strr(U.Kdownloaded));
   29:Print(Strr(U.FilePoints));
   30:Print(Strr(U.Lines));
   31:Print(Emul(U.Emulation));
   32:Print(Strr(U.Prompt));
   33:Print(Strr(U.BankMaximum));
   34:Print(Strr(U.MaximumDeposit));
   35:Print(Strr(U.Balance));
   36:Print(Strr(U.Calls));
 End;
End;

PROCEDURE FillAll;
VAR I:Byte;
Begin
  Show('USEREDIT',True,False);
  For I:=1 to 36 do Fill(I);
End;

PROCEDURE RemoveNuv;
VAR F:File; S:String;
Begin
  New(Nuv);
  S:=Sys.DataDir+'\NUV.DAT';
  If Exist(S) then
    Begin
      Assign(F,S);
      FillChar(Nuv^,SizeOf(Nuv^),#0);
      Nuv^.Deleted:=True;
      SetFileMode(WriteDenyNone);
      Reset(F,1);
      SetFileMode(NormalMode);
      Seek(F,(U.NuvLoc-1)*SizeOf(Nuv^));
      Repeat
        BlockWrite(F,Nuv^,SizeOf(Nuv^));
        Ignore:=IOresult;
        If Ignore=5 then Delay(300);
      Until Ignore<>5;
      Close(F);
    End;
  Dispose(Nuv);
End;

PROCEDURE ListLevels;
VAR F:File; Access:AccessRec; L:Integer; S:String; I:Word;
Begin
  S:=Sys.DataDir+'\LEVELS.DAT';
  SetFileMode(NormalMode);
  Assign(F,S);
  If Not Exist(S) then
    Begin
      SSC(4); Println('There are no levels!');
    End else
    Begin
      I:=1;
      Reset(F,1);
      SSC(1);
      If FileSize(F)>0 then
     Begin
      MenuTop;
      Repeat
        BlockRead(F,Access,SizeOf(Access),L);
        If L=SizeOf(Access) then
          Begin
            ListCmd(I,Access.Note);
            Inc(I);
          End;
      Until (Logoff) or (L<>SizeOf(Access));
      MenuBottom;
     End else
       Begin
         SSC(4);
         Println('There are no levels!');
       End;
      Close(F);
    End;
End;

Begin
  CloseFile;
  Color(3,0);
  Cls;
  If Not LoadUser(1,U) then
    Begin
      Color(12,0);
      Println('No users exist!  Please logon and create one!');
      Exit;
    End;
  If Not OpenUf(ReadDenyNone) then Exit;
  TotalUsers:=FileSize(Uf);
  CloseUf;
  CurrentUser:=1;
  FillAll;
  Repeat
    GoXY(12+Length(Strr(CurrentUser))+Length(Strr(TotalUsers))+1,2);
    C:=Upcase(Getkey);
    If (C='+') and (TotalUsers>1) then
      Begin
        If Upper(User.Alias)=Upper(U.Alias) then User:=U;
        SaveUser(CurrentUser,U);
        If CurrentUser=TotalUsers then CurrentUser:=1 else Inc(CurrentUser);
        If Not LoadUser(CurrentUser,U) then Exit;
        FillAll;
      End else
    If (C='-') and (TotalUsers>1) then
      Begin
        If Upper(User.Alias)=Upper(U.Alias) then User:=U;
        SaveUser(CurrentUser,U);
        If CurrentUser=1 then CurrentUser:=TotalUsers else Dec(CurrentUser);
        If Not LoadUser(CurrentUser,U) then Exit;
        FillAll;
      End else
    Case C of
      'A':GetStrXY(16,3,U.Alias,30);
      'N':GetStrXY(16,4,U.Name,30);
      'O':GetStrXY(16,5,U.Note,30);
      '$':If Not Carrier then GetStrXY(16,6,U.Password,30);
      'R':GetStrXY(16,7,U.Address,30);
      'C':GetStrXY(16,8,U.City,30);
(*      'T':GetStrXY(16,9,U.State,2);
      'Z':GetStrXY(16,10,U.Zip,10);
      'P':GetStrXY(16,11,U.Phone,12);*)
      'F':ToggleFlags;
      '.':Begin LoadUser(CurrentUser,U); FillAll; End;
      'D':Begin U.Deleted:=Not U.Deleted; Fill(1); End;
      'S':U.Sl:=GetVal(66,2,Strr(U.Sl));
      'L':U.Dsl:=GetVal(66,3,Strr(U.Dsl));
      ':':U.Calls:=GetVal(66,22,Strr(U.Calls));
      '0':U.FilePointRatio:=GetVal(24,15,Strr(U.FilePointRatio));
      '1':U.Colors:=Sys.Colors;
      '2':U.TimeLimit:=GetVal(66,4,Strr(U.TimeLimit));
      '5':U.PostCallRatio:=GetVal(66,7,Strr(U.PostCallRatio));
      '7':U.FilesRatio:=GetVal(66,9,Strr(U.FilesRatio));
      '#':U.FilePoints:=GetVal(66,15,Strr(U.FilePoints));
      'V':Begin
            U.Sl:=U.Sl+5;
            U.Dsl:=U.Dsl+5;
            Cls;
            SSC(1);
            If U.NuvLoc>0 then
              Begin
                Print('Removing Users New User Voting Record...');
                RemoveNUV;
                Println(' Done!');
                U.NuvLoc:=0;
                If Sys.NewUsers>0 then Dec(Sys.NewUsers);
              End;
            Repeat
              Print('Level to Validate user to (?/List): '); SSC(0); Limit(S,5,2); Cr;
              If S='?' then ListLevels;
            Until (Logoff) or (S<>'?');
            If Intt(S)>0 then
            If ValidateUser(U,Intt(S)) then
              Begin
                SSC(1); Println('User Validated.');
                SysOpAccess:=False;
              End else
              Begin
                SSC(4);
                Println('Error validating user!');
              End else
            Begin
              SSC(4);
              Println('Level does not exist!');
            End;
            getkey;
            fillall;
          End;
    End;
  Until (C='Q') or (Logoff);
  If SysOpAccess then
    If User.Sl<>255 then SysOpAccess:=False;
  If Upper(User.Alias)=Upper(U.Alias) then User:=U;
  SaveUser(CurrentUser,U);
  Open(ReadDenyNone);
End;

PROCEDURE ListUsers;
VAR User:UserRec; B:Boolean; C:Char;
Begin
  If Not OpenUf(ReadDenyNone) then
    Begin
      SSC(4);
      Println('Warning!  Error opening User File!');
      Exit;
    End;
  If FileSize(Uf)=0 then
    Begin
      SSC(4);
      Println('Strange...  This system has NO users!  [ Moron! ]');
    End else
    Begin
      Show('ULISTTOP',False,False);
      Repeat
      Repeat
        B:=ReadUf(User);
        If B then
          Begin
            SSC(1);
            Print(User.Alias);
            Repeat Print(#32); Until (WhereX=30);
            Print(User.Note);
            Repeat Print(#32); Until (WhereX=60);
            Println(User.Name);
          End;
      Until (Not B) or (Logoff) or (ChWait);
      if ChWait then C:=Getkey else C:=#0;
      Until (C in [#32,^X,^C]) or (Logoff) or (Not B);
      Show('ULISTBOT',False,False);
    End;
  Close(Uf);
End;

End.
