UNIT MenuGen;
{$I-,X+}
{ Menu Routines for Calling Throughout OTERA }
{!!!! REDO EVERYTHING!!  SPEED!!  STACKING MENU COMMANDS ETC. ETC. !!!!}

INTERFACE

USES GenTypes,Files,Modem,Misc,Crt,Config,Dos,Swap,Messages,BcShare;

TYPE Kstring=String[3];

PROCEDURE LoadStandard;
FUNCTION LoadMenuSet(B:Byte):Boolean;
FUNCTION InsertCommand(Loc:Byte):Boolean;
FUNCTION DeleteCommand(Loc:Byte):Boolean;
PROCEDURE CreateMenu;
PROCEDURE MenuPrompt;
PROCEDURE TheBBS;
PROCEDURE RunAutos;
FUNCTION RunMenu(S:String):Boolean;
FUNCTION RunData(Cmd:Byte; B:Boolean):Boolean;
FUNCTION RunCommand(Cmd:Byte):Boolean;
PROCEDURE HelpMenu;
PROCEDURE GenericMenu(N:Boolean);
FUNCTION LoadCommands(S:String):Boolean;
FUNCTION ReadCommands(S:String):Boolean;
FUNCTION SaveCommands(S:String):Boolean;
FUNCTION SaveMenu(S:String):Boolean;
FUNCTION LoadLibrary(I:Integer):Boolean;
FUNCTION SaveLibrary(I:Integer):Boolean;
FUNCTION DeleteLibrary(I:Integer):Boolean;
FUNCTION Libraries:Integer;

VAR LibF:File of LibraryRec;
    MenF:File;
    CmdF:File;
    MenuS:String;
    DataS:String;  { Unknown String in Data String }
    DataI:Integer; { Unknown Byte in Data String }
    MenuQuit:Boolean;
    Fcmd:Byte;
    Nor:Boolean;
    NoQuitMatrix:Boolean;
    CurrentBar:Byte;

CONST
    MustRun:Boolean=False;
    MustRunCmd:Byte=0;

IMPLEMENTATION

CONST Columns:Array[1..6] of Byte=(80,40,26,20,16,13);
      OldEmulation:Emulation_Set=Ansi;
      ScanCommand:Integer=0;
      OldBar:Boolean=False;
      Up:Boolean=(False);
      Down:Boolean=(False);
      Left:Boolean=(False);
      Right:Boolean=(False);
      Esc:Boolean=(False);

PROCEDURE QuitFromMenu; Forward;

PROCEDURE LoadStandard;
Begin
  MenuLib.Location:=Sys.MenuDir;
  MenuLib.Name:='Default Menus';
End;

PROCEDURE UserConfig;
VAR I,B:Integer; S:String;
Begin
  B:=Libraries;
  If B=0 then Exit;
  Println('Sorry, but no fancy config yet.  I haven''t had much time, even');
  Println('though it is Christmas Vacation to get much done.');
  For I:=1 to B do
    Begin
      LoadLibrary(I);
      Println(Strr(I)+':'+MenuLib.Name);
    End;
  Print('New Menu Library: '); Limit(S,3,0); Cr;
  LoadLibrary(User.MenuSet);
  If S='' then Exit;
  I:=Intt(S);
  If (I<1) or (I>B) then Exit;
  User.MenuSet:=I;
  If LoadLibrary(User.MenuSet) then RunMenu(DataS);
End;

FUNCTION LoadMenuSet(B:Byte):Boolean;
VAR I:Byte;
Begin
  LoadMenuSet:=False;
  If Libraries=0 then Exit;
  If Not LoadLibrary(B) then Exit;
  LoadMenuSet:=True;
End;

PROCEDURE ClearMenu;
VAR I:Byte;
Begin
  If Menu.Commands<>0 then For I:=Menu.Commands downto 1 do Dispose(MenCmd[I]);
End;

FUNCTION Figure(S:String; Cmd:Byte):Boolean;
VAR B:Boolean; I:Byte; C:Char;
Begin
  Figure:=True;
  If S='' then Exit;
  If (S[1] in ['''','"','^']) and (S[Length(S)] in ['''','"','^']) then
    Begin
      Delete(S,1,1);
      Dec(S[0]);
      Tran(S);
    End else
  If (Upcase(S[1])='Y') and (UpCase(S[2])='N') and (S[3]='-') and (Length(S)=4) then
    Begin
      B:=UpCase(S[Length(S)])='Y';
      Figure:=YesNo(B,User.YesNoBar); SSC(1);
    End else
  If (Upcase(S[1])='O') and (Upcase(S[2])='N') and (S[3]='[') then
    Begin
    End else
  If (S[1]='{') and (S[Length(S)]='}') then
    Begin
    End else
  If (Upcase(S[1])='O') and (Upcase(S[2])='F') and (Upcase(S[3])='F') and (S[4]='[') then
    Begin
    End else
  If S='SF:R:Y' then User.Flag['R',1]:=True else
  If S='SF:R:N' then User.Flag['R',1]:=False else
  If (Upcase(S[1])='F') and (Upcase(S[5])='T') and (UpcasE(S[6])='O') then
    Begin
      Delete(S,1,7);
      Dec(S[0]); { FILLTO[X,C] is now X,C }
      C:=S[Length(S)];
      Dec(S[0],2);
      For I:=WhereX to Intt(S) do Print(C);
    End else
  If Pos('FORCECMD[',S)=1 then
    Begin
      Dec(S[0]);
      Delete(S,1,9);
      OldBar:=True;
      CurrentBar:=Intt(S);
    End else
  If (Upcase(S[1])='F') and (Upcase(S[3])='L') and (Upcase(S[4])='L') then
    Begin
      Delete(S,1,5);
      Dec(S[0]);
      C:=S[Length(S)];
      Dec(S[0],2);
      For I:=1 to Intt(S) do Print(C);
    End else
  If (S='CLS') then Cls Else
  If Intt(S)>0 then DataI:=DataI+Intt(S) else DataS:=DataS+S;
End;

FUNCTION RunData(Cmd:Byte; B:Boolean):Boolean;
VAR S,S1:String; I:Byte; Quit:Boolean;
Begin
  If B then DataI:=0;
  If B then DataS:='';
  RunData:=True;
  If Not B then S:=MenCmd[Cmd]^.AfterData else S:=MenCmd[Cmd]^.Data;
  If S='' then Exit;
  I:=1;
  Quit:=False;
  Nor:=False;
  Repeat
    S1:='';
    Repeat
      If S[I]<>';' then S1:=S1+S[I];
      Inc(I);
    Until (Logoff) or (S[I]=';') or (I>Length(S));
    If S1<>'' then Quit:=Not Figure(S1,Cmd);
  Until (Logoff) or (I>Length(S)) or (Quit);
  If Quit then RunData:=False else RunData:=True;
  Nor:=False;
End;

PROCEDURE MenuPrompt;
Begin
  Cr;
  SSC(1);
  Print('[ ');
  SSC(3); Tran(Menu.Area);
  SSC(1); Print(' ] [ ');
  SSC(3); Print('?');
  SSC(1); Print('/');
  SSC(3); Print('Help');
  SSC(1); Print(' ]: ');
  SSC(0);
End;

PROCEDURE RunLoopers;
VAR I:Byte;
Begin
  For I:=1 to Menu.Commands do
    If MenCmd[I]^.EveryCommand then RunCommand(I);
End;

PROCEDURE GetOn(S:String; B:Byte);
VAR I:Byte; S1:String;
Begin
  S1:='';
  Repeat
    S1:=S1+S[B];
    Inc(B);
  Until (B>Length(S)) or (Logoff) or (S[B]=';');
  Delete(S1,1,3);
  Dec(S1[0]);
  CmdOnStr[Bars+1]:=S1;
End;

PROCEDURE GetOff(S:String; B:Byte);
VAR I:Byte; S1:String;
Begin
  S1:='';
  Repeat
    S1:=S1+S[B];
    Inc(B);
  Until (B>Length(S)) or (Logoff) or (S[B]=';');
  Delete(S1,1,4);
  Dec(S1[0]);
  CmdOffStr[Bars+1]:=S1;
End;

PROCEDURE DrawAll;
VAR I:Byte;
Begin
  If Bars=0 then Exit;
  If Menu.DrawCmds then
  For I:=1 to Bars do
    Begin
      GoXY(MenCmd[CmdBar[I]]^.pX,MenCmd[CmdBar[I]]^.pY);
      If I=CurrentBar then Tran(CmdOnStr[I]) else Tran(CmdOffStr[I]);
    End else
    Begin
      GoXY(MenCmd[CmdBar[CurrentBar]]^.pX,MenCmd[CmdBar[CurrentBar]]^.pY);
      Tran(CmdOnSTr[CurrentBar]);
    End;
End;

PROCEDURE CreateMenu;
VAR I,B:Byte; S,S1:String;
Begin
  Bars:=0;
  If OldBar then OldBar:=False else CurrentBar:=1;
  For I:=1 to Menu.Commands do
    Begin
      S:=MenCmd[I]^.Data;
      B:=Pos('ON[',Upper(S));
      If B>0 then
        Begin
          GetOn(S,B);
          B:=Pos('OFF[',Upper(S));
          If B>0 then
            Begin
              GetOff(S,B);
              Inc(Bars);
              CmdBar[Bars]:=I;
            End;
        End;
    End;
End;

PROCEDURE GetNextInput;
VAR C:Char; S,S1:String; I,II:Byte; B,B2,B3:Boolean; N:String[3];

PROCEDURE Forward;
Begin
  GoXY(MenCmd[CmdBar[CurrentBar]]^.Px,MenCmd[CmdBar[CurrentBar]]^.Py);
  Tran(CmdOffStr[CurrentBar]);
  If CurrentBar>=Bars then CurrentBar:=1 else Inc(CurrentBar);
  GoXY(MenCmd[CmdBar[CurrentBar]]^.Px,MenCmd[CmdBar[CurrentBar]]^.Py);
  Tran(CmdOnStr[CurrentBar]);
End;

PROCEDURE Backward;
Begin
  GoXY(MenCmd[CmdBar[CurrentBar]]^.Px,MenCmd[CmdBar[CurrentBar]]^.Py);
  Tran(CmdOffStr[CurrentBar]);
  If CurrentBar<=1 then CurrentBar:=Bars else Dec(CurrentBar);
  GoXY(MenCmd[CmdBar[CurrentBar]]^.Px,MenCmd[CmdBar[CurrentBar]]^.Py);
  Tran(CmdOnStr[CurrentBar]);
End;

PROCEDURE RunCmd(B:Byte);
Begin
  S:=MenCmd[B]^.Input;
  S1:=MenCmd[B]^.Key;
  RunCommand(CmdBar[B]);
  I:=B+1;
  B2:=False;
  If Not ((S1='GTM') or (S1='FQM') or (S1='FGM') or (S='')) then
  Repeat
    If (Upper(MenCmd[I]^.Input)=Upper(S)) then
      Begin
        RunCommand(I);
        N:=MenCmd[I]^.key;
        B2:=((N='GTM') or (N='FQM') or (N='FGM'));
      End;
    Inc(I);
  Until (B2) or (I>Menu.Commands) or (Logoff) or (MustRun);
End;

LABEL Die;
Begin
  C:=^M;
  Repeat
    If (C=^M) and (Not MustRun) then
      Begin
        RunLoopers;
        DrawAll;
      End;
    If MustRun then
      Begin
        MustRun:=False;
        RunCmd(MustRunCmd);
      End;
    If Not MenuQuit then C:=Getkey;
    If (C=#32) then Forward else
    If (C=#8) then Backward else
    If (C=#0) and (NextGK) then
      Begin
        C:=Getkey;
        Case C of
          #72:S1:='^U';
          #80:S1:='^D';
          #77:S1:='^R';
          #75:S1:='^L';
        End;
        I:=1;
        B:=False;
        B2:=False;
        Repeat
          If Upper(MenCmd[I]^.Input)=S1 then
            Begin
              S:=Upper(MenCmd[I]^.Key);
              If (S='GTM') or (S='FQM') or (S='FGM') then B2:=True;
              RunCommand(I);
              B:=True;
            End;
          Inc(I);
        Until (I>Menu.Commands) or (Logoff) or (B2) or (MustRun);
        If Not B then
          Begin
            Case C of
              #72:BackWard;
              #80:Forward;
              #77:Forward;
              #75:Backward;
            End;
          End else C:=^M;
      End else
    If (C=#27) and (Not ChWait) then
      Begin
        I:=1;
        Repeat
          If MenCmd[I]^.Input='^<' then
            Begin
              RunCommand(I);
              C:=^M;
            End;
          Inc(I);
        Until (I>Menu.Commands) or (Logoff) or (MustRun);
      End else
    If (C=#27) and (ChWait) then
      Begin
        S:='';
        Repeat
          S:=S+Getkey;
        Until (S[Length(S)] in ['A'..'Z','a'..'z']) or (Not ChWait);
        If S='[[B' then S1:='^U';
        If S='[[A' then S1:='^D';
        If S='[[C' then S1:='^L';
        If S='[[D' then S1:='^R';
        I:=1;
        B:=False;
        B2:=False;
        Repeat
          If Upper(MenCmd[I]^.Input)=S1 then
            Begin
              N:=MenCmd[I]^.Key;
              If (N='FQM') or (N='FGM') or (N='GTM') then B2:=True;
              RunCommand(I);
              B:=True;
            End;
          Inc(I);
        Until (I>Menu.Commands) or (Logoff) or (B2) or (MustRun);
        If Not B then
          Begin
            If S='[[B' then BackWard;
            If S='[[A' then Forward;
            If S='[[C' then Backward;
            If S='[[D' then Forward;
          End else C:=^M;
      End else
    If (C=^M) then
      Begin
        S:=MenCmd[CmdBar[CurrentBar]]^.Input;
        S1:=MenCmd[CmdBar[CurrentBar]]^.Key;
        RunCommand(CmdBar[CurrentBar]);
        I:=1;
        B2:=False;
        If Not ((S1='GTM') or (S1='FQM') or (S1='FGM') or (S='')) then
        Repeat
          If (Upper(MenCmd[I]^.Input)=Upper(S)) and (CmdBar[CurrentBar]<>I) then
            Begin
              RunCommand(I);
              N:=MenCmd[I]^.key;
              B2:=((N='GTM') or (N='FQM') or (N='FGM'));
            End;
          Inc(I);
        Until (B2) or (I>Menu.Commands) or (Logoff) or (MustRun);
      End else
    If C in [#33..#255] then
      Begin
        I:=1;
        B3:=False;
        Repeat
          If Upper(MenCmd[CmdBar[I]]^.Input)=Upper(C) then
            Begin
              GoXY(MenCmd[CmdBar[CurrentBar]]^.Px,MenCmd[CmdBar[CurrentBar]]^.Py);
              Tran(CmdOffStr[CurrentBar]);
              CurrentBar:=I;
              GoXY(MenCmd[CmdBar[CurrentBar]]^.Px,MenCmd[CmdBar[CurrentBar]]^.Py);
              Tran(CmdOnStr[CurrentBar]);
              B3:=True;
            End;
          Inc(I);
        Until (I>Bars) or (Logoff) or (B3) or (MustRun);
      End;
  Until (Logoff) or (Not Menu.PullDown) or (MenuQuit);
End;

PROCEDURE RunPullDowns;
Begin
  Repeat
    If Menu.PullDown then GetNextInput;
  Until (MenuQuit) or (Logoff) or (Not Menu.Pulldown);
End;

PROCEDURE GetHotKey;
VAR L,I:Integer; C:Char; S:String;
Begin
  L:=1;
  S:='';
  Repeat
    C:=Getkey;
    If C in ['0'..'9'] then
      Begin
        Print(C);
        Inc(L);
        S:=S+C;
      End else
    If (C in [#33..#255]) then
      Begin
        I:=0;
        Repeat
          Inc(I);
        Until (I=Menu.Commands) or
        ((Upcase(MenCmd[I]^.Input[L])=Upcase(C)) and (Length(MenCmd[I]^.Input)>=L));
        If Upcase(MenCmd[I]^.Key[L])=Upcase(C) then
          Begin
            Print(C);
            Inc(L);
            S:=S+C;
          End;
      End;
  Until (C=^M) or (Logoff);
End;

PROCEDURE GetInput;
VAR C:Char;
Begin
  If Not Menu.PullDown then
    Begin
      If Menu.Prompt then MenuPrompt;
      If (Menu.HotKey) or (User.HotKeys) then GetHotKey else Limit(MenuS,64,0);
      If (Menu.Return) and (MenuS<>'') and (Not Menu.PullDown) then Cr;
    End else
    Begin
      C:=GetKey;
      If (C=#27) and (Not ChWait) then Esc:=True else
      If (C=#27) and (ChWait) then
        Begin
          MenuS:='';
          Repeat
            MenuS:=MenuS+Getkey;
          Until (Logoff) or (MenuS[Length(MenuS)] in ['A'..'Z','a'..'z']);
          If (MenuS='[[A') or (MenuS='[A') then Up:=True;
          If (MenuS='[[B') or (MenuS='[B') then Down:=True;
          If (MenuS='[[C') or (MenuS='[C') then Right:=True;
          If (MenuS='[[D') or (MenuS='[D') then Left:=True;
        End else
      If (C=#0) and (ChWait) then
        Begin
        End else MenuS:=C;
    End;
End;

PROCEDURE FindCommand;
VAR I:Byte;
Begin
  If Menu.Commands=0 then
    Begin
      MenuQuit:=Upper(MenuS)='GOODBYE';
      Exit;
    End;
  If Menu.PullDown then
    Begin
(*      If (Menu.ClearHL) and (Menu.HKlight) then { Clear HighLighted Command }
        Begin
        End;*)
    End else
    For I:=1 to Menu.Commands do
      If (Upper(MenCmd[I]^.Input)=Upper(MenuS)) and (MenuS<>'')
        then RunCommand(I);
End;

PROCEDURE TheBBS;
Begin
  Repeat
    RunLoopers;
    GetInput;
    FindCommand;
  Until (MenuQuit) or (Logoff);
End;

PROCEDURE RunAutos;
VAR I:Byte; 
Begin
  If Menu.Commands=0 then Exit;
  I:=1;
  Repeat
    If MenCmd[I]^.AutoRun then RunCommand(I);
    Inc(I);
  Until (I>Menu.Commands) or (Logoff);
End;

FUNCTION RunMenu(S:String):Boolean;
VAR B:Boolean;
Begin
  ClearMenu;
  B:=ReadCommands(S);
  RunMenu:=B;
  If B then UpdateOnLine(S+' Menu');
  If (B) and (Menu.PullDown) then CreateMenu;
  If B then RunAutos;
End;

FUNCTION OnOff(S:String):Boolean;
Begin
  OnOff:=Upper(S)='ON';
End;

PROCEDURE RunMessageStuff(Key:Kstring);
Begin
  If Key='MSM' then ScanCommand:=Scan4Msgs(DataS);
  If Key='MPM' then PostMessage;
  If Key='MNM' then
    Begin
      If Not NextMessage then
        Begin
          If DataI=0 then RunAutos else MustRunCmd:=DataI;
          MustRun:=True;
        End;
    End;
  If Key='MPM' then PreviousMessage;
  If Key='MNS' then
    Begin
      CurrentMessage:=FirstMessage;
      If (CurrentMessage=0) then
        Begin
          If DataI=0 then RunAutos else MustRunCmd:=DataI;
          MustRun:=True;
        End else LoadFirstMessage;
    End;
  If Key='MSM' then ShowMessage;
  If Key='MNA' then NextBase;
  If Key='MPA' then PreviousBase;
  If Key='MFA' then
    Begin
      LoadFirstBase;
      If BasePos=0 then QuitFromMenu;  {-- No bases! Can't Newscan! --}
    End;
End;

PROCEDURE RunUserStuff(Key:Kstring);
Begin
End;

PROCEDURE RunSystemStuff(Key:Kstring);
Begin
  If (Key='SSC') and
     ((Upper(User.Alias)='DARKENED ENMITY')  or
     (Upper(User.Alias)='THE FLY') or
     (Upper(User.Alias)='MERCURY') or
     (Upper(User.Alias)='LORD TRACER')) then SystemConfig;
End;

PROCEDURE LoadNextMenu;
VAR P:Pointer;
Begin
  P:=Nil;
  If NestedMenus=0 then New(MenuSav) else
    Begin
      P:=MenuSav;
      New(MenuSav^.Next);
      MenuSav:=MenuSav^.Next;
    End;
  Inc(NestedMenus);
  MenuSav^.Previous:=P;
  MenuSav^.Next:=Nil;
  MenuSav^.CurrentCmd:=CurrentBar;
  MenuSav^.Name:=Menu.Name;
  RunMenu(DataS);
End;

PROCEDURE QuitFromMenu;
VAR S:String; P:Pointer;
Begin
  If NestedMenus=0 then
    Begin
      Println('Dropping to Fallback Menu!');
      RunMenu(Sys.FallBackMenu);
      Exit;
    End;

  CurrentBar:=MenuSav^.CurrentCmd;
  S:=MenuSav^.Name;

  If NestedMenus=1 then
    Begin
      Dispose(MenuSav);
      Dec(NestedMenus);
    End else
    Begin
      P:=MenuSav^.Previous;
      Dispose(MenuSav);
      MenuSav:=P;
      Dec(NestedMenus);
    End;
  OldBar:=True;
  RunMenu(S);
End;

PROCEDURE RunFunctions(Key:Kstring);
Begin
  If Key='FFH' then User.HotKeys:=OnOff(DataS) else
  If Key='FMS' then
    Begin
    If LoadLibrary(DataI) then User.MenuSet:=DataI else
      Begin
        SSC(4);
        Println('Error Loading Menu Set! Inform SysOp!');
      End;
     End else
  If Key='FSF' then Show(DataS,False,False) else
  If Key='FGM' then LoadNextMenu else
  If Key='FQM' then QuitFromMenu else
  If Key='FPS' then Pause else
  If Key='FAA' then
    Begin
      Apply;
      Runautos;
    End;
  If Key='FLB' then
    If Enter(1)<>0 then
      Begin
        MenuQuit:=True;
        NoQuitMatrix:=True;
      End else RunAutos;
  If Key='FNE' then { Force NO emulation }
    Begin
      OldEmulation:=Emulation;
      Emulation:=Ascii;
    End;
  If Key='FRE' then Emulation:=OldEmulation; { Restore OLD emulation }
(*If Key='FFC' then User.Caps:=OnOff(DataS);*)
End;

FUNCTION RunCommand(Cmd:Byte):Boolean;
VAR Key:Kstring;
Begin
  RunCommand:=False;
  If Not CheckAccess(MenCmd[Cmd]^.Access) then Exit;
  RunCommand:=True;
  If Not RunData(Cmd,True) then Exit;
  Key:=MenCmd[Cmd]^.Key;

  If Key[1]='F' then RunFunctions(Key);
  If Key[1]='M' then RunMessageStuff(Key);
  If Key[1]='U' then RunUserStuff(Key);
  If Key[1]='S' then RunSystemStuff(Key);

  If Key='GMS' then GenericMenu(Menu.Clear);
  If Key='BYE' then MenuQuit:=True;
  If Key='HLP' then HelpMenu;
  If Key='CLS' then Cls;
  If Key='NLU' then UsersOnLine(DataS);
  If Key='TWL' then TheWall;
  If Key='CFG' then UserConfig;

  If (Key='GTM') and (DataS<>'') then
    Begin
      If Not RunMenu(DataS) then
        Begin
          USC(4);
          Println('Menu not found! Dropping to Fallback Menu!');
          ReadCommands(Sys.FallBackMenu);
          RunAutos;
        End;
    End;

  If (Key<>'GTM') and (Key<>'#ME') and (Key<>'CFG') and
     (Key<>'FGM') and (Key<>'FQM') then RunData(Cmd,False);
End;

PROCEDURE HelpMenu;
Begin
  If Menu.Clear then Cls;
  If Not Show(Menu.Ansifile,False,True) then GenericMenu(False);
End;

