UNIT FILES2;
{$I-,X+,F+,O+}

INTERFACE

USES Dos,Crt,Gentypes,Misc,Modem,BcShare,PckdTime,ConfigU,Menu2;

PROCEDURE PromptEditor;
FUNCTION LoadThePrompt(Which:Byte):Boolean;
PROCEDURE ShowPrompt;

VAR Prompt:PromptPtr;

IMPLEMENTATION

FUNCTION LoadPrompt(Which:Byte):Boolean; Forward;

VAR Pf:File;
FUNCTION OpenPrompt(Mode:Byte):Boolean;
VAR S:String;
Begin
  S:=Sys.DataDir+'\PROMPTS.DAT';
  Assign(PF,S);
  OpenPrompt:=False;
  SetFileMode(Mode);
  If Not Exist(S) then
    Begin
      Repeat
        Rewrite(PF,1);
        Ignore:=IOresult;
        If Ignore=5 then Delay(300);
      Until Ignore<>5;
    End else
    Begin
      Repeat
        Reset(PF,1);
        Ignore:=IOresult;
        If Ignore=5 then Delay(300);
      Until Ignore<>5;
    End;
  SetFileMode(NormalMode);
  OpenPrompt:=(Ignore=0);
  Repeat Until IOresult=0;
End;

FUNCTION LoadThePrompt(Which:Byte):Boolean;
LABEL Die;
Begin
  LoadThePrompt:=False;
  If Not OpenPrompt(ReadDenyNone) then Exit;
  If Not LoadPrompt(Which) then Goto Die;
  LoadThePrompt:=True;
  Die:
  Close(Pf);
  Repeat Until IOresult=0;
End;

FUNCTION SavePrompt(Which:Byte):Boolean;
Begin
  SavePrompt:=False;
  Close(PF);
  If Not OpenPrompt(WriteDenyNone) then Exit;
  Seek(PF,(Which-1)*SizeOf(PromptRec));
  Repeat
    BlockWrite(PF,Prompt^,SizeOf(Prompt^));
    Ignore:=IOresult;
    If Ignore=5 then Delay(300);
  Until Ignore<>5;
  SavePrompt:=Ignore=0;
  Close(PF);
  OpenPrompt(ReadDenyNone);
  Repeat Until IOresult=0;
End;

PROCEDURE AddPrompt;
VAR I:Byte;
Begin
  FillChar(Prompt^,SizeOf(Prompt^),#0);
  Prompt^.Name:='/ OTERA Prompt /';
  Prompt^.Data[1]:='|U1[ |U0T|U3i|U1me |U0L|U3e|U1ft|U0: %TL mins |U1]';
  Prompt^.Data[2]:='|U1[ |U0%CA |U1] [ |U0|CT |U1]';
  Prompt^.Data[3]:='\/\|U0- C|U3o|U1mmmand |U0-|U1/\/|U0: |U0';
  For I:=4 to 10 do Prompt^.Data[I]:='';
  Prompt^.EndFile:='';
  Prompt^.Select:=True;
  SavePrompt(FileSize(PF) div SizeOf(PromptRec)+1);
End;

PROCEDURE ModPrompt;
VAR I:Byte; C:Char; S:String;

PROCEDURE Draw;
VAR I:Byte;

PROCEDURE DoIt(C:Char; S,S1:String);
Begin
  SSC(1); Print('['); SSC(3); Print(C); SSC(1); Print('] ');
  SSC(3); Print(S);
  If S1<>'' then
    Begin
      SSC(0);
      Print(S1);
    End;
  Cr;
End;

Begin
  Cls;
  I:=0;
  Repeat
    Inc(I);
    If Prompt^.Data[I]<>'' then
      Begin
        Tran(Prompt^.Data[I]);
        If (I<10) and (Data^[I+1]='') then
          Begin
            Color(31,0);
            Print('_');
            SSC(1);
          End else Cr;
      End;
  Until (Logoff) or (Prompt^.Data[I]='') or (I=10);
  If I=1 then
    Begin
      SSC(4);
      Println('Blank Prompt!');
    End;
  Cr;
  GoXY(1,12);
  DoIt('M','Modify Prompt','');
  DoIt('A','Prompt Name     : ',Prompt^.Name);
  DoIt('B','End Ansi File   : ',Prompt^.EndFile);
  DoIt('C','User Selectable : ',Yn(Prompt^.Select));
  DoIt('Q','Quit','');
End;

PROCEDURE EditIt;
VAR I:Byte;
Begin
  Cls;
  SSC(3);
  Println('|PXX go UP XX Lines');
  Println('|DXX go DOWN XX Lines');
  Println('|FXX go FORWARD XX Columns');
  Println('|BXX go BACK XX Columns');
  Println('|GXX;YY go TO XX,YY on Screen');
  Println('|G;YY go TO Line YY');
  Println('|GXX! go TO Column XX');
  Println('');
  I:=0;
  Repeat
    Inc(I);
    SSC(1);
    Print(Strr(I)+': '); SSC(0); Limit(S,75,0); Cr;
    If Not((I=1) and (S='')) then Prompt^.Data[I]:=S;
  Until (S='') or (Logoff) or (I=10);
End;

Begin
  SSC(1); Print('Which Prompt: '); SSC(0); Limit(S,3,2); Cr;
  If (Intt(S)<1) or (Intt(S)>255) then Exit;
  If Not LoadPrompt(Intt(S)) then Exit;
  I:=Intt(S);
  Repeat
    Draw;
    DoPrompt;
    Repeat C:=Upcase(Getkey); Until (C in ['L','Q','M','A'..'C']) or (Logoff);
    Println(C);
    If C='M' then EditIt;
    If C='A' then
      Begin
        SSC(1); Print('New Name: '); SSC(0); Limit(S,40,0); Cr;
        If S<>'' then Prompt^.Name:=S;
      End;
    If C='B' then
      Begin
        SSC(1); Print('New End File: '); SSC(0); Limit(S,14,2); Cr;
        Prompt^.EndFile:=S;
      End;
    If C='C' then Prompt^.Select:=Not Prompt^.Select;
  Until (C='Q') or (Logoff);
  SavePrompt(I);
End;

PROCEDURE PromptEditor;
VAR C:Char;

PROCEDURE ListPrompts;
VAR I:Integer; L:Integer;
Begin
  Cls;
  If FileSize(PF)=0 then
    Begin
      SSC(4);
      Println('There are no prompts!');
      Exit;
    End;
  MenuTop;
  I:=1;
  Seek(Pf,0);
  Repeat
    Repeat
      BlockRead(Pf,Prompt^,SizeOf(Prompt^),L);
      Ignore:=IOresult;
      If Ignore=5 then Delay(300);
    Until Ignore<>5;
    If (Ignore=0) and (L=SizeOf(Prompt^)) then ListCmd(I,Prompt^.Name);
    Inc(I);
  Until (I>255) or (Ignore<>0) or (Logoff) or (L<SizeOf(Prompt^));
  MenuBottom;
End;

Begin
  If Not OpenPrompt(ReadDenyNone) then Exit;
  Repeat
    ListPrompts;
    DoPrompt;
    Repeat C:=Upcase(Getkey); Until (C in ['L','A','E','Q','D','M']) or (Logoff);
    PRintln(C);
    If C='A' then AddPrompt else
    If C='M' then ModPrompt;
  Until (C='Q') or (Logoff);
  Close(PF);
End;

FUNCTION LoadPrompt(Which:Byte):Boolean;
VAR L:Integer;
Begin
  LoadPrompt:=False;
  Seek(PF,(Which-1)*SizeOf(PromptRec));
  Repeat
    BlockRead(PF,Prompt^,SizeOf(Prompt^),L);
    Ignore:=IOresult;
    If Ignore=5 then Delay(300);
  Until Ignore<>5;
  If (Ignore=0) and (L=SizeOf(Prompt^)) then
    Begin
      Prompt^.Number:=Which;
      LoadPrompt:=True;
    End;
  Repeat Until IOresult=0;
End;

PROCEDURE ShowPrompt;
VAR I:Byte;
Begin
  I:=0;
  USC(1);
  Cr;
  Repeat
    Inc(I);
    If Prompt^.Data[I]<>'' then
      Begin
        Tran(Prompt^.Data[I]);
        If Not ((I=10) or (Prompt^.Data[I+1]='')) then Cr;
      End;
  Until (Prompt^.Data[I]='') or (I=10);
End;

Begin
  New(Prompt);
End.
