/*****************************************************************************
 *
 * File ..................: setup/m_tty.c
 * Purpose ...............: Setup Ttyinfo structure.
 * Last modification date : 18-Mar-2000
 *
 *****************************************************************************
 * Copyright (C) 1997-2000
 *   
 * Michiel Broek		FIDO:		2:280/2802
 * Beekmansbos 10
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of MBSE BBS.
 *
 * This BBS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * MB BBS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MB BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "../lib/libs.h"
#include "../lib/structs.h"
#include "../lib/records.h"
#include "../lib/common.h"
#include "../lib/clcomm.h"
#include "screen.h"
#include "mutil.h"
#include "ledit.h"
#include "stlist.h"
#include "m_modem.h"
#include "m_global.h"
#include "m_tty.h"



int	TtyUpdated = 0;


/*
 * Count nr of ttyinfo records in the database.
 * Creates the database if it doesn't exist.
 */
int CountTtyinfo(void)
{
	FILE	*fil;
	char	ffile[81];
	int	count;

	sprintf(ffile, "%s/etc/ttyinfo.data", getenv("MBSE_ROOT"));
	if ((fil = fopen(ffile, "r")) == NULL) {
		if ((fil = fopen(ffile, "a+")) != NULL) {
			ttyinfohdr.hdrsize = sizeof(ttyinfohdr);
			ttyinfohdr.recsize = sizeof(ttyinfo);
			fwrite(&ttyinfohdr, sizeof(ttyinfohdr), 1, fil);
			fclose(fil);
			return 0;
		} else
			return -1;
	}

	fread(&ttyinfohdr, sizeof(ttyinfohdr), 1, fil);
	fseek(fil, 0, SEEK_END);
	count = (ftell(fil) - ttyinfohdr.hdrsize) / ttyinfohdr.recsize;
	fclose(fil);

	return count;
}



/*
 * Open database for editing. The datafile is copied, if the format
 * is changed it will be converted on the fly. All editing must be 
 * done on the copied file.
 */
int OpenTtyinfo(void)
{
	FILE	*fin, *fout;
	char	fnin[81], fnout[81];
	long	oldsize;

	sprintf(fnin,  "%s/etc/ttyinfo.data", getenv("MBSE_ROOT"));
	sprintf(fnout, "%s/etc/ttyinfo.temp", getenv("MBSE_ROOT"));
	if ((fin = fopen(fnin, "r")) != NULL) {
		if ((fout = fopen(fnout, "w")) != NULL) {
			fread(&ttyinfohdr, sizeof(ttyinfohdr), 1, fin);
			/*
			 * In case we are automatic upgrading the data format
			 * we save the old format. If it is changed, the
			 * database must always be updated.
			 */
			oldsize = ttyinfohdr.recsize;
			if (oldsize != sizeof(ttyinfo))
				TtyUpdated = 1;
			else
				TtyUpdated = 0;
			ttyinfohdr.hdrsize = sizeof(ttyinfohdr);
			ttyinfohdr.recsize = sizeof(ttyinfo);
			fwrite(&ttyinfohdr, sizeof(ttyinfohdr), 1, fout);

			/*
			 * The datarecord is filled with zero's before each
			 * read, so if the format changed, the new fields
			 * will be empty.
			 */
			memset(&ttyinfo, 0, sizeof(ttyinfo));
			while (fread(&ttyinfo, oldsize, 1, fin) == 1) {
				fwrite(&ttyinfo, sizeof(ttyinfo), 1, fout);
				memset(&ttyinfo, 0, sizeof(ttyinfo));
			}

			fclose(fin);
			fclose(fout);
			return 0;
		} else
			return -1;
	}
	return -1;
}



void CloseTtyinfo(void)
{
	char	fin[81], fout[81];
	FILE	*fi, *fo;
	st_list	*tty = NULL, *tmp;

	sprintf(fin, "%s/etc/ttyinfo.data", getenv("MBSE_ROOT"));
	sprintf(fout,"%s/etc/ttyinfo.temp", getenv("MBSE_ROOT"));

	if (TtyUpdated == 1) {
		if (yes_no((char *)"Database is changed, save changes") == 1) {
			working(1, 0, 0);
			fi = fopen(fout, "r");
			fo = fopen(fin,  "w");
			fread(&ttyinfohdr, ttyinfohdr.hdrsize, 1, fi);
			fwrite(&ttyinfohdr, ttyinfohdr.hdrsize, 1, fo);

			while (fread(&ttyinfo, ttyinfohdr.recsize, 1, fi) == 1)
				if (!ttyinfo.deleted)
					fill_stlist(&tty, ttyinfo.tty, ftell(fi) - ttyinfohdr.recsize);
			sort_stlist(&tty);

			for (tmp = tty; tmp; tmp = tmp->next) {
				fseek(fi, tmp->pos, SEEK_SET);
				fread(&ttyinfo, ttyinfohdr.recsize, 1, fi);
				fwrite(&ttyinfo, ttyinfohdr.recsize, 1, fo);
			}

			tidy_stlist(&tty);
			fclose(fi);
			fclose(fo);
			unlink(fout);
			Syslog('+', "Updated \"ttyinfo.data\"");
			return;
		}
	}
	working(1, 0, 0);
	unlink(fout); 
}



int AppendTtyinfo(void)
{
	FILE	*fil;
	char	ffile[81];

	sprintf(ffile, "%s/etc/ttyinfo.temp", getenv("MBSE_ROOT"));
	if ((fil = fopen(ffile, "a")) != NULL) {
		memset(&ttyinfo, 0, sizeof(ttyinfo));
		fwrite(&ttyinfo, sizeof(ttyinfo), 1, fil);
		fclose(fil);
		TtyUpdated = 1;
		return 0;
	} else
		return -1;
}


void TtyScreen(void)
{
	clr_index();
	set_color(WHITE, BLACK);
	mvprintw( 5, 6, "6.  EDIT TTY LINE");
	set_color(CYAN, BLACK);
	mvprintw( 7, 6, "1.  Comment");
	mvprintw( 8, 6, "2.  TTY Device");
	mvprintw( 9, 6, "3.  Phone nr.");
	mvprintw(10, 6, "4.  Line Speed");
	mvprintw(11, 6, "5.  Fido Flags");
	mvprintw(12, 6, "6.  Line Type");
	mvprintw(13, 6, "7.  Available");
	mvprintw(14, 6, "8.  Auth. log");
	mvprintw(15, 6, "9.  Honor ZMH");
	mvprintw(16, 6, "10. Deleted");
	mvprintw(17, 6, "11. Callout");

	mvprintw(15,31, "12. Portspeed");
	mvprintw(16,31, "13. Modemtype");
	mvprintw(17,31, "14. EMSI name");
}



/*
 * Edit one record, return -1 if there are errors, 0 if ok.
 */
int EditTtyRec(int Area)
{
	FILE	*fil;
	char	mfile[81];
	long	offset;
	int	j;
	unsigned long crc, crc1;

	clr_index();
	working(1, 0, 0);
	IsDoing("Edit Ttyinfo");

	sprintf(mfile, "%s/etc/ttyinfo.temp", getenv("MBSE_ROOT"));
	if ((fil = fopen(mfile, "r")) == NULL) {
		working(2, 0, 0);
		return -1;
	}

	offset = sizeof(ttyinfohdr) + ((Area -1) * sizeof(ttyinfo));
	if (fseek(fil, offset, 0) != 0) {
		working(2, 0, 0);
		return -1;
	}

	fread(&ttyinfo, sizeof(ttyinfo), 1, fil);
	fclose(fil);
	crc = 0xffffffff;
	crc = upd_crc32((char *)&ttyinfo, crc, sizeof(ttyinfo));
	working(0, 0, 0);
	TtyScreen();
	
	for (;;) {
		set_color(WHITE, BLACK);
		show_str( 7,21,40, ttyinfo.comment);
		show_str( 8,21, 6, ttyinfo.tty);
		show_str( 9,21,25, ttyinfo.phone);
		show_str(10,21,20, ttyinfo.speed);
		show_str(11,21,30, ttyinfo.flags);
		show_linetype(12,21, ttyinfo.type);
		show_bool(13,21,   ttyinfo.available);
		show_bool(14,21,   ttyinfo.authlog);
		show_bool(15,21,   ttyinfo.honor_zmh);
		show_bool(16,21,   ttyinfo.deleted);
		show_bool(17,21,   ttyinfo.callout);
		show_int( 15,45,   ttyinfo.portspeed);
		show_str( 16,45,30,ttyinfo.modem);
		show_str( 17,45,35,ttyinfo.name);

		j = select_menu(14);
		switch(j) {
		case 0:	crc1 = 0xffffffff;
			crc1 = upd_crc32((char *)&ttyinfo, crc1, sizeof(ttyinfo));
			if (crc != crc1) {
				if (yes_no((char *)"Record is changed, save") == 1) {
					working(1, 0, 0);
					if ((fil = fopen(mfile, "r+")) == NULL) {
						working(2, 0, 0);
						return -1;
					}
					fseek(fil, offset, 0);
					fwrite(&ttyinfo, sizeof(ttyinfo), 1, fil);
					fclose(fil);
					TtyUpdated = 1;
					working(1, 0, 0);
					working(0, 0, 0);
				}
			}
			IsDoing("Browsing Menu");
			return 0;
		case 1:	E_STR(  7,21,40,ttyinfo.comment,  "The ^Comment^ for this record")
		case 2:	E_STR(  8,21,7, ttyinfo.tty,      "The ^Device name^ of this tty line")
		case 3:	E_STR(  9,21,25,ttyinfo.phone,    "The ^Phone number^ or ^Hostname^ or ^IP address^ of this tty line")
		case 4:	E_STR( 10,21,20,ttyinfo.speed,    "The ^Speed^ of this device")
		case 5:	E_STR( 11,21,30,ttyinfo.flags,    "The ^Fidonet Capability Flags^ for this tty line")
		case 6:	ttyinfo.type = edit_linetype(12,21, ttyinfo.type); break;
		case 7:	E_BOOL(13,21,   ttyinfo.available,"Switch if this tty line is ^Available^ for use.")
		case 8:	E_BOOL(14,21,   ttyinfo.authlog,  "Is mgetty ^Auth^ logging available")
		case 9: E_BOOL(15,21,   ttyinfo.honor_zmh,"Honor ^Zone Mail Hour^ on this tty line")
		case 10:E_BOOL(16,21,   ttyinfo.deleted,  "Is this tty line ^deleted") 
		case 11:E_BOOL(17,21,   ttyinfo.callout,  "Is this line available for ^calling out^")
		case 12:E_INT (15,45,   ttyinfo.portspeed,"The ^locked speed^ of this tty port")
		case 13:strcpy(ttyinfo.modem, PickModem((char *)"6.13")); TtyScreen(); break;
		case 14:E_STR( 17,45,30,ttyinfo.name,     "The ^EMSI name^ for this tty line")
		}
	}

	return 0;
}



void EditTtyinfo(void)
{
	int	records, i, o, x, y;
	char	pick[12];
	FILE	*fil;
	char	temp[81];
	long	offset;

	clr_index();
	working(1, 0, 0);
	IsDoing("Browsing Menu");
	if (config_read() == -1) {
		working(2, 0, 0);
		return;
	}

	records = CountTtyinfo();
	if (records == -1) {
		working(2, 0, 0);
		return;
	}

	if (OpenTtyinfo() == -1) {
		working(2, 0, 0);
		return;
	}
	working(0, 0, 0);
	o = 0;

	for (;;) {
		clr_index();
		set_color(WHITE, BLACK);
		mvprintw( 5, 4, "6.  TTY LINES SETUP");
		set_color(CYAN, BLACK);
		if (records != 0) {
			sprintf(temp, "%s/etc/ttyinfo.temp", getenv("MBSE_ROOT"));
			if ((fil = fopen(temp, "r")) != NULL) {
				fread(&ttyinfohdr, sizeof(ttyinfohdr), 1, fil);
				x = 2;
				y = 7;
				set_color(CYAN, BLACK);
				for (i = 1; i <= 20 ; i++) {
					if (i == 11) {
						x = 42;
						y = 7;
					}
					if ((o + i) <= records) {
						offset = sizeof(ttyinfohdr) + (((o + i) - 1) * ttyinfohdr.recsize);
						fseek(fil, offset, 0);
						fread(&ttyinfo, ttyinfohdr.recsize, 1, fil);
						if (ttyinfo.available)
							set_color(CYAN, BLACK);
						else
							set_color(LIGHTBLUE, BLACK);
						sprintf(temp, "%3d.  %-6s %-25s", o+i, ttyinfo.tty, ttyinfo.comment);
						temp[37] = 0;
						mvprintw(y, x, temp);
						y++;
					}
				}
				fclose(fil);
			}
		}
		strcpy(pick, select_record(records, 20));
		
		if (strncmp(pick, "-", 1) == 0) {
			CloseTtyinfo();
			return;
		}

		if (strncmp(pick, "A", 1) == 0) {
			working(1, 0, 0);
			if (AppendTtyinfo() == 0) {
				records++;
				working(1, 0, 0);
			} else
				working(2, 0, 0);
			working(0, 0, 0);
		}

		if (strncmp(pick, "N", 1) == 0) 
			if ((o + 20) < records) 
				o = o + 20;

		if (strncmp(pick, "P", 1) == 0)
			if ((o - 20) >= 0)
				o = o - 20;

		if ((atoi(pick) >= 1) && (atoi(pick) <= records)) {
			EditTtyRec(atoi(pick));
			o = ((atoi(pick) -1) / 20) * 20;
		}
	}
}



int tty_doc(FILE *fp, FILE *toc, int page)
{
	char	temp[81];
	FILE	*tty;
	int	j;

	sprintf(temp, "%s/etc/ttyinfo.data", getenv("MBSE_ROOT"));
	if ((tty = fopen(temp, "r")) == NULL)
		return page;

	page = newpage(fp, page);
	addtoc(fp, toc, 5, 0, page, (char *)"TTY lines information");
	j = 0;

	fprintf(fp, "\n\n");
	fread(&ttyinfohdr, sizeof(ttyinfohdr), 1, tty);

	while ((fread(&ttyinfo, ttyinfohdr.recsize, 1, tty)) == 1) {
		if (j == 4) {
			page = newpage(fp, page);
			fprintf(fp, "\n");
			j = 0;
		}

		fprintf(fp, "     TTY name     %s\n", ttyinfo.comment);
		fprintf(fp, "     Device name  %s\n", ttyinfo.tty);
		fprintf(fp, "     Phone or DNS %s\n", ttyinfo.phone);
		fprintf(fp, "     Line speed   %s\n", ttyinfo.speed);
		fprintf(fp, "     Fido flags   %s\n", ttyinfo.flags);
		fprintf(fp, "     Equipment    %s\n", getlinetype(ttyinfo.type));
		fprintf(fp, "     Available    %s\n", getboolean(ttyinfo.available));
		fprintf(fp, "     Auth. log    %s\n", getboolean(ttyinfo.authlog));
		fprintf(fp, "     Honor ZMH    %s\n", getboolean(ttyinfo.honor_zmh));
		fprintf(fp, "     Callout      %s\n", getboolean(ttyinfo.callout));
		fprintf(fp, "     Modem type   %s\n", ttyinfo.modem);
		fprintf(fp, "     EMSI name    %s\n", ttyinfo.name);
		fprintf(fp, "\n\n\n");
		j++;
	}

	fclose(tty);
	return page;
}


