/*****************************************************************************
 *
 * File ..................: mbsed/rdconfig.c
 * Purpose ...............: Read configuration $MBSE_ROOT/etc/mbsed.conf
 * Last modification date : 25-Aug-2000
 *
 *****************************************************************************
 * Copyright (C) 1997-2000
 *   
 * Michiel Broek		FIDO:		2:280/2802
 * Beekmansbos 10
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of MBSE BBS.
 *
 * This BBS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * MB BBS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MB BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/


#include "libs.h"
#include "logger.h"
#include "rdconfig.h"

#define	S(x) (x)?(x):"(null)"


/**********************************************************************
 *
 *  Global configuration variables
 */

char		*zmhstart=(char *)"";	/* Zone Mail Hour start		*/
char		*zmhend=(char *)"";	/* Zone Mail Hour end		*/
int		logtrans=0;		/* Show transactions in the log	*/
srv_auth	*srvauth = NULL;	/* Linked server/clients list   */


/* Local */

char		*configname=(char *)"";
static char	*k,*v;
static int	linecnt=0;


/* parser prototypes */

static int getsrv(char**);
static int getstr(char**);
static int getlong(char**);


/* keyword table */

static struct _keytab {
	char *key;
	int (*prc)(char**);
	char** dest;
} keytab[] = {
	{(char *)"client",		getsrv,		(char**)&srvauth},
	{(char *)"logtrans",		getlong,	(char**)&logtrans},
	{(char *)"zmhs",		getstr,		&zmhstart},
	{(char *)"zmhe",		getstr,		&zmhend},
	{NULL,				NULL,		NULL}
};


char *xmalloc(size_t);
char *xmalloc(size_t size)
{
	char *tmp;

	tmp=malloc(size);
	if (!tmp) 
		abort();
	
	return tmp;
}



char *xstrcpy(char *src)
{
	char	*tmp;

	if (src == NULL) 
		return(NULL);
	tmp=xmalloc(strlen(src)+1);
	strcpy(tmp,src);
	return tmp;
}



char *xstrcat(char *src, char *add)
{
	char	*tmp;
	size_t	size = 0;

	if ((add == NULL) || (strlen(add) == 0))
		return src;
	if (src)
		size = strlen(src);
	size += strlen(add);
	tmp = xmalloc(size + 1);
	*tmp = '\0';
	if (src) {
		strcpy(tmp, src);
		free(src);
	}
	strcat(tmp, add);
	return tmp;
}



int readconfig()
{
	int		err=0, i;
	FILE		*fp;
	char		buf[PATH_MAX], *p;
	srv_auth	*sv;

	sprintf(buf, "%s/etc/mbsed.conf", getenv("MBSE_ROOT"));
	configname = buf;

	if ((fp=fopen(configname,"r")) == NULL) {
		mbselog((char *)"?", (char *)"$rdconfig: cannot open file \"%s\" ", S(configname));
		printf("PANIC: cannot open file: %s\n", configname);
		exit(1);
	}

	while (fgets(buf,sizeof(buf)-1,fp)) {
		linecnt++;
		if (*(p=buf+strlen(buf)-1) != '\n') {
			mbselog((char *)"?", (char *)"mbsed.conf(%d): %s - line too long", linecnt, buf);
			while (fgets(buf,sizeof(buf)-1,fp) &&
				(*(p=buf+strlen(buf)-1) != '\n'));
			continue;
		}

		*p--='\0';
		while ((p >= buf) && isspace(*p)) 
			*p--='\0';
		k=buf;
		while (*k && isspace(*k)) 
			k++;
		p=k;
		while (*p && !isspace(*p)) 
			p++;
		*p++='\0';
		v=p;
		while (*v && isspace(*v)) 
			v++;

		/*
		 * Skip empty and comment lines 
		 */
		if ((*k == '\0') || (*k == '#')) 
			continue;

		for (i=0;keytab[i].key;i++)
			if (strcasecmp(k,keytab[i].key) == 0) 
				break;

		if (keytab[i].key == NULL) {
			mbselog((char *)"?", (char *)"mbsed.conf(%d): %s %s - unknown keyword", 
				linecnt, S(k), S(v));
			err++;
		} else {
			keytab[i].prc(keytab[i].dest);
		}
	}
	fclose(fp);
	if (err != 0) {
		printf("Configuration error(s), see logfile for details\n");
		exit(1);
	}

	for (sv = srvauth; sv; sv=sv->next)
		mbselog((char *)"#", (char *)"Client name/code : %s %s", sv->hostname, sv->authcode);
	mbselog((char *)"#", (char *)"Log transactions : %s", logtrans ? (char *)"True" : (char *)"False");
	mbselog((char *)"#", (char *)"Zone Mail Hour   : %s - %s", zmhstart, zmhend);
	return 0;
}




/************************************************************************
 *
 *  Parsers
 */


/* Read a string from the config file until eol. */

static int getstr(char **);
static int getstr(char **dest)
{
	*dest=xstrcpy(v);
	return 0;
}



static int getsrv(char **dest)
{
	srv_auth	**tmpm;
	char		*p;

	for (p = v; *p && !isspace(*p); p++);
	if (*p)
		*p++ = '\0';
	while (*p && isspace(*p))
		p++;

	if (*p == '\0') {
		mbselog((char *)"?", (char *)"mbsed.conf(%d): less then two tokens in client", linecnt);
	} else {
		for (tmpm = (srv_auth**)dest; *tmpm; tmpm = &((*tmpm)->next));
		(*tmpm) = (srv_auth *)xmalloc(sizeof(srv_auth));
		(*tmpm)->next = NULL;
		(*tmpm)->hostname = xstrcpy(v);
		(*tmpm)->authcode = xstrcpy(p);
	}

	return 0;
}



static int getlong(char **);
static int getlong(char **dest)
{
	if (strspn(v,"0123456789") != strlen(v)) 
		mbselog((char *)"?", (char *)"mbsed.conf(%d): %s %s - bad numeric", linecnt, S(k), S(v));
	else 
		*((long*)dest)=atol(v);
	return 0;
}


