/*****************************************************************************
 *
 * File ..................: mbsed/logger.c
 * Purpose ...............: Logging functions
 * Last modification date : 25-Aug-1999
 *
 *****************************************************************************
 * Copyright (C) 1997-1999
 *   
 * Michiel Broek		FIDO:		2:2801/16
 * Beekmansbos 10		Internet:	mbroek@ux123.pttnwb.nl
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of MBSE BBS.
 *
 * This BBS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * MB BBS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MB BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/


#include "libs.h"
#include "logger.h"

char *myname=(char *)"mbsed";		/* my (program) name			*/


int oserr=0;			/* Last operating system error		*/


static char *mon[] = {
	(char *)"Jan",(char *)"Feb",(char *)"Mar",
	(char *)"Apr",(char *)"May",(char *)"Jun",
	(char *)"Jul",(char *)"Aug",(char *)"Sep",
	(char *)"Oct",(char *)"Nov",(char *)"Dec"
};



/************************************************************************
 *
 *  Loging procedures.
 */


char *date(void);
char *date(void)
{
	struct	tm	ptm;
	time_t		now;
	static	char	buf[20];

	now = time(NULL);
	ptm = *localtime(&now);
	sprintf(buf,"%02d-%s-%04d %02d:%02d:%02d",
		ptm.tm_mday, mon[ptm.tm_mon], ptm.tm_year+1900,
		ptm.tm_hour, ptm.tm_min, ptm.tm_sec);
	return(buf);
}



/*
 * Macro to print a message to any logfile.
 */

#define PRINT_LOGFILE(lfile, grade, mynam, pid, fmt) \
	fprintf(lfile, "%s %s %s[%d] ", grade, date(), mynam, pid);\
	fprintf(lfile, *fmt == '$' ? fmt+1 : fmt);\
	if (*fmt == '$')\
		fprintf(lfile, ": %s\n", strerror(errno));\
	else\
		fprintf(lfile, "\n");\
	fflush(lfile);



/*
 * general log for this server
 */

void mbselog(char *grade, char *format, ...)
{
	va_list	va_ptr;
	char	outstr[1024];
	int	oldmask;
	FILE	*logfile;
	char	*logname;

	va_start(va_ptr, format);
	vsprintf(outstr, format, va_ptr);
	va_end(va_ptr);

	logname = calloc(PATH_MAX, sizeof(char));
	oldmask=umask(066);
	sprintf(logname, "%s/log/mbsed.log", getenv("MBSE_ROOT"));
	logfile = fopen(logname, "a");
	umask(oldmask);
	if (logfile == NULL) {
		printf("Cannot open logfile \"%s\"\n", logname);
		free(logname);
		return;
	}

	PRINT_LOGFILE(logfile, grade, myname, getpid(), outstr);

	if (fclose(logfile) != 0)
		printf("Cannot close logfile \"%s\"\n", logname);

	free(logname);
	return;
}



/* user log process */

int ulog(char *fn, char *grade, char *prname, char *prpid, char *format, ...)
{
	va_list	va_ptr;
	char	outstr[1024];
	int	oldmask;
	FILE	*log;
	
	va_start(va_ptr, format);
	vsprintf(outstr, format, va_ptr);
	va_end(va_ptr);

	oldmask = umask(066);
	log = fopen(fn, "a");
	umask(oldmask);
	if (log == NULL) {
		oserr = errno;
		mbselog((char *)"!", (char *)"$Cannot open user logfile %s", fn);
		return -1;
	}

	PRINT_LOGFILE(log, grade, prname, atoi(prpid), outstr);

	if (fclose(log) != 0) {
		oserr = errno;
		mbselog((char *)"!", (char *)"$Cannot close user logfile %s", fn);
		return -1;
	}
	return 0;
}

