/*****************************************************************************
 *
 * File ..................: bbs/timeout.c
 * Purpose ...............: Inactivity timeout functions
 * Last modification date : 13-Aug-1999
 *
 *****************************************************************************
 * Copyright (C) 1997-1999
 *   
 * Michiel Broek		FIDO:		2:2801/16
 * Beekmansbos 10		Internet:	mbroek@ux123.pttnwb.nl
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of MBSE BBS.
 *
 * This BBS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * MBSE BBS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MBSE BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "../lib/libs.h"
#include "../lib/mbse.h"
#include "../lib/structs.h"
#include "../lib/records.h"
#include "../lib/common.h"
#include "../lib/clcomm.h"
#include "../lib/msg.h"
#include "timeout.h"
#include "funcs.h"
#include "funcs4.h"
#include "bye.h"
#include "filesub.h"
#include "language.h"


extern	int e_pid;			/* Pid of external program	     */



void die(int onsig)
{
	/*
	 * First check if there is a child running, if so, kill it.
	 */
	if (e_pid) {
		if ((kill(e_pid, SIGTERM)) == 0)
			Syslog('+', "SIGTERM to pid %d succeeded", e_pid);
		else {
			if ((kill(e_pid, SIGKILL)) == 0)
				Syslog('+', "SIGKILL to pid %d succeeded", e_pid);
			else
				WriteError("Failed to kill pid %d", e_pid);
		}

		/*
		 * In case the child had the tty in raw mode, reset the tty
		 */
		system("stty sane");
	}

	if (MsgBase.Locked)
		Msg_UnLock();
	if (MsgBase.Open)
		Msg_Close();

	Home();
	signal(onsig, SIG_IGN);
	if (onsig)
		if (onsig == SIGHUP) {
			Syslog('+', "Lost Carrier");
		} else if (onsig == SIGALRM) {
			Syslog('+', "User inactivity timeout");
		} else {
			if (onsig <= NSIG)
				WriteError("$Terminated on signal %d (%s)", onsig, SigName[onsig]);
			else
				WriteError("Terminated with error %d", onsig);
		}
	else
		Syslog(' ', "Terminated by user");

	if (onsig == SIGSEGV) {
		Syslog('+', "Last msg area %s", msgs.Name);
	}

	if (LoginPrompt) {
		Unsetraw();
		Quick_Bye(onsig);
	} else
		Good_Bye(onsig);
}



void alarm_sig()
{
	colour(12, 0);
	/* Autologout: idletime reached.*/
	printf("\r\n%s\r\n", (char *) Language(410));

	if (LoginPrompt)
		Syslog('!', "Autologout: idletime reached at login prompt");
	else
		Syslog('!', "Autologout: idletime reached");

	die(SIGALRM);
}



void alarm_set(int val)
{
	signal(SIGALRM, (void (*))alarm_sig);
	alarm(val);
//	Syslog('s', "Alarm set for %d seconds", val);
}



void alarm_on()
{
	alarm_set(60 * CFG.idleout);
}



void alarm_off()
{
	alarm(0);
	signal(SIGALRM, SIG_IGN);
//	Syslog('s', "Alarm is off");
}

