/*****************************************************************************
 *
 * File ..................: mbftpd/util.c
 * Purpose ...............: MBSE BBS Ftp Daemon
 * Last modification date : 21-Feb-2000
 *
 *****************************************************************************
 * Copyright (C) 1997-2000
 *   
 * Michiel Broek		FIDO:		2:280/2802
 * Beekmansbos 10
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of MBSE BBS.
 *
 * This BBS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * MBSE BBS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MBSE BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "../config.h"
#include "../lib/libs.h"
#include "../lib/structs.h"
#include "../lib/records.h"
#include "../lib/common.h"
#include "../lib/clcomm.h"
#include "../lib/dbcfg.h"
#include "util.h"


int		Initialized = FALSE;		/* Is initialization done	*/
fil_areas	*are = NULL;			/* File areas access list	*/
securityrec	usersec;			/* Current users security	*/
int		userrec = -1;			/* Users record pointer		*/
unsigned long	Downloads = 0;			/* User downloads		*/
unsigned long	DownloadK = 0;			/* Download size		*/
unsigned long	Uploads = 0;			/* User uploads			*/
unsigned long	UploadK = 0;			/* Upload size			*/
static int	downfd = -1;			/* Download stats file		*/
extern int	administrator;			/* Administrator flag		*/
extern char	*home;				/* Users home			*/
extern uid_t	sysuid;
extern gid_t	sysgid;


void	tidy_areas(fil_areas **);
void	fill_areas(fil_areas **, unsigned long);


int init_bbs(char *username, int no_bbsuser)
{
	char		*temp;
	FILE		*fp;
	unsigned long	i = 0;

	Syslog('f', "Init BBS");
	temp = calloc(128, sizeof(char));
	sprintf(temp, "%s/etc/fareas.data", getenv("MBSE_ROOT"));
	if ((fp = fopen(temp, "r")) == NULL) {
		WriteError("$Can't open %s", temp);
		free(temp);
		return FALSE;
	}
	fread(&areahdr, sizeof(areahdr), 1, fp);

	while (fread(&area, sizeof(area), 1, fp) == 1) {
		i++;
		if (strlen(area.Path) && area.Available)
			fill_areas(&are, i);
	}

	fclose(fp);

	/*
	 * If a normal bbs user, lookup the user record.
	 */
	usersec = CFG.newuser_access;
	if (!no_bbsuser) {
		sprintf(temp, "%s/etc/users.data", getenv("MBSE_ROOT"));
		if ((fp = fopen(temp, "r")) == NULL) {
			WriteError("$Can't open %s", temp);
		} else {
			fread(&usrconfighdr, sizeof(usrconfighdr), 1, fp);

			while (fread(&usrconfig, sizeof(usrconfig), 1, fp) == 1) {
				if (strcmp(usrconfig.Name, username) == 0) {
					userrec = ftell(fp) - sizeof(usrconfig);
					usersec = usrconfig.Security;
				}
			}
			fclose(fp);
		}
	}
	Syslog('+', "User %s logged in, security level %d", username, usersec.level);

	sprintf(temp, "%s/var/download.ftp", getenv("MBSE_ROOT"));
	if (downfd < 0 && (downfd = open(temp, O_CREAT | O_WRONLY | O_APPEND, 00666)) < 0) {
		WriteError("$Can't open %s", temp);
	} else {
		Syslog('f', "fchown %d", fchown(downfd, sysuid, sysgid));
	}

	free(temp);

	Syslog('f', "Init done");
	Initialized = TRUE;
	return TRUE;
}



void exit_bbs()
{
	if (!Initialized)
		return;

	Syslog('f', "Deinit BBS");

//	Won't work after chroot.
//	if ((userrec != -1) && ((Uploads || Downloads))) {
//		Syslog('h', "Should update users record");
//	}

	tidy_areas(&are);
}



void tidy_areas(fil_areas **fap)
{
	fil_areas	*tmp, *old;

	for (tmp = *fap; tmp; tmp = old) {
		old = tmp->next;
		free(tmp);
	}
	*fap = NULL;
}



void fill_areas(fil_areas **fap, unsigned long rec)
{
	fil_areas	*tmp;

	if (!strlen(area.Path) || !area.Available)
		return;

	tmp = (fil_areas *)xmalloc(sizeof(fil_areas));
	tmp->next = *fap;
	tmp->LTsec = area.LTSec;
	tmp->DNsec = area.DLSec;
	tmp->UPsec = area.UPSec;
	sprintf(tmp->Name, "%s", area.Name);
	sprintf(tmp->Path, "%s", area.Path);
	sprintf(tmp->Password, "%s", area.Password);
	tmp->Areanr = rec;
	*fap = tmp;
}



void fill_down(unsigned long rec, char *filename)
{
	char		*p;
	struct stat	buf;
	downftp		down;	

	Syslog('f', "fill_down(%lu, %s)", rec, filename);
	if (rec == 0)
		return;

	if (downfd == -1) {
		Syslog('f', "Stats file not open");
		return;
	}

	if (fstat(downfd, &buf) == 0) {
		memset(&down, 0, sizeof(down));

		if ((p = strrchr(filename, '/')) == NULL)
			sprintf(down.Name, "%s", filename);
		else
			sprintf(down.Name, "%s", p+1);
		down.Areanr = rec;
		if (write(downfd, (char *)&down, sizeof(down)) == sizeof(down))
			Syslog('f', "Stored %lu %s", down.Areanr, down.Name);
	}
}



/*
 * Security Access Check
 */
int Access(securityrec us)
{
//	Syslog('b', "User %5d %08lx %08lx", usersec.level, usersec.flags, ~usersec.flags);
//	Syslog('b', "Ref. %5d %08lx %08lx", us.level, us.flags, us.notflags);

	if (administrator)
		return TRUE;

	if (usersec.level < us.level)
		return FALSE;

	if ((us.notflags & ~usersec.flags) != us.notflags)
		return FALSE;

	if ((us.flags & usersec.flags) != us.flags)
		return FALSE;

	return TRUE;
}



unsigned long GetArea(char *filename)
{
	char		*cwd, *temp, *p;
	fil_areas	*tmp;
	unsigned long	Area = 0;

	cwd = calloc(PATH_MAX, sizeof(char));
	temp = calloc(PATH_MAX, sizeof(char));
	(void)getcwd(cwd, PATH_MAX);
	if (filename[0] == '/')
		sprintf(temp, "%s%s%s", home, cwd, filename+1);
	else
		sprintf(temp, "%s%s/%s", home, cwd, filename);
	Syslog('f', "Path now %s", temp);
	p = strrchr(temp, '/');
	*p = '\0';
	Syslog('f', "Path then %s", temp);

	for (tmp = are; tmp; tmp = tmp->next) {
		if (strcmp(temp, tmp->Path) == 0) {
			Area = tmp->Areanr;
			break;
		}
	}

	Syslog('f', "GetArea=%d home=%s cwd=%s", Area, home, cwd);
	free(cwd);
	free(temp);
	return Area;
}



